unit DANE;
{======================================================================}
{=                                                                    =}
{=  Ten modu zawiera deklaracje wszystkich danych Engine'u gry (tzn. =}
{=  danych wykorzystywanych przez inne moduy gry) oraz procedury i   =}
{=  funkcje suce do operowania nimi lub wczytywaniu ich wartoci.  =}
{=                                                                    =}
{======================================================================}

interface
uses crt,textopr;
const
     {OZNACZENIE ZDAZENIA LOSOWEGO}
     Spotkano=1;
     NieSpotkano=0;
     {KOLORY}
     Czarny=0;
     Niebieski=1;
     Zielony=2;
     DziwnyNiebieski=3;
     Czerwony=4;
     Fioletowy=5;
     Brazowy=6;
     JasnySzary=7;
     Szary=8;
     CiemnyDziwnyNiebieski=9;
     JasnyZielony=10;
     JasnyNiebieski=11;
     JasnyCzerwony=12;
     JasnyFioletowy=13;
     Zolty=14;
     Bialy=15;

        {========PLIKI========}
        {SCIERZKI}
        Mapy='Data/Maps/';
        Urzytkownicy='data/Users/';

        SkryptyPostaci='Data/Scripts/Chars/';
        SkryptyPrzedmiotow='Data/Scripts/inv/';
        SkryptyScenerii='Data/Scripts/Scennery/';
        SkryptyMap='Data/Scripts/Maps/';
        SkryptySpatial='Data/Scripts/Spec/';
        SkryptyZapisow='Data/Scripts/Records/';

        TekstyScenerii='Data/text/scennery/';
        Dialogi='Data/text/chars/Dialog/';
        TekstyDialogoweScenerii='Data/text/scennery/use/';
        TekstyGry='Data/text/game/';
        TekstyZapisow='Data/text/records/';
        TekstyZadan='Data/text/game/';
        TekstyPrzedmiotow='Data/text/INV/';
        TekstyMap='Data/text/maps/';
        TekstySpatial='Data/text/intro/';
        OpisyPrzedmiotow='Data/Text/game/';
        TekstyPostaci='Data/text/chars/dialog/';
        DanePrzedmiotow='Data/inv/';


        DaneGry='Data/Game/';
        Tymczasowe='data/_temp_/';


        {=========POSTAC========}
        MaxLevel=60; {Maksymalny poziom postaci}
        {STATUSY}
        Normalny=1; {postac zyje}
        Martwy=2;   {postac nie zyje}
        Niema=0;    {postac nie istnieje}

        {NUMERY CHOROB}
        Napromieniowanie=1;
        Trucizna=2;
        Uzaleznienie=3;

        {NUMERY AI}
        Zwierze=1;        {zwierzeta domowe}
        Potwor=2;         {potwory takie jak skorpiony itp}
        Czlowiek=3;       {zwyczajny czlowiek, chodzacy sobie w losowe kierunki}
        Straznik=4;       {obracajaca sie postac}
        Handlarz=5;       {czlowiek handlujacy}

        {NASTAWIENIA}
        Wrog=1;
        Przyjaciel=2;
        Neutralny=0;

        {CECH POSTACI}
        Sila=1;
        Zrecznosc=2;
        Wytrzymalosc=3;
        Percepcja=4;
        Inteligencja=5;
        Charyzma=6;
        Szczescie=7;
        NazwyCech:array[1..7] of string[12]=('Sila','Zrecznosc','Wytrzymalosc',
                                         'Percepcja','Inteligencja','Charyzma',
                                         'Szczescie');
        {UMIEJETNOSCI}
        BronReczna=1;
        BronBiala=2;
        Nieuzbrojony=3;
        Handel=4;
        Kradzierz=5;
        OtwieranieZamkow=6;
        Nauka=7;
        Leczenie=8;
        NazwyUmie:array[1..8] of string[17]=('Bron Reczna','Bron Biala','Nieuzbrojony',
                                         'Handel','Kradzierz','Otwieranie Zamkow',
                                         'Nauka','Leczenie');
        {==========OBIEKTY=========}

        {STANY OBIEKTOW (chodzi raczej o same obiekty typu:drzwi lub szafki)}
        Zniszczone=0;     {obiekt zniszczony}
        Otwarte=1;        {obiekt otwarty}
        Zamkniete=2;      {obiekt zamkniety}
        Zamek=3;          {obiekt zamkniety na zamek}
        {TYPY OBIEKTOW SCENERII}
        Komputer=1;
        DrzwiZwykle=100;

        {========PRZEDMIOTY=========}
        {TYPY WIZERUNKOW PRZEDMIOTOW}
         {bron}
        BronDluga=1;
        BronKrutka=2;
        Norze=3;
        Wlucznie=4;
         {zbroja}
        Kurtka=1;
        Kamizelka=2;
        ZBPancerz=3;
        DuzaZbroja=4;
        {TYPY PRZEDMIOTOW}
        Bron=1;
        BronB=2;
        Pancerz=3;
        Medykament=4;
        Specjalny=5;
        Waluta=6;
        Klucz=7;
        Urzywka=8;
        Amunicja=9;
        TypPrzedmiotu:array[1..10] of string[11]=
        ('Bron Reczna','Bron Biala','Pancerz','Medykament','Specjalny',
         'Waluta','Klucz','Urzywka','Amunicja','Wlucznia');

        {============MAPA===========}
        {TYPY MIEJSCA (pomieszczenie, przestrzen itd.}
        Pomieszczenie=1;
        Przestrzen=0;

        {NUMERY WALIDACYJNE}
        Wolne=0;
        Polwolne=1;
        VSciana=2;
        Postac=3;
        VSceneria=4;
        VSzafka=5;
        Trup=6;
        Spatial=7;
        {POZYCJA MAPY}
        MapPozX=11;
        MapPozY=11;
        {KIERUNKI (Nie tylko wyjsc ale i tez poruszania sie postaci - za jednym razem)}
        KLewo=1;
        KPrawo=2;
        KGora=3;
        KDol=4;
        KLewoGora=5;
        KLewoDol=6;
        KPrawoGora=7;
        KPrawoDol=8;
        {===========SKRYPTY=========}
        {RODZAJE SPOSOBW WYBIERANIA OPCJI}
        List=0;       {Za pomoca listy (tak jak w Fallout)}
        Button=1;     {Za pomoca przyciskow}
        Chouse=2;     {Za pomoca prostokata (tak jak w Norton Commander)}
        Enter=3;      {Za pomoca wprowadzonego z klawiatury napisu (np. ,,Ziutek'')}

        {===========INNE===========}
        {STATUSY ZADAN}
        Wykonane=1;      {zadanie wykonane}
        Niewykonane=2;   {zadanie niewykonane}
        Nieaktywne=0;    {zadanie jeszcze nie zlecone}
        {STATUSY ZAPISOW}
        Niezapisany=1;   {Zapis nie zostal jeszcze wprowadzony do PipBoya}
        Zapisany=2;      {Zapis zostal wprowadzony do pipboya}
        Nieistniejacy=0; {Zapis nie istnieje}
        {CZAS}
        Dzien=1;         {Pora dnia}
        Noc=2;           {Pora dnia}
        {STANY PRZYCISKU}
        NieWcisniety=0;
        Wcisniety=1;
        Wciskany=2;
        Odciskany=3;
        {POLECENIA}
        Koniec=1;
        {TRYBY GRY}
        TrybWalki=1;
        TrybNormalny=0;
        {======AI=======}
        {rodzaje AI}
        StojWMiejscu=0;
        ChaotycznyRuch=1;
        Wiezyczka=2;

type
     {TYPY DO MAPY SWIATA}
     obiektms=record
         nazwa:string[14];
         x,y:integer;
         view:byte;
         runfile:string[8];
         xst,yst:byte;
        end;
     TWorldMap=record
         obiekty:array[1..30] of obiektms;
         WMT:array[1..45,1..45] of byte;
        end;
      {-----------}
      TData=Record
               Dzien:byte;
               Miesiac:byte;
               Rok:integer;
              end;
       TPostac=Record
               Smierc:Tdata;                      {Data smierci}
               Zmienne:array[1..6] of byte;       {Dodatkowe zmienne postaciowe, do wykorzystania przez skrypty}
               Xp,Yp:byte;                        {Wspolrzedne}
               Imie:string[16];                   {IMIE POSTACI}
               Skrypt:string[8];                  {nazwa skryptu}
               Cechy:array[1..7] of byte;         {CECHY POSTACI}
               Skills:array[1..8] of byte;        {Umiejetnosci postaci}
               Rysunek:integer;                   {numer rysunku postaci}
               Ai:byte;                           {rodzaj Ai }
               LicznikAi:integer;                 {liczniki pomocnicze (sluza do liczenia czasu, pomiedzy zadaniami AI}
                                                  {i wyswietlaniem Flood Tekstow)}
               cel:byte;                          {numer postaci ustalonej jako cel do ataku}
               Ekwipunek:array[1..24] of integer; {Sloty ekwipunku postaci (Numery ID przedmiotow w kazdym slocie)}
               Spec:array[1..24] of real;         {Specyfikacja kazdego ze slotow ekwipunku}
               AP,MaxAP:byte;                     {Punkty akcji, aktualne i maksymalne}
               Hp,MaxHP:integer;                  {Hit Points, aktualne i maksymalne);}
               Bron,Zbroja:integer;               {bron(a tekze jej specyfikacja) i opancerzenie postaci}
               BronSpec:real;
               Nastawienie:byte;                  {nastawienie wobec bohatera}
               Status:byte;                       {Status postaci}
               Choroby:array[1..3] of byte;       {Poziomy poszczegolnych chorob:1 - Napromieniowanie, 2 - Trucizna}
                                                  {, 3 - Uzaleznienie od uzywek}
              end;
      TSceneria=record
               Rysunek:integer;                   {rysunek obiektu scenerii}
               Typ:byte;                          {typ obiektu scenerii (drzwi, komputer itp.)}
               Xs,Ys:byte;                        {wspolrzedne na mapie}
               Skrypt:string[8];                  {nazwa skryptu}
               Powiazanie:byte;                   {numer postaci z ktora powiazany jest obiekt scenerii}
               Stan:byte;                         {stan obiektu (np. drzwi:zamkniete,otwarte)}
               Wytrzymalosc:byte;                 {wytrzymalosc obiektu}
               Stopien:byte;                      {stopien skomplikowania zamka lub interface'u urzadzenia}
               Klucz:integer;                     {numer przedmiotu, ktory jest kluczem do tego obiektu}
                                                  {(jesli obiekt to np. drzwi)}
              end;
      TSzafka=record
               Rysunek:integer;                   {rysunek obiektu szafka}
               xs,ys:byte;                        {wspolrzedne szafki}
               Sprzety:array[1..24] of integer;   {Przedmioty znajdujace sie w obiekcie Szafka}
               Spec:array[1..24] of real;      {Specyfikacja kazdego z przedmiotow w slotach}
               powiazanie:byte;                   {Numer postaci z ktora powiazana jest szafka}
              end;

      TZadanie=Record
               Status:byte;                       {status zadania - wykonane, niewykonane, niezlecone}
              end;
      TZapis=record
               Nazwa:string[46];                  {Nazwa zapisu}
               Skrypt:string[8];                  {skrypt zapisu}
               Status:byte;                       {Status zapisu}
              end;
      TSpatial=record
               Nazwa:string[8];                   {Nazwa pliku skryptu}
               xs,ys:byte;                        {wspolrzedne na mapie}
               Exec:byte;                      {oznaczenie czy skrypt zostal juz wykonany}
              end;
      TMap=record
               Nazwa:string[24];                  {Nazwa mapy}
               Tiles:array[1..80,1..80] of byte;  {Podloze mapy (kafelki)}
               Sciany:array[1..80,1..80] of byte; {Sciany na mapie}
               Va:array[1..80,1..80] of byte;     {Walidacja mapy}
               Rozx,Rozy:integer;                 {Rozmiary mapy}
               Wyjscia:array[1..8] of string[8];  {Powiazania plikowe mapy z inna mapa}
               Trigs:array[1..25] of byte;        {Przelaczniki Mapowe}
               Skrypt:string[8];                  {Skrypt mapy}
               Postacie:array[0..20] of Tpostac;  {Dane wszystkich postaci na aktualnej mapie + dane postaci bohatera (0)}
               Scenerie:array[1..50] of TSceneria;{Dane wszystkich obiektow scenerii w aktualnej mapie}
               Szafki:array[1..40] of TSzafka;    {Dane wszystkich obiektow typu szafki na aktualnej mapie}
               Spatiale:array[1..10] of TSpatial; {Dane wszystkich skryptow Spatial umieszczonych na mapie}
               Promieniowanie:byte;               {Poziom PRomieniowania}
               Miejsce:byte;                      {Oznaczenie czy mapa odzwierciedla podziemne, oswietlone pomieszczenie}
                                                  {czy lokacje powierzchniow}
              end;
      TWybor=record
               kierunek:string[8];                  {Numer lini do ktorej ma byc wykonany skok po wybraniu opcji}
              end;

     {=====TYPY OBIEKTOW GUI=====}
     TPrzycisk=record
             Xp1,yp1,xp2,yp2:integer;     {Wspolrzedne Przycisku}
             Stan:byte;                   {Stan Przycisku}
             Typ:byte;                    {Typ przycisku}
             Tekst:string;                {Nazwa Przycisku}
            end;
     TEkrany=record
               Xe1,Xe2,Ye1,Ye2:integer;   {Rozmiary ekranu}
               Typ:byte;                  {Typ ekranu}
               Lo:byte;                {Aktualna linijka tekstu w oknie (nr)}
              end;
     TLista=record                      {Wykorzystywane przy dialogach}
             Xl,Yl:integer;             {Polozenie obiektu listy}
             Tekst:string;              {Tekst jednego z dialogow do wyboru na liscie}
            end;
     TOpcja=record                         {- ODPOWIEDNIK WYBORU PLIKU W NORTONIE}
             Tekst:string[20];              {Tekst opcji}
             Xop,Yop:integer;           {Polozenie obiektu opcji}
            end;
     TZapisy=record                     {Hasla dostepne w bazie danych (Gracz wpisuje jakies slowo by je znalezc}
             Haslo:string;              {Nazwa hasla wybierajacego}
            end;
              {===================================================}
              {=                                                 =}
              {=                DEKLAROWANIE ZMIENNYCH           =}
              {=                                                 =}
              {===================================================}
var
    {ZMIENNE MAPY SWIATA}
    worldmap:Tworldmap;
    lwm:file of Tworldmap;
    x,y:byte;
    Xpw,Ypw:integer;      {Wspolrzedne bohatera na mapie swiata}
    SpotkanieLosowe:byte;

     {TABLICA MAPY}
     Mapa:TMap;
     Mx,My:integer; {wspolrzedne kafelka, od ktorego rysowana jest aktualnie mapa}
     Slabe,Srednie,Trudne:integer;               {Ilosc kazdego z Random Encounters}


     TRIGGERS:array[1..100] of byte;             {Przelaczniki globalne}
     MapName:string[8];                          {Nazwa pliku mapy}
     {DODATKOWE ZMIENNE POSTACI BOHATERA}
     Karma:integer;                              {Suma uczynkw bohatera}
     Reputation:array[1..10] of byte;         {reputacje bohatera}

     Exp:real;                                   {Doswiadczenie bohatera}
     Poziom:byte;                                {Poziom bohatera}
     PomLev:boolean;                             {Dodatkowa zmienna okreslajaca czy gracz}
                                                 {spojzal juz na ekran postaci po awansowaniu}
                                                 {na wyzszy poziom, czy jeszcze nie}

     Pnkt:integer;                               {Punkty do rozdzielenia przy podnoszeniu umiejetnosci}
     Cpnk:byte;
     SkillSlev:array[1..8] of byte;              {Pomocnicze dane rozwiniec umiejetnosci przy}
                                                 {przydzielaniu punktow do rozdzielenia}
     AddAP:byte;                                 {Dodane tymczasowo punkty akcji (np. po zazyciu narkotykow)}
     {ZMIENNE CZASU}
     dd,mm,rr:integer;                           {Dzien, miesiac, rok}
     gg,mn,ss:integer;                           {Godzina,minuta,sekunda}
     PoraDnia:byte;                              {Poradnia:dzien, noc}
     LicznikFlood:real;                       {licznik czasu dla floodtekstow}
     LicznikAI:integer;
     {ZMIENNE KTORYCH WARTOSCI SA WCZYTYWANE}
     DaneKarmy:array[1..10] of string[20];           {Dane Karmy}
     MapaStartowa:String[8];                     {Nazwa mapy startowej}
     Reputacja:array[1..10] of string[20];       {Nazwy reputacji (np. Bokser itp)}

     Zadania:array[1..200] of TZadanie;          {Wszystkie zadania}
     IloscZadan:byte;                            {Ilosc zadan w grze}
     Zapis:array[1..20] of TZapis;               {Wszystkie zapisy dostepne}
     IloscZapisow:byte;                          {Ilosc zapisow w grze}
     Xst,Yst:byte;                               {Wspolrzedne startowe postaci na mapie}

     {ZMIENNE SAMEJ GRY}
     Konsola:array[1..6] of string;
     DoHandlu:array[1..2,1..24] of integer;
     DoHandluSpec:array[1..2,1..24] of real;
     Oferta:array[1..2] of real; {calkowity koszt oferowanych przedmiotow}
     RHL,RHR:byte;         {numery wybranych slotow podczas handlu}

     {ZMIENNE SKRYPTW}
     Wybory:array[1..11] of TWybor;              {Dane wszystkich dostepnych opcji podczas dialogw itp.)}
     Odczyt:string;                              {Zmienna zawierajca odczyt z klawiatury jesli podczas skryptu}
                                                 {istnieje mozliwosc wprowadzenia jakiegos slowa z klawiatury}
     TypWyboru:byte;                             {Zmienna okreslajca typ aktualnego sposobu wyboru opcji (np. Przyciski)}
                                                 {ta zmienna musi byc wczytywana zanim nastapi deklaracja samych opcji,}
                                                 {poniewaz w przeciwnym razie, zostanie zdefiniowana domyslnie(czyli:lista)}
     KolorTla:byte;                              {Kolor tla w momecie gdy zaznaczony jest obiekt OPCJA}
                                                 {lub gdy wybrana zostala pozycja z LISTY (tekst na tej pozycji zmienia barwe)}
     KolorTekstu:byte;                           {Kolor tekstu przy wyborze typu: LISTA lub OPCJE}
     KolorNumerow:byte;                          {Kolor numerw przy wyborze typu: LISTA}
                                                 {(Oznacza tez kolor tekstu w wyborze typu OPCJA}

     AktOpcja:byte;                         {Numer aktulanie wybranej opcji}
     Crit:byte;                             {Numer postaci do ktorej nalezy skrypt}
     Killer:byte;                           {Numer postaci ktora zabila postac do ktorej nalezy skrypt}
     HitCrit:byte;                          {Numer postaci ktora oberwala z broni}
     Scen:byte;                             {Numer obiektu scenerii do ktorego nalezy skrypt}
     Spat:byte;                             {Numer skryptu Spatial ktory jest wlasnie uruchomiony}
     Inven:byte;                            {Numer przedmiotu do ktorego nalezy skrypt}

     UsedSkill:byte;                        {Numer umiejetnosci uzytej na obiekcie lub postaci do ktorej nalezy skrypt}
     UsedItem:integer;                         {Numer przedmiotu uzytego na obiekcie lub postaci do ktorej nalezy skrypt}
    {ZMIENNE OBIEKTOW INTERFACE'U}
    Przyciski:array[1..11] of TPrzycisk;   {Tablica Wszystkich obiektow przy wyborze typu przycisk}
    Lista:array[1..11] of TLista;          {Tablica wszystkich obiektow przy wyborze typu List}
    Opcje:array[1..11] of TOpcja;          {Tablica wszystkich obiektow przy wyborze typu Chouse}
    Zapisy:array[1..11] of TZapisy;        {Tablica wszystkich hase przy wyborze typu ENTER}

    Ekrany:array[1..6] of TEkrany;         {Tablica wszystkich Ekranow}

    EkranWpisu:byte;                       {Numer ekranu w ktorym gracz wprowadza dane}
    EkranOdczytu:byte;                     {Numer Ekranu w ktorym gracz odczytuje dane}

    AktPanel:byte;                         {Numer Aktualnego Panelu}

    LiczbPrzycisk:byte;                    {Ilosc Przyciskow}
    LiczbEkranow:byte;                     {Ilosc ekranow}
    LiczbList:byte;                        {Ilosc opcji na liscie}
    LiczbOpcji:byte;                       {Ilosc opcji w nortonowym wyborze}
    LiczbZapisow:byte;

    {INNE ZMIENNE}
    NRW:byte;                              {Numer postaci ktora aktualnie wykonuje ruch podczas walki}
    A,B,C:Word;                            {Dane myszy}
    q:char;                                {zmienna do obslugi klawiatury}
    TrybGry:byte;                          {aktualny tryb gry (np. walka)}
    Polecenie:byte;                        {polecenie od gracza dla samego programu (np. QUIT)}
    Wb:byte;                               {pomocnicza zmienna oznaczajaca wybrana opcje(np. w charakterystyce)}
    LicznikLeczenia:byte;                  {zmienna pomocnicza przy odpoczynku i leczeniu obrazen}
    Ws:byte;                               {pomocnicza zmienna wyboru}

    Urzytkownik:string[8];                 {Nazwa aktualnego urzytkownika}
    {DANE DO PROCEDUR RYSOWANIA POSTACI}
    KolorNog,KolorTlowia,KolorPaska,kolorButow,kolorrak,kolorzbroji1,kolorzbroji2:byte;

    {USTAWIENIA}
    Testy:boolean;

     {====================================================}
     {=                                                  =}
     {=              PROCEDURY I FUNKCJE                 =}
     {=                                                  =}
     {====================================================}

     Procedure DaneStartowe;  {Procedura wczytujaca dane startowe gry}
     procedure WczytajDaneKarmy; {procedura wczytujaca dane karmy}
     procedure WczytajDaneZapisow;{procedure wczytujaca dane zapisow}
     Function NazwaZadania(nrz:byte):string;{zwraca nazwe zadani o podanym numerze}

     {OPERACJE NA DANYCH OBIEKTW INTERFACE'U}
     function CzyWcisnieto(nrp:byte):boolean;     {Zwraca True jesli wcisnieto przycisk o numerze nrp}
     Procedure TworzPrzycisk(xo1,yo1,xo2,yo2:integer; StanPr,TypPr:byte; TekstPR:string);{tworzy przycisk i zapisuje jego dane}
                                                                                         { w pamieci zmiennej PRZYCISKI}
     Procedure TworzEkran(Xe1,Ye1,Xe2,Ye2:integer; Typek:byte); {tworzy ekran i zapisuje jego dane w pamici zmienej Ekrany}
     Procedure TworzElementListy(xl,yl:integer; Tekst:string);  {Tworzy element listy i zapisuje jego dane w pamieci zmiennej}
                                                                { Listy}
     Procedure TworzOpcje(xl,yl:integer; Tekst:string);         {Tworzy opcje i zapisuje jej dane w pamici zmiennej Opcje}
     Procedure ZerujPrzyciski;  {Usuwa wszystkie przyciski z pamieci zmiennej PRZYCISKI}
     Procedure ZerujEkrany;     {usuwa wszystkie ekrany z pamieci zmiennej EKRANY}
     Procedure ZerujListe;      {Usuwa wszystkie elementy listy z pamieci zmiennej LISTY}
     Procedure ZerujOpcje;      {Usuwa wszystkie opcje z pamieci zmiennej OPCJE}
     Procedure ZerujZapisy;     {Usuwa wszystkie hasla ze zmiennej ZAPISY}

     procedure dopisz(slowa:string); {dopisanie danych do konsoli}

     {OPERACJE NA WCZYTYWANYCH DANYCH}
     function CzytajText(namefile1:string;nrl:integer):string; {Czyta tekst zawarty pomiedzy znakami " " z lini o numerze}
                                                               {,,nrl'' w pliku o nazwie ,,namefile1''}
     {OPERACJE NA CECHACH I UMIEJETNOSCIACH POSTACI}
     Function CalkowitySkill(nrp,nrs:byte):byte;     {Zliczanie calkowitego poziomu umiejetnosci}
     Function ZliczEXP:real;                         {zliczanie doswiadczenia potrzebnego do awansu na kolejny poziom}
     Function StopienKarmy:string;                   {Okreslanie stopnia karmy postaci}

     {IDENTYFIKACJA PRZEDMIOTOW}
     Function IdName(Nrp:integer):string;  {Identyfikuje nazwe przedmiotu o numerze ,,nrp''}
     Function IdPrice(Nrp:integer):integer;{Identyfikuje cene przedmiotu o numerze ,,nrp''}
     Function IdDam(Nrp:integer):integer;  {Identyfikuje DAMAGE przedmiotu o numerze ,,nrp''}
     Function IdRes(Nrp:integer):integer;  {Identyfikuje RESISTANCE przedmiotu o numerze ,,nrp''}
     Function IdGfx(Nrp:integer):integer;  {Identyfikuje numer rysunku przedmiotu o numerze ,,nrp''}
     Function IdTyp(Nrp:integer):integer;  {Identyfikuje typ przedmiotu o numerze ,,nrp''}
     Function IdScript(Nrp:integer):string;{Identyfikuje nazwe pliku skryptu przedmiotu o numerze ,,nrp''}
     Function IdAmmo(Nrp:integer):integer; {Identyfikuje rodzaj amunicji wykorzystywanej przez przedmiot o numerze ,,nrp''}
     Function IdOpis(Nrp:integer):string;  {Zwraca tekst z pliku *.msg bedacy opisem przedmiotu}
     Function IdFrame(Nrp:integer):integer;{Identyfikuje numer obrazka przedmiotu w urzyciu}
     Function IdFire(Nrp:integer):integer; {identyfikuje ilosc amunicji wystrzeliwanej podczas strzalu}
     Function IdAmmoLoad(nrp:integer):integer; {identyfikuje ilosc amunicji mieszczacej sie w broni}
     Function IdRange(Nrp:integer):integer; {identyfikuje zasieg broni}
     Function IdAPC(Nrp:integer):integer;  {identyfikuje koszt uzycia broni w punktach akcji}
     {FUNKCJE POMOCNICZE PRZY OPEROWANIU POSTACIAMI}
     Function Xpoz(nrp:byte):integer;   {zliczanie pozycji x postaci na ekranie monitora}
     Function Ypoz(nrp:byte):integer;   {zliczanie pozycji y postaci na ekranie monitora}

     Function XpozS(nrp:byte):integer;
     Function YpozS(nrp:byte):integer;
     Function XpozSz(nrp:byte):integer;
     Function YpozSz(nrp:byte):integer;


     {OPERACJE NA DANYCH MAPY}
     Procedure SetUser(nw:string);
     Procedure LoadMap(nf:string);
     Procedure SaveMap(nf:string);
     Procedure NewMap;
     Procedure CzyscListeUrzytych;
     Procedure ChangeMap(way:byte);
     Function SprawdzListeUrzytych(namef:string):boolean;
     Procedure DopiszDoListy(namef:string);
     {UPLYW CZASU}
     Procedure SprawdzChoroby;
     Procedure SprawdzLeczenie;
     Procedure DodajMinute;


implementation
var  f:text;



{===============================================}
{=     PROCEDURA WCZYTUJACA DANE STARTOWE      =}
{=                                             =}
{=  PLIK DOCELOWY: DATA/GAME/Game.ini          =}
{===============================================}
procedure DaneStartowe;
var slowo:string;
begin
assign(f,danegry+'Game.ini');
reset(f);
repeat
readln(f,slowo);
if lewo(slowo,15)='MapaStartowa = ' then
                                   begin
                                    MapaStartowa:=pomin(slowo,15);
                                   end;
if lewo(slowo,8)='Slabe = ' then
                           begin
                            slabe:=zmien(pomin(slowo,8));
                           end;
if lewo(slowo,10)='Srednie = ' then
                           begin
                            srednie:=zmien(pomin(slowo,10));
                           end;
if lewo(slowo,9)='Trudne = ' then
                           begin
                            trudne:=zmien(pomin(slowo,9));
                           end;

if lewo(slowo,8)='Dzien = ' then
                           begin
                            dd:=zmien(pomin(slowo,8));
                           end;
if lewo(slowo,10)='Miesiac = ' then
                           begin
                            mm:=zmien(pomin(slowo,10));
                           end;
if lewo(slowo,6)='Rok = ' then
                           begin
                            rr:=zmien(pomin(slowo,6));
                           end;
if lewo(slowo,10)='Godzina = ' then
                           begin
                            gg:=zmien(pomin(slowo,10));
                           end;
if lewo(slowo,9)='Minuta = ' then
                           begin
                            mn:=zmien(pomin(slowo,9));
                           end;
if lewo(slowo,10)='Sekunda = ' then
                           begin
                            ss:=zmien(pomin(slowo,10));
                           end;
if lewo(slowo,10)='Zadania = ' then
                           begin
                            IloscZadan:=zmien(pomin(slowo,10));
                           end;
if lewo(slowo,9)='Zapisy = ' then ilosczapisow:=zmien(pomin(slowo,9));
if lewo(slowo,5)='MX = ' then mx:=zmien(pomin(slowo,5));
if lewo(slowo,5)='MY = ' then my:=zmien(pomin(slowo,5));
if lewo(slowo,6)='XST = ' then xst:=zmien(pomin(slowo,6));
if lewo(slowo,6)='YST = ' then yst:=zmien(pomin(slowo,6));
if lewo(slowo,6)='XPW = ' then xPW:=zmien(pomin(slowo,6));
if lewo(slowo,6)='YPW = ' then yPW:=zmien(pomin(slowo,6));
until eof(f);
close(f);
assign(lwm,mapy+'worldmap.dat');
reset(lwm);
read(lwm,worldmap);
close(lwm);
end;
{=======================================================}
{= FUNKCJA ODCZYTUJACA NAZWE ZADANIA O PODANYM NUMERZE =}
{=                                                     =}
{=        PLIK DOCELOWY: DATA/TEXT/Zadania.msg         =}
{=======================================================}
Function NazwaZadania(nrz:byte):string;
begin
nazwazadania:=czytajtext(tekstyzadan+'Zadania.msg',nrz);
end;
{===============================================}
{=     PROCEDURA WCZYTUJACA NAZWY ZAPISOW      =}
{=                                             =}
{=  PLIK DOCELOWY: DATA/TEXT/Zapisy.msg        =}
{===============================================}
procedure WczytajdaneZapisow;
var slowos:string;
    aktk:byte;
begin
for aktk:=1 to IloscZapisow do
           begin
            zapis[aktk].nazwa:=czytajtext(tekstyzadan+'Zapisy.msg',aktk);
            zapis[aktk].skrypt:=czytajtext(danegry+'SKRZAP.txt',aktk);
            zapis[aktk].status:=niezapisany;
           end;

end;
{===============================================}
{=     PROCEDURA WCZYTUJACA DANE KARMY         =}
{=                                             =}
{=  PLIK DOCELOWY: DATA/GAME/karma.txt         =}
{===============================================}
procedure WczytajDaneKarmy;
var slowos:string;
    aktk:byte;
    opuzn:integer;
begin
opuzn:=2000;
assign(f,danegry+'karma.txt');
reset(f);
for aktk:=1 to 10 do danekarmy[aktk]:='';
aktk:=1;
repeat
readln(f,slowos);
      if lewo(slowos,7)='[NR] = ' then aktk:=zmien(pomin(slowos,7));
      if lewo(slowos,8)='Nazwa = ' then DaneKarmy[aktk]:=pomin(slowos,8);
      if lewo(slowos,15)='Reputacja(1) = ' then Reputacja[1]:=pomin(slowos,15);
      if lewo(slowos,15)='Reputacja(2) = ' then Reputacja[2]:=pomin(slowos,15);
      if lewo(slowos,15)='Reputacja(3) = ' then Reputacja[3]:=pomin(slowos,15);
      if lewo(slowos,15)='Reputacja(4) = ' then Reputacja[4]:=pomin(slowos,15);
      if lewo(slowos,15)='Reputacja(5) = ' then Reputacja[5]:=pomin(slowos,15);
      if lewo(slowos,15)='Reputacja(6) = ' then Reputacja[6]:=pomin(slowos,15);
      if lewo(slowos,15)='Reputacja(7) = ' then Reputacja[7]:=pomin(slowos,15);
      if lewo(slowos,15)='Reputacja(8) = ' then Reputacja[8]:=pomin(slowos,15);
      if lewo(slowos,15)='Reputacja(9) = ' then Reputacja[9]:=pomin(slowos,15);
      if lewo(slowos,16)='Reputacja(10) = ' then Reputacja[10]:=pomin(slowos,16);
until eof(f);
close(f);
end;
{                                                               }
{                                                               }
{                                                               }
{                                                               }
{            OPERACJE NA DANYCH OBIEKTOW INTERFACE'U            }
{                                                               }
{                                                               }
{                                                               }
{                                                               }
{============================================}
{= SPRAWDZANIE CZY PRZYCISK ZOSTAL WCISNIETY=}
{============================================}
function CzyWcisnieto(nrp:byte):boolean;
begin
CzyWcisnieto:=false;
if (a>przyciski[nrp].xp1) and (a<przyciski[nrp].xp2) and (b>przyciski[nrp].yp1) and (b<przyciski[nrp].yp2) then
                             Czywcisnieto:=true;

end;

{=======================================================}
{=            DOPISANIE WIERSZA DO KONSOLI             =}
{=======================================================}
procedure dopisz(slowa:string);
var p5:integer;
begin
p5:=0;
repeat
p5:=p5+1;
konsola[p5]:=konsola[p5+1];
until p5=6;
konsola[6]:='';
if length(slowa)>49 then
                      begin
                       konsola[6]:=lewo(slowa,49);
                       slowa:=pomin(slowa,49);
                       dopisz(slowa);
                      end
                      else
                      begin
                       konsola[6]:=slowa;
                      end;
end;

{=============================================}
{=       PROCEDURA PRZYDZIELANIA EKRANU      =}
{=============================================}
Procedure TworzEkran(Xe1,Ye1,Xe2,Ye2:integer; Typek:byte);
begin
if liczbekranow<6 then
                    begin
                     Liczbekranow:=Liczbekranow+1;
                     Ekrany[liczbekranow].xe1:=xe1;
                     Ekrany[liczbekranow].xe2:=xe2;
                     Ekrany[liczbekranow].ye1:=ye1;
                     Ekrany[liczbekranow].ye2:=ye2;
                     Ekrany[liczbekranow].typ:=typek;
                     Ekrany[liczbekranow].lo:=0;
                    end;
end;
{=============================================}
{=    PROCEDURA USUWAJACA EKRANY Z PAMIECI   =}
{=============================================}
Procedure ZerujEkrany;
var i:byte;
begin
for i:=1 to 6 do
       begin
        Ekrany[i].xe1:=0;
        Ekrany[i].ye1:=0;
        Ekrany[i].xe2:=0;
        Ekrany[i].ye2:=0;
        Ekrany[i].typ:=0;
        Ekrany[i].lo:=0;
       end;
LiczbEkranow:=0;
end;
{=============================================}
{=    PROCEDURA USUWAJACA ZAPISY Z PAMIECI   =}
{=============================================}
Procedure ZerujZapisy;
var i:byte;
begin
for i:=1 to 11 do
       begin
        zapisy[i].haslo:='';
       end;
Liczbzapisow:=0;
end;

{=============================================}
{=     PROCEDURA PRZYDZIELANIA PRZYCISKU     =}
{=============================================}
Procedure TworzPrzycisk(xo1,yo1,xo2,yo2:integer; StanPr,TypPr:byte; TekstPR:string);
begin
if Liczbprzycisk<11 then
                    begin
                     inc(liczbPrzycisk);
                     Przyciski[liczbprzycisk].xp1:=xo1;
                     Przyciski[liczbprzycisk].xp2:=xo2;
                     Przyciski[liczbprzycisk].yp1:=yo1;
                     Przyciski[liczbprzycisk].yp2:=yo2;
                     Przyciski[liczbprzycisk].Stan:=stanpr;
                     Przyciski[liczbprzycisk].Typ:=typpr;
                     Przyciski[liczbprzycisk].tekst:=tekstpr;
                    end;
end;
{=============================================}
{=  PROCEDURA USUWAJACA PRZYCISKI Z PAMIECI  =}
{=============================================}
Procedure ZerujPrzyciski;
var i:byte;
begin
for i:=1 to 11 do
      begin
       Przyciski[i].Xp1:=0;
       Przyciski[i].Xp2:=0;
       Przyciski[i].Yp1:=0;
       Przyciski[i].Yp1:=0;
       Przyciski[i].Stan:=0;
       Przyciski[i].Typ:=0;
       Przyciski[i].Tekst:='';
      end;
LiczbPrzycisk:=0;
end;
{=============================================}
{=       PROCEDURA PRZYDZIELANIA LISTY       =}
{=============================================}
Procedure TworzElementListy(xl,yl:integer; Tekst:string);
begin
if Liczblist<11 then
            begin
             inc(Liczblist);
             Lista[liczblist].xl:=xl+10;
             Lista[liczblist].yl:=yl+10;
             Lista[liczblist].tekst:=tekst;
            end;
end;
{=============================================}
{=    PROCEDURA USUWAJACA LISTE Z PAMIECI    =}
{=============================================}
Procedure ZerujListe;
var i:byte;
begin
for i:=1 to 11 do
      begin
       Lista[i].Xl:=0;
       Lista[i].yl:=0;
       Lista[i].tekst:='';
      end;
Liczblist:=0;
end;
{=============================================}
{=       PROCEDURA PRZYDZIELANIA OPCJI       =}
{=============================================}
Procedure TworzOpcje(xl,yl:integer; Tekst:string);
begin
if Liczbopcji<11 then
            begin
             inc(Liczbopcji);
             Opcje[liczbopcji].xop:=xl;
             Opcje[liczbopcji].yop:=yl;
             Opcje[liczbopcji].tekst:=tekst;
            end;
end;
{=============================================}
{=    PROCEDURA USUWAJACA LISTE Z PAMIECI    =}
{=============================================}
Procedure ZerujOpcje;
var i:byte;
begin
for i:=1 to 11 do
      begin
       opcje[i].Xop:=0;
       opcje[i].yop:=0;
       opcje[i].tekst:='';
      end;
Liczbopcji:=0;
end;

{                                                               }
{                                                               }
{                                                               }
{                                                               }
{       OPERACJE NA CECHACH I UMIEJTNOSCIACH POSTACI           }
{                                                               }
{                                                               }
{                                                               }
{                                                               }

{============================================}
{=     OKRESLANIE STOPNIA KARMY POSTACI     =}
{============================================}
Function StopienKarmy:string;
begin
if karma<=-1600 then StopienKarmy:=DaneKarmy[1];
if (karma>-1600) and (karma<-800) then StopienKarmy:=DaneKarmy[2];
if (Karma>-800) and (karma<-100) then stopienKarmy:=DaneKarmy[3];
if (karma>-100) and (karma<100) then stopienkarmy:=danekarmy[4];
if (karma>100) and (karma<800) then stopienkarmy:=daneKarmy[5];
if (karma>800) and (karma<1600) then stopienkarmy:=danekarmy[6];
if (karma>1600) and (karma<2200) then stopienkarmy:=danekarmy[7];
if (karma>2200) and (karma<3000) then stopienkarmy:=danekarmy[8];
if (karma>3000) and (karma<5000) then stopienkarmy:=danekarmy[9];
if karma>=5000 then StopienKarmy:=DaneKarmy[10];





end;

{===================================================================}
{= ZLICZANIE POTRZEBNEGO DOSWIADCZENIA DO AWANSU NA KOLEJNY POZIOM =}
{===================================================================}
Function ZliczEXP:real;
var i:byte;
    Zmm:real;
    Skk:integer;
begin
skk:=1000;
zmm:=0;
for i:=1 to poziom do
       begin
        zmm:=zmm+skk;
        skk:=skk+500;
       end;
ZliczExp:=zmm;
end;
{=======================================================}
{= FUNKCJA OBLICZANIA CALKOWITEGO POZIOMU UMIEJETNOSCI =}
{=======================================================}
function CalkowitySkill(nrp,nrs:byte):byte;
var pam:byte;
begin
{BRON RECZNA: 5+(ZR*4) }
if nrs=bron then pam:=5+(mapa.postacie[nrp].cechy[zrecznosc]*4);
{BRON BIALA: 20+(2*(ZR+SI))}
if nrs=bronb then pam:=20+(2*(mapa.postacie[nrp].cechy[zrecznosc]+mapa.postacie[nrp].cechy[sila]));
{NIEUZBROJONY: 30+(2*(ZR+SI))}
if nrs=nieuzbrojony then pam:=30+(2*(mapa.postacie[nrp].cechy[zrecznosc]+mapa.postacie[nrp].cechy[sila]));
{HANDEL: 4*CH}
if nrs=handel then pam:=4*(mapa.postacie[nrp].cechy[charyzma]);
{NAUKA: 4*INT}
if nrs=nauka then pam:=4*(mapa.postacie[nrp].cechy[inteligencja]);
{KRADZIEZ: 3*ZR}
if nrs=kradzierz then pam:=3*(mapa.postacie[nrp].cechy[zrecznosc]);
{OTWIERANIE ZAMKOW: 10+(PE+ZR)}
if nrs=otwieraniezamkow then pam:=10+(mapa.postacie[nrp].cechy[zrecznosc]+mapa.postacie[nrp].cechy[percepcja]);
{LECZENIE: 5+(PE+IN)}
if nrs=leczenie then pam:=5+(mapa.postacie[nrp].cechy[percepcja]+mapa.postacie[nrp].cechy[inteligencja]);
inc(pam,mapa.postacie[nrp].skills[nrs]);
if nrp=0 then inc(pam,skillslev[nrs]);
CalkowitySkill:=pam;
end;


{                                                               }
{                                                               }
{                                                               }
{                                                               }
{    OPERACJE NA WCZYTYWANYCH DANYCH TEKSTOWYCH I LICZBOWYCH    }
{                                                               }
{                                                               }
{                                                               }
{                                                               }

{==========================================}
{= FUNKCJA CZYTANIA TEKSTU W PODANEJ LINI =}
{==========================================}
function CzytajText(namefile1:string;nrl:integer):string;
var s1,sl1,sl2:string;
    h:text;
begin
assign(h,namefile1);
sl1:='';
sl2:='';
czytajtext:='';
reset(h);
repeat
readln(h,sl1);
if lewo(sl1,1)='<' then
                     begin
                      sl2:=pomin(lewo(sl1,6),1);
                      repeat
                       if lewo(sl2,1)='0' then sl2:=pomin(sl2,1);
                      until lewo(sl2,1)<>'0';
                      if zmien(sl2)=nrl then
                                          begin
                                           if SzukajText(sl1,'"') then sl2:=WytnijCytat(pomin(sl1,8)) else sl2:='';
                                          end
                                          else
                                           begin
                                            sl2:='';
                                           end;
                     end;
until (eof(h)) or (sl2<>'');
close(h);
czytajtext:=sl2;
end;

{                                                               }
{                                                               }
{                                                               }
{                                                               }
{                           IDENTYFIKACJA                       }
{                                                               }
{                                                               }
{                                                               }
{                                                               }

{===============================================}
{=       IDENTYFIKACJA NAZWY PRZEDMIOTU        =}
{===============================================}
Function IdName(Nrp:integer):string;
var h:text;
    Sciezka:string;
begin
idname:='';
if nrp<>0 then
begin
sciezka:=daneprzedmiotow+Czytajtext(danegry+'Inv.txt',nrp)+'.inv';
assign(h,sciezka);
reset(h);
if length(czytajtext(sciezka,1))>16 then IdName:=lewo(czytajtext(sciezka,1),16)
                                    else IdName:=czytajtext(sciezka,1);
close(h);
end;
end;
{===============================================}
{=       IDENTYFIKACJA CENY PRZEDMIOTU         =}
{===============================================}
Function IdPrice(Nrp:integer):integer;
var h:text;
    Sciezka,sl:string;
begin
idprice:=0;
if nrp<>0 then
begin
sciezka:=daneprzedmiotow+Czytajtext(danegry+'Inv.txt',nrp)+'.inv';
assign(h,sciezka);
reset(h);
repeat
readln(h,sl);
if lewo(sl,7)='Cena = ' then IdPrice:=zmien(pomin(sl,7));
until eof(h);
close(h);
end;
end;
{====================================================}
{= IDENTYFIKACJA OBRAZEN ZADAWANYCH PRZEZ PRZEDMIOT =}
{====================================================}
Function IdDam(Nrp:integer):integer;

var h:text;
    Sciezka,sl:string;
begin
iddam:=0;
if nrp<>0 then
begin
sciezka:=daneprzedmiotow+Czytajtext(danegry+'Inv.txt',nrp)+'.inv';
assign(h,sciezka);
reset(h);
repeat
readln(h,sl);
if lewo(sl,9)='Damage = ' then IdDam:=zmien(pomin(sl,9));
until eof(h);
close(h);
end;
end;
{========================================================}
{= IDENTYFIKACJA OBRAZEN WYTRZYMYWANYCH PRZEZ PRZEDMIOT =}
{========================================================}
Function IdRes(Nrp:integer):integer;
var h:text;
    Sciezka,sl:string;
begin
idres:=0;
if nrp<>0 then
begin
sciezka:=daneprzedmiotow+Czytajtext(danegry+'Inv.txt',nrp)+'.inv';
assign(h,sciezka);
reset(h);
repeat
readln(h,sl);
if lewo(sl,13)='Resistance = ' then Idres:=zmien(pomin(sl,13));
until eof(h);
close(h);
end;
end;
{========================================================}
{=          IDENTYFIKACJA OBRAZKA PRZEDMIOTU            =}
{========================================================}
Function IdGfx(Nrp:integer):integer;
var h:text;
    Sciezka,sl:string;
begin
idgfx:=0;
if nrp<>0 then
begin
sciezka:=daneprzedmiotow+Czytajtext(danegry+'Inv.txt',nrp)+'.inv';
assign(h,sciezka);
reset(h);
repeat
readln(h,sl);
if lewo(sl,6)='GFX = ' then Idgfx:=zmien(pomin(sl,6));
until eof(h);
close(h);
end;
end;
{========================================================}
{=           IDENTYFIKACJA TYPU PRZEDMIOTU              =}
{========================================================}
Function IdTyp(Nrp:integer):integer;
var h:text;
    Sciezka,sl:string;
begin
idtyp:=0;
if nrp<>0 then
begin
sciezka:=daneprzedmiotow+Czytajtext(danegry+'Inv.txt',nrp)+'.inv';
assign(h,sciezka);
reset(h);
repeat
readln(h,sl);
if lewo(sl,7)='Type = ' then Idtyp:=zmien(pomin(sl,7));
until eof(h);
close(h);
end;
end;
{========================================================}
{=      IDENTYFIKACJA NAZWY SKRYPTU PRZEDMIOTU          =}
{========================================================}
Function IdScript(Nrp:integer):string;
var h:text;
    Sciezka,sl:string;
begin
Idscript:='';
if nrp<>0 then
begin
sciezka:=daneprzedmiotow+Czytajtext(danegry+'Inv.txt',nrp)+'.inv';
assign(h,sciezka);
reset(h);
repeat
readln(h,sl);
if lewo(sl,9)='Script = ' then Idscript:=pomin(sl,9);
until eof(h);
close(h);
end;

end;
{=========================================================}
{= IDENTYFIKACJA RODZAJU AMUNICJI JAKIEJ UZYWA PRZEDMIOT =}
{=========================================================}

{podaje numer przedmiotu ktory jest amunicja}
Function IdAmmo(Nrp:integer):integer;
var h:text;
    Sciezka,sl:string;
begin
Idammo:=0;
if nrp<>0 then
begin
sciezka:=daneprzedmiotow+Czytajtext(danegry+'Inv.txt',nrp)+'.inv';
assign(h,sciezka);
reset(h);
repeat
readln(h,sl);
if lewo(sl,7)='Ammo = ' then Idammo:=zmien(pomin(sl,7));
until eof(h);
close(h);
end;
end;
{=========================================================}
{=       ODCZYTANIE OPISU PRZEDMIOTU Z PLIKU *.MSG       =}
{=========================================================}
Function IdOpis(Nrp:integer):string;
var h:text;
    Sciezka,sl:string;
begin
Idopis:='';
if nrp<>0 then
begin
sciezka:=OpisyPrzedmiotow+'inv.msg';
IdOpis:=czytajtext(sciezka,nrp);
end;
end;
{========================================================}
{=    IDENTYFIKACJA OBRAZKA PRZEDMIOTU W URZYCIU        =}
{========================================================}
Function IdFrame(Nrp:integer):integer;
var h:text;
    Sciezka,sl:string;
begin
idframe:=0;
if nrp<>0 then
begin
sciezka:=daneprzedmiotow+Czytajtext(danegry+'Inv.txt',nrp)+'.inv';
assign(h,sciezka);
reset(h);
repeat
readln(h,sl);
if lewo(sl,8)='Frame = ' then Idframe:=zmien(pomin(sl,8));
until eof(h);
close(h);
end;
end;

{=========================================================}
{= IDENTYFIKACJA CZESTOTLIWOSCI WYSTRZELIWANYCH POCISKOW =}
{=========================================================}
Function IdFire(Nrp:integer):integer;
var h:text;
    Sciezka,sl:string;
begin
idfire:=0;
if nrp<>0 then
begin
sciezka:=daneprzedmiotow+Czytajtext(danegry+'Inv.txt',nrp)+'.inv';
assign(h,sciezka);
reset(h);
repeat
readln(h,sl);
if lewo(sl,7)='Fire = ' then Idfire:=zmien(pomin(sl,7));
until eof(h);
close(h);
end;
end;
{=========================================================}
{= IDENTYFIKACJA ILOSCI AMUNICJI MIESZCZACEJ SIE W BRONI =}
{=========================================================}
Function IdAmmoLoad(Nrp:integer):integer;
var h:text;
    Sciezka,sl:string;
begin
idammoload:=0;
if nrp<>0 then
begin
sciezka:=daneprzedmiotow+Czytajtext(danegry+'Inv.txt',nrp)+'.inv';
assign(h,sciezka);
reset(h);
repeat
readln(h,sl);
if lewo(sl,7)='Load = ' then Idammoload:=zmien(pomin(sl,7));
until eof(h);
close(h);
end;
end;
{=========================================================}
{=             IDENTYFIKACJA ZASIEGU BRONI               =}
{=========================================================}
Function IdRange(Nrp:integer):integer;
var h:text;
    Sciezka,sl:string;
begin
idrange:=0;
if nrp<>0 then
begin
sciezka:=daneprzedmiotow+Czytajtext(danegry+'Inv.txt',nrp)+'.inv';
assign(h,sciezka);
reset(h);
repeat
readln(h,sl);
if lewo(sl,8)='Range = ' then Idrange:=zmien(pomin(sl,7));
until eof(h);
close(h);
end;
end;
{=========================================================}
{=        IDENTYFIKACJA KOSZTU UZYCIA PRZEDMIOTU         =}
{=========================================================}
Function IdAPC(Nrp:integer):integer;
var h:text;
    Sciezka,sl:string;
begin
idapc:=0;
if nrp<>0 then
begin
sciezka:=daneprzedmiotow+Czytajtext(danegry+'Inv.txt',nrp)+'.inv';
assign(h,sciezka);
reset(h);
repeat
readln(h,sl);
if lewo(sl,6)='APC = ' then Idapc:=zmien(pomin(sl,6));
until eof(h);
close(h);
end;
end;

{                                                       }
{                                                       }
{                   OPERACJE NA MAPACH                  }
{                                                       }
{                                                       }

{===============================================}
{=           USTAWIENIE URZYTKOWNIKA           =}
{===============================================}
Procedure SetUser(nw:string);
begin
urzytkownik:=nw;
end;
{===============================================}
{= SPRAWDZANIE CZY PLIK ZNAJDUJE SIE NA LISCIE =}
{===============================================}
Function SprawdzListeUrzytych(namef:string):boolean;
var wrodex:string;
begin
sprawdzlisteurzytych:=false;
assign(f,urzytkownicy+urzytkownik+'/'+'otwarte.txt');
reset(f);
repeat
readln(f,wrodex);
until (wrodex=namef) or eof(f);
close(f);
if wrodex=namef then sprawdzlisteurzytych:=true;
end;
{===================================================}
{=                WCZYTYWANIE MAP                  =}
{===================================================}
Procedure LoadMap(nf:string);
var t:file of Tmap;
    Postz:Tpostac;
begin
if not SprawdzListeUrzytych(nf) then assign(t,mapy+nf+'.map')
                      else assign(t,urzytkownicy+urzytkownik+'/'+nf+'.map');
reset(t);
postz:=mapa.postacie[0];
read(t,mapa);
close(t);
mapa.postacie[0]:=postz;
mapa.nazwa:=nf;
MapName:=nf;
end;
{========================================}
{= DOPISYWANIE DO LISTY PLIKOW URZYTYCH =}
{========================================}
Procedure DopiszDoListy(namef:string);
begin
assign(f,urzytkownicy+urzytkownik+'/'+'otwarte.txt');
append(f);
writeln(f,namef);
close(f);
end;
{=====================================}
{= WYMAZYWANIE LISTY PLIKOW URZYTYCH =}
{=====================================}
Procedure CzyscListeUrzytych;
begin
assign(f,urzytkownicy+urzytkownik+'/'+'otwarte.txt');
rewrite(f);
close(f);
end;
{===================================================}
{=                ZAPISYWANIE MAP                  =}
{===================================================}
Procedure SaveMap(nf:string);
var t:file of Tmap;
begin
assign(t,urzytkownicy+urzytkownik+'/'+nf+'.map');
rewrite(t);
write(t,mapa);
close(t);
DopiszDoListy(nf);
end;
{===================================================}
{=                CZYSZCZENIE MAPY                 =}
{===================================================}
Procedure NewMap;
var i,j:byte;
begin
mapa.rozx:=0;
mapa.rozy:=0;
for j:=1 to 80 do for i:=1 to 80 do
          begin
           mapa.tiles[i,j]:=0;
           mapa.va[i,j]:=0;
           mapa.sciany[i,j]:=0;
          end;
for i:=0 to 20 do
        begin
         mapa.postacie[i].imie:='';
         mapa.postacie[i].xp:=0;
         mapa.postacie[i].yp:=0;
         mapa.postacie[i].status:=niema;
         mapa.postacie[i].zmienne[1]:=0;
         mapa.postacie[i].zmienne[2]:=0;
         mapa.postacie[i].zmienne[3]:=0;
         mapa.postacie[i].zmienne[4]:=0;
         mapa.postacie[i].zmienne[5]:=0;
         mapa.postacie[i].zmienne[6]:=0;
         mapa.postacie[i].rysunek:=0;
         mapa.postacie[i].cechy[1]:=0;
         mapa.postacie[i].cechy[2]:=0;
         mapa.postacie[i].cechy[3]:=0;
         mapa.postacie[i].cechy[4]:=0;
         mapa.postacie[i].cechy[5]:=0;
         mapa.postacie[i].cechy[6]:=0;
         mapa.postacie[i].cechy[7]:=0;
         mapa.postacie[i].skrypt:='';
         mapa.postacie[i].skills[1]:=0;
         mapa.postacie[i].skills[2]:=0;
         mapa.postacie[i].skills[3]:=0;
         mapa.postacie[i].skills[4]:=0;
         mapa.postacie[i].skills[5]:=0;
         mapa.postacie[i].skills[6]:=0;
         mapa.postacie[i].skills[7]:=0;
         mapa.postacie[i].skills[8]:=0;
         mapa.postacie[i].ai:=0;
         mapa.postacie[i].licznikai:=0;
         for j:=1 to 24 do
              begin
               mapa.postacie[i].ekwipunek[j]:=0;
               mapa.postacie[i].spec[j]:=0;
              end;
         mapa.postacie[i].maxap:=0;
         mapa.postacie[i].ap:=0;
         mapa.postacie[i].bron:=0;
         mapa.postacie[i].bronspec:=0;
         mapa.postacie[i].zbroja:=0;
         mapa.postacie[i].hp:=0;
         mapa.postacie[i].maxhp:=0;
         mapa.postacie[i].nastawienie:=0;
         mapa.postacie[i].choroby[1]:=0;
         mapa.postacie[i].choroby[2]:=0;
         mapa.postacie[i].choroby[3]:=0;
        end;
for i:=1 to 50 do
        begin
         mapa.scenerie[i].rysunek:=0;
         mapa.scenerie[i].typ:=0;
         mapa.scenerie[i].xs:=0;
         mapa.scenerie[i].ys:=0;
         mapa.scenerie[i].skrypt:='';
         mapa.scenerie[i].powiazanie:=0;
         mapa.scenerie[i].stan:=0;
         mapa.scenerie[i].wytrzymalosc:=0;
         mapa.scenerie[i].stopien:=0;
         mapa.scenerie[i].klucz:=0;
        end;
for i:=1 to 40 do
        begin
         mapa.szafki[i].rysunek:=0;
         mapa.szafki[i].xs:=0;
         mapa.szafki[i].ys:=0;
         for j:=1 to 24 do
                 begin
                  mapa.szafki[i].sprzety[j]:=0;
                  mapa.szafki[i].spec[j]:=0;
                 end;
         mapa.szafki[i].powiazanie:=0;
        end;
for i:=1 to 25 do mapa.trigs[i]:=0;
for i:=1 to 8 do mapa.wyjscia[i]:='';
for i:=1 to 10 do
           begin
            mapa.spatiale[i].nazwa:='';
            mapa.spatiale[i].exec:=0;
            mapa.spatiale[i].xs:=0;
            mapa.spatiale[i].ys:=0;
           end;

end;
{====================================}
{=  ZMIANA MAPY NA PODSTAWIE WYJSC  =}
{====================================}
Procedure ChangeMap(way:byte);
begin
Savemap(MapName);
loadmap(mapa.wyjscia[way]);
end;
{                                                              }
{                                                              }
{        FUNKCJE POMOCNICZE PRZY OPEROWANIU POSTACIAMI         }
{                                                              }
{                                                              }

{======================================}
{=    OKRESLENIE POZYCJI X POSTACI    =}
{======================================}
Function Xpoz(nrp:byte):integer;
begin
Xpoz:=(mappozx-(20*(mx-1)))+((mapa.postacie[nrp].xp-1)*20);
end;
{======================================}
{=    OKRESLENIE POZYCJI Y POSTACI    =}
{======================================}
Function Ypoz(nrp:byte):integer;
begin
Ypoz:=(mappozy-(30*(my-1)))+((mapa.postacie[nrp].yp-1)*30);
end;
{======================================}
{=    OKRESLENIE POZYCJI X SCENERII   =}
{======================================}
Function XpozS(nrp:byte):integer;
begin
Xpozs:=(mappozx-(20*(mx-1)))+((mapa.scenerie[nrp].xs-1)*20);
end;
{======================================}
{=    OKRESLENIE POZYCJI Y SCENERII   =}
{======================================}
Function YpozS(nrp:byte):integer;
begin
Ypozs:=(mappozy-(30*(my-1)))+((mapa.scenerie[nrp].ys-1)*30);
end;
{======================================}
{=    OKRESLENIE POZYCJI X SZAFKI     =}
{======================================}
Function XpozSz(nrp:byte):integer;
begin
Xpozsz:=(mappozx-(20*(mx-1)))+((mapa.szafki[nrp].xs-1)*20);
end;
{======================================}
{=    OKRESLENIE POZYCJI Y SZAFKI     =}
{======================================}
Function YpozSz(nrp:byte):integer;
begin
Ypozsz:=(mappozy-(30*(my-1)))+((mapa.szafki[nrp].ys-1)*30);
end;
{===============================================================}
{=                                                             =}
{=                                                             =}
{=                                                             =}
{=                         UPLYW CZASU                         =}
{=                                                             =}
{=                                                             =}
{=                                                             =}
{===============================================================}

{======================================================================}
{=   SPRAWDZANIE CZY POSTAC OTRZYMA OBRAZENIA ZE WZGLEDU NA CHOROBY   =}
{======================================================================}
Procedure SprawdzChoroby;
var n:byte;
    slowko:string;
begin
for n:=0 to 20 do if mapa.postacie[n].status=normalny then
    begin
     if n>0 then slowko:=mapa.postacie[n].imie+' czuje'
             else slowko:='Czujesz';
     if mapa.postacie[n].choroby[napromieniowanie]>0 then
                         begin
                          dec(mapa.postacie[n].hp,trunc(mapa.postacie[n].choroby[napromieniowanie]*0.5));
                          dopisz('* '+slowko+' obrazenia z powodu napromieniowania.');
                          dec(mapa.postacie[n].choroby[napromieniowanie]);
                          if mapa.postacie[n].choroby[napromieniowanie]=0 then
                                         dopisz('* '+slowko+' sie znacznie lepiej.');
                         end;
     if mapa.postacie[n].choroby[trucizna]>0 then
                         begin
                          dec(mapa.postacie[n].hp,trunc(mapa.postacie[n].choroby[trucizna]*0.5));
                          dopisz('* '+slowko+' obrazenia z powodu trucizny.');
                          dec(mapa.postacie[n].choroby[trucizna]);
                          if mapa.postacie[n].choroby[trucizna]=0 then
                                dopisz('* '+slowko+' sie znacznie lepiej.');
                         end;
     if n=0 then if mapa.postacie[n].choroby[uzaleznienie]>0 then
                         begin
                          dec(mapa.postacie[n].maxhp,round(mapa.postacie[n].choroby[uzaleznienie]*0.5));
                          if mapa.postacie[n].hp>mapa.postacie[n].maxhp then mapa.postacie[n].hp:=mapa.postacie[n].maxhp;
                          dopisz('* Wszystko wokol zaczyna zwalniac. Twoje uzaleznienie daje o sobie znac.');
                          dopisz('* Twoja wytrzymalosc na obrazenia spada z powodu uzaleznienia.');
                          dec(mapa.postacie[n].choroby[uzaleznienie]);
                          if mapa.postacie[n].choroby[uzaleznienie]=0 then
                                      begin
                                       dopisz('* Udalo ci sie pokonac uzaleznienie. Otrzymujesz 25 PD.');
                                       exp:=exp+25;
                                      end;
                         end;
    end;
end;
{=================================================================}
{=  SPRAWDZANIE ILE PUNKTOW WYLECZYLA POSTAC PODCZAS ODPOCZYNKU  =}
{=================================================================}
Procedure SprawdzLeczenie;
var L:byte;
begin
for l:=0 to 20 do if mapa.postacie[0].status=normalny then
          begin
           if mapa.postacie[l].hp<mapa.postacie[l].maxhp then
                                      begin
                                       inc(mapa.postacie[l].hp,round(mapa.postacie[l].cechy[wytrzymalosc]*0.5));
                                       if mapa.postacie[l].hp>mapa.postacie[l].maxhp then
                                       mapa.postacie[l].hp:=mapa.postacie[l].maxhp;
                                      end;

          end;
end;
{============================================}
{=    DODANIE MINUTY DO AKTUALNEGO CZASU    =}
{============================================}
Procedure DodajMinute;
begin
inc(mn);
if mn=60 then
           begin
            mn:=0;
            inc(gg);
            if mapa.postacie[0].licznikai>0 then dec(mapa.postacie[0].licznikai,1);
            if mapa.postacie[0].licznikai=0 then addap:=0;
            if mapa.promieniowanie>0 then
               begin
                if mapa.postacie[0].choroby[napromieniowanie]+mapa.promieniowanie>255 then
                                 begin
                                  mapa.postacie[0].choroby[napromieniowanie]:=255;
                                 end
                                 else inc(mapa.postacie[0].choroby[napromieniowanie],mapa.promieniowanie);
                dopisz('* Otrzymujesz duza dawke promieniowania.');
               end;
            inc(licznikleczenia);
            if licznikleczenia=2 then
                                   begin
                                    licznikleczenia:=0;
                                    sprawdzchoroby;
                                    SprawdzLeczenie;
                                   end;
            if gg=24 then
                       begin
                        gg:=0;
                        dd:=dd+1;
                        if dd=31 then
                                   begin
                                    dd:=1;
                                    mm:=mm+1;
                                    if mm=13 then
                                               begin
                                                mm:=1;
                                                inc(rr);
                                               end;
                                   end;
                       end;
           end;
if gg>=18 then Poradnia:=noc;
if gg<=7 then poradnia:=noc;
if (gg<18) and (gg>7) then poradnia:=dzien;
if mapa.miejsce>0 then poradnia:=dzien;
end;

end.