Unit Elements;
interface
uses graph,dane,walls,tiles,textopr;
const

     {Palety Kolorow}
     PDzien:array[0..15] of byte=(0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15);
     PNoc:array[0..15] of byte=(0,7,8,7,7,8,7,8,8,15,7,8,15,7,8,15);
      {PROCEDURY POMOCNICZE}
      Procedure Kol(kolor:byte);
      Procedure Wypelnienie(wzor,kolor:byte);

      {ELEMENTY MAPY}
      Procedure Kafelka(xk,yk:integer; typ:byte);
      Procedure Wall(xk,yk:integer; typ:byte);
      Procedure Szafka(xs,ys:integer; typ:byte);
      Procedure Sceneria(xs,ys:integer; typ,stan:byte);
      {PRZEDMIOTY EKWIPUNKU}
      Procedure RysujPrzedmiot(xr,yr,nrp:integer);
      Procedure WczytajRysunek(xx,yy:integer; nazwa:string);

implementation


{=======================================}
{= ZMIANA KOLORU W ZWIAZKU Z PORA DNIA =}
{=======================================}
Procedure Kol(kolor:byte);
begin
if PoraDnia=Dzien then setcolor(Pdzien[kolor]);
if PoraDnia=Noc then if mapa.miejsce=przestrzen then setcolor(Pnoc[kolor])
                        else setcolor(Pdzien[kolor]);
end;
{===================================================}
{= ZMIANA KOLORU WYPENIENIA W ZWIAZKU Z PORA DNIA =}
{===================================================}
Procedure Wypelnienie(wzor,kolor:byte);
begin
if PoraDnia=Dzien then setfillstyle(wzor,Pdzien[kolor]);
if PoraDnia=Noc then if mapa.miejsce=przestrzen then setfillstyle(wzor,Pnoc[kolor])
                        else setfillstyle(wzor,Pdzien[kolor]);
end;
{==================================================}
{= ZWROT KOLORU WYPENIENIA W ZWIAZKU Z PORA DNIA =}
{==================================================}
Function UKolor(kolor:byte):byte;
begin
if PoraDnia=Dzien then UKolor:=Pdzien[kolor];
if PoraDnia=Noc then if mapa.miejsce=przestrzen then ukolor:=Pnoc[kolor]
                        else UKolor:=Pdzien[kolor];
end;

Procedure WczytajRysunek(xx,yy:integer; nazwa:string);
const
      RLinia=1;
      RWypelnienie=2;
      ROkrag=3;
      RProstokat=4;
      RRamka=5;
      RTekst=6;
      RPunkt=7;
      wzorex : FillPatternType = (239,239,239,0,253,253,253,0);
type TGfx=record
         Rodzaj:byte; {polecenie (linia, okrg itd.}
         x1,y1,x2,y2:integer;{dwie wspolrzedne}
         k:byte;             {kolor}
         tryb:byte;          {np. tryb wypelnienia}
         kierunek:byte;     {kierunek}
         tekst:string[10];   {jakis ewentualny tekst do umieszczenia}
        end;
var g:tgfx;
    fg:file of tgfx;
begin
assign(fg,nazwa);
reset(fg);
repeat
read(fg,g);
if g.rodzaj=Rpunkt then
                     begin
                      putpixel(xx+g.x1,yy+g.y1,g.k);
                     end;
if g.rodzaj=Rlinia then
                     begin
                      setcolor(g.k);
                      line(xx+g.x1,yy+g.y1,xx+g.x2,yy+g.y2);
                     end;
if g.rodzaj=Rramka then
                     begin
                      setcolor(g.k);
                      rectangle(xx+g.x1,yy+g.y1,xx+g.x2,yy+g.y2);
                     end;
if g.rodzaj=Rprostokat then
                     begin
                      if g.tryb<12 then setfillstyle(g.tryb,g.k)
                                   else setfillpattern(wzorex,g.k);
                      bar(xx+g.x1,yy+g.y1,xx+g.x2,yy+g.y2);
                     end;
if g.rodzaj=ROkrag then
                     begin
                      setcolor(g.k);
                      circle(xx+g.x1,yy+g.y1,g.x2); {x2 to promie okrgu}
                     end;
if g.rodzaj=Rwypelnienie then
                     begin
                      if g.tryb<12 then setfillstyle(g.tryb,g.k)
                                   else setfillpattern(wzorex,g.k);
                      floodfill(xx+g.x1,yy+g.y1,g.k);
                     end;
if g.rodzaj=Rtekst then
                     begin
                      setcolor(g.k);
                      settextstyle(g.x2,g.kierunek,g.y2);  {x2 to numer czcionki,y2 to rozmiar}
                      outtextxy(xx+g.x1,yy+g.y1,g.tekst);
                     end;

until eof(fg);
close(fg);
end;
{=============================================}
{=      RYSOWANIE WYBRANEGO PRZEDMIOTU       =}
{=============================================}
Procedure RysujPrzedmiot(xr,yr,nrp:integer);
begin
{setfillstyle(1,green);
bar(xr,yr,xr+70,yr+35);}
if nrp=1 then
           begin
            {----PIENIADZE----}
            setcolor(yellow);
            circle(xr+25,yr+17,8);
            setfillstyle(1,yellow);
            FloodFill(xr+25,yr+17,yellow);
            setcolor(black);
            circle(xr+25,yr+17,8);
            setcolor(yellow);
            circle(xr+35,yr+20,8);
            FloodFill(xr+40,yr+20,yellow);
            setcolor(black);
            circle(xr+35,yr+20,8);
            setcolor(yellow);
            circle(xr+45,yr+10,8);
            FloodFill(xr+45,yr+10,yellow);
            setcolor(black);
            circle(xr+45,yr+10,8);
           end;
if nrp=2 then
           begin
            {----SHOT GUN-----}
            setfillstyle(1,brown);
            bar(xr+12,yr+12,xr+50,yr+15);
            bar(xr+5,yr+14,xr+22,yr+15);
            setcolor(brown);
            line(xr+50,yr+12,xr+57,yr+14);
            line(xr+57,yr+14,xr+63,yr+25);
            line(xr+63,yr+25,xr+58,yr+25);
            line(xr+58,yr+25,xr+50,yr+14);;
            floodfill(xr+55,yr+14,brown);
            Setfillstyle(1,8);
            bar(xr+14,yr+14,xr+30,yr+18);
            setcolor(black);
            line(xr+45,yr+15,xr+49,yr+17);
            line(xr+49,yr+17,xr+53,yr+19);
                {obramowanie}
                setcolor(black);
                line(xr+12,yr+12,xr+50,yr+12);
                line(xr+50,yr+12,xr+57,yr+14);
                line(xr+57,yr+14,xr+63,yr+25);
                line(xr+63,yr+25,xr+58,yr+25);
                line(xr+58,yr+25,xr+50,yr+15);
                line(xr+50,yr+15,xr+30,yr+15);
                rectangle(xr+14,yr+14,xr+30,yr+18);

                line(xr+15,yr+15,xr+5,yr+15);
                line(xr+5,yr+15,xr+5,yr+13);
                line(xr+5,yr+13,xr+12,yr+13);
                line(xr+12,yr+15,xr+12,yr+12);
           end;
if nrp=3 then
           begin
            {-----UZI-----}
            setfillstyle(1,8);
            bar(xr+20,yr+10,xr+50,yr+15);
            bar(xr+16,yr+12,xr+20,yr+14);
            bar(xr+36,yr+15,xr+41,yr+26);
            bar(xr+38,yr+26,xr+40,yr+30);
            setcolor(black);
            rectangle(xr+20,yr+10,xr+50,yr+15);
            rectangle(xr+16,yr+12,xr+20,yr+14);
            rectangle(xr+36,yr+15,xr+41,yr+26);
            rectangle(xr+38,yr+26,xr+40,yr+30);
            rectangle(xr+32,yr+15,xr+36,yr+17);
           end;
if nrp=4 then
           begin
            {-----Pistolet-----}
            setfillstyle(1,8);
            bar(xr+30,yr+11,xr+48,yr+15);
            bar(xr+28,yr+12,xr+30,yr+14);
            setcolor(8);
            line(xr+48,yr+10,xr+51,yr+9);
            line(xr+51,yr+9,xr+52,yr+10);
            line(xr+52,yr+10,xr+51,yr+11);
            line(xr+51,yr+11,xr+53,yr+25);
            line(xr+53,yr+25,xr+47,yr+25);
            line(xr+47,yr+25,xr+44,yr++15);
            floodfill(xr+50,yr+11,8);
            setcolor(black);
            rectangle(xr+30,yr+11,xr+48,yr+15);
            rectangle(xr+28,yr+12,xr+30,yr+14);
            line(xr+48,yr+10,xr+51,yr+9);
            line(xr+51,yr+9,xr+52,yr+10);
            line(xr+52,yr+10,xr+51,yr+11);
            line(xr+51,yr+11,xr+53,yr+25);
            line(xr+53,yr+25,xr+47,yr+25);
            line(xr+47,yr+25,xr+44,yr++15);
            line(xr+39,yr+15,xr+41,yr+19);
            line(xr+41,yr+19,xr+45,yr+20);
           end;
if nrp=5 then
           begin
            {-----MashineGun-----}
            setfillstyle(1,8);
            bar(xr+20,yr+15,xr+50,yr+20);
            bar(xr+10,yr+17,xr+20,yr+19);
            bar(xr+30,yr+20,xr+35,yr+28);
            bar(xr+32,yr+28,xr+34,yr+31);
            setcolor(8);
            line(xr+50,yr+15,xr+57,yr+16);
            line(xr+57,yr+16,xr+63,yr+28);
            line(xr+63,yr+28,xr+58,yr+28);
            line(xr+58,yr+28,xr+50,yr+20);
            floodfill(xr+55,yr+17,8);
            setcolor(black);
            rectangle(xr+20,yr+15,xr+50,yr+20);
            line(xr+50,yr+15,xr+57,yr+16);
            line(xr+57,yr+16,xr+63,yr+28);
            line(xr+63,yr+28,xr+58,yr+28);
            line(xr+58,yr+28,xr+50,yr+20);
            rectangle(xr+10,yr+17,xr+20,yr+19);
            rectangle(xr+30,yr+20,xr+35,yr+28);
            rectangle(xr+32,yr+28,xr+34,yr+31);
           end;
if nrp=6 then
           begin
            {------KLUCZ-------}
            setcolor(8);
            circle(xr+50,yr+20,6);
            circle(xr+50,yr+20,3);
            setfillstyle(1,8);
            bar(xr+30,yr+19,xr+43,yr+21);
            bar(xr+31,yr+21,xr+33,yr+24);
            bar(xr+35,yr+21,xr+37,yr+24);
            floodfill(xr+45,yr+20,8);
            setcolor(black);
            circle(xr+50,yr+20,6);
            circle(xr+50,yr+20,4);
            rectangle(xr+30,yr+19,xr+43,yr+21);
            rectangle(xr+31,yr+21,xr+33,yr+24);
            rectangle(xr+35,yr+21,xr+37,yr+24);
           end;
if nrp=7 then
           begin
            {------MEDYKA-----}
            setfillstyle(1,white);
            bar(xr+20,yr+8,xr+45,yr+28);
            setfillstyle(1,red);
            bar(xr+30,yr+11,xr+35,yr+24);
            bar(xr+23,yr+16,xr+42,yr+20);
            setcolor(black);
            rectangle(xr+20,yr+8,xr+45,yr+28);
           end;
if nrp=8 then
           begin
            {------BUTELKA------}
            setfillstyle(1,lightblue);
            bar(xr+30,yr+15,xr+40,yr+30);
            setcolor(lightblue);
            line(xr+30,yr+15,xr+33,yr+9);
            line(xr+40,yr+15,xr+37,yr+9);
            line(xr+33,yr+9,xr+33,yr+6);
            line(xr+33,yr+6,xr+37,yr+6);
            line(xr+37,yr+6,xr+37,yr+9);
            floodfill(xr+34,yr+7,lightblue);
            Setfillstyle(1,white);
            bar(xr+30,yr+18,xr+40,yr+23);
            setcolor(red);
            line(xr+32,yr+20,xr+36,yr+20);
            line(xr+34,yr+21,xr+38,yr+21);
           end;
if nrp=9 then
           begin
            {------N------}
            setfillstyle(1,7);
            setcolor(7);
            line(xr+8,yr+15,xr+11,yr+18);
            line(xr+11,yr+18,xr+40,yr+20);
            line(xr+40,yr+20,xr+40,yr+15);
            line(xr+40,yr+15,xr+8,yr+15);
            floodfill(xr+20,yr+16,7);
            setcolor(black);
            line(xr+8,yr+15,xr+11,yr+18);
            line(xr+11,yr+18,xr+40,yr+20);
            line(xr+40,yr+20,xr+40,yr+15);
            line(xr+40,yr+15,xr+8,yr+15);
            rectangle(xr+40,yr+14,xr+41,yr+21);
            setfillstyle(1,8);
            bar(xr+41,yr+16,xr+57,yr+19);
            rectangle(xr+41,yr+16,xr+57,yr+19);
           end;
if nrp=10 then
           begin
            {-----WLCZNIA-----}
            setcolor(black);
            line(xr+9,yr+5,xr+68,yr+30);
            line(xr+8,yr+5,xr+69,yr+31);
            setcolor(7);
            line(xr+5,yr+7,xr+10,yr+2);
            line(xr+5,yr+7,xr+3,yr+2);
            line(xr+3,yr+2,xr+10,yr+2);
            setfillstyle(1,7);
            floodfill(xr+5,yr+4,7);
            setcolor(black);
            line(xr+5,yr+7,xr+10,yr+2);
            line(xr+5,yr+7,xr+3,yr+2);
            line(xr+3,yr+2,xr+10,yr+2);
           end;
if nrp=11 then
           begin
            {----DYSK----}
            setfillstyle(1,white);
            bar(xr+13,yr+2,xr+37,yr+12);
            setcolor(blue);
            line(xr+10,yr+2,xr+13,yr+2);
            line(xr+13,yr+2,xr+13,yr+13);
            line(xr+13,yr+13,xr+37,yr+13);
            line(xr+37,yr+13,xr+37,yr+2);
            line(xr+37,yr+2,xr+40,yr+2);
            line(xr+40,yr+2,xr+40,yr+30);
            line(xr+40,yr+30,xr+13,yr+30);
            line(xr+13,yr+30,xr+10,yr+27);
            line(xr+10,yr+27,xr+10,yr+2);
            setfillstyle(1,blue);
            floodfill(xr+12,yr+20,blue);
            setfillstyle(1,7);
            bar(xr+17,yr+20,xr+33,yr+30);
            setfillstyle(1,blue);
            bar(xr+20,yr+22,xr+23,yr+28);
           end;
if nrp=12 then
           begin
            {----KSIAZKA-----}
            setfillstyle(1,red);
            bar(xr+23,yr+3,xr+47,yr+32);
            setcolor(black);
            rectangle(xr+23,yr+3,xr+47,yr+32);
            line(xr+26,yr+10,xr+32,yr+10);
            line(xr+35,yr+10,xr+43,yr+10);
            line(xr+28,yr+10,xr+28,yr+8);
            line(xr+30,yr+11,xr+30,yr+11);
            line(xr+33,yr+10,xr+33,yr+9);
            line(xr+36,yr+10,xr+36,yr+12);
            line(xr+40,yr+10,xr+40,yr+8);
           end;
if nrp=13 then
            begin
             {-----POCISKI-----}
             setfillstyle(1,red);
             bar(xr+30,yr+30,xr+40,yr+10);
             setfillstyle(1,yellow);
             bar(xr+30,yr+25,xr+40,yr+30);
             setcolor(black);
             rectangle(xr+30,yr+30,xr+40,yr+10);
             rectangle(xr+28,yr+30,xr+42,yr+31);
            end;
if nrp=14 then
            begin
             {------KURTKA------}
             setcolor(8);
             {Lewy Rkaw}
             line(xr+12,yr+32,xr+13,yr+21);
             line(xr+13,yr+21,xr+20,yr+5);
             line(xr+20,yr+5,xr+30,yr+1);
             line(xr+12,yr+32,xr+14,yr+34);
             line(xr+14,yr+34,xr+17,yr+35);
             line(xr+17,yr+35,xr+20,yr+33);
             line(xr+20,yr+33,xr+21,yr+23);
             line(xr+21,yr+23,xr+25,yr+16);
             line(xr+25,yr+16,xr+23,yr+24);
             line(xr+23,yr+24,xr+22,yr+34);
             line(xr+22,yr+34,xr+27,yr+35);
             line(xr+27,yr+35,xr+33,yr+33);
             line(xr+33,yr+33,xr+34,yr+10);
             line(xr+34,yr+10,xr+30,yr+1);
             {Prawy Rkaw}
             line(xr+58,yr+32,xr+57,yr+21);
             line(xr+57,yr+21,xr+50,yr+5);
             line(xr+50,yr+5,xr+40,yr+1);
             line(xr+58,yr+32,xr+56,yr+34);
             line(xr+56,yr+34,xr+53,yr+35);
             line(xr+53,yr+35,xr+50,yr+33);
             line(xr+50,yr+33,xr+49,yr+23);
             line(xr+49,yr+23,xr+45,yr+16);
             line(xr+45,yr+16,xr+47,yr+24);
             line(xr+47,yr+24,xr+48,yr+34);
             line(xr+48,yr+34,xr+43,yr+35);
             line(xr+43,yr+35,xr+37,yr+33);
             line(xr+37,yr+33,xr+36,yr+10);
             line(xr+36,yr+10,xr+40,yr+1);
             setfillstyle(1,8);
             floodfill(xr+30,yr+5,8);
             floodfill(xr+40,yr+5,8);
             setcolor(black);
             line(xr+12,yr+32,xr+13,yr+21);
             line(xr+13,yr+21,xr+20,yr+5);
             line(xr+20,yr+5,xr+30,yr+1);
             line(xr+12,yr+32,xr+14,yr+34);
             line(xr+14,yr+34,xr+17,yr+35);
             line(xr+17,yr+35,xr+20,yr+33);
             line(xr+20,yr+33,xr+21,yr+23);
             line(xr+21,yr+23,xr+25,yr+16);
             line(xr+25,yr+16,xr+23,yr+24);
             line(xr+23,yr+24,xr+22,yr+34);
             line(xr+22,yr+34,xr+27,yr+35);
             line(xr+27,yr+35,xr+33,yr+33);
             line(xr+33,yr+33,xr+34,yr+10);
             line(xr+34,yr+10,xr+30,yr+1);

             line(xr+58,yr+32,xr+57,yr+21);
             line(xr+57,yr+21,xr+50,yr+5);
             line(xr+50,yr+5,xr+40,yr+1);
             line(xr+58,yr+32,xr+56,yr+34);
             line(xr+56,yr+34,xr+53,yr+35);
             line(xr+53,yr+35,xr+50,yr+33);
             line(xr+50,yr+33,xr+49,yr+23);
             line(xr+49,yr+23,xr+45,yr+16);
             line(xr+45,yr+16,xr+47,yr+24);
             line(xr+47,yr+24,xr+48,yr+34);
             line(xr+48,yr+34,xr+43,yr+35);
             line(xr+43,yr+35,xr+37,yr+33);
             line(xr+37,yr+33,xr+36,yr+10);
             line(xr+36,yr+10,xr+40,yr+1);

             line(xr+40,yr+1,xr+30,yr+1);
             line(xr+33,yr+30,xr+37,yr+30);
             setfillstyle(1,black);
             floodfill(xr+35,yr+28,black);
            end;
if nrp=15 then
            begin
             {----MAGAZYNEK----}
             setfillstyle(1,8);
             bar(xr+28,yr+10,xr+42,yr+30);
             setcolor(black);
             rectangle(xr+28,yr+10,xr+42,yr+30);
             line(xr+31,yr+10,xr+31,yr+30);
             line(xr+34,yr+10,xr+34,yr+30);
             line(xr+37,yr+10,xr+37,yr+30);
             line(xr+40,yr+10,xr+40,yr+30);
            end;
if nrp>15 then WczytajRysunek(xr,yr,'data/gfx/'+zamien(nrp)+'.gfx');
end;
{=======================================================}
{=            RYSOWANIE OBIEKTOW SCENERII              =}
{=======================================================}
Procedure Sceneria(xs,ys:integer; typ,stan:byte);
const
  wzorex : FillPatternType = (239,239,239,0,253,253,253,0);
begin
if typ=0 then
           begin
            wypelnienie(1,jasnyszary);
            bar(xs+2,ys+2,xs+18,ys+12);
            wypelnienie(1,szary);
            bar(xs+8,ys+12,xs+12,ys+30);
            kol(czarny);
            rectangle(xs+2,ys+2,xs+18,ys+12);
            rectangle(xs+8,ys+12,xs+12,ys+30);
            wypelnienie(1,zielony);
            bar(xs+4,ys+4,xs+11,ys+10);
            kol(czerwony);
            line(xs+13,ys+10,xs+13,ys+10);
            line(xs+15,ys+10,xs+15,ys+10);
            kol(czarny);
            line(xs+13,ys+13,xs+15,ys+13);
           end;
if typ=1 then
           begin
            wypelnienie(1,jasnyszary);
            bar(xs,ys,xs+20,ys+4);
            kol(czarny);
            line(xs,ys,xs+20,ys);
            line(xs,ys+4,xs+20,ys+4);
            wypelnienie(1,szary);
            bar(xs,ys+5,xs+20,ys+7);
            rectangle(xs,ys+7,xs+19,ys+29);
            if (stan=zamkniete) or (stan=zamek) then
                               begin
                                wypelnienie(1,brazowy);
                                bar(xs+1,ys+8,xs+18,ys+29);
                                kol(czarny);
                                line(xs+2,ys+18,xs+6,ys+18);
                               end;
           end;
if typ=2 then
           begin
            wypelnienie(1,dziwnyniebieski);
            bar(xs,ys,xs+20,ys+4);
            kol(czarny);
            line(xs,ys,xs+20,ys);
            line(xs,ys+4,xs+20,ys+4);
            wypelnienie(1,11);
            bar(xs,ys+5,xs+20,ys+7);
            rectangle(xs,ys+7,xs+19,ys+29);
            if (stan=zamkniete) or (stan=zamek) then
                               begin
                                wypelnienie(1,jasnyszary);
                                bar(xs+1,ys+8,xs+18,ys+28);
                                kol(czarny);
                                line(xs+10,ys+7,xs+10,ys+28);
                               end;
           end;
if typ=3 then
           begin
            wypelnienie(1,brazowy);
            bar(xs,ys,xs+20,ys+4);
            kol(czarny);
            line(xs,ys,xs+20,ys);
            line(xs,ys+4,xs+20,ys+4);
            wypelnienie(1,brazowy);
            bar(xs,ys+5,xs+20,ys+7);
            rectangle(xs,ys+7,xs+19,ys+29);
            if (stan=zamkniete) or (stan=zamek) then
                               begin
                                wypelnienie(1,brazowy);
                                bar(xs+1,ys+8,xs+18,ys+29);
                                kol(czarny);
                                line(xs+2,ys+18,xs+6,ys+18);
                               end;
           end;
if typ=4 then
           begin
              kol(czarny);
              rectangle(xs,ys,xs+19,ys+29);
              rectangle(xs+1,ys+1,xs+18,ys+28);
            if (stan=zamkniete) or (stan=zamek) then
                               begin
                                line(xs,ys,xs+20,ys+20);
                                line(xs+3,ys,xs+20,ys+17);
                                line(xs+6,ys,xs+20,ys+14);
                                line(xs+9,ys,xs+20,ys+11);
                                line(xs+12,ys,xs+20,ys+8);
                                line(xs+15,ys,xs+20,ys+5);
                                line(xs+18,ys,xs+20,ys+2);
                                line(xs,ys+3,xs+20,ys+23);
                                line(xs,ys+6,xs+20,ys+26);
                                line(xs,ys+9,xs+20,ys+29);
                                line(xs,ys+12,xs+17,ys+29);
                                line(xs,ys+15,xs+14,ys+29);
                                line(xs,ys+18,xs+11,ys+29);
                                line(xs,ys+21,xs+8,ys+29);
                                line(xs,ys+24,xs+5,ys+29);
                                line(xs,ys+27,xs+2,ys+29);
                                rectangle(xs+3,ys+16,xs+6,ys+17);
                               end;

           end;
if typ=5 then
           begin
            wypelnienie(1,jasnyszary);
            bar(xs,ys,xs+20,ys+4);
            kol(czarny);
            line(xs,ys,xs+20,ys);
            line(xs,ys+4,xs+20,ys+4);
            wypelnienie(1,bialy);
            bar(xs,ys+5,xs+20,ys+7);
            rectangle(xs,ys+7,xs+19,ys+29);
            if (stan=zamkniete) or (stan=zamek) then
                               begin
                                wypelnienie(1,jasnyszary);
                                bar(xs+1,ys+8,xs+18,ys+28);
                                kol(czarny);
                                line(xs+10,ys+7,xs+10,ys+28);
                               end;
           end;
if typ=6 then
           begin
            wypelnienie(1,szary);
            bar(xs,ys,xs+20,ys+4);
            kol(czarny);
            line(xs,ys,xs+20,ys);
            line(xs,ys+4,xs+20,ys+4);
            setfillpattern(wzorex,czerwony);
            bar(xs,ys+5,xs+20,ys+7);
            rectangle(xs,ys+7,xs+19,ys+29);
            if (stan=zamkniete) or (stan=zamek) then
                               begin
                                wypelnienie(1,szary);
                                bar(xs+1,ys+8,xs+18,ys+29);
                                kol(czarny);
                                line(xs+2,ys+18,xs+6,ys+18);

                               end;
           end;
if typ=7 then
           begin
            wypelnienie(1,szary);
            bar(xs,ys,xs+20,ys+4);
            kol(czarny);
            line(xs,ys,xs+20,ys);
            line(xs,ys+4,xs+20,ys+4);
            setfillpattern(wzorex,bialy);
            bar(xs,ys+5,xs+20,ys+7);
            rectangle(xs,ys+7,xs+19,ys+29);
            if (stan=zamkniete) or (stan=zamek) then
                               begin
                                wypelnienie(1,brazowy);
                                bar(xs+1,ys+8,xs+18,ys+29);
                                kol(czarny);
                                line(xs+2,ys+18,xs+6,ys+18);

                               end;
           end;
if typ=8 then
           begin
            wypelnienie(1,jasnyszary);
            bar(xs,ys,xs+20,ys+4);
            kol(czarny);
            line(xs,ys,xs+20,ys);
            line(xs,ys+4,xs+20,ys+4);
            setfillpattern(wzorex,szary);
            bar(xs,ys+5,xs+20,ys+7);
            rectangle(xs,ys+7,xs+19,ys+29);
            if (stan=zamkniete) or (stan=zamek) then
                               begin
                                wypelnienie(1,brazowy);
                                bar(xs+1,ys+8,xs+18,ys+29);
                                kol(czarny);
                                line(xs+2,ys+18,xs+6,ys+18);

                               end;
           end;
if typ=9 then
           begin
            wypelnienie(1,szary);
            bar(xs+1,ys+1,xs+19,ys+16);
            wypelnienie(1,dziwnyniebieski);
            bar(xs+5,ys+17,xs+15,ys+30);
            kol(czarny);
            rectangle(xs+1,ys+1,xs+19,ys+16);
            rectangle(xs+5,ys+17,xs+15,ys+30);
            wypelnienie(1,jasnyszary);
            bar(xs+5,ys+3,xs+15,ys+10);
            putpixel(xs+3,ys+3,ukolor(niebieski));
            putpixel(xs+3,ys+5,ukolor(niebieski));
            putpixel(xs+3,ys+7,ukolor(niebieski));
            putpixel(xs+3,ys+9,ukolor(niebieski));
            putpixel(xs+17,ys+3,ukolor(niebieski));
            putpixel(xs+17,ys+5,ukolor(niebieski));
            putpixel(xs+17,ys+7,ukolor(niebieski));
            putpixel(xs+17,ys+9,ukolor(niebieski));
            rectangle(xs+5,ys+3,xs+15,ys+10);
            putpixel(xs+3,ys+12,ukolor(czerwony));
            putpixel(xs+5,ys+12,ukolor(czerwony));
            putpixel(xs+7,ys+12,ukolor(czerwony));
            putpixel(xs+9,ys+12,ukolor(czerwony));
            putpixel(xs+11,ys+12,ukolor(czerwony));
            putpixel(xs+13,ys+12,ukolor(czerwony));
            putpixel(xs+15,ys+12,ukolor(czerwony));
            putpixel(xs+17,ys+12,ukolor(czerwony));
            putpixel(xs+3,ys+14,ukolor(czerwony));
            putpixel(xs+5,ys+14,ukolor(czerwony));
            putpixel(xs+7,ys+14,ukolor(czerwony));
            putpixel(xs+9,ys+14,ukolor(czerwony));
            putpixel(xs+11,ys+14,ukolor(czerwony));
            putpixel(xs+13,ys+14,ukolor(czerwony));
            putpixel(xs+15,ys+14,ukolor(czerwony));
            putpixel(xs+17,ys+14,ukolor(czerwony));
           end;
if typ=10 then
           begin
            wypelnienie(1,bialy);
            bar(xs+2,ys+10,xs+18,ys+29);
            kol(czarny);
            rectangle(xs+2,ys+10,xs+18,ys+29);
            wypelnienie(1,szary);
            bar(xs+4,ys+12,xs+7,ys+15);
            bar(xs+9,ys+12,xs+11,ys+15);
            bar(xs+13,ys+12,xs+16,ys+15);
            wypelnienie(1,jasnyszary);
            bar(xs+7,ys+19,xs+13,ys+27);
            kol(czarny);
            rectangle(xs+7,ys+19,xs+13,ys+27);
            line(xs+2,ys+17,xs+18,ys+17);
            wypelnienie(1,czerwony);
            bar(xs+4,ys+19,xs+5,ys+25);
            bar(xs+15,ys+19,xs+16,ys+25);
           end;
if typ=11 then
           begin
            kol(szary);
            line(xs+2,ys+23,xs+12,ys+26);
            line(xs+2,ys+23,xs+8,ys+2);
            line(xs+12,ys+26,xs+17,ys+5);
            line(xs+8,ys+2,xs+17,ys+5);
            wypelnienie(1,szary);
            floodfill(xs+8,ys+5,ukolor(szary));
            kol(czarny);
            line(xs+2,ys+23,xs+12,ys+26);
            line(xs+2,ys+23,xs+8,ys+2);
            line(xs+12,ys+26,xs+17,ys+5);
            line(xs+8,ys+2,xs+17,ys+5);
            line(xs+15,ys+13,xs+17,ys+26);
            line(xs+16,ys+13,xs+18,ys+26);
            kol(bialy);
            line(xs+6,ys+16,xs+8,ys+9);
            line(xs+6,ys+16,xs+10,ys+17);
            line(xs+8,ys+9,xs+12,ys+10);
            line(xs+12,ys+10,xs+10,ys+17);
            wypelnienie(1,bialy);
            floodfill(xs+8,ys+13,ukolor(bialy));
           end;
if typ=12 then
           begin
            wypelnienie(1,szary);
            bar(xs,ys+29,xs+20,ys+25);
            bar(xs+4,ys+25,xs+20,ys+20);
            bar(xs+8,ys+20,xs+20,ys+15);
            bar(xs+12,ys+15,xs+20,ys+10);
            bar(xs+16,ys+10,xs+20,ys+5);
            kol(czarny);
            line(xs,ys+29,xs,ys+25);
            line(xs,ys+25,xs+4,ys+25);
            line(xs+4,ys+25,xs+4,ys+20);
            line(xs+4,ys+20,xs+8,ys+20);
            line(xs+8,ys+20,xs+8,ys+15);
            line(xs+8,ys+15,xs+12,ys+15);
            line(xs+12,ys+15,xs+12,ys+10);
            line(xs+12,ys+10,xs+16,ys+10);
            line(xs+16,ys+10,xs+16,ys+5);
            line(xs+16,ys+5,xs+20,ys+5);
            line(xs+20,ys+5,xs+20,ys+29);
            line(xs+20,ys+29,xs,ys+29);
            line(xs,ys+25,xs,ys+20);
            line(xs+16,ys+5,xs+16,ys);
            line(xs,ys+20,xs+16,ys);
            line(xs+4,ys+20,xs+4,ys+15);
            line(xs+8,ys+15,xs+8,ys+10);
            line(xs+12,ys+10,xs+12,ys+5);
           end;
if typ=13 then
           begin
            Wall(xs,ys,22);
            wypelnienie(1,szary);
            bar(xs+6,ys+10,xs+14,ys+20);
            kol(czarny);
            rectangle(xs+6,ys+10,xs+14,ys+20);
            putpixel(xs+8,ys+12,ukolor(czerwony));
            putpixel(xs+8,ys+14,ukolor(czerwony));
            putpixel(xs+8,ys+16,ukolor(czerwony));
            putpixel(xs+8,ys+18,ukolor(zielony));
            wypelnienie(1,fioletowy);
            bar(xs+10,ys+12,xs+12,ys+18);
            kol(bialy);
            rectangle(xs+10,ys+12,xs+12,ys+18);
           end;
if typ=14 then
           begin
            Wall(xs,ys,62);
            wypelnienie(1,szary);
            bar(xs+6,ys+10,xs+14,ys+20);
            kol(czarny);
            rectangle(xs+6,ys+10,xs+14,ys+20);
            putpixel(xs+8,ys+12,ukolor(czerwony));
            putpixel(xs+8,ys+14,ukolor(czerwony));
            putpixel(xs+8,ys+16,ukolor(czerwony));
            putpixel(xs+8,ys+18,ukolor(zielony));
            wypelnienie(1,fioletowy);
            bar(xs+10,ys+12,xs+12,ys+18);
            kol(bialy);
            rectangle(xs+10,ys+12,xs+12,ys+18);
           end;
if typ=15 then
           begin
            kol(czarny);
            rectangle(xs+4,ys,xs+5,ys+30);
            rectangle(xs+15,ys,xs+16,ys+30);
            rectangle(xs+5,ys+3,xs+15,ys+4);
            rectangle(xs+5,ys+9,xs+15,ys+10);
            rectangle(xs+5,ys+15,xs+15,ys+16);
            rectangle(xs+5,ys+21,xs+15,ys+22);
            rectangle(xs+5,ys+27,xs+15,ys+28);
           end;
if typ=16 then
           begin
            wypelnienie(1,czarny);
            bar(xs,ys+15,xs+19,ys+29);
            kol(bialy);
            rectangle(xs,ys+15,xs+19,ys+29);
            wypelnienie(1,szary);
            bar(xs+18,ys+16,xs+14,ys+28);
            bar(xs+18,ys+20,xs+10,ys+28);
            bar(xs+18,ys+24,xs+5,ys+28);
            kol(czarny);
            line(xs+5,ys+28,xs+5,ys+24);
            line(xs+10,ys+28,xs+10,ys+20);
            line(xs+14,ys+28,xs+14,ys+16);
           end;
if typ=17 then
           begin
            wypelnienie(1,szary);
            bar(xs+8,ys+29,xs+12,ys+4);
            kol(czarny);
            rectangle(xs+8,ys+29,xs+12,ys+4);
            bar(xs+1,ys+10,xs+19,ys+13);
            kol(czarny);
            line(xs+1,ys+10,xs+8,ys+10);
            line(xs+1,ys+10,xs+1,ys+13);
            line(xs+1,ys+13,xs+8,ys+13);
            line(xs+12,ys+10,xs+19,ys+10);
            line(xs+19,ys+10,xs+19,ys+13);
            line(xs+19,ys+13,xs+12,ys+13);
           end;
if typ=18 then
           begin
            wypelnienie(1,czarny);
            bar(xs+1,ys+16,xs+18,ys+29);
            kol(szary);
            rectangle(xs+3,ys+18,xs+16,ys+27);
            kol(jasnyszary);
            rectangle(xs+1,ys+16,xs+18,ys+29);
            kol(czerwony);
            rectangle(xs+4,ys+15,xs+5,ys+4);
            rectangle(xs+14,ys+15,xs+15,ys+4);
            line(xs+3,ys+6,xs+6,ys+6);
            line(xs+13,ys+6,xs+16,ys+6);
            line(xs+3,ys+8,xs+6,ys+8);
            line(xs+13,ys+8,xs+16,ys+8);
            line(xs+3,ys+10,xs+6,ys+10);
            line(xs+13,ys+10,xs+16,ys+10);
            line(xs+3,ys+12,xs+6,ys+12);
            line(xs+13,ys+12,xs+16,ys+12);
            line(xs+3,ys+14,xs+6,ys+14);
            line(xs+13,ys+14,xs+16,ys+14);
            wypelnienie(1,zielony);
            bar(xs+6,ys+20,xs+7,ys+21);
            wypelnienie(1,czerwony);
            bar(xs+9,ys+20,xs+10,ys+21);
            bar(xs+12,ys+20,xs+13,ys+21);
           end;
if typ=19 then
           begin
            kol(jasnyniebieski);
            line(xs+3,ys+25,xs+4,ys+22);
            line(xs+4,ys+22,xs+6,ys+19);
            line(xs+6,ys+19,xs+10,ys+18);
            line(xs+3,ys+9,xs+4,ys+6);
            line(xs+4,ys+6,xs+6,ys+3);
            line(xs+6,ys+3,xs+10,ys+2);
            line(xs+17,ys+25,xs+16,ys+22);
            line(xs+16,ys+22,xs+14,ys+19);
            line(xs+14,ys+19,xs+10,ys+18);
            line(xs+17,ys+9,xs+16,ys+6);
            line(xs+16,ys+6,xs+14,ys+3);
            line(xs+14,ys+3,xs+10,ys+2);
            line(xs+3,ys+25,xs+3,ys+9);
            line(xs+17,ys+25,xs+17,ys+9);
            wypelnienie(1,jasnyniebieski);
            floodfill(xs+4,ys+20,ukolor(jasnyniebieski));
            kol(szary);
            line(xs+3,ys+25,xs+4,ys+22);
            line(xs+4,ys+22,xs+6,ys+19);
            line(xs+6,ys+19,xs+10,ys+18);
            line(xs+17,ys+25,xs+16,ys+22);
            line(xs+16,ys+22,xs+14,ys+19);
            line(xs+14,ys+19,xs+10,ys+18);
            line(xs+3,ys+25,xs+3,ys+29);
            line(xs+3,ys+29,xs+17,ys+29);
            line(xs+17,ys+29,xs+17,ys+25);
            wypelnienie(1,szary);
            floodfill(xs+5,ys+27,ukolor(szary));
            kol(czarny);
            line(xs+3,ys+25,xs+4,ys+22);
            line(xs+4,ys+22,xs+6,ys+19);
            line(xs+6,ys+19,xs+10,ys+18);
            line(xs+3,ys+9,xs+4,ys+6);
            line(xs+4,ys+6,xs+6,ys+3);
            line(xs+6,ys+3,xs+10,ys+2);
            line(xs+17,ys+25,xs+16,ys+22);
            line(xs+16,ys+22,xs+14,ys+19);
            line(xs+14,ys+19,xs+10,ys+18);
            line(xs+17,ys+9,xs+16,ys+6);
            line(xs+16,ys+6,xs+14,ys+3);
            line(xs+14,ys+3,xs+10,ys+2);
            line(xs+3,ys+25,xs+3,ys+9);
            line(xs+17,ys+25,xs+17,ys+9);
            line(xs+3,ys+29,xs+17,ys+29);
            rectangle(xs+3,ys+23,xs+17,ys+29);
           end;
IF typ>19 then if czytajtext(danegry+'scenes.txt',typ-19)<>'' then
                 wczytajrysunek(xs,ys,'data/gfx/'+czytajtext(danegry+'scenes.txt',typ-19)+'.gfx');
end;

{====================}
{= WYWOLANIE SCIANY =}
{====================}
Procedure Wall(xk,yk:integer; typ:byte);
begin
Sciana(xk,yk,typ);
end;
{=======================================================}
{=                 RYSOWANIE KAFELKI                   =}
{=======================================================}
Procedure Kafelka(xk,yk:integer; typ:byte);
begin
Floor(xk,yk,typ);
end;
{=======================================================}
{=                 RYSOWANIE SZAFKI                    =}
{=======================================================}
Procedure Szafka(xs,ys:integer; typ:byte);
begin
if typ=0 then
           begin
            {------ZWYKLY REGAL-------}
            wypelnienie(1,brazowy);
            bar(xs+2,ys+29,xs+19,ys+4);
            kol(czarny);
            rectangle(xs+2,ys+29,xs+19,ys+4);
            line(xs+2,ys+24,xs+19,ys+24);
            line(xs+2,ys+19,xs+19,ys+19);
            line(xs+2,ys+14,xs+19,ys+14);
            line(xs+2,ys+9,xs+19,ys+9);
            wypelnienie(1,czerwony);
            bar(xs+4,ys+23,xs+8,ys+21);
            wypelnienie(1,niebieski);
            bar(xs+9,ys+13,xs+13,ys+11);
           end;
if typ=1 then
           begin
            wypelnienie(1,jasnyszary);
            bar(xs+4,ys+2,xs+16,ys+29);
            kol(czarny);
            rectangle(xs+4,ys+2,xs+16,ys+29);
            rectangle(xs+6,ys+4,xs+14,ys+10);
            rectangle(xs+6,ys+14,xs+14,ys+27);
            line(xs+6,ys+12,xs+8,ys+12);
           end;
if typ=2 then
           begin
            wypelnienie(1,bialy);
            bar(xs+2,ys+10,xs+18,ys+29);
            kol(czarny);
            rectangle(xs+2,ys+10,xs+18,ys+29);
            rectangle(xs+4,ys+12,xs+16,ys+27);
            line(xs+6,ys+15,xs+8,ys+15);
           end;
if typ=3 then
           begin
            wypelnienie(1,szary);
            bar(xs+2,ys+4,xs+18,ys+29);
            kol(czarny);
            rectangle(xs+2,ys+4,xs+18,ys+29);
            line(xs+2,ys+8,xs+18,ys+8);
            line(xs+2,ys+12,xs+18,ys+12);
            line(xs+2,ys+16,xs+18,ys+16);
            line(xs+2,ys+20,xs+18,ys+20);
            line(xs+2,ys+24,xs+18,ys+24);
            wypelnienie(1,niebieski);
            bar(xs+4,ys+11,xs+8,ys+9);
            bar(xs+11,ys+28,xs+15,ys+26);
           end;
if typ=4 then
           begin
            wall(xs,ys,2);
            wypelnienie(1,jasnyszary);
            bar(xs+4,ys+10,xs+16,ys+20);
            kol(czarny);
            rectangle(xs+4,ys+10,xs+16,ys+20);
            line(xs+6,ys+15,xs+8,ys+15);
           end;
if typ=5 then
           begin
            wypelnienie(1,brazowy);
            bar(xs+2,ys+16,xs+18,ys+29);
            kol(czarny);
            rectangle(xs+2,ys+16,xs+18,ys+29);
            line(xs+5,ys+16,xs+5,ys+29);
            line(xs+15,ys+16,xs+15,ys+29);

            line(xs+5,ys+19,xs+15,ys+19);
            line(xs+5,ys+22,xs+15,ys+22);
            line(xs+5,ys+25,xs+15,ys+25);
           end;
if typ=6 then
           begin
            wypelnienie(1,szary);
            bar(xs+4,ys+19,xs+16,ys+29);
            kol(czarny);
            rectangle(xs+4,ys+19,xs+16,ys+29);
            line(xs+4,ys+21,xs+16,ys+21);
            rectangle(xs+8,ys+17,xs+12,ys+19);
           end;
if typ=7 then
           begin
            wypelnienie(1,brazowy);
            bar(xs,ys,xs+19,ys+29);
            kol(czarny);
            rectangle(xs,ys,xs+19,ys+29);
            line(xs,ys+4,xs+19,ys+4);
            line(xs,ys+8,xs+19,ys+8);
            line(xs,ys+12,xs+19,ys+12);
            line(xs,ys+16,xs+19,ys+16);
            line(xs,ys+20,xs+19,ys+20);
            line(xs,ys+24,xs+19,ys+24);
           end;

end;


end.