unit Game;

interface
uses crt,dane,grafika,scripts,mysz,textopr,anims,elements,world,graph;

var timex:integer;
    Zablokuj:boolean;
    {WCZYTYWANIE DANYCH}
    Procedure WczytajMape(namef:string);  {pelne wczytanie mapy}

    {OPERACJE INTERFACE'U}

     {funkcje}
    Function PozycjaY:integer;               {pozycja X kliknietego kwadratu}
    Function PozycjaX:integer;               {pozycja Y kliknietego kwadratu}

    {INTERFACE}
    Procedure PanelStart;

    {STEROWANIE ENGINEM}
    Procedure Lecz(nrpo:byte);
    Procedure RuchPostaci(nrp,Strona:byte); {przesuwa postac o numerze NRP w podana strone}
    procedure RuchPostaciFight(nrp,Strona:byte); {jak wyzej, tyle ze podczas walki}
    Procedure WalidatujMape;
    Procedure Walidatuj(xw,yw:byte);
    Function SzansaTrafienia(pos1,pos2,TypBroni:byte):byte;
    Procedure Kolejka;
    Procedure UrzyjPRzedmiotu(nrpostaci,nrslotu:byte); {urzycie przedmiotu ze slotu NRSLOTU postaci}
                                                       {gracza na postaci o numerze NRPOSTACI}
    Function MoznaUrzyc(nrprz:integer):boolean;        {sprawdzanie czy mozna uzyc przedmiotu}

     {funkcje}
    Function Odleglosc(posa,posb:byte):byte;     {odleglosc pomiedzy dwoma postaciami}
    Function OdlegloscS(posa:byte):byte;         {Odleglosc pomiedzy postacia gracza a obiektem scenerii}
    Function OdlegloscSZ(posa:byte):byte;        {Odleglosc pomiedzy postacia gracza a szafka}
    Function LiniaStrzalu(Po1,po2:byte):boolean; {Sprawdza czy linia strzalu jest wolna}
    Function LiniaStrzaluS(Po1,po2:byte):boolean;{jak wyzej tyle ze pomiedzy postacia gracza a obiektem scenerii}
    Function ZnajdzPostac(szx,szy:byte):byte;    {Poszukuje postaci na pozycji SZX,SZY}
    Function ZnajdzScenerie(szx,szy:byte):byte;  {Poszukuje obiektu scenerii na pozycji SZX,SZY}
    Function ZnajdzSzafke(szx,szy:byte):byte;    {Jak wyzej ale chodzi o szafke}
    Function ZnajdzTrupa(szx,szy:byte):byte;     {Znajdz trupa}
    Function ZnajdzNumer(xz,yz:byte):byte;       {znajdywanie numeru, kliknietego obiektu}
    Function ZaladujBron(nrp1:byte):boolean;   {zaadowywanie broni odpowiednia amunicja. Jesli}
                                               {postac o numerze NRP1 miala odpowiednia amunicje}
                                               {podczas zaladowywania, to funcja zwraca wartosc TRUE}
    {POZOSTALE}
    Procedure Wymarzs(nrs:byte);            {wymazanie kwadratu mapy, na ktrorym stoi obiektscenerii}
    Procedure Wymarz(nrp:byte);             {wymazywanie kwadratu mapy, na ktorym stoi postac}
    procedure umiescpostac(nrp:byte);       {umieszczanie postaci}
    {Operacje na danych postaci}
    Procedure KopiujDo(SlotZ,SlotDo,NrPostaci:byte);
    Function WeaponSearch(nrps:byte):boolean;
    Function UzbrojPostac(nrps:byte):boolean;


implementation

{============================================================}
{=                                                          =}
{=                                                          =}
{=                                                          =}
{=                   OPERACJE INTERFACE'U                   =}
{=                                                          =}
{=                                                          =}
{=                                                          =}
{============================================================}

{==============================================}
{=  ZLICZANIE POZYCJI X KLIKNITEGO KWADRATU  =}
{==============================================}
Function PozycjaX:integer;
begin
PozycjaX:=mx+trunc((a-mappozx)/20);
end;
{==============================================}
{=  ZLICZANIE POZYCJI Y KLIKNITEGO KWADRATU  =}
{==============================================}
Function PozycjaY:integer;
begin
Pozycjay:=my+trunc((b-mappozy)/30);
end;


{============================================================}
{=                                                          =}
{=                                                          =}
{=                                                          =}
{=                     WCZYTYWANIE DANYCH                   =}
{=                                                          =}
{=                                                          =}
{=                                                          =}
{============================================================}

{==================================================}
{= SPRAWDZANIE CZY WCZYTANE POSTACIE JESZCZE ZYJA =}
{==================================================}
Procedure SprawdzPostacie;
var i:byte;
begin
for i:=1 to 20 do if mapa.postacie[i].status=martwy then
             begin
              if (rr>mapa.postacie[i].smierc.rok) then mapa.postacie[i].status:=niema;
              if (mm>mapa.postacie[i].smierc.miesiac) then mapa.postacie[i].status:=niema;
             end;
end;
{========================================}
{=  PROCEDURA W PELNI ODCZYTUJACA MAPE  =}
{========================================}
Procedure WczytajMape(namef:string);
var Zapamietaj:TPostac;
begin
Zapamietaj:=mapa.postacie[0];
{newmap;       }
loadmap(namef);
SprawdzPostacie;
Mapa.postacie[0]:=zapamietaj;
if namef<>'' then RunMapScript(namef,1);
walidatujmape;
end;
{=======================================================================}
{=                                                                     =}
{=                                                                     =}
{=                                                                     =}
{=                       PROCEDURY STEROWANIA                          =}
{=                                                                     =}
{=                                                                     =}
{=                                                                     =}
{=======================================================================}

{                                                       }
{                                                       }
{   OPEROWANIE DANYMI POSTACI PRZY POMOCY INTERFACE'U   }
{                                                       }
{                                                       }

{                                               }
{  GWNE PROCEDURY STEROWANIA POSTACIA GRACZA  }
{                                               }
{                                               }

{====================================================}
{=  KIEROWANIE POSTACI GRACZA W ODPOWIEDNIA STRONE  =}
{====================================================}
procedure MoveC;
begin
if a>xpoz(0) then if (b>ypoz(0)) and (b<ypoz(0)+29) then RuchPostaci(0,Kprawo);
if a<xpoz(0) then if (b>ypoz(0)) and (b<ypoz(0)+29) then RuchPostaci(0,Klewo);
if b>ypoz(0) then if (a>xpoz(0)) and (a<xpoz(0)+19) then RuchPostaci(0,Kdol);
if b<ypoz(0) then if (a>xpoz(0)) and (a<xpoz(0)+19) then RuchPostaci(0,Kgora);
if (a>xpoz(0)) and (a>xpoz(0)+19) then if (b>ypoz(0)) and (b>ypoz(0)+29) then RuchPostaci(0,KprawoDol);
if (a<xpoz(0)) and (a<xpoz(0)+19) then if (b>ypoz(0)) and (b>ypoz(0)+29) then RuchPostaci(0,KLewoDol);
if (a>xpoz(0)) and (a>xpoz(0)+19) then if (b<ypoz(0)) and (b<ypoz(0)+29) then RuchPostaci(0,Kprawogora);
if (a<xpoz(0)) and (a<xpoz(0)+19) then if (b<ypoz(0)) and (b<ypoz(0)+29) then RuchPostaci(0,KlewoGora);
end;
{=====================}
{=  PORUSZANIE MAPA  =}
{=====================}
Procedure ScrollMap(strona:byte);
begin
if strona=klewo then if mx>1 then
                 begin
                  mx:=mx-1;
                  Showmap;
                 end;
if strona=kprawo then if mx<61 then
                 begin
                  mx:=mx+1;
                  ShowMap;
                 end;
if strona=kgora then if my>1 then
                 begin
                  my:=my-1;
                  Showmap;
                 end;
if strona=kdol then if my<68 then
                 begin
                  my:=my+1;
                  ShowMap;
                 end;
if strona=klewogora then
                 begin
                  if mx>1 then mx:=mx-1;
                  if my>1 then my:=my-1;
                  Showmap;
                 end;
if strona=kprawogora then
                 begin
                  if mx<61 then mx:=mx+1;
                  if my>1 then my:=my-1;
                  Showmap;
                 end;
if strona=kprawodol then
                 begin
                  if mx<61 then mx:=mx+1;
                  if my<68 then my:=my+1;
                  Showmap;
                 end;
if strona=klewodol then
                 begin
                  if mx>1 then mx:=mx-1;
                  if my<68 then my:=my+1;
                  Showmap;
                 end;
end;
{=====================================}
{=      POLECENIA KLAWIATUROWE       =}
{=====================================}
Procedure Klawiatura;
begin
if keypressed then
                           begin
                            q:=readkey;
                            ukryjmysz;
                            if q='x' then if testy=true then
                                            begin
                                             wyswietlwyjscia;
                                             readkey;
                                             glownypanel;
                                             daneglownegopanelu;
                                             showmap;
                                            end;
                            if q='T' then testy:=true;
                            if q='z' then if zablokuj=false then zablokuj:=true else zablokuj:=false;
                            if q='4' then ScrollMap(klewo);
                            if q='6' then scrollmap(kprawo);
                            if q='8' then scrollmap(kgora);
                            if q='2' then scrollmap(kdol);
                            if q='7' then scrollmap(klewogora);
                            if q='9' then scrollmap(kprawogora);
                            if q='3' then scrollmap(kprawodol);
                            if q='1' then scrollmap(klewodol);
                            if q='e' then Polecenie:=koniec;
                            pokazmysz;
                           end;
end;
{=====================================================}
{= OPEROWANIE LEWYM PRZYCISKIEM MYSZY PRZY EKWIPUNKU =}
{=====================================================}
Procedure LewyPrzyciskEkwipunku;
begin
repeat
pozycjamyszy(a,b,c);
until c=0;
if czywcisnieto(1) then
                     begin
                      polecenie:=koniec;
                      wcisnijprzycisk(1);
                     end;
if czywcisnieto(2) then
                     begin
                      wcisnijprzycisk(2);
                      if ZaladujBron(0) then RysujPrzedmiotyEkwipunku;
                     end;
if (a>110) and (a<250) and (b>30) and (b<450) then
   begin
    ukryjmysz;
    if (a>110) and (a<180) then
                            begin
                             DelRamkaEkw(wp);
                             wp:=trunc( (b-30)/35)+1;
                             CzyscEkran(1);
                             if mapa.postacie[0].ekwipunek[wp]>0 then
                               WyswietlDanePrzedmiotu(mapa.postacie[0].ekwipunek[wp]);
                             RamkaEkw(wp);
                            end;
    if (a>180) and (a<250) then
                            begin
                             DelRamkaEkw(wp);
                             wp:=trunc( (b-30)/35)+13;
                             CzyscEkran(1);
                             if mapa.postacie[0].ekwipunek[wp]>0 then
                               WyswietlDanePrzedmiotu(mapa.postacie[0].ekwipunek[wp]);
                             RamkaEkw(wp);
                            end;
    pokazmysz;
   end;
if (a>300) and (a<370) and (b>300) and (b<335) then
           begin
            ukryjmysz;
            delramkaekw(wp);
            wp:=25;
            CzyscEkran(1);
            if mapa.postacie[0].bron>0 then
                  WyswietlDanePrzedmiotu(mapa.postacie[0].bron);
            RamkaEkw(wp);
            pokazmysz;
           end;
if (a>300) and (a<370) and (b>370) and (b<405) then
           begin
            ukryjmysz;
            delramkaekw(wp);
            wp:=26;
            CzyscEkran(1);
            if mapa.postacie[0].zbroja>0 then
             WyswietlDanePrzedmiotu(mapa.postacie[0].zbroja);
            RamkaEkw(wp);
            pokazmysz;
           end;

end;
{======================================================}
{= OPEROWANIE PRAWYM PRZYCISKIEM MYSZY PRZY EKWIPUNKU =}
{======================================================}
Procedure PrawyPrzyciskEkwipunku;
begin
repeat
pozycjamyszy(a,b,c);
until c=0;
if (a>110) and (a<250) and (b>30) and (b<450) and (wp<>0) then
   begin
    if (a>110) and (a<180) then KopiujDo(wp,trunc((b-30)/35)+1,0);
    if (a>180) and (a<250) then KopiujDo(wp,trunc((b-30)/35)+13,0);
   end;
if (a>300) and (a<370) and (b>300) and (b<335) then KopiujDo(wp,25,0);
if (a>300) and (a<370) and (b>370) and (b<405) then KopiujDo(wp,26,0);
ukryjmysz;
DelRamkaEkw(wp);
RysujPrzedmiotyEkwipunku;
RamkaEkw(wp);
pokazmysz;
end;
{===========================================}
{=    OBSLUGA EKWIPUNKU POSTACI GRACZA     =}
{===========================================}
Procedure ObslugaEkwipunku;
begin
wp:=0;
ukryjmysz;
PanelEkwipunku;
RysujPrzedmiotyEkwipunku;
pokazmysz;
Polecenie:=0;
RamkaEkw(wp);
repeat
pozycjamyszy(a,b,c);
if c<>0 then
          begin
           if c=1 then LewyPrzyciskEkwipunku;
           if c=2 then PrawyPrzyciskEkwipunku;
          end;
until Polecenie=koniec;
Polecenie:=0;
ukryjmysz;
GlownyPanel;
DaneGlownegoPanelu;
ShowMap;
pokazmysz;
end;
{=========================}
{=  URUCHAMIANIE ZAPISU  =}
{=========================}
Procedure UruchomZapis(nrzap:byte);
begin
ukryjmysz;
RunRecordScript(zapis[nrzap].skrypt);
zerujekrany;
zerujprzyciski;
TworzPrzycisk(511,200,620,225,0,1,'Zadania');
TworzPrzycisk(511,240,620,265,0,1,'Pliki');
TworzPrzycisk(511,280,620,305,0,1,'Odpoczynek');
tworzprzycisk(515,60,555,75,0,1,'/\ ');
tworzprzycisk(515,80,555,95,0,1,'\/ ');
tworzprzycisk(511,430,620,445,0,1,'Koniec ');
TworzEkran(15,15,500,460,4);
czyscekran(ekranwpisu);
ekranwpisu:=1;
ekranodczytu:=1;
wyswietldate;
wyswietlzapisy;
pokazmysz;
end;
{================}
{=  ODPOCZYNEK  =}
{================}
Procedure Odpocznij(nrodp:byte);
var liczba:integer;
begin
ukryjmysz;
if nrodp=1 then
             begin
              liczba:=0;
              repeat
               inc(liczba);
               delay(50);
               dodajminute;
               wyswietlgodzine;
              until liczba=60;
              wyswietldate;
             end;
if nrodp=2 then
             begin
              liczba:=0;
              repeat
               inc(liczba);
               delay(50);
               dodajminute;
               wyswietlgodzine;
              until liczba=120;
              wyswietldate;
             end;
if nrodp=3 then
             begin
              liczba:=0;
              repeat
               inc(liczba);
               delay(50);
               dodajminute;
               wyswietlgodzine;
              until liczba=240;
              wyswietldate;
             end;
if nrodp=4 then
             begin
              liczba:=0;
              repeat
               inc(liczba);
               delay(5);
               dodajminute;
               wyswietlgodzine;
              until gg=8;
               wyswietldate;
             end;
if nrodp=5 then
             begin
              liczba:=0;
              repeat
               inc(liczba);
               delay(5);
               dodajminute;
               wyswietlgodzine;
              until gg=12;
               wyswietldate;
             end;
if nrodp=6 then
             begin
              liczba:=0;
              repeat
               inc(liczba);
               delay(5);
               dodajminute;
               wyswietlgodzine;
              until gg=18;
               wyswietldate;
             end;
if nrodp=7 then
             begin
              liczba:=0;
              repeat
               inc(liczba);
               delay(5);
               dodajminute;
               wyswietlgodzine;
              until gg=0;
               wyswietldate;
             end;
if nrodp=8 then
             begin
              liczba:=0;
              repeat
               inc(liczba);
               delay(5);
               dodajminute;
               wyswietlgodzine;
              until mapa.postacie[0].hp=mapa.postacie[0].maxhp;
               wyswietldate;
             end;
pokazmysz;
end;
{==============================================}
{=        PROCEDURA OBSLUGI DZIENNIKA         =}
{==============================================}
Procedure ObslugaDziennika;
var AktWyb:byte;
    pomocn:byte;
const
      WZadania=1;
      WZapisy=2;
      WOdpoczynek=3;
begin
PanelDziennika;
aktwyb:=0;
wyswietldate;
repeat
pozycjamyszy(a,b,c);
if c=1 then
          begin
           repeat
            pozycjamyszy(a,b,c);
           until c=0;
           if czywcisnieto(6) then
                                begin
                                 Polecenie:=koniec;
                                 wcisnijprzycisk(6);
                                 c:=0;
                                end;
           if czywcisnieto(1) then
                                begin
                                 wcisnijprzycisk(1);
                                 czyscekran(ekranwpisu);
                                 wyswietlzadania;
                                 aktwyb:=Wzadania;
                                end;
           if czywcisnieto(2) then
                                begin
                                 wcisnijprzycisk(2);
                                 czyscekran(ekranwpisu);
                                 wyswietlzapisy;
                                 aktwyb:=WZapisy;
                                end;
           if czywcisnieto(4) then if scrol>1 then
                                begin
                                  wcisnijprzycisk(4);
                                  dec(scrol);
                                  czyscekran(ekranwpisu);
                                  wyswietlzadania;
                                end;
           if czywcisnieto(5) then if scrol<ilosczadan then
                                begin
                                 wcisnijprzycisk(5);
                                 inc(scrol);
                                 czyscekran(ekranwpisu);
                                 wyswietlzadania;
                                end;
       if czywcisnieto(3) then
                            begin
                             wcisnijprzycisk(3);
                             WyswietlOdpoczynek;
                             aktwyb:=WOdpoczynek;
                            end;

       if aktwyb=WOdpoczynek then
                   begin
                    if (a>40) and (a<340) and (b>60) and (b<70) then Odpocznij(1);
                    if (a>40) and (a<340) and (b>90) and (b<100) then Odpocznij(2);
                    if (a>40) and (a<340) and (b>120) and (b<130) then Odpocznij(3);
                    if (a>40) and (a<340) and (b>150) and (b<160) then Odpocznij(4);
                    if (a>40) and (a<340) and (b>180) and (b<190) then Odpocznij(5);
                    if (a>40) and (a<340) and (b>210) and (b<220) then Odpocznij(6);
                    if (a>40) and (a<340) and (b>240) and (b<250) then Odpocznij(7);
                    if (a>40) and (a<340) and (b>270) and (b<280) then Odpocznij(8);
                   end;
           if (a>15) and (a<500) and (b>25) and (b<225) then if aktwyb=Wzapisy then
                            begin
                             pomocn:=trunc((b-15)/10);
                             if zapis[pomocn].status=zapisany then uruchomzapis(pomocn);
                            end;
          end;
until polecenie=koniec;
polecenie:=0;
glownypanel;
daneglownegopanelu;
showmap;
end;
{==============================}
{= GLOWNA PROCEDURA KRADZIEZY =}
{==============================}
Procedure Ukradnij(SP,SG,nrp:byte);
var spr:integer;
begin
if (mapa.postacie[0].ekwipunek[sp]=0)and(mapa.postacie[nrp].ekwipunek[sg-24]>0) then
     begin
      spr:=random(100)-mapa.postacie[0].cechy[szczescie];

      if spr>calkowityskill(0,kradzierz) then
         begin
          dopisz('* Nie udalo ci sie niczego ukrasc!');
          Crit:=nrp;
          glownypanel;
          daneglownegopanelu;
          wyswietlkonsole;
          showmap;
          if mapa.postacie[nrp].skrypt<>'' then RunCritterScript(mapa.postacie[nrp].skrypt,7);
          polecenie:=koniec;
         end
         else
         begin
          dopisz('* Lup:'+idname(mapa.postacie[nrp].ekwipunek[sg-24])+' nalezy do ciebie.');
          Exp:=exp+50;
          dopisz('* Otrzymujesz 50 PD za poprawne urzycie umiejetnosci Kradzierz.');
          mapa.postacie[0].ekwipunek[sp]:=mapa.postacie[nrp].ekwipunek[sg-24];
          mapa.postacie[0].spec[sp]:=mapa.postacie[nrp].spec[sg-24];
          mapa.postacie[nrp].ekwipunek[sg-24]:=0;
          mapa.postacie[nrp].spec[sg-24]:=0;
          polecenie:=koniec;
          glownypanel;
          daneglownegopanelu;
          wyswietlkonsole;
          showmap;
         end;
     end;
end;
{===============================}
{= PROCEDURA OBSLUGI KRADZIEZY =}
{===============================}
Procedure Kradnij(nrp:byte);
begin
panelkradziezy;
danekradziezy(nrp);
polecenie:=0;
repeat
pozycjamyszy(a,b,c);
if c<>0 then
          begin
           if c=1 then
                   begin
                    repeat
                    pozycjamyszy(a,b,c);
                    until c=0;
                    if czywcisnieto(1) then
                                        begin
                                         wcisnijprzycisk(1);
                                         polecenie:=koniec;
                                        end;
                    if (a>159) and (a<230) and (b>29) and (b<451) then
                            begin
                             DelRamkaKRadziezy;
                             ws:=trunc((b-30)/35)+1;
                             RamkaKradziezy;
                            end;
                    if (a>230) and (a<300) and (b>29) and (b<451) then
                            begin
                             DelRamkaKRadziezy;
                             ws:=trunc((b-30)/35)+13;
                             RamkaKradziezy;
                            end;
                    if (a>340) and (a<410) and (b>29) and (b<451) then
                            begin
                             DelRamkaKRadziezy;
                             ws:=trunc((b-30)/35)+25;
                             RamkaKradziezy;
                            end;
                    if (a>410) and (a<480) and (b>29) and (b<451) then
                            begin
                             DelRamkaKRadziezy;
                             ws:=trunc((b-30)/35)+37;
                             RamkaKradziezy;
                            end;
                   end;
           if c=2 then
                   begin
                    repeat
                    pozycjamyszy(a,b,c);
                    until c=0;
                    if (a>159) and (a<230) and (b>29) and (b<451) then if ws>24 then
                            begin
                             Ukradnij(trunc((b-30)/35)+1,ws,nrp);
                            end;
                    if (a>230) and (a<300) and (b>29) and (b<451) then if ws>24 then
                            begin
                             ukradnij(trunc((b-30)/35)+13,ws,nrp);
                            end;
                   end;
          end;
until polecenie=koniec;
glownypanel;
daneglownegopanelu;
wyswietlkonsole;
showmap;
end;
{==============================================}
{=   DODANIE WARTOSCI DO DANEJ UMIEJETNOSCI   =}
{==============================================}
Procedure DodajDoSkilla(nrsk:byte);
begin
wcisnijprzycisk(1);
if mapa.postacie[0].skills[nrsk]+skillslev[nrsk]<200 then
          begin
           inc(skillslev[nrsk]);
           dec(pnkt);
           Wyswietlumiejetnosci;
          end;
end;
{============================================}
{=  ODJECIE WARTOSCI OD DANEJ UMIEJETNOSCI  =}
{============================================}
Procedure OdejmijOdSkilla(nrsk:byte);
begin
wcisnijprzycisk(2);
dec(skillslev[nrsk]);
inc(pnkt);
Wyswietlumiejetnosci;
end;

{==============================================}
{=     PROCEDURA OBSLUGI CHARAKTERYSTYKI      =}
{==============================================}
Procedure ObslugaCharakterystyki;
begin
skillslev[1]:=0;
skillslev[2]:=0;
skillslev[3]:=0;
skillslev[4]:=0;
skillslev[5]:=0;
skillslev[6]:=0;
skillslev[7]:=0;
skillslev[8]:=0;
ukryjmysz;
PanelPostaci;
DanePostaci;
polecenie:=0;
pomlev:=false;
wb:=1;
wyswietlwspolczynniki;
pokazmysz;
repeat
pozycjamyszy(a,b,c);
if c<>0 then
          begin
           repeat
           pozycjamyszy(a,b,c);
           until c=0;
           if czywcisnieto(3) then
                                begin
                                 polecenie:=koniec;
                                 wcisnijprzycisk(3);
                                 inc(mapa.postacie[0].skills[1],skillslev[1]);
                                 inc(mapa.postacie[0].skills[2],skillslev[2]);
                                 inc(mapa.postacie[0].skills[3],skillslev[3]);
                                 inc(mapa.postacie[0].skills[4],skillslev[4]);
                                 inc(mapa.postacie[0].skills[5],skillslev[5]);
                                 inc(mapa.postacie[0].skills[6],skillslev[6]);
                                 inc(mapa.postacie[0].skills[7],skillslev[7]);
                                 inc(mapa.postacie[0].skills[8],skillslev[8]);
                                 skillslev[1]:=0;
                                 skillslev[2]:=0;
                                 skillslev[3]:=0;
                                 skillslev[4]:=0;
                                 skillslev[5]:=0;
                                 skillslev[6]:=0;
                                 skillslev[7]:=0;
                                 skillslev[8]:=0;
                                end;
           if czywcisnieto(1) then if (wb>7) and (wb<16) then if pnkt>0 then DodajdoSkilla(wb-7);
           if czywcisnieto(2) then if (wb>7) and (wb<16) then if skillslev[wb-7]>0 then odejmijodSkilla(wb-7);
           if czywcisnieto(4) then
                                begin
                                 wcisnijprzycisk(4);
                                 lecz(0);
                                 wyswietlkonsole;
                                end;
           if (a>125) and (a<240) and (b>100) and (b<110) then Wb:=1;
           if (a>125) and (a<240) and (b>120) and (b<130) then Wb:=2;
           if (a>125) and (a<240) and (b>140) and (b<150) then Wb:=3;
           if (a>125) and (a<240) and (b>160) and (b<170) then Wb:=4;
           if (a>125) and (a<240) and (b>180) and (b<190) then Wb:=5;
           if (a>125) and (a<240) and (b>200) and (b<210) then Wb:=6;
           if (a>125) and (a<240) and (b>220) and (b<230) then Wb:=7;

           if (a>365) and (a<540) and (b>70) and (b<80) then Wb:=8;
           if (a>365) and (a<540) and (b>80) and (b<90) then Wb:=9;
           if (a>365) and (a<540) and (b>90) and (b<100) then Wb:=10;
           if (a>365) and (a<540) and (b>100) and (b<110) then Wb:=11;
           if (a>365) and (a<540) and (b>110) and (b<120) then Wb:=12;
           if (a>365) and (a<540) and (b>120) and (b<130) then Wb:=13;
           if (a>365) and (a<540) and (b>130) and (b<140) then Wb:=14;
           if (a>365) and (a<540) and (b>140) and (b<150) then Wb:=15;

           if (a>260) and (a<340) and (b>70) and (b<80) then Wb:=16;
           if (a>260) and (a<340) and (b>85) and (b<95) then Wb:=17;
           if (a>260) and (a<340) and (b>100) and (b<120) then Wb:=18;
           if (a>260) and (a<340) and (b>125) and (b<135) then Wb:=19;
           if (a>260) and (a<340) and (b>140) and (b<150) then Wb:=20;

           if (a>120) and (a<250) and (b>245) and (b<330) then Wb:=21;

           if (a>260) and (a<340) and (b>200) and (b<210) then Wb:=22;
           if (a>260) and (a<400) and (b>230) and (b<240) then if reputation[1]>0 then wb:=23;
           if (a>260) and (a<400) and (b>240) and (b<250) then if reputation[2]>0 then wb:=24;
           if (a>260) and (a<400) and (b>250) and (b<260) then if reputation[3]>0 then wb:=25;
           if (a>260) and (a<400) and (b>260) and (b<270) then if reputation[4]>0 then wb:=26;
           if (a>260) and (a<400) and (b>270) and (b<280) then if reputation[5]>0 then wb:=27;
           if (a>260) and (a<400) and (b>280) and (b<290) then if reputation[6]>0 then wb:=28;
           if (a>260) and (a<400) and (b>290) and (b<300) then if reputation[7]>0 then wb:=29;
           if (a>260) and (a<400) and (b>300) and (b<310) then if reputation[8]>0 then wb:=30;
           if (a>260) and (a<400) and (b>310) and (b<320) then if reputation[9]>0 then wb:=31;
           if (a>260) and (a<400) and (b>320) and (b<330) then if reputation[10]>0 then wb:=32;
           wyswietlwspolczynniki;
          end;
until polecenie=koniec;
glownypanel;
daneglownegopanelu;
showmap;
polecenie:=0;
end;

{=========================================}
{= OPEROWANIE ZA POMOCA LEWEGO PRZYCISKU =}
{=========================================}
Procedure LewyPrzycisk;
begin
repeat
pozycjamyszy(a,b,c);
until c=0;
if a>10 then if a<410 then if b>10 then if b<400 then MoveC;
if czywcisnieto(1) then
                     begin
                      polecenie:=koniec;
                      wcisnijprzycisk(1);
                     end;
if czywcisnieto(3) then
                     begin
                      wcisnijprzycisk(3);
                      ObslugaEkwipunku;
                     end;
if czywcisnieto(4) then
                     begin
                      wcisnijprzycisk(4);
                      ObslugaDziennika;
                     end;
if czywcisnieto(2) then
                     begin
                      wcisnijprzycisk(2);
                      ObslugaCharakterystyki;
                     end;
if (a>425) and (b>191) and (a<625) and (b<216) then
                            begin
                             ukryjmysz;
                             ProbaAtaku;
                             pokazmysz;
                             FightAnim;
                             TrybGry:=TrybWalki;
                            end;
end;
{=====================================}
{=  WYBIERANIE PRZEDMIOTU DO UZYCIA  =}
{=====================================}
Function WybierzPrzedmiot:byte;
begin
wybierzprzedmiot:=0;
RysujPrzedmiotyUzycia;

repeat
pozycjamyszy(a,b,c);
if c=1 then
         begin
          repeat
          pozycjamyszy(a,b,c);
          until c=0;
          if (a>110) and (a<250) and (b>30) and (b<450) then
                           begin
                            ukryjmysz;
                            if (a>110) and (a<180) then
                                   begin
                                    wybierzprzedmiot:=trunc( (b-30)/35)+1;
                                    polecenie:=koniec;
                                   end;
                            if (a>180) and (a<250) then
                                   begin
                                    wybierzprzedmiot:=trunc( (b-30)/35)+13;
                                    polecenie:=koniec;
                                   end;
                            pokazmysz;
                           end;
         end;
until polecenie=koniec;
polecenie:=0;
end;
{=====================================}
{= OCZEKIWANIE NA WYBOR UMIEJETNOSCI =}
{=====================================}
Function WybierzUmiejetnosc:byte;
begin
repeat
pozycjamyszy(a,b,c);
until c<>0;
if c=1 then
        begin
         repeat
         pozycjamyszy(a,b,c);
         until c=0;
         if czywcisnieto(1) then
                              begin
                               wcisnijprzycisk(1);
                               wybierzumiejetnosc:=nauka;
                              end;
         if czywcisnieto(2) then
                              begin
                               wcisnijprzycisk(2);
                               wybierzumiejetnosc:=otwieraniezamkow;
                              end;
         if czywcisnieto(3) then
                              begin
                               wcisnijprzycisk(3);
                               wybierzumiejetnosc:=leczenie;
                              end;
         if czywcisnieto(4) then
                              begin
                               wcisnijprzycisk(4);
                               wybierzumiejetnosc:=kradzierz;
                              end;

        end;
end;
{==============}
{=  LECZENIE  =}
{==============}
Procedure Lecz(nrpo:byte);
var uleczone:byte;
    Przybylo:integer;
    i:byte;
begin
ukryjmysz;
if mapa.postacie[nrpo].hp<mapa.postacie[nrpo].maxhp then
begin
 if random(100)-mapa.postacie[0].cechy[szczescie]>calkowityskill(nrpo,leczenie) then
  begin
    dopisz('* Mija jakis czas.');
    dopisz('* Nie udalo ci sie wyleczyc zadnych obrazen.');
    repeat
    inc(i);
    dodajminute;
    until i=15;
    delay(1500);
  end else
                begin
                 dopisz('* Mija jakis czas.');
                 repeat
                 inc(i);
                 dodajminute;
                 until i=15;
                 delay(1500);
                 uleczone:=round(mapa.postacie[0].skills[leczenie]*0.05)+1;
             if nrpo>0 then dopisz('* Udaloci sie uleczyc '+zamien(uleczone)+' punktow obrazen u:'+mapa.postacie[nrpo].imie)
                              else dopisz('* Udalo ci sie uleczyc '+zamien(uleczone)+' punktow obrazen.');

                 inc(mapa.postacie[nrpo].hp,uleczone);
                 if mapa.postacie[nrpo].hp>mapa.postacie[nrpo].maxhp then mapa.postacie[nrpo].hp:=mapa.postacie[nrpo].maxhp;
                 przybylo:=5*uleczone;
                 exp:=exp+przybylo;
                 dopisz('Otrzymujesz '+zamien(przybylo)+' PD za poprawne zastosowanie umiejetnosci Leczenie.');
                end;
 end else if nrpo=0 then dopisz('* Nie odniosles ostatnio zadnych obrazen.')
                else dopisz('* '+mapa.postacie[nrpo].imie+' jest zdrowy.');

pokazmysz;
end;
{===================================================}
{= PROCEDURA OBSLUGI KONTAKTU Z NAPOTKAN POSTACI =}
{===================================================}
Procedure ObslugaPostaci(nrp:byte);
var WU:byte;
begin
ukryjmysz;
PanelCzynnosci(nrp,postac);
pokazmysz;
repeat
pozycjamyszy(a,b,c);
if c<>0 then
           begin
            if c=2 then
                     begin
                      polecenie:=koniec;
                      repeat
                      pozycjamyszy(a,b,c);
                      until c=0;
                      glownypanel;
                      daneglownegopanelu;
                      wyswietlkonsole;
                      showmap;
                     end;
            if c=1 then
                     begin
                      repeat
                       pozycjamyszy(a,b,c);
                      until c=0;

                      if czywcisnieto(1) then if mapa.postacie[nrp].skrypt<>'' then
                                                                   begin
                                                                    wcisnijprzycisk(1);
                                                                    crit:=nrp;
                                                                    runcritterscript(mapa.postacie[nrp].skrypt,1);
                                                                    Polecenie:=koniec;
                                                                    glownypanel;
                                                                    daneglownegopanelu;
                                                                    wyswietlkonsole;
                                                                    showmap;
                                                                   end
                                                                    else
                                                                   begin
                                                                    wcisnijprzycisk(1);
                                                                    dopisz('* Nie chce z toba rozmawiac.');
                                                                    wyswietlkonsole;
                                                                    Polecenie:=koniec;
                                                                    glownypanel;
                                                                    daneglownegopanelu;
                                                                    wyswietlkonsole;
                                                                    showmap;
                                                                   end;
                      if czywcisnieto(2) then if mapa.postacie[nrp].skrypt<>'' then
                                                                   begin
                                                                    wcisnijprzycisk(2);
                                                                    crit:=nrp;
                                                                    runcritterscript(mapa.postacie[nrp].skrypt,2);
                                                                    Polecenie:=koniec;
                                                                    glownypanel;
                                                                    daneglownegopanelu;
                                                                    wyswietlkonsole;
                                                                    showmap;
                                                                   end
                                                                    else
                                                                   begin
                                                                    wcisnijprzycisk(2);
                                                                    dopisz('* Widzisz jakiegos czlowieka');
                                                                    wyswietlkonsole;
                                                                    Polecenie:=koniec;
                                                                    glownypanel;
                                                                    daneglownegopanelu;
                                                                    wyswietlkonsole;
                                                                    showmap;
                                                                   end;
                      if czywcisnieto(3) then
                                            begin
                                             PanelUzyciaPrzedmiotow;
                                             WU:=WybierzPrzedmiot;
                                             if wu>0 then
                                                if moznaurzyc(mapa.postacie[0].ekwipunek[wu]) then UrzyjPrzedmiotu(nrp,wu)
                                                       else dopisz('* Tego typu przedmiotow nie uzywa sie w ten sposob.');
                                             polecenie:=koniec;
                                             glownypanel;
                                             daneglownegopanelu;
                                             wyswietlkonsole;
                                             showmap;
                                            end;
                      if czywcisnieto(4) then
                                            begin
                                             PanelUmiejetnosci;
                                             WU:=WybierzUmiejetnosc;
                                             if wu=kradzierz then if nrp>0 then Kradnij(nrp)
                                                                    else
                                                                      begin
                                                                       dopisz('* Nie mozesz okrasc sam siebie!');
                                                                       polecenie:=koniec;
                                                                       glownypanel;
                                                                       daneglownegopanelu;
                                                                       wyswietlkonsole;
                                                                       showmap;
                                                                      end;
                                             if wu=leczenie then
                                                             begin
                                                              lecz(nrp);
                                                              polecenie:=koniec;
                                                              glownypanel;
                                                              daneglownegopanelu;
                                                              wyswietlkonsole;
                                                              showmap;
                                                             end;
                                             if wu=nauka then
                                                           begin
                                                            dopisz('* Nie sadze by udalo ci sie czegos nauczyc.');
                                                            polecenie:=koniec;
                                                            glownypanel;
                                                            daneglownegopanelu;
                                                            wyswietlkonsole;
                                                            showmap;
                                                           end;
                                             if wu=otwieraniezamkow then
                                                                     begin
                                                                      dopisz('* Eee... Chyba nie.');
                                                                      polecenie:=koniec;
                                                                      glownypanel;
                                                                      daneglownegopanelu;
                                                                      wyswietlkonsole;
                                                                      showmap;
                                                                     end;
                                            end;
                     end;
           end;
until polecenie=koniec;
polecenie:=0;
end;
{==============================================================}
{= PRZENOSZENIE PRZEDMIOTOW POMIEDZY SZAFKA A POSTACIA MARTWA =}
{==============================================================}
Procedure KopiujMartwy(SlotDocelowy,SlotWyjsciowy,nrs:byte);
var Z1,Z2:integer;
    W1,W2:real;
    Okresl:boolean;
begin
okresl:=true;
if slotdocelowy=slotwyjsciowy then okresl:=false;
if okresl then
     begin
      if slotwyjsciowy<25 then
               begin
                 Z1:=mapa.postacie[0].ekwipunek[slotwyjsciowy];
                 W1:=mapa.postacie[0].spec[slotwyjsciowy];
               end;
      if slotwyjsciowy>24 then
               begin
                 Z1:=mapa.postacie[nrs].ekwipunek[slotwyjsciowy-24];
                 W1:=mapa.postacie[nrs].spec[slotwyjsciowy-24];
               end;
      if slotdocelowy<25 then
               begin
                 Z2:=mapa.postacie[0].ekwipunek[slotdocelowy];
                 W2:=mapa.postacie[0].spec[slotdocelowy];
               end;
      if slotdocelowy>24 then
               begin
                 Z2:=mapa.postacie[nrs].ekwipunek[slotdocelowy-24];
                 W2:=mapa.postacie[nrs].spec[slotdocelowy-24];
               end;
      {KOPIOWANIE}
      if slotdocelowy<25 then
               begin
                mapa.postacie[0].ekwipunek[slotdocelowy]:=z1;
                mapa.postacie[0].spec[slotdocelowy]:=w1;
               end;
      if slotdocelowy>24 then
               begin
                mapa.postacie[nrs].ekwipunek[slotdocelowy-24]:=z1;
                mapa.postacie[nrs].spec[slotdocelowy-24]:=w1;
               end;
      if slotwyjsciowy<25 then
               begin
                mapa.postacie[0].ekwipunek[slotwyjsciowy]:=z2;
                mapa.postacie[0].spec[slotwyjsciowy]:=w2;
               end;
      if slotwyjsciowy>24 then
               begin
                mapa.postacie[nrs].ekwipunek[slotwyjsciowy-24]:=z2;
                mapa.postacie[nrs].spec[slotwyjsciowy-24]:=w2;
               end;

     end;
end;
{==========================================================}
{= SPRAWDZANIE JAKIEJ BRONI UZYWALA POSTAC PRZED SMIERCIA =}
{==========================================================}
Procedure Sprawdztrupa(nrs:byte);
var pomz:byte;
begin
pomz:=itemsearch(nrs,0);
if pomz>0 then if mapa.postacie[nrs].bron<>0 then
            begin
             mapa.postacie[nrs].ekwipunek[pomz]:=mapa.postacie[nrs].bron;
             mapa.postacie[nrs].spec[pomz]:=mapa.postacie[nrs].bronspec;
            end;
end;
{===============================}
{=   OBSLUGA MARTWEJ POSTACI   =}
{===============================}
Procedure ObslugaTrupa(nrs:byte);
begin
ws:=0;
panelszafek;
sprawdztrupa(nrs);
daneTrupa(nrs);
polecenie:=0;
repeat
pozycjamyszy(a,b,c);
if c<>0 then
         begin
          if c=1 then
                   begin
                    repeat
                    pozycjamyszy(a,b,c);
                    until c=0;
                    if czywcisnieto(1) then
                                        begin
                                         wcisnijprzycisk(1);
                                         polecenie:=koniec;
                                        end;
                    if (a>159) and (a<230) and (b>29) and (b<451) then
                            begin
                             DelRamkaKRadziezy;
                             ws:=trunc((b-30)/35)+1;
                             RamkaKradziezy;
                            end;
                    if (a>230) and (a<300) and (b>29) and (b<451) then
                            begin
                             DelRamkaKRadziezy;
                             ws:=trunc((b-30)/35)+13;
                             RamkaKradziezy;
                            end;
                    if (a>340) and (a<410) and (b>29) and (b<451) then
                            begin
                             DelRamkaKRadziezy;
                             ws:=trunc((b-30)/35)+25;
                             RamkaKradziezy;
                            end;
                    if (a>410) and (a<480) and (b>29) and (b<451) then
                            begin
                             DelRamkaKRadziezy;
                             ws:=trunc((b-30)/35)+37;
                             RamkaKradziezy;
                            end;
                   end;
          if c=2 then
                   begin
                    repeat
                    pozycjamyszy(a,b,c);
                    until c=0;
                    if (a>159) and (a<230) and (b>29) and (b<451) then
                            begin
                             KopiujMartwy(trunc((b-30)/35)+1,ws,nrs);
                             czyscpanelszafek;
                             danetrupa(nrs);
                            end;
                    if (a>230) and (a<300) and (b>29) and (b<451) then
                            begin
                             KopiujMartwy(trunc((b-30)/35)+13,ws,nrs);
                             czyscpanelszafek;
                             danetrupa(nrs);
                            end;
                    if (a>340) and (a<410) and (b>29) and (b<451) then
                            begin
                             KopiujMartwy(trunc((b-30)/35)+25,ws,nrs);
                             czyscpanelszafek;
                             danetrupa(nrs);
                            end;
                    if (a>410) and (a<480) and (b>29) and (b<451) then
                            begin
                             Kopiujmartwy(trunc((b-30)/35)+37,ws,nrs);
                             czyscpanelszafek;
                             danetrupa(nrs);
                            end;
                   end;
         end;
until polecenie=koniec;
polecenie:=0;
glownypanel;
daneglownegopanelu;
showmap;
end;

{==============================================================}
{= PRZENOSZENIE PRZEDMIOTOW POMIEDZY SZAFKA A POSTACIA GRACZA =}
{==============================================================}
Procedure KopiujSzafka(SlotDocelowy,SlotWyjsciowy,nrs:byte);
var Z1,Z2:integer;
    W1,W2:real;
    Okresl:boolean;
begin
okresl:=true;
if slotdocelowy=slotwyjsciowy then okresl:=false;

if okresl then
     begin
      if slotwyjsciowy<25 then
               begin
                 Z1:=mapa.postacie[0].ekwipunek[slotwyjsciowy];
                 W1:=mapa.postacie[0].spec[slotwyjsciowy];
               end;
      if slotwyjsciowy>24 then
               begin
                 Z1:=mapa.szafki[nrs].sprzety[slotwyjsciowy-24];
                 W1:=mapa.szafki[nrs].spec[slotwyjsciowy-24];
               end;
      if slotdocelowy<25 then
               begin
                 Z2:=mapa.postacie[0].ekwipunek[slotdocelowy];
                 W2:=mapa.postacie[0].spec[slotdocelowy];
               end;
      if slotdocelowy>24 then
               begin
                 Z2:=mapa.szafki[nrs].sprzety[slotdocelowy-24];
                 W2:=mapa.szafki[nrs].spec[slotdocelowy-24];
               end;
      {KOPIOWANIE}
      if slotdocelowy<25 then
               begin
                mapa.postacie[0].ekwipunek[slotdocelowy]:=z1;
                mapa.postacie[0].spec[slotdocelowy]:=w1;
               end;
      if slotdocelowy>24 then
               begin
                mapa.szafki[nrs].sprzety[slotdocelowy-24]:=z1;
                mapa.szafki[nrs].spec[slotdocelowy-24]:=w1;
               end;
      if slotwyjsciowy<25 then
               begin
                mapa.postacie[0].ekwipunek[slotwyjsciowy]:=z2;
                mapa.postacie[0].spec[slotwyjsciowy]:=w2;
               end;
      if slotwyjsciowy>24 then
               begin
                mapa.szafki[nrs].sprzety[slotwyjsciowy-24]:=z2;
                mapa.szafki[nrs].spec[slotwyjsciowy-24]:=w2;
               end;

     end;
end;
{===============================}
{= OBSLUGA OBIEKTU TYPU SZAFKA =}
{===============================}
Procedure ObslugaSzafki(nrs:byte);
begin
ws:=0;
panelszafek;
daneszafek(nrs);
polecenie:=0;
repeat
pozycjamyszy(a,b,c);
if c<>0 then
         begin
          if c=1 then
                   begin
                    repeat
                    pozycjamyszy(a,b,c);
                    until c=0;
                    if czywcisnieto(1) then
                                        begin
                                         wcisnijprzycisk(1);
                                         polecenie:=koniec;
                                        end;
                    if (a>159) and (a<230) and (b>29) and (b<451) then
                            begin
                             DelRamkaKRadziezy;
                             ws:=trunc((b-30)/35)+1;
                             RamkaKradziezy;
                            end;
                    if (a>230) and (a<300) and (b>29) and (b<451) then
                            begin
                             DelRamkaKRadziezy;
                             ws:=trunc((b-30)/35)+13;
                             RamkaKradziezy;
                            end;
                    if (a>340) and (a<410) and (b>29) and (b<451) then
                            begin
                             DelRamkaKRadziezy;
                             ws:=trunc((b-30)/35)+25;
                             RamkaKradziezy;
                            end;
                    if (a>410) and (a<480) and (b>29) and (b<451) then
                            begin
                             DelRamkaKRadziezy;
                             ws:=trunc((b-30)/35)+37;
                             RamkaKradziezy;
                            end;
                   end;
          if c=2 then
                   begin
                    repeat
                    pozycjamyszy(a,b,c);
                    until c=0;
                    if (a>159) and (a<230) and (b>29) and (b<451) then
                            begin
                             KopiujSzafka(trunc((b-30)/35)+1,ws,nrs);
                             czyscpanelszafek;
                             daneszafek(nrs);
                            end;
                    if (a>230) and (a<300) and (b>29) and (b<451) then
                            begin
                             KopiujSzafka(trunc((b-30)/35)+13,ws,nrs);
                             czyscpanelszafek;
                             daneszafek(nrs);
                            end;
                    if (a>340) and (a<410) and (b>29) and (b<451) then
                            begin
                             Kopiujszafka(trunc((b-30)/35)+25,ws,nrs);
                             czyscpanelszafek;
                             daneszafek(nrs);
                            end;
                    if (a>410) and (a<480) and (b>29) and (b<451) then
                            begin
                             Kopiujszafka(trunc((b-30)/35)+37,ws,nrs);
                             czyscpanelszafek;
                             daneszafek(nrs);
                            end;
                   end;
         end;
until polecenie=koniec;
polecenie:=0;
glownypanel;
daneglownegopanelu;
showmap;
end;
{========================}
{= SPRAWDZENIE SCENERII =}
{========================}
Procedure RunScennery(nrs:byte);
begin
if (mapa.scenerie[nrs].typ=0) or (mapa.scenerie[nrs].typ>8) then
                              begin
                               wcisnijprzycisk(1);
                               dopisz('* '+czytajtext(tekstygry+'scenname.msg',mapa.scenerie[nrs].typ+1));
                               glownypanel;
                               daneglownegopanelu;
                               showmap;
                              end;
if (mapa.scenerie[nrs].typ>0) and ((mapa.scenerie[nrs].typ<9)or(mapa.scenerie[nrs].typ=20)) then
                              begin
                               wcisnijprzycisk(1);
                               if mapa.scenerie[nrs].stan=otwarte then
                                                                    begin
                                                                     wymarzs(nrs);
                                                                     mapa.scenerie[nrs].stan:=zamkniete;
                                                                     walidatuj(mapa.scenerie[nrs].xs,mapa.scenerie[nrs].ys);
                                                                     RysujKwadrat(mapa.scenerie[nrs].xs,mapa.scenerie[nrs].ys);
                                                                    end
                                                                    else if mapa.scenerie[nrs].stan=zamkniete then
                                                                    begin
                                                                     wymarzs(nrs);
                                                                     mapa.scenerie[nrs].stan:=otwarte;
                                                                     walidatuj(mapa.scenerie[nrs].xs,mapa.scenerie[nrs].ys);
                                                                     RysujKwadrat(mapa.scenerie[nrs].xs,mapa.scenerie[nrs].ys);
                                                                    end
                                                                    else if mapa.scenerie[nrs].stan=zamek then
                                                                    begin
                                                                     dopisz('* Niestety, drzwi sa zamkniete.');
                                                                    end;
                              end;
end;
{===============================}
{= PROCEDURA OTWIERANIA ZAMKOW =}
{===============================}
Procedure OtworzZamek(nrs:byte);
var los:integer;
begin
los:=random(10)-mapa.postacie[0].cechy[szczescie]+mapa.scenerie[nrs].stopien;
if los>calkowityskill(0,otwieraniezamkow) then dopisz('* Nie udalo ci sie otworzyc zamka.')
                 else
                 begin
                  dopisz('* Otwierasz zamek.');
                  dopisz('* Otrzymujesz '+zamien(round(mapa.scenerie[nrs].stopien/10)*5)+
                            ' PD za poprawne wykorzystanie umiejetnosci Otwieranie Zamkow.');
                  mapa.scenerie[nrs].stan:=zamkniete;
                  exp:=exp+(round(mapa.scenerie[nrs].stopien/10)*5);
                 end;
end;
{===========================================}
{= URZYCIE PRZEDMIOTU NA OBIEKCIE SCENERII =}
{===========================================}
Procedure PrzedmiotNaScenerii(nrslot,nrs:byte);
begin
if (mapa.scenerie[nrs].typ=20) or ((mapa.scenerie[nrs].typ>0)and(mapa.scenerie[nrs].typ<9))
      then
        begin
         if mapa.postacie[0].ekwipunek[nrslot]=mapa.scenerie[nrs].klucz then
          begin
           if (mapa.scenerie[nrs].stan=otwarte) or (mapa.scenerie[nrs].stan=zamkniete) then
                                             dopisz('* Te drzwi nie sa zamkniete na klucz.');
           if mapa.scenerie[nrs].stan=zamek then
                                         begin
                                          dopisz('* Otwierasz drzwi.');
                                          mapa.scenerie[nrs].stan:=zamkniete;
                                         end;
          end else dopisz('* To do niczego nie prowadzi.');
         end
         else
          begin
           if mapa.scenerie[nrs].skrypt<>'' then
                  begin
                   scen:=nrs;
                   crit:=0;
                   runscenneryscript(mapa.scenerie[nrs].skrypt,4);
                  end else dopisz('* To do niczego nie prowadzi.');
          end;
end;
{========================================}
{=      OBSLUGA OBIEKTOW SCENERII       =}
{========================================}
Procedure ObslugaScenerii(nrs:byte);
var wu:byte;
begin
ukryjmysz;
panelczynnosci(nrs,vsceneria);
pokazmysz;
polecenie:=0;
repeat
pozycjamyszy(a,b,c);
if c<>0 then
          begin
           if c=2 then
                    begin
                     repeat
                     pozycjamyszy(a,b,c);
                     until c=0;
                     polecenie:=koniec;
                     glownypanel;
                     daneglownegopanelu;
                     showmap;
                    end;
           if c=1 then
                 begin
                  repeat
                  pozycjamyszy(a,b,c);
                  until c=0;
                  {UZYJ}
                  if czywcisnieto(1) then if mapa.scenerie[nrs].skrypt<>'' then
                         begin
                          wcisnijprzycisk(1);
                          if (mapa.scenerie[nrs].powiazanie>0)and(mapa.postacie[mapa.scenerie[nrs].powiazanie].status=normalny)
                                       then
                                          begin
                                           glownypanel;
                                           daneglownegopanelu;
                                           showmap;
                                           crit:=mapa.scenerie[nrs].powiazanie;
                                           runcritterscript(mapa.postacie[crit].skrypt,6);
                                           polecenie:=koniec;
                                          end
                                          else
                                          begin
                                           glownypanel;
                                           daneglownegopanelu;
                                           showmap;
                                           scen:=nrs;
                                           runscenneryscript(mapa.scenerie[nrs].skrypt,1);
                                           polecenie:=koniec;
                                          end;

                         end else
                               begin
                                RunScennery(nrs);
                                glownypanel;
                                daneglownegopanelu;
                                walidatujmape;
                                showmap;
                                polecenie:=koniec;
                               end;

                  {PATRZ}
                  if czywcisnieto(2) then if mapa.scenerie[nrs].skrypt<>'' then
                         begin
                          wcisnijprzycisk(2);
                          SCEN:=nrs;
                          RunScenneryScript(mapa.scenerie[nrs].skrypt,2);
                          polecenie:=koniec;
                          glownypanel;
                          daneglownegopanelu;
                          showmap;
                         end
                         else
                            begin
                             wcisnijprzycisk(2);
                             dopisz('* '+czytajtext(tekstygry+'scenlook.msg',mapa.scenerie[nrs].typ+1));
                             glownypanel;
                             daneglownegopanelu;
                             showmap;
                             polecenie:=koniec;
                            end;
                  {PRZEDMIOT}
                  if czywcisnieto(3) then
                         begin
                          PanelUzyciaPrzedmiotow;
                          WU:=WybierzPrzedmiot;
                          PrzedmiotNaScenerii(wu,nrs);
                          glownypanel;
                          daneglownegopanelu;
                          showmap;
                          polecenie:=koniec;
                         end;
                  {UMIEJETNOSC}
                  if czywcisnieto(4) then
                         begin
                          wcisnijprzycisk(4);
                          PanelUmiejetnosci;
                          WU:=Wybierzumiejetnosc;
                          if wu=leczenie then
                                           begin
                                            dopisz('* Co???');
                                            polecenie:=koniec;
                                            glownypanel;
                                            daneglownegopanelu;
                                            showmap;
                                           end;
                          if wu=kradzierz then
                                           begin
                                            dopisz('* Jakto?');
                                            polecenie:=koniec;
                                            glownypanel;
                                            daneglownegopanelu;
                                            showmap;
                                           end;
                          if wu=nauka then if mapa.scenerie[nrs].typ<100 then
                                                   begin
                                                    if mapa.scenerie[nrs].skrypt<>'' then
                                                                begin
                                                                 scen:=nrs;
                                                                 polecenie:=koniec;
                                                                 glownypanel;
                                                                 daneglownegopanelu;
                                                                 showmap;
                                                                 RunScenneryScript(mapa.scenerie[nrs].skrypt,3);
                                                                end
                                                                else
                                                                begin
                                                                 dopisz('* Nie udalo ci sie niczego nauczyc.');
                                                                 polecenie:=koniec;
                                                                 glownypanel;
                                                                 daneglownegopanelu;
                                                                 showmap;
                                                                end;
                                                   end
                                                   else
                                                   begin
                                                    dopisz('* To do niczego nie prowadzi.');
                                                    polecenie:=koniec;
                                                    glownypanel;
                                                    daneglownegopanelu;
                                                    showmap;
                                                   end;
                          if wu=otwieraniezamkow then
                                           begin
                                            if mapa.scenerie[nrs].stan=zamek then OtworzZamek(nrs)
                                                     else dopisz('* Te drzwi nie sa zamkniete na zamek.');
                                            polecenie:=koniec;
                                            glownypanel;
                                            daneglownegopanelu;
                                            showmap;
                                           end;
                          
                         end;
                 end;
          end;
until polecenie=koniec;
polecenie:=0;
end;
{================================}
{= PROCEDURA CENTROWANIA EKRANU =}
{================================}
Procedure UstawEkran(pzx,pzy:byte);
begin
mx:=pzx-9;
my:=pzy-6;
if mx<1 then mx:=1;
if my<1 then my:=1;
if mx+19>mapa.rozx then mx:=mapa.rozx-19;
if my+12>mapa.rozy then my:=mapa.rozy-12;
end;
{==========================================}
{= OPEROWANIE ZA POMOCA PRAWEGO PRZYCISKU =}
{==========================================}
Procedure PrawyPrzycisk;
var pzx,pzy,numerpom:byte;
begin
{*******************************************************************}
{OBSUGI SCENERII (DRZWI, URZDZENIA), OBSUGI SZAFEK,
PRZESZUKIWANIA TRUPW I URZYWANIA UMIEJTNOCI I PRZEDMIOTW.
{*******************************************************************}
repeat
pozycjamyszy(a,b,c);
until c=0;
if (a>mappozx) and (b>mappozy) and (a<470) and (b<410) then
                   begin

                    pzx:=pozycjax;
                    pzy:=pozycjay;
                    if (not ((mapa.postacie[0].xp=pzx) and (mapa.postacie[0].yp=pzy)))
                            and  (mapa.va[pzx,pzy]>2) then
                      begin
                      {KLIKNICIE NA POSTA}
                      if ZnajdzPostac(pzx,pzy)>0 then
                         begin
                           numerpom:=ZnajdzPostac(pzx,pzy);
                           if (odleglosc(0,numerpom)<4) and liniastrzalu(0,numerpom) then
                                  begin
                                   if mapa.postacie[numerpom].status=normalny then
                                   ObslugaPostaci(numerpom);
                                  end
                                  else dopisz('* W tym momecie nie potrafisz sie tam dostac.');
                         end
                         else
                         begin
                          pzx:=pozycjax;
                          pzy:=pozycjay;
                          {KLIKNIECIE NA OBIEKT SCENERII}
                          if znajdzscenerie(pzx,pzy)>0 then
                              begin
                               numerpom:=Znajdzscenerie(pzx,pzy);
                               if (odlegloscS(numerpom)=1) then
                                  begin
                                   if mapa.scenerie[numerpom].xs>0 then
                                   ObslugaScenerii(numerpom);
                                  end
                                  else dopisz('* W tym momecie nie potrafisz sie tam dostac.');
                              end
                              else
                              begin
                               pzx:=pozycjax;
                               pzy:=pozycjay;
                               {KLIKNIECIE NA OBIEKT SCENERII}
                               if znajdzszafke(pzx,pzy)>0 then
                                     begin
                                      numerpom:=Znajdzszafke(pzx,pzy);
                                      if (odlegloscSZ(numerpom)=1) then
                                         begin
                                          if mapa.szafki[numerpom].xs>0 then
                                              if mapa.szafki[numerpom].powiazanie=0 then ObslugaSzafki(numerpom)
                                                   else
                                                    begin
                                                     crit:=mapa.szafki[numerpom].powiazanie;
                                                     if mapa.postacie[crit].status=normalny then
                                                               runcritterscript(mapa.postacie[crit].skrypt,6)
                                                                  else obslugaszafki(numerpom);

                                                    end;
                                         end
                                         else dopisz('* W tym momecie nie potrafisz sie tam dostac.');
                                     end
                                     else
                                     begin
                                      pzx:=pozycjax;
                                      pzy:=pozycjay;
                                      {KLIKNIECIE NA TRUPA}
                                      if znajdztrupa(pzx,pzy)>0 then
                                             begin
                                              numerpom:=Znajdztrupa(pzx,pzy);
                                              if (odleglosc(0,numerpom)=1) then
                                                    begin
                                                     obslugatrupa(numerpom);
                                                    end
                                                    else dopisz('* W tym momecie nie potrafisz sie tam dostac.');
                                             end
                                             else
                                             begin
                                              UstawEkran(pzx,pzy);
                                              ShowMap;
                                             end;

                                     end;

                              end;

                         end;
                      end;
                    wyswietlkonsole;
                   end;
end;

{================================================}
{=   START GLOWNEGO PANELU PODCZAS STARTU GRY   =}
{================================================}
Procedure PanelStart;

begin
GlownyPanel;
DaneGlownegoPanelu;
ShowMap;
WalidatujMape;
pokazmysz;
end;
{                                                       }
{                                                       }
{                    GLOWNY INTERFACE                   }
{                                                       }
{                                                       }

{=================================================}
{= GLOWNY INTERFACE GRY PODCZAS TRYBU NORMALNEGO =}
{=================================================}
Procedure ObslugaMain;
begin
pozycjamyszy(a,b,c);
if c=0 then Klawiatura;
if c<>0 then
          begin
           if c=1 then LewyPrzycisk;
           if c=2 then PrawyPrzycisk;
          end;
end;

{=============================================================}
{=                                                           =}
{=                                                           =}
{=                                                           =}
{=                    STEROWANIE ENGINEM                     =}
{=                                                           =}
{=                                                           =}
{=                                                           =}
{=============================================================}

{                                                        }
{                                                        }
{                          WALKA                         }
{                                                        }
{                                                        }

{================================================================}
{= KIEROWANIE POSTACI GRACZA W ODPOWIEDNIA STRONE PODCZAS WALKI =}
{================================================================}
procedure MoveWalka;
var Xzm,Yzm:byte;
begin
xzm:=mapa.postacie[0].xp;
yzm:=mapa.postacie[0].yp;
if a>xpoz(0) then if (b>ypoz(0)) and (b<ypoz(0)+29) then RuchPostaciFight(0,Kprawo);
if a<xpoz(0) then if (b>ypoz(0)) and (b<ypoz(0)+29) then RuchPostaciFight(0,Klewo);
if b>ypoz(0) then if (a>xpoz(0)) and (a<xpoz(0)+19) then RuchPostaciFight(0,Kdol);
if b<ypoz(0) then if (a>xpoz(0)) and (a<xpoz(0)+19) then RuchPostaciFight(0,Kgora);
if (a>xpoz(0)) and (a>xpoz(0)+19) then if (b>ypoz(0)) and (b>ypoz(0)+29) then RuchPostaciFight(0,KprawoDol);
if (a<xpoz(0)) and (a<xpoz(0)+19) then if (b>ypoz(0)) and (b>ypoz(0)+29) then RuchPostaciFight(0,KLewoDol);
if (a>xpoz(0)) and (a>xpoz(0)+19) then if (b<ypoz(0)) and (b<ypoz(0)+29) then RuchPostaciFight(0,Kprawogora);
if (a<xpoz(0)) and (a<xpoz(0)+19) then if (b<ypoz(0)) and (b<ypoz(0)+29) then RuchPostaciFight(0,KlewoGora);
daneherosa;
end;

{=================================================}
{= WYSWIETLANIE ILOSCI OBRAZEN NAD GLOWA POSTACI =}
{=================================================}
Procedure WyswietlObrazenia(wart,nrp:byte);
var g,h:byte;
begin
if (15+((mapa.postacie[nrp].xp-mx)*20)>11) and (15+((mapa.postacie[nrp].xp-mx*20))<410) and
   (20+((mapa.postacie[nrp].yp-my)*30)-1>11) and (20+((mapa.postacie[nrp].yp-my)*30)-1<400) then
   begin
kol(czarny);
h:=1;
g:=1;
centre(22+((mapa.postacie[nrp].xp-mx)*20)-1,25+((mapa.postacie[nrp].yp-my)*30)-1,zamien(wart));
centre(22+((mapa.postacie[nrp].xp-mx)*20),25+((mapa.postacie[nrp].yp-my)*30)-1,zamien(wart));
centre(22+((mapa.postacie[nrp].xp-mx)*20)+1,25+((mapa.postacie[nrp].yp-my)*30)-1,zamien(wart));

centre(22+((mapa.postacie[nrp].xp-mx)*20)-1,25+((mapa.postacie[nrp].yp-my)*30),zamien(wart));
centre(22+((mapa.postacie[nrp].xp-mx)*20)+1,25+((mapa.postacie[nrp].yp-my)*30),zamien(wart));

centre(22+((mapa.postacie[nrp].xp-mx)*20)-1,25+((mapa.postacie[nrp].yp-my)*30)+1,zamien(wart));
centre(22+((mapa.postacie[nrp].xp-mx)*20),25+((mapa.postacie[nrp].yp-my)*30)+1,zamien(wart));
centre(22+((mapa.postacie[nrp].xp-mx)*20)+1,25+((mapa.postacie[nrp].yp-my)*30)+1,zamien(wart));
kol(czerwony);
centre(22+((mapa.postacie[nrp].xp-mx)*20),25+((mapa.postacie[nrp].yp-my)*30),zamien(wart));
    delay(1000);
    wymarz(nrp);
    umiescpostac(nrp);
   end;

end;

{=====================================}
{=      TRAFIENIE PODCZAS WALKI      =}
{=====================================}
Procedure Trafiony(pat,pob:byte);
var obrazenia:integer;
    silaudezenia:integer;
    imies:string;
begin
if (mapa.postacie[pat].bron>0) and (idscript(mapa.postacie[pat].bron)<>'')
                      and ((idtyp(mapa.postacie[pat].bron)=bron) or (idtyp(mapa.postacie[pat].bron)=bronb)) then
                                                    begin
                                                     Crit:=pat;
                                                     HitCrit:=pob;
                                                     RunItemScript(idscript(mapa.postacie[pat].bron),2);
                                                    end;
if mapa.postacie[pat].bron=0 then silaudezenia:=random(4+round((mapa.postacie[pat].cechy[sila]*1.5)/2))

     else silaudezenia:=random(iddam(mapa.postacie[pat].bron));

{pisztekst(silaudezenia*10,10,zamien(silaudezenia));
delay(1000);             }
obrazenia:=silaudezenia-round(((mapa.postacie[pob].cechy[wytrzymalosc]*1.1)*0.5)+idres(mapa.postacie[pob].zbroja));
if obrazenia<0 then obrazenia:=0;
wyswietlobrazenia(obrazenia,pob);
if pob=0 then imies:='Twoja postac' else imies:=mapa.postacie[pob].imie;
if obrazenia=0 then dopisz('* '+imies+' obrywa lecz nie odnosi obrazen.');
if obrazenia>=mapa.postacie[pob].hp then
                                      begin
                                       dopisz('* '+imies+' traci '+zamien(obrazenia)+' PW i ginie.');
                                       mapa.postacie[pob].status:=martwy;
                                       mapa.postacie[pob].hp:=mapa.postacie[pob].hp-obrazenia;
                                       crit:=pob;
                                       Killer:=pat;
{                                       kol(czarny);
                                       pisztekst(10,40,mapa.postacie[pob].skrypt);
                                       delay(3000);}
                                       runcritterscript(mapa.postacie[pob].skrypt,4);
                                       showmap;
                                      end;
if (obrazenia>0) and (obrazenia<mapa.postacie[pob].hp) then
                     begin
                      dec(mapa.postacie[pob].hp,obrazenia);
                      dopisz('* '+imies+' traci '+zamien(obrazenia)+' PW.');
                     end;
end;
{=====================================}
{=               PUDLO!              =}
{=====================================}
Procedure Nietrafiony(pat:byte);
begin
if pat=0 then dopisz('* Twoja postac nie trafia.')
  else dopisz('* '+mapa.postacie[pat].imie+' nie trafia.');
end;
{=====================================}
{= SPRAWDZENIE CZY ATAK JEST MOZLIWY =}
{=====================================}
Function MozliwyAtak(posat,posob:byte):boolean;
begin
mozliwyatak:=false;
if (idtyp(mapa.postacie[posat].bron)=bron) or (idtyp(mapa.postacie[posat].bron)=bronb) then
 if liniastrzalu(posat,posob) then
    begin
     if (odleglosc(posat,posob)<=idrange(mapa.postacie[posat].bron)) then mozliwyatak:=true
        else if posat=0 then dopisz('* Cel poza zasiegiem.');
    end
    else if posat=0 then dopisz('* Linia strzalu zablokowana.');
if mapa.postacie[posat].bron=0 then
                               begin
                                if odleglosc(posat,posob)<2 then mozliwyatak:=true
                                    else if posat=0 then dopisz('* Cel poza zasiegiem.');
                               end;
end;
{======================================}
{=       ZAATAKOWANIE POSTACI         =}
{======================================}
Procedure Atakuj(PosAtak,PosObron:byte);
var obrazenia:integer;
    modyf:integer;
begin
if mozliwyatak(posatak,posobron) then
      begin
       ukryjmysz;
       if posatak=0 then if mapa.postacie[posobron].nastawienie<>wrog then if mapa.postacie[posobron].skrypt<>'' then
                                                                        begin
                                                                          crit:=posobron;
                                                                          RunCritterScript(mapa.postacie[posobron].skrypt,3);
                                                                        end else mapa.postacie[posobron].nastawienie:=wrog;
       if mapa.postacie[posatak].bron>0 then dec(mapa.postacie[posatak].ap,idapc(mapa.postacie[posatak].bron))
               else dec(mapa.postacie[posatak].ap,3);
       if posatak=0 then daneherosa;
       wymarz(posatak);
       if mapa.postacie[posatak].xp>=mapa.postacie[posobron].xp then
             RysOdpAtak(11+((mapa.postacie[posatak].xp-mx)*20),11+((mapa.postacie[posatak].yp-my)*30),
                  posatak,Klewo) else RysOdpAtak(11+((mapa.postacie[posatak].xp-mx)*20),11+((mapa.postacie[posatak].yp-my)*30),
                  posatak,Kprawo);
             delay(500);
       modyf:=random(100)-mapa.postacie[posatak].cechy[szczescie];
       if modyf<SzansaTrafienia(posatak,posobron,mapa.postacie[posatak].bron)
                   then Trafiony(posatak,posobron) else Nietrafiony(posatak);

       wymarz(posatak);
       Umiescpostac(posatak);
       if mapa.postacie[posatak].bron<>0 then if idtyp(mapa.postacie[posatak].bron)=bron then
                         begin
                          mapa.postacie[posatak].bronspec:=mapa.postacie[posatak].bronspec-idfire(mapa.postacie[posatak].bron);
                          if mapa.postacie[posatak].bronspec<0 then mapa.postacie[posatak].bronspec:=0;
                         end;
       pokazmysz;
      end;
end;

{======================================}
{=  SPRAWDZENIE CZY MOZNA ZAATAKOWAC  =}
{======================================}
Function SprawdzAtak(pat:byte):boolean;
begin
{POSTAC JEST UZBROJONA}
sprawdzatak:=false;
if mapa.postacie[pat].bron<>0 then if (idtyp(mapa.postacie[pat].bron)=bron) or (idtyp(mapa.postacie[pat].bron)=bronb) then
                 begin
                  if mapa.postacie[pat].ap>=idapc(mapa.postacie[pat].bron) then
                    begin
                     if idtyp(mapa.postacie[pat].bron)=bron then if mapa.postacie[pat].bronspec>0 then sprawdzatak:=true
                                                      else if pat=0 then dopisz('* Nie masz amunicji!')
                                                      else
                                   dopisz('* '+mapa.postacie[pat].imie+' nie ma amunicji.');
                     if idtyp(mapa.postacie[pat].bron)=bronb then sprawdzatak:=true;
                    end
                                  else if pat=0 then dopisz('* Potrzebujesz wiecej punktow akcji.');
                 end;

if mapa.postacie[pat].bron=0 then if mapa.postacie[pat].ap>=3 then sprawdzatak:=true
                                  else if pat=0 then dopisz('* Potrzebujesz wiecej punktow akcji.');
end;
{============================================}
{=  WCISNIECIE KTOREGOS Z PRZYCISKOW WALKI  =}
{============================================}
procedure WcisnijPWalki(a1,b1,a2,b2:integer);
begin
przycisk(a1,b1,a2,b2,2,3,'');
delay(50);
przycisk(a1,b1,a2,b2,3,3,'');
end;

{=======================================}
{= SPRAWDZANIE CZY SA JESZCZE WROGOWIE =}
{=======================================}
Function SprawdzWrogow:boolean;
var i:byte;
begin
sprawdzwrogow:=true;
for i:=1 to 20 do if (mapa.postacie[i].nastawienie=wrog) and (mapa.postacie[i].status=normalny) then sprawdzwrogow:=false;
end;

{=================================}
{=  PROCEDURA ZAKONCZENIA WALKI  =}
{=================================}
Procedure KoniecWalki;
begin
if sprawdzwrogow then
      begin
       EndFightAnim;
       mapa.postacie[0].ap:=mapa.postacie[0].maxap+addap;
       TrybGry:=trybnormalny;
       DaneHerosa;
      end
      else
      begin
       dopisz('* Nie mozna zakonczyc walki jesli w poblizu znajduja sie wrogie istoty!');
       wyswietlkonsole;
      end;
end;

{=============================}
{=    LEWY PRZYCISK WALKI    =}
{=============================}
Procedure LewyPrzyciskWalki;
var pzx,pzy:byte;
begin
repeat
pozycjamyszy(a,b,c);
until c=0;
if czywcisnieto(1) then
                     begin
                      Polecenie:=Koniec;
                      WcisnijPrzycisk(1);
                     end;
if (a>470) and (a<590) and (b>320) and (b<335) then
                                               begin
                                                WcisnijPwalki(470,320,590,335);
                                                inc(nrw);
                                                mapa.postacie[0].ap:=mapa.postacie[0].maxap+addap;
                                                daneherosa;
                                               end;
if (a>470) and (a<590) and (b>340) and (b<355) then
                                               begin
                                                WcisnijPwalki(470,340,590,355);
                                                KoniecWalki;
                                                daneherosa;
                                               end;
if (a>470) and (a<590) and (b>360) and (b<375) then if mapa.postacie[0].ap>=2 then
                                                        begin
                                                         WcisnijPwalki(470,360,590,375);
                                                         if not ZaladujBron(0) then
                                                                                  begin
                                                                                   dopisz('* Brak zapasowej amunicji!');
                                                                                   wyswietlkonsole;
                                                                                  end
                                                                                  else
                                                                                  begin
                                                                                   dec(mapa.postacie[0].ap,2);
                                                                                   daneherosa;
                                                                                  end;
                                                        end
                                                        else dopisz('* Potrzebujesz wiecejpunktow akcji.');
if czywcisnieto(4) then
                     begin
                      dopisz('* Nie mozna korzystac z dzinnika podczas walki!');
                      wyswietlkonsole;
                     end;
if czywcisnieto(2) then obslugacharakterystyki;
if czywcisnieto(3) then if mapa.postacie[0].ap<4 then
                                                   begin
                                                    dopisz('* Potrzebujesz wiecej punktow akcji.');
                                                    wyswietlkonsole;
                                                   end
                                                   else
                                                   begin
                                                    wcisnijprzycisk(3);
                                                    dec(mapa.postacie[0].ap,4);
                                                    DaneHerosa;
                                                    Obslugaekwipunku;
                                                   end;
if (a>10) and (a<410) and (b>10) and (b<400) and (mapa.va[pozycjax,pozycjay]<>postac) then
                                               if mapa.postacie[0].ap>0 then
                                                begin
                                                 MoveWalka;
                                                 if mapa.postacie[0].ap=0 then
                                                                          begin
                                                                           inc(nrw);
                                                                           mapa.postacie[0].ap:=mapa.postacie[0].maxap;
                                                                          end;
                                                 daneherosA;
                                                end
                                                else
                                                begin
                                                 dopisz('* Potrzebujesz wiecej punktow akcji.');
                                                 wyswietlkonsole;
                                                end;

if (a>11) and (b>11) and (a<410) and (b<400) and (mapa.va[pozycjax,pozycjay]=postac) then
                   begin
                    pzx:=pozycjax;
                    pzy:=pozycjay;
                    If (mapa.va[PzX,PzY]=postac) and ((pzx<>mapa.postacie[0].xp) or (pzy<>mapa.postacie[0].yp)) then
                      if SprawdzAtak(0) then if mapa.postacie[znajdznumer(pzx,pzy)].status=normalny then
                                atakuj(0,znajdznumer(pzx,pzy));
                    wyswietlkonsole;
                    if mapa.postacie[0].ap=0 then inc(nrw);
                    daneherosa;
                   end;

end;

{===========================================}
{= WYSWIETLANIE WARTOSCI NAD GLOWA POSTACI =}
{===========================================}
Procedure WyswietlWartosc(wart,nrp:byte);
var g,h:byte;
begin
kol(czarny);
h:=1;
g:=1;
pisztekst(15+((mapa.postacie[nrp].xp-mx)*20)-1,20+((mapa.postacie[nrp].yp-my)*30)-1,zamien(wart));
pisztekst(15+((mapa.postacie[nrp].xp-mx)*20),20+((mapa.postacie[nrp].yp-my)*30)-1,zamien(wart));
pisztekst(15+((mapa.postacie[nrp].xp-mx)*20)+1,20+((mapa.postacie[nrp].yp-my)*30)-1,zamien(wart));

pisztekst(15+((mapa.postacie[nrp].xp-mx)*20)-1,20+((mapa.postacie[nrp].yp-my)*30),zamien(wart));
pisztekst(15+((mapa.postacie[nrp].xp-mx)*20)+1,20+((mapa.postacie[nrp].yp-my)*30),zamien(wart));

pisztekst(15+((mapa.postacie[nrp].xp-mx)*20)-1,20+((mapa.postacie[nrp].yp-my)*30)+1,zamien(wart));
pisztekst(15+((mapa.postacie[nrp].xp-mx)*20),20+((mapa.postacie[nrp].yp-my)*30)+1,zamien(wart));
pisztekst(15+((mapa.postacie[nrp].xp-mx)*20)+1,20+((mapa.postacie[nrp].yp-my)*30)+1,zamien(wart));
kol(bialy);
pisztekst(15+((mapa.postacie[nrp].xp-mx)*20),20+((mapa.postacie[nrp].yp-my)*30),zamien(wart));

end;

{==============================================}
{= WYSWIETLANIE SZANS POWODZENIA ATAKU GRACZA =}
{==============================================}
Procedure WyswietlSzanse(pomz1:byte);
begin
if idtyp(mapa.postacie[0].bron)=0 then if odleglosc(0,pomz1)>1 then dopisz('* Cel poza zasiegiem.')
                                 else
                                   begin
                                    ukryjmysz;
                                    WyswietlWartosc(szansatrafienia(0,pomz1,mapa.postacie[0].bron),pomz1);
                                   dopisz('* '+zamien(szansatrafienia(0,pomz1,mapa.postacie[0].bron))+'% szans na trafienie.');
                                    wyswietlkonsole;
                                    repeat
                                    pozycjamyszy(a,b,c);
                                    until c=2;
                                    repeat
                                    pozycjamyszy(a,b,c);
                                    until c=0;
                                    Wymarz(pomz1);
                                    umiescpostac(pomz1);
                                    pokazmysz;
                                   end;
if (idtyp(mapa.postacie[0].bron)=bron) or (idtyp(mapa.postacie[0].bron)=bronb) then
                 if odleglosc(0,pomz1)>idrange(mapa.postacie[0].bron) then
                                              dopisz('* Cel poza zasiegiem.')
                                              else
                                   begin
                                    ukryjmysz;
                                    WyswietlWartosc(szansatrafienia(0,pomz1,mapa.postacie[0].bron),pomz1);
                                   dopisz('* '+zamien(szansatrafienia(0,pomz1,mapa.postacie[0].bron))+'% szans na trafienie.');
                                    wyswietlkonsole;
                                    repeat
                                    pozycjamyszy(a,b,c);
                                    until c=2;
                                    repeat
                                    pozycjamyszy(a,b,c);
                                    until c=0;
                                    Wymarz(pomz1);
                                    umiescpostac(pomz1);
                                    pokazmysz;
                                   end;
end;

{=============================}
{=   PRAWY PRZYCISK WALKI    =}
{=============================}
Procedure PrawyPrzyciskWalki;
var pzx,pzy:byte;
begin
repeat
pozycjamyszy(a,b,c);
until c=0;
if (a>mappozx) and (b>mappozy) and (a<470) and (b<410) then
                   begin
                    {KLIKNICIE NA POSTA PODCZAS WALKI}
                    pzx:=pozycjax;
                    pzy:=pozycjay;
                    If mapa.va[PzX,PzY]=postac then if mapa.postacie[znajdznumer(pzx,pzy)].status=normalny then
                                WyswietlSzanse(znajdznumer(pzx,pzy));
                    WyswietlKonsole;
                   end;
end;

{================================================}
{= GLOWNA PROCEDURA OBSLUGI PODCZAS TRYBU WALKI =}
{================================================}
procedure ObslugaWalki;
begin
pozycjamyszy(a,b,c);
if c=0 then Klawiatura;
if c<>0 then
          begin
           if c=1 then LewyPrzyciskWalki;
           if c=2 then PrawyPrzyciskWalki;
          end;
end;

{                                                        }
{                                                        }
{                         AI                             }
{                                                        }
{                                                        }

{=====================================================}
{= ROZKAZ AI ,,RUSZAJ W KIERUNKU WSKAZANEJ POSTACI'' =}
{=====================================================}
Procedure RuchDoPostaci(nrc,nrd:byte);
{NRC TO POSTAC ATAKUJACA A NRD TO ATAKOWANA}
begin
if (mapa.postacie[nrc].xp>mapa.postacie[nrd].xp) and (mapa.postacie[nrc].yp=mapa.postacie[nrd].yp) then
         RuchPostaciFight(nrc,Klewo);
if (mapa.postacie[nrc].xp<mapa.postacie[nrd].xp) and (mapa.postacie[nrc].yp=mapa.postacie[nrd].yp) then
         RuchPostaciFight(nrc,Kprawo);
if (mapa.postacie[nrc].yp>mapa.postacie[nrd].yp) and (mapa.postacie[nrc].xp=mapa.postacie[nrd].xp) then
         RuchPostaciFight(nrc,Kgora);
if (mapa.postacie[nrc].yp<mapa.postacie[nrd].yp) and (mapa.postacie[nrc].xp=mapa.postacie[nrd].xp) then
         RuchPostaciFight(nrc,Kdol);
if (mapa.postacie[nrc].xp>mapa.postacie[nrd].xp) and (mapa.postacie[nrc].yp>mapa.postacie[nrd].yp) then
         RuchPostaciFight(nrc,Klewogora);
if (mapa.postacie[nrc].xp<mapa.postacie[nrd].xp) and (mapa.postacie[nrc].yp>mapa.postacie[nrd].yp) then
         RuchPostaciFight(nrc,Kprawogora);
if (mapa.postacie[nrc].xp>mapa.postacie[nrd].xp) and (mapa.postacie[nrc].yp<mapa.postacie[nrd].yp) then
         RuchPostaciFight(nrc,Klewodol);
if (mapa.postacie[nrc].xp<mapa.postacie[nrd].xp) and (mapa.postacie[nrc].yp<mapa.postacie[nrd].yp) then
         RuchPostaciFight(nrc,Kprawodol);


end;
{==========================================================}
{=  WPRAWDZANIE CZY MOZLIWY JEST RUCH W KIEURNKU POSTACI  =}
{==========================================================}
Function RuchDmozliwy(nrc,nrd:byte):boolean;
{NRC TO POSTAC ATAKUJACA A NRD TO ATAKOWANA}
begin
ruchdmozliwy:=false;
if (mapa.postacie[nrc].xp>mapa.postacie[nrd].xp) and (mapa.postacie[nrc].yp=mapa.postacie[nrd].yp) then
        if mapa.va[mapa.postacie[nrc].xp-1,mapa.postacie[nrc].yp]=wolne then ruchdmozliwy:=true;
if (mapa.postacie[nrc].xp<mapa.postacie[nrd].xp) and (mapa.postacie[nrc].yp=mapa.postacie[nrd].yp) then
        if mapa.va[mapa.postacie[nrc].xp+1,mapa.postacie[nrc].yp]=wolne then ruchdmozliwy:=true;
if (mapa.postacie[nrc].xp=mapa.postacie[nrd].xp) and (mapa.postacie[nrc].yp>mapa.postacie[nrd].yp) then
        if mapa.va[mapa.postacie[nrc].xp,mapa.postacie[nrc].yp-1]=wolne then ruchdmozliwy:=true;
if (mapa.postacie[nrc].xp=mapa.postacie[nrd].xp) and (mapa.postacie[nrc].yp<mapa.postacie[nrd].yp) then
        if mapa.va[mapa.postacie[nrc].xp,mapa.postacie[nrc].yp+1]=wolne then ruchdmozliwy:=true;
if (mapa.postacie[nrc].xp>mapa.postacie[nrd].xp) and (mapa.postacie[nrc].yp>mapa.postacie[nrd].yp) then
        if mapa.va[mapa.postacie[nrc].xp-1,mapa.postacie[nrc].yp-1]=wolne then ruchdmozliwy:=true;
if (mapa.postacie[nrc].xp<mapa.postacie[nrd].xp) and (mapa.postacie[nrc].yp>mapa.postacie[nrd].yp) then
        if mapa.va[mapa.postacie[nrc].xp+1,mapa.postacie[nrc].yp-1]=wolne then ruchdmozliwy:=true;
if (mapa.postacie[nrc].xp>mapa.postacie[nrd].xp) and (mapa.postacie[nrc].yp<mapa.postacie[nrd].yp) then
        if mapa.va[mapa.postacie[nrc].xp-1,mapa.postacie[nrc].yp+1]=wolne then ruchdmozliwy:=true;
if (mapa.postacie[nrc].xp<mapa.postacie[nrd].xp) and (mapa.postacie[nrc].yp<mapa.postacie[nrd].yp) then
        if mapa.va[mapa.postacie[nrc].xp+1,mapa.postacie[nrc].yp+1]=wolne then ruchdmozliwy:=true;
end;

{======================}
{= ROZKAZ ,,CZEKAJ''  =}
{======================}
Procedure Czekaj(nrpc:byte);
begin
mapa.postacie[nrpc].ap:=mapa.postacie[nrpc].maxap;
inc(nrw);
end;

{                                                       }
{                                                       }
{                      ATAK BEZ BRONI                   }
{                                                       }
{                                                       }
Procedure PAtakujacaBezBroni(Patakujaca,Patakowana:byte);
begin
if mapa.postacie[patakujaca].ap>=3 then
        {postac ma wystarczajaca duzo punktow akcji by przeprowadzic atak}
        begin
         if odleglosc(patakujaca,patakowana)=1 then
         {postac jest wystarczajaco blisko by atakowac}
              begin
               atakuj(patakujaca,patakowana);
               if mapa.postacie[patakujaca].ap=0 then czekaj(patakujaca);
               wyswietlkonsole;
               if patakowana=0 then daneherosa;
               delay(300);
              end
         {postac jest za daleko by atakowac}
              else
              begin
               if ruchdmozliwy(patakujaca,patakowana) then RuchDoPostaci(patakujaca,patakowana)
                                                      else czekaj(patakujaca);
               delay(300);
               if mapa.postacie[patakujaca].ap=0 then czekaj(patakujaca);
              end;
        end
        {postac nie ma mniej niz 3 punkty akcji}
        else if odleglosc(patakujaca,patakowana)<3 then
        {Postac jest wystarczajaco blisko by moc atakowac w nastepnej kolejce}
              czekaj(patakujaca)
              else if mapa.postacie[patakujaca].ap>0 then
       {postac ma jeszcze jeden punkt ruchu ktory moze wykorzystac na zblizenie}
                 begin
                  if ruchdmozliwy(patakujaca,patakowana) then RuchDoPostaci(patakujaca,patakowana)
                                     else czekaj(patakujaca);
                  delay(300);
                  if mapa.postacie[patakujaca].ap=0 then czekaj(patakujaca);
                 end
                 {postac nie ma juz punktow akcji}
                 else czekaj(patakujaca);

end;

{==================================================}
{=   SPRAWDZANIE CZY POSTAC MA AMUNICJE W BRONI   =}
{==================================================}
Function CheckAmmo(nrp:byte):boolean;
begin
checkammo:=false;
if idtyp(mapa.postacie[nrp].bron)=bron then
              begin
               if mapa.postacie[nrp].bronspec>0 then CheckAmmo:=true;
              end;
end;


{===================================================}
{=  PROBA ATAKU PODEJMOWANA PRZEZ POSTA UZBROJON =}
{===================================================}
Procedure ProbaAtakuBronia(Chatak,ChObr:byte);
var RAmmo:integer;
begin
Rammo:=idammo(mapa.postacie[chatak].bron);
if liniastrzalu(chatak,chobr) then
           begin {Jesli linia strzalu nie jest zablokowana}
            if idtyp(mapa.postacie[chatak].bron)=bron then
               begin
                if checkammo(chatak) then
                 begin
                  {Jesli postac ma amunicje w broni}
                  Atakuj(chatak,chobr);
                  if mapa.postacie[chatak].ap=0 then czekaj(chatak);
                  wyswietlkonsole;
                  if chobr=0 then daneherosa;
                  delay(300);
                 end
                 else
                 begin
                  {Jesli postac nie ma amunicji}
                  if zaladujbron(chatak) then
                          begin
                           {Jesli postac ma amunicje do zaladowania}
                           dopisz('* '+mapa.postacie[chatak].imie+' przeladowuje bron.');
                           wyswietlkonsole;
                           dec(mapa.postacie[chatak].ap,2);
                          end
                          else
                          begin
                           {jesli postac nie ma amunicji do zaladowania}
                           dopisz('* '+mapa.postacie[chatak].imie+' nie ma juz amunicji.');
                           wyswietlkonsole;
                           kopiujdo(25,itemsearch(chatak,0),chatak);
                           wymarz(chatak);
                           umiescpostac(chatak);
                          end;
                 end;
               end
               else if idtyp(mapa.postacie[chatak].bron)=bronb then
                 begin
                  Atakuj(chatak,chobr);
                  if mapa.postacie[chatak].ap=0 then czekaj(chatak);
                  wyswietlkonsole;
                  daneherosa;
                 end;
           end
           else
           begin {A jesli linia strzalu jest zablokowana to czekaj}
            czekaj(chatak);
           end;
delay(300);
end;

{                                                       }
{                                                       }
{              POSTAC ATAKUJCA BRONI                  }
{                                                       }
{                                                       }
Procedure PAtakujacaBronia(Patakujaca,Patakowana:byte);
var PAk,needpak:byte;
begin
pak:=mapa.postacie[patakujaca].ap;
needpak:=idapc(mapa.postacie[patakujaca].bron);
if odleglosc(patakujaca,patakowana)<idrange(mapa.postacie[patakujaca].bron) then
            begin {Jesli postac znajduje sie dostatecznie blisko by atakowac}
         if mapa.postacie[patakujaca].ap>=idapc(mapa.postacie[patakujaca].bron) then
              ProbaAtakuBronia(patakujaca,patakowana){jesli postac ma odp.ilosc punktow akcji by atakowac}
                     else Czekaj(patakujaca);
            end
            else
                 begin{Jesli postac nie znajduje sie dostatecznie blisko by atakowac}
                   if ruchdmozliwy(patakujaca,patakowana) then RuchDoPostaci(patakujaca,patakowana)
                                      else czekaj(patakujaca);
                   delay(300);
                   if mapa.postacie[patakujaca].ap=0 then czekaj(patakujaca);
                  end;
end;

{======================================}
{= WYBIERANIE POSTACI DO ZAATAKOWANIA =}
{======================================}
Function WybierzCel(nrps:byte):byte;
var cele:array[1..20] of byte;
    odle:array[1..20] of byte;
    i:byte;
    Lic:byte;
    WPamieci:byte;

begin
for i:=1 to 20 do
                begin
                 Cele[i]:=0;
                 Odle[i]:=0;
                end;
cele[1]:=0;
odle[1]:=odleglosc(nrps,0);
lic:=1;
for i:=0 to 20 do if (mapa.postacie[i].status=normalny) and (mapa.postacie[i].nastawienie=przyjaciel) then
                     begin
                      inc(lic);
                      cele[lic]:=i;
                      odle[lic]:=odleglosc(nrps,i);
                     end;
i:=0;
wpamieci:=1;
if lic>2 then
           begin
            for i:=1 to lic do if odle[i]<odle[wpamieci] then if liniastrzalu(nrps,cele[i]) then wpamieci:=i;
            wybierzcel:=cele[wpamieci];
           end
           else if lic=1 then wybierzcel:=0 else
               begin
                if odleglosc(cele[1],nrps)<=odleglosc(cele[2],nrps) then Wybierzcel:=cele[2]
                                                   else wybierzcel:=cele[1];
               end;


end;
{===================================================}
{=  AI POSTACI ATAKUJCEJ GRACZA I JEGO PRZYJACIOL =}
{===================================================}
Procedure PostacAtakujacaGracza(Nrpa:byte);
var cel:byte;
begin
cel:=wybierzcel(nrpa);

if mapa.postacie[nrpa].bron=0 then
                                begin
                                 if weaponsearch(nrpa) then
                                   begin
                                    if mapa.postacie[nrpa].ap>=4 then UzbrojPostac(nrpa)
                                             else PAtakujacaBezBroni(nrpa,cel);
                                   end
                                   else PAtakujacaBezBroni(nrpa,cel);
                                end

  else if (idtyp(mapa.postacie[nrpa].bron)=bron) or (idtyp(mapa.postacie[nrpa].bron)=bronb) then
                                        PAtakujacaBronia(nrpa,cel);


end;
{========================================}
{= WYBIERANIE POSTACI DO ZAATAKOWANIA 2 =}
{========================================}
Function WybierzCel2(nrps:byte):byte;
var Cele:array[1..20] of byte;
    odle:array[1..20] of byte;
    i:byte;
    Lic:byte;
    Wpamieci:byte;
begin
for i:=1 to 20 do
                begin
                 Cele[i]:=0;
                 Odle[i]:=0;
                end;
lic:=0;
for i:=1 to 20 do if (mapa.postacie[i].nastawienie=wrog) and (mapa.postacie[i].status=normalny) and (i<>nrps) then
                     begin
                      inc(lic);
                      cele[lic]:=i;
                      odle[lic]:=odleglosc(nrps,i);
                     end;
if lic>1 then
           begin
            wpamieci:=1;
            for i:=1 to lic do if (liniastrzalu(cele[i],nrps)) and (odle[i]<odle[wpamieci]) then wpamieci:=i;
            wybierzcel2:=cele[wpamieci];
           end
           else if lic=0 then wybierzcel2:=0 else wybierzcel2:=cele[1];
end;

{===================================================}
{=      AI POSTACI WALCZCEJ PO STRONIE GRACZA     =}
{===================================================}
Procedure PostacBroniacaGracza(Nrpa:byte);
var cel:byte;
begin
cel:=wybierzcel2(nrpa);
if cel<>0 then
  begin
   if mapa.postacie[nrpa].bron=0 then
                                begin
                                 if weaponsearch(nrpa) then
                                   begin
                                    if mapa.postacie[nrpa].ap>=4 then UzbrojPostac(nrpa)
                                             else PAtakujacaBezBroni(nrpa,cel);
                                   end
                                   else PAtakujacaBezBroni(nrpa,cel);
                                end

  else if (idtyp(mapa.postacie[nrpa].bron)=bron) or (idtyp(mapa.postacie[nrpa].bron)=bronb) then
                                        PAtakujacaBronia(nrpa,cel);

  end else czekaj(nrpa);
end;

{                                                       }
{                                                       }
{                   PROCEDURY KOLEJKI                   }
{                                                       }
{                                                       }

{================================}
{=   STEROWANIE PODCZAS WALKI   =}
{================================}
Procedure RuchWalki(nrp:byte);
begin
if nrp=0 then
           begin
            if mapa.postacie[0].ap=0 then
                                      begin
                                       mapa.postacie[0].ap:=mapa.postacie[0].maxap+addap;
                                       daneherosa;
                                      end;
            Obslugawalki
           end
           else if mapa.postacie[nrp].ai<>Wiezyczka then
                               begin
                                {ZWYCZAJNIE WALCZACA POSTAC}
                                if mapa.postacie[nrp].status=normalny then
                                  begin
                                   If mapa.postacie[nrp].nastawienie=wrog then PostacAtakujacaGracza(nrp);
                                   if mapa.postacie[nrp].nastawienie=neutralny then inc(nrw);
                                   if mapa.postacie[nrp].nastawienie=przyjaciel then PostacBroniacaGracza(nrp);
                                  end
                                  else inc(nrw);
                               end
                               else
                               begin
                                inc(nrw);
                                mapa.postacie[nrp].ap:=mapa.postacie[nrp].maxap;
                               end;

end;
{=================}
{= UPLYW SEKUNDY =}
{=================}
Procedure UplywSekundy;
begin
ss:=ss+1;
if ss=60 then
          begin
           ss:=0;
           dodajminute;
          end;
end;
{=================================}
{= SPRAWDZANIE ELEMENTOW KOLEJKI =}
{=================================}
Procedure SprawdzNastawienie;
var i:byte;
begin
if trybgry=trybnormalny then for i:=1 to 20 do if (mapa.postacie[i].nastawienie=wrog)
                   and (mapa.postacie[i].status=normalny) then
             begin
              TrybGry:=TrybWalki;
              Fightanim;
              nrw:=i;
              i:=20;
             end;
end;
Procedure SprawdzAI;
var i:byte;
    Los:byte;
begin
for i:=1 to 20 do if (mapa.postacie[i].ai=chaotycznyruch) and (mapa.postacie[i].status=normalny) then
                   begin
                    los:=random(20);
                    if los<=2 then RuchPostaci(i,Klewo);
                    if (los>2) and (los<=3) then RuchPostaci(i,Kprawo);
                    if (los>3) and (los<=4) then RuchPostaci(i,Kgora);
                    if (los>4) and (los<=5) then ruchpostaci(i,Kdol);
                    if (los>5) and (los<=6) then ruchpostaci(i,kprawodol);
                    if (los>6) and (los<=7) then ruchpostaci(i,kprawogora);
                    if (los>7) and (los<=8) then ruchpostaci(i,klewodol);
                    if (los>8) and (los<=9) then ruchpostaci(i,klewogora);
                   end;
end;
Procedure SprawdzTryb;
var zapp:byte;
begin
if trybgry=trybwalki then
                       begin
                        RuchWalki(nrw);
                        if nrw=21 then nrw:=0;
                       end;
if trybgry=trybnormalny then
                      begin
                       timex:=timex+1;
                       if timex=500 then
                                      begin
                                       zapp:=gg;
                                       uplywsekundy;
                                       if (gg=18) and (zapp=17) then showmap;
                                       if (gg=7) and (zapp=6) then showmap;
                                       timex:=0;
                                       inc(licznikai);
                                       if licznikai=100 then
                                                     begin
                                                      delay(1);
                                                      licznikai:=0;
                                                      SprawdzAI;
                                                     end;

                                      end;

                       obslugamain;
                      end;

end;
{=======================================================================}
{=  SPRAWDZANIE CZY POSTAC GRACZA NIE WESZLA W POLE DZIALANIA SPATIALU =}
{=======================================================================}
Procedure SprawdzSpatiale;
var i:byte;
begin
for i:=1 to 10 do if (mapa.postacie[0].xp=mapa.spatiale[i].xs) and (mapa.postacie[0].yp=mapa.spatiale[i].ys) then
    if mapa.spatiale[i].exec=0 then
     begin
      mapa.spatiale[i].exec:=1;
      Spat:=i;
      RunSpecialScript(mapa.spatiale[i].nazwa);
      i:=10;
     end;
end;
{================================}
{=   GLOWNA PROCEDURA KOLEJKI   =}
{================================}
Procedure Kolejka;
begin
nrw:=0;
zablokuj:=false;
repeat
SprawdzNastawienie;
sprawdztryb;
if licznikflood>0 then
                    begin
                     licznikflood:=licznikflood+1;
                     if licznikflood>200000 then
                                             begin
                                              wymarzflood;
                                              licznikflood:=0;
                                             end;
                    end;
if mapa.postacie[0].hp<=0 then
                           begin
                            dopisz('* ZGINALES!!!');
                            wyswietlkonsole;
                            delay(2000);
                            polecenie:=koniec;
                           end;
if exp>=zliczexp then if poziom<99 then
                   begin
                    pomlev:=true;
                    inc(poziom);
                    inc(pnkt,mapa.postacie[0].cechy[inteligencja]*2);
                    daneherosa;
                    dopisz('* Awansujesz na kolejny poziom doswiadczenia.');
                    daneglownegopanelu;
                   end;
SprawdzSpatiale;
until polecenie=koniec;
end;



{==============================================}
{=     ODLEGLOSC POMIEDZY DWOMA POSTACIAMI    =}
{==============================================}
Function Odleglosc(posa,posb:byte):byte;
var odlx,odly:byte;
begin
if mapa.postacie[posa].xp>mapa.postacie[posb].xp then
               odlx:=mapa.postacie[posa].xp-mapa.postacie[posb].xp
               else odlx:=mapa.postacie[posb].xp-mapa.postacie[posa].xp;
if mapa.postacie[posa].yp>mapa.postacie[posb].yp then
               odly:=mapa.postacie[posa].yp-mapa.postacie[posb].yp
               else odly:=mapa.postacie[posb].yp-mapa.postacie[posa].yp;
{kol(czarny);
pisztekst(20,50,zamien(posb));
pisztekst(20,30,zamien(mapa.postacie[posa].xp)+':'+zamien(mapa.postacie[posb].xp)+' Odleglosc X:'+zamien(odlx));
pisztekst(20,40,zamien(odly));}
odleglosc:=round(sqrt((odlx*odlx)+(odly*odly)));
end;
{==========================================================}
{= ODLEGLOSC POMIEDZY POSTACIA GRACZA A OBIEKTEM SCENERII =}
{==========================================================}
Function OdlegloscS(posa:byte):byte;
var odlx,odly:byte;
begin
if mapa.postacie[0].xp>mapa.scenerie[posa].xs then
               odlx:=mapa.postacie[0].xp-mapa.scenerie[posa].xs
               else odlx:=mapa.scenerie[posa].xs-mapa.postacie[0].xp;
if mapa.postacie[0].yp>mapa.scenerie[posa].ys then
               odly:=mapa.postacie[0].yp-mapa.scenerie[posa].ys
               else odly:=mapa.scenerie[posa].ys-mapa.postacie[0].yp;
{kol(czarny);
pisztekst(20,50,zamien(posb));
pisztekst(20,30,zamien(mapa.postacie[posa].xp)+':'+zamien(mapa.postacie[posb].xp)+' Odleglosc X:'+zamien(odlx));
pisztekst(20,40,zamien(odly));}
odlegloscs:=round(sqrt((odlx*odlx)+(odly*odly)));
end;
{===============================================}
{= ODLEGLOSC POMIEDZY POSTACIA GRACZA A SZAFKA =}
{===============================================}
Function OdlegloscSZ(posa:byte):byte;
var odlx,odly:byte;
begin
if mapa.postacie[0].xp>mapa.szafki[posa].xs then
               odlx:=mapa.postacie[0].xp-mapa.szafki[posa].xs
               else odlx:=mapa.szafki[posa].xs-mapa.postacie[0].xp;
if mapa.postacie[0].yp>mapa.szafki[posa].ys then
               odly:=mapa.postacie[0].yp-mapa.szafki[posa].ys
               else odly:=mapa.szafki[posa].ys-mapa.postacie[0].yp;
{kol(czarny);
pisztekst(20,50,zamien(posb));
pisztekst(20,30,zamien(mapa.postacie[posa].xp)+':'+zamien(mapa.postacie[posb].xp)+' Odleglosc X:'+zamien(odlx));
pisztekst(20,40,zamien(odly));}
odlegloscsz:=round(sqrt((odlx*odlx)+(odly*odly)));
end;

{==============================================}
{=        ZLICZANIE SZANSY TRAFIENIA          =}
{==============================================}
Function SzansaTrafienia(pos1,pos2,TypBroni:byte):byte;
var wwww:byte;
begin
wwww:=0;
{kol(czarny);
pisztekst(40,50,zamien(pos2));}
if idtyp(typbroni)=Bron then wwww:=BronReczna;
if idtyp(typbroni)=BronB then wwww:=BronBiala;
if idtyp(typbroni)=0 then wwww:=Nieuzbrojony;
if wwww<>0 then
      begin
       if wwww<>nieuzbrojony then szansaTrafienia:=calkowityskill(pos1,wwww)-(2*odleglosc(pos1,pos2));
       if wwww=nieuzbrojony then szansaTrafienia:=round(calkowityskill(pos1,wwww)*0.9);
      end;
end;


{======================================}
{= FUNKCJA SPRAWDZAJACA LINIE STRZALU =}
{======================================}
Function LiniaStrzalu(Po1,po2:byte):boolean;
var xls1,xls2,yls1,yls2:byte; {skrocone wspolrzedne dwoch postaci}
    Odpx,Odpy:byte;           {odleglosc pomiedzy nimi (w iksach i igrekach)}
    Skok,Poczatek:real;
    temp,i:integer;
    KW:byte;
begin
LiniaStrzalu:=true;
xls1:=mapa.postacie[po1].xp;
yls1:=mapa.postacie[po1].yp;
xls2:=mapa.postacie[po2].xp;
yls2:=mapa.postacie[po2].yp;
{100}
{000}
{002}
if (xls1<xls2) and (yls1<yls2) then
                                     begin
                                      odpx:=xls2-xls1;
                                      odpy:=yls2-yls1;
                                      if odpx>odpy then {Szersza niz dluzsza}
                                         begin
                                          skok:=odpy/odpx;
                                          poczatek:=yls1;
                                          for i:=xls1 to xls2 do
                                               begin
                                                KW:=2;
                               if (mapa.va[i,round(poczatek)]<>postac) and (mapa.va[i,round(poczatek)]<>wolne)
                               and (mapa.va[i,round(poczatek)]<>polwolne) then
                                                        begin
                                                         KW:=0;
                                                         liniastrzalu:=false;
                                                        end;
{                                                mapa.tiles[i,round(poczatek)]:=kw;}
                                                poczatek:=poczatek+skok;
                                               end;
                                         end
                                         else
                                         begin
                                          skok:=odpx/odpy;
                                          poczatek:=xls1;
                                          for i:=yls1 to yls2 do
                                               begin
                                                KW:=2;
                                if (mapa.va[round(poczatek),i]<>postac) and (mapa.va[round(poczatek),i]<>wolne)
                                and (mapa.va[round(poczatek),i]<>polwolne) then
                                                        begin
                                                         KW:=0;
                                                         liniastrzalu:=false;
                                                        end;
{                                                mapa.tiles[i,round(poczatek)]:=kw;}
                                                poczatek:=poczatek+skok;
                                               end;

                                         end;
                                     end;

{200}
{0-0}
{001}
            if (xls1>xls2) and (yls1>yls2) then
                                     begin
                                      odpx:=xls1-xls2;
                                      odpy:=yls1-yls2;
                                      if odpx>odpy then {Szersza niz dluzsza}
                                         begin
                                          skok:=odpy/odpx;
                                          poczatek:=yls2;
                                          for i:=xls2 to xls1 do
                                               begin
                                                Kw:=2;
                                              if (mapa.va[i,round(poczatek)]<>wolne) and (mapa.va[i,round(poczatek)]<>polwolne)
                                                and (mapa.va[i,round(poczatek)]<>postac) then
                                                      begin
                                                       kw:=0;
                                                       liniastrzalu:=false;
                                                      end;
{                                                mapa.tiles[i,round(poczatek)]:=kw;  }
                                                poczatek:=poczatek+skok;
                                               end;
                                         end
                                         else
                                         begin
                                          skok:=odpx/odpy;
                                          poczatek:=xls2;
                                          for i:=yls2 to yls1 do
                                               begin
                                                kw:=2;
                                              if (mapa.va[round(poczatek),i]<>wolne) and (mapa.va[round(poczatek),i]<>polwolne)
                                                and (mapa.va[round(poczatek),i]<>postac) then
                                                    begin
                                                     kw:=0;
                                                     liniastrzalu:=false;
                                                    end;
{                                               mapa.tiles[round(poczatek),i]:=kw;}
                                                poczatek:=poczatek+skok;
                                               end;

                                         end;
                                     end;
{010}
{0-0}
{020}
            if (xls1=xls2) and (yls1<yls2) then
                                     begin
                                      odpx:=0;
                                      odpy:=yls2-yls1;
                                      for i:=yls1 to yls2 do
                                          begin
                                           Kw:=2;
                                           if (mapa.va[xls1,i]<>wolne) and (mapa.va[xls1,i]<>polwolne)
                                           and (mapa.va[xls1,i]<>postac) then
                                                 begin
                                                  kw:=0;
                                                  liniastrzalu:=false;
                                                 end;
{                                           mapa.tiles[xls1,i]:=kw;}
                                          end;
                                     end;
{020}
{0-0}
{010}
            if (xls1=xls2) and (yls1>yls2) then
                                     begin
                                      odpx:=0;
                                      odpy:=yls1-yls2;
                                      for i:=yls2 to yls1 do
                                          begin
                                           KW:=2;
                                           if (mapa.va[xls1,i]<>wolne) and (mapa.va[xls1,i]<>polwolne)
                                           and (mapa.va[xls1,i]<>postac) then
                                                   begin
                                                    kw:=0;
                                                    liniastrzalu:=false;
                                                   end;
{                                           mapa.tiles[xls1,i]:=kw;  }
                                          end;
                                     end;
{001}
{0-0}
{200}
            if (xls1>xls2) and (yls1<yls2) then
                                     begin
                                      odpx:=xls1-xls2;
                                      odpy:=yls2-yls1;
                                      if odpx>odpy then {Szersza niz dluzsza}
                                         begin
                                          skok:=odpy/odpx;
                                          poczatek:=yls2;
                                          for i:=xls2 to xls1 do
                                               begin
                                                Kw:=2;
                                              if (mapa.va[i,round(poczatek)]<>wolne) and (mapa.va[i,round(poczatek)]<>polwolne)
                                                and (mapa.va[i,round(poczatek)]<>postac) then
                                                        begin
                                                         kw:=0;
                                                         liniastrzalu:=false;
                                                        end;
 {                                               mapa.tiles[i,round(poczatek)]:=kw;}
                                                poczatek:=poczatek-skok;
                                               end;
                                         end
                                         else
                                         begin
                                          skok:=odpx/odpy;
                                          poczatek:=xls1;
                                          for i:=yls1 to yls2 do
                                               begin
                                                kw:=2;
                                              if (mapa.va[round(poczatek),i]<>wolne) and (mapa.va[round(poczatek),i]<>polwolne)
                                              and (mapa.va[round(poczatek),i]<>postac) then
                                                      begin
                                                       kw:=0;
                                                       liniastrzalu:=false;
                                                      end;
{                                                mapa.tiles[round(poczatek),i]:=kw;}
                                                poczatek:=poczatek-skok;
                                               end;

                                         end;
                                     end;

{002}
{0-0}
{100}
            if (xls1<xls2) and (yls1>yls2) then
                                     begin
                                      odpx:=xls2-xls1;
                                      odpy:=yls1-yls2;
                                      if odpx>odpy then {Szersza niz dluzsza}
                                         begin
                                          skok:=odpy/odpx;
                                          poczatek:=yls1;
                                          for i:=xls1 to xls2 do
                                               begin
                                                kw:=2;
                                              if (mapa.va[i,round(poczatek)]<>wolne) and (mapa.va[i,round(poczatek)]<>polwolne)
                                                and (mapa.va[i,round(poczatek)]<>postac) then
                                                      begin
                                                       kw:=0;
                                                       liniastrzalu:=false;
                                                      end;
{                                                mapa.tiles[i,round(poczatek)]:=kw;}
                                                poczatek:=poczatek-skok;
                                               end;
                                         end
                                         else
                                         begin
                                          skok:=odpx/odpy;
                                          poczatek:=xls2;
                                          for i:=yls2 to yls1 do
                                               begin
                                                kw:=2;
                                              if (mapa.va[round(poczatek),i]<>wolne) and (mapa.va[round(poczatek),i]<>polwolne)
                                                and (mapa.va[round(poczatek),i]<>postac) then
                                                          begin
                                                           kw:=0;
                                                           liniastrzalu:=false;
                                                          end;
{                                                mapa.tiles[round(poczatek),i]:=kw;}
                                                poczatek:=poczatek-skok;
                                               end;

                                         end;
                                     end;
{000}
{1-2}
{000}
            if (xls1<xls2) and (yls1=yls2) then
                                     begin
                                      odpx:=xls2-xls1;
                                      odpy:=0;
                                      for i:=xls1 to xls2 do
                                          begin
                                           kw:=2;
                                           if (mapa.va[i,yls1]<>wolne) and (mapa.va[i,yls1]<>polwolne)
                                           and (mapa.va[i,yls1]<>postac) then
                                                            begin
                                                             kw:=0;
                                                             liniastrzalu:=false;
                                                            end;
{                                           mapa.tiles[i,yls1]:=kw;}
                                          end;
                                     end;

{000}
{2-1}
{000}
            if (xls1>xls2) and (yls1=yls2) then
                                     begin
                                      odpx:=xls2-xls1;
                                      odpy:=0;
                                      for i:=xls2 to xls1 do
                                          begin
                                           kw:=2;
                                         if (mapa.va[i,yls1]<>postac) and (mapa.va[i,yls1]<>wolne)
                                         and (mapa.va[i,yls1]<>polwolne) then
                                                             begin
                                                              kw:=0;
                                                              liniastrzalu:=false;
                                                             end;
{                                           mapa.tiles[i,yls1]:=kw;  }
                                          end;
                                     end;

end;
{==================================================================}
{= FUNKCJA SPRAWDZAJACA LINIE STRZALU POMIEDZY GRACZEM A SCENERIA =}
{==================================================================}
Function LiniaStrzaluS(Po1,po2:byte):boolean;
var xls1,xls2,yls1,yls2:byte; {skrocone wspolrzedne dwoch postaci}
    Odpx,Odpy:byte;           {odleglosc pomiedzy nimi (w iksach i igrekach)}
    Skok,Poczatek:real;
    temp,i:integer;
    KW:byte;
begin
LiniaStrzaluS:=true;
xls1:=mapa.postacie[po1].xp;
yls1:=mapa.postacie[po1].yp;
xls2:=mapa.scenerie[po2].xs;
yls2:=mapa.scenerie[po2].ys;
{100}
{000}
{002}
if (xls1<xls2) and (yls1<yls2) then
                                     begin
                                      odpx:=xls2-xls1;
                                      odpy:=yls2-yls1;
                                      if odpx>odpy then {Szersza niz dluzsza}
                                         begin
                                          skok:=odpy/odpx;
                                          poczatek:=yls1;
                                          for i:=xls1 to xls2 do
                                               begin
                                                KW:=2;
                               if (mapa.va[i,round(poczatek)]<>vsceneria) and (mapa.va[i,round(poczatek)]<>wolne)
                               and (mapa.va[i,round(poczatek)]<>polwolne) then
                                                        begin
                                                         KW:=0;
                                                         liniastrzaluS:=false;
                                                        end;
{                                                mapa.tiles[i,round(poczatek)]:=kw;}
                                                poczatek:=poczatek+skok;
                                               end;
                                         end
                                         else
                                         begin
                                          skok:=odpx/odpy;
                                          poczatek:=xls1;
                                          for i:=yls1 to yls2 do
                                               begin
                                                KW:=2;
                                if (mapa.va[round(poczatek),i]<>vsceneria) and (mapa.va[round(poczatek),i]<>wolne)
                                and (mapa.va[round(poczatek),i]<>polwolne) then
                                                        begin
                                                         KW:=0;
                                                         liniastrzalus:=false;
                                                        end;
{                                                mapa.tiles[i,round(poczatek)]:=kw;}
                                                poczatek:=poczatek+skok;
                                               end;

                                         end;
                                     end;

{200}
{0-0}
{001}
            if (xls1>xls2) and (yls1>yls2) then
                                     begin
                                      odpx:=xls1-xls2;
                                      odpy:=yls1-yls2;
                                      if odpx>odpy then {Szersza niz dluzsza}
                                         begin
                                          skok:=odpy/odpx;
                                          poczatek:=yls2;
                                          for i:=xls2 to xls1 do
                                               begin
                                                Kw:=2;
                                              if (mapa.va[i,round(poczatek)]<>wolne) and (mapa.va[i,round(poczatek)]<>polwolne)
                                                and (mapa.va[i,round(poczatek)]<>vsceneria) then
                                                      begin
                                                       kw:=0;
                                                       liniastrzalus:=false;
                                                      end;
{                                                mapa.tiles[i,round(poczatek)]:=kw;  }
                                                poczatek:=poczatek+skok;
                                               end;
                                         end
                                         else
                                         begin
                                          skok:=odpx/odpy;
                                          poczatek:=xls2;
                                          for i:=yls2 to yls1 do
                                               begin
                                                kw:=2;
                                              if (mapa.va[round(poczatek),i]<>wolne) and (mapa.va[round(poczatek),i]<>polwolne)
                                                and (mapa.va[round(poczatek),i]<>vsceneria) then
                                                    begin
                                                     kw:=0;
                                                     liniastrzalus:=false;
                                                    end;
{                                               mapa.tiles[round(poczatek),i]:=kw;}
                                                poczatek:=poczatek+skok;
                                               end;

                                         end;
                                     end;
{010}
{0-0}
{020}
            if (xls1=xls2) and (yls1<yls2) then
                                     begin
                                      odpx:=0;
                                      odpy:=yls2-yls1;
                                      for i:=yls1 to yls2 do
                                          begin
                                           Kw:=2;
                                           if (mapa.va[xls1,i]<>wolne) and (mapa.va[xls1,i]<>polwolne)
                                           and (mapa.va[xls1,i]<>vsceneria) then
                                                 begin
                                                  kw:=0;
                                                  liniastrzalus:=false;
                                                 end;
{                                           mapa.tiles[xls1,i]:=kw;}
                                          end;
                                     end;
{020}
{0-0}
{010}
            if (xls1=xls2) and (yls1>yls2) then
                                     begin
                                      odpx:=0;
                                      odpy:=yls1-yls2;
                                      for i:=yls2 to yls1 do
                                          begin
                                           KW:=2;
                                           if (mapa.va[xls1,i]<>wolne) and (mapa.va[xls1,i]<>polwolne)
                                           and (mapa.va[xls1,i]<>vsceneria) then
                                                   begin
                                                    kw:=0;
                                                    liniastrzalus:=false;
                                                   end;
{                                           mapa.tiles[xls1,i]:=kw;  }
                                          end;
                                     end;
{001}
{0-0}
{200}
            if (xls1>xls2) and (yls1<yls2) then
                                     begin
                                      odpx:=xls1-xls2;
                                      odpy:=yls2-yls1;
                                      if odpx>odpy then {Szersza niz dluzsza}
                                         begin
                                          skok:=odpy/odpx;
                                          poczatek:=yls2;
                                          for i:=xls2 to xls1 do
                                               begin
                                                Kw:=2;
                                              if (mapa.va[i,round(poczatek)]<>wolne) and (mapa.va[i,round(poczatek)]<>polwolne)
                                                and (mapa.va[i,round(poczatek)]<>vsceneria) then
                                                        begin
                                                         kw:=0;
                                                         liniastrzalus:=false;
                                                        end;
 {                                               mapa.tiles[i,round(poczatek)]:=kw;}
                                                poczatek:=poczatek-skok;
                                               end;
                                         end
                                         else
                                         begin
                                          skok:=odpx/odpy;
                                          poczatek:=xls1;
                                          for i:=yls1 to yls2 do
                                               begin
                                                kw:=2;
                                              if (mapa.va[round(poczatek),i]<>wolne) and (mapa.va[round(poczatek),i]<>polwolne)
                                              and (mapa.va[round(poczatek),i]<>vsceneria) then
                                                      begin
                                                       kw:=0;
                                                       liniastrzalus:=false;
                                                      end;
{                                                mapa.tiles[round(poczatek),i]:=kw;}
                                                poczatek:=poczatek-skok;
                                               end;

                                         end;
                                     end;

{002}
{0-0}
{100}
            if (xls1<xls2) and (yls1>yls2) then
                                     begin
                                      odpx:=xls2-xls1;
                                      odpy:=yls1-yls2;
                                      if odpx>odpy then {Szersza niz dluzsza}
                                         begin
                                          skok:=odpy/odpx;
                                          poczatek:=yls1;
                                          for i:=xls1 to xls2 do
                                               begin
                                                kw:=2;
                                              if (mapa.va[i,round(poczatek)]<>wolne) and (mapa.va[i,round(poczatek)]<>polwolne)
                                                and (mapa.va[i,round(poczatek)]<>vsceneria) then
                                                      begin
                                                       kw:=0;
                                                       liniastrzalus:=false;
                                                      end;
{                                                mapa.tiles[i,round(poczatek)]:=kw;}
                                                poczatek:=poczatek-skok;
                                               end;
                                         end
                                         else
                                         begin
                                          skok:=odpx/odpy;
                                          poczatek:=xls2;
                                          for i:=yls2 to yls1 do
                                               begin
                                                kw:=2;
                                              if (mapa.va[round(poczatek),i]<>wolne) and (mapa.va[round(poczatek),i]<>polwolne)
                                                and (mapa.va[round(poczatek),i]<>vsceneria) then
                                                          begin
                                                           kw:=0;
                                                           liniastrzalus:=false;
                                                          end;
{                                                mapa.tiles[round(poczatek),i]:=kw;}
                                                poczatek:=poczatek-skok;
                                               end;

                                         end;
                                     end;
{000}
{1-2}
{000}
            if (xls1<xls2) and (yls1=yls2) then
                                     begin
                                      odpx:=xls2-xls1;
                                      odpy:=0;
                                      for i:=xls1 to xls2 do
                                          begin
                                           kw:=2;
                                           if (mapa.va[i,yls1]<>wolne) and (mapa.va[i,yls1]<>polwolne)
                                           and (mapa.va[i,yls1]<>vsceneria) then
                                                            begin
                                                             kw:=0;
                                                             liniastrzalus:=false;
                                                            end;
{                                           mapa.tiles[i,yls1]:=kw;}
                                          end;
                                     end;

{000}
{2-1}
{000}
            if (xls1>xls2) and (yls1=yls2) then
                                     begin
                                      odpx:=xls2-xls1;
                                      odpy:=0;
                                      for i:=xls2 to xls1 do
                                          begin
                                           kw:=2;
                                         if (mapa.va[i,yls1]<>vsceneria) and (mapa.va[i,yls1]<>wolne)
                                         and (mapa.va[i,yls1]<>polwolne) then
                                                             begin
                                                              kw:=0;
                                                              liniastrzalus:=false;
                                                             end;
{                                           mapa.tiles[i,yls1]:=kw;  }
                                          end;
                                     end;

end;
{=============================================}
{=  POSZUKIWANIE POSTACI NA PODANEJ POZYCJI  =}
{=============================================}
Function ZnajdzPostac(szx,szy:byte):byte;
var i:byte;
begin
Znajdzpostac:=0;
for i:=1 to 20 do if (mapa.postacie[i].xp=szx) and (mapa.postacie[i].yp=szy) then if mapa.postacie[i].status=normalny then
           begin
            ZnajdzPostac:=i;
            i:=20;
           end;
end;
{===========================================}
{=  POSZUKIWANIE TRUPA NA PODANEJ POZYCJI  =}
{===========================================}
Function ZnajdzTrupa(szx,szy:byte):byte;
var i:byte;
begin
Znajdztrupa:=0;
for i:=1 to 20 do if (mapa.postacie[i].xp=szx) and (mapa.postacie[i].yp=szy) then if mapa.postacie[i].status=martwy then
           begin
            Znajdztrupa:=i;
            i:=20;
           end;
end;

{======================================================}
{=  POSZUKIWANIE OBIEKTU SCENERII NA PODANEJ POZYCJI  =}
{======================================================}
Function ZnajdzScenerie(szx,szy:byte):byte;
var i:byte;
begin
Znajdzscenerie:=0;
for i:=1 to 50 do if (mapa.scenerie[i].xs=szx) and (mapa.scenerie[i].ys=szy) then
           begin
            ZnajdzScenerie:=i;
            i:=50;
           end;
end;
{============================================}
{=  POSZUKIWANIE SZAFKI NA PODANEJ POZYCJI  =}
{============================================}
Function ZnajdzSzafke(szx,szy:byte):byte;
var i:byte;
begin
Znajdzszafke:=0;
for i:=1 to 40 do if (mapa.szafki[i].xs=szx) and (mapa.szafki[i].ys=szy) then
           begin
            ZnajdzSzafke:=i;
            i:=40;
           end;
end;

{=================================================}
{= SPRAWDZANIE WSPRZDNYCH KLIKNITEGO OBIEKTU =}
{=================================================}
Function ZnajdzNumer(xz,yz:byte):byte;
var i:byte;
begin
ZnajdzNumer:=0;
if mapa.va[xz,yz]=postac then for i:=1 to 20 do if (mapa.postacie[i].xp=xz) and (mapa.postacie[i].yp=yz) then
                                   begin
                                    ZnajdzNumer:=i;
                                    i:=20;
                                   end;
if mapa.va[xz,yz]=vsceneria then for i:=1 to 50 do if (mapa.scenerie[i].xs=xz) and (mapa.scenerie[i].ys=yz) then
                                   begin
                                    ZnajdzNumer:=i;
                                    i:=50;
                                   end;
if mapa.va[xz,yz]=vszafka then for i:=1 to 40 do if (mapa.szafki[i].xs=xz) and (mapa.szafki[i].ys=yz) then
                                   begin
                                    ZnajdzNumer:=i;
                                    i:=40;
                                   end;
if mapa.va[xz,yz]=Spatial then for i:=1 to 10 do if (mapa.spatiale[i].xs=xz) and (mapa.spatiale[i].ys=yz) then
                                   begin
                                    ZnajdzNumer:=i;
                                    i:=10;
                                   end;
if mapa.va[xz,yz]=trup then for i:=1 to 20 do if (mapa.postacie[i].xp=xz) and (mapa.postacie[i].yp=yz) then
                                   begin
                                    ZnajdzNumer:=i;
                                    i:=20;
                                   end;

end;

{                                                               }
{                                                               }
{                                                               }
{                   STEROWANIE WIATEM GRY                      }
{                                                               }
{                                                               }
{                                                               }


{====================================================}
{= PROCEDURA ZALADOWANIA BRONI ODPOWIEDNIA AMUNICJA =}
{====================================================}
Function ZaladujBron(nrp1:byte):boolean;
var typammo:integer;
    Ladownosc:integer;
    Roznica:real;
    Slocik:byte;
    Przeladunek:real;
begin
zaladujbron:=false;
if idtyp(mapa.postacie[nrp1].bron)=bron then
    begin
     typammo:=idammo(mapa.postacie[nrp1].bron);
     Ladownosc:=idammoload(mapa.postacie[nrp1].bron);
     roznica:=ladownosc-mapa.postacie[nrp1].bronspec;
     slocik:=itemsearch(nrp1,typammo);
     if slocik>0 then
                   begin
                    if mapa.postacie[nrp1].spec[slocik]>=roznica then
                                begin
                                 przeladunek:=roznica;
                                 mapa.postacie[nrp1].spec[slocik]:=mapa.postacie[nrp1].spec[slocik]-przeladunek;
                                end
                             else
                                begin
                                 przeladunek:=mapa.postacie[nrp1].spec[slocik];
                                 mapa.postacie[nrp1].spec[slocik]:=mapa.postacie[nrp1].spec[slocik]-przeladunek;
                                end;
                    if mapa.postacie[nrp1].spec[slocik]=0 then mapa.postacie[nrp1].ekwipunek[slocik]:=0;
                    mapa.postacie[nrp1].bronspec:=mapa.postacie[nrp1].bronspec+przeladunek;
                    ZaladujBron:=true;
                   end;
    end;
end;
{==============================}
{=     OPUSZCZENIE MAPY       =}
{==============================}
Procedure OpuscMape;
begin
savemap(mapname);
RunMapScript(mapname,2);
end;
{===============================================================}
{= ZMIANA MAPY W WYNIKU DOTARCIA POSTACI GRACZA DO KRANCA MAPY =}
{===============================================================}
Procedure ZmianaMapy(strona:byte);
begin
if mapa.wyjscia[strona]<>'' then
    begin

{     Savemap(mapname);
     LoadMap(mapa.wyjscia[strona]);}
     opuscmape;
     wczytajmape(mapa.wyjscia[strona]);
     if strona=Klewo then
                  begin
                   mapa.postacie[0].xp:=79;
                   mx:=61;
 {                  my:=mapa.postacie[0].yp-6;}
                   Showmap;
                  end;
     if strona=Kprawo then
                  begin
                   mapa.postacie[0].xp:=2;
                   mx:=1;
{                   my:=mapa.postacie[0].yp-6;  }
                   Showmap;
                  end;
     if strona=Kgora then
                  begin
                   mapa.postacie[0].yp:=79;
 {                  mx:=mapa.postacie[0].xp-8;}
                   my:=68;
                   Showmap;
                  end;
     if strona=Kdol then
                  begin
                   mapa.postacie[0].yp:=2;
{                   mx:=mapa.postacie[0].xp-8;}
                   my:=1;
                   Showmap;
                  end;
     if strona=KLewoGora then
                  begin
                   mapa.postacie[0].xp:=79;
                   mapa.postacie[0].yp:=79;
                   mx:=mapa.postacie[0].xp-19;
                   my:=mapa.postacie[0].yp-12;
                   Showmap;
                  end;
     if strona=KLewoDol then
                  begin
                   mapa.postacie[0].xp:=79;
                   mapa.postacie[0].yp:=2;
                   mx:=mapa.postacie[0].xp-19;
                   my:=1;
                   Showmap;
                  end;
     if strona=KPrawoGora then
                  begin
                   mapa.postacie[0].xp:=2;
                   mapa.postacie[0].yp:=79;
                   mx:=1;
                   my:=mapa.postacie[0].yp-12;
                   Showmap;
                  end;
     if strona=KPrawoDol then
                  begin
                   mapa.postacie[0].xp:=2;
                   mapa.postacie[0].yp:=2;
                   mx:=1;
                   my:=1;
                   Showmap;
                  end;
     nazwamapy;
     walidatujmape;
    end;

end;
{=====================================================}
{= PORUSZANIE POSTACIA O NUMERZE NRP W PODANA STRONE =}
{=====================================================}
procedure RuchPostaci(nrp,Strona:byte);
begin
if strona=Kprawo then if mapa.postacie[nrp].xp+1<=80{mapa.pozx} then
             if mapa.va[mapa.postacie[nrp].xp+1,mapa.postacie[nrp].yp]=wolne then
                   begin
                    UkryjMysz;
                    Wymarz(nrp);
                    mapa.postacie[nrp].xp:=mapa.postacie[nrp].xp+1;
                    UmiescPostac(nrp);
                    Pokazmysz;
                    Walidatuj(mapa.postacie[nrp].xp-1,mapa.postacie[nrp].yp);
                    Walidatuj(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp);
                    if zablokuj=true then if nrp=0 then scrollmap(strona);
                   end;
if strona=Klewo then if mapa.postacie[nrp].xp-1>=1 then
             if mapa.va[mapa.postacie[nrp].xp-1,mapa.postacie[nrp].yp]=wolne then
               begin
                UkryjMysz;
                Wymarz(nrp);
                mapa.postacie[nrp].xp:=mapa.postacie[nrp].xp-1;
                UmiescPostac(nrp);
                PokazMysz;
                Walidatuj(mapa.postacie[nrp].xp+1,mapa.postacie[nrp].yp);
                Walidatuj(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp);
                if zablokuj=true then if nrp=0 then scrollmap(strona);
               end;
if strona=Kgora then if mapa.postacie[nrp].yp-1>=1 then
            if mapa.va[mapa.postacie[nrp].xp,mapa.postacie[nrp].yp-1]=wolne then
               begin
                UkryjMysz;
                Wymarz(nrp);
                mapa.postacie[nrp].yp:=mapa.postacie[nrp].yp-1;
                UmiescPostac(nrp);
                PokazMysz;
                Walidatuj(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp+1);
                Walidatuj(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp);
                if zablokuj=true then if nrp=0 then scrollmap(strona);
               end;

if strona=Kdol then if mapa.postacie[nrp].yp+1<=80{mapa.rozy} then
            if mapa.va[mapa.postacie[nrp].xp,mapa.postacie[nrp].yp+1]=wolne then
               begin
                UkryjMysz;
                Wymarz(nrp);
                mapa.postacie[nrp].yp:=mapa.postacie[nrp].yp+1;
                UmiescPostac(nrp);
                Pokazmysz;
                Walidatuj(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp-1);
                Walidatuj(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp);
                if zablokuj=true then if nrp=0 then scrollmap(strona);
               end;
if strona=KPrawoDol then if (mapa.postacie[nrp].xp+1<=80{mapa.rozx}) and (mapa.postacie[nrp].yp+1<=80{mapa.rozy}) then
            if mapa.va[mapa.postacie[nrp].xp+1,mapa.postacie[nrp].yp+1]=wolne then
               begin
                UkryjMysz;
                Wymarz(nrp);
                mapa.postacie[nrp].yp:=mapa.postacie[nrp].yp+1;
                mapa.postacie[nrp].xp:=mapa.postacie[nrp].xp+1;
                UmiescPostac(nrp);
                PokazMysz;
                Walidatuj(mapa.postacie[nrp].xp-1,mapa.postacie[nrp].yp-1);
                Walidatuj(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp);
{       if nrp=0 then if (mapa.postacie[nrp].xp=mapa.rozx) and (mapa.postacie[nrp].yp=mapa.rozy) then ZmianaMapy(KPrawoDol);}
                if zablokuj=true then if nrp=0 then scrollmap(strona);
               end;
if strona=KLewoDol then if (mapa.postacie[nrp].xp-1>=1) and (mapa.postacie[nrp].yp+1<=80{mapa.rozy}) then
            if mapa.va[mapa.postacie[nrp].xp-1,mapa.postacie[nrp].yp+1]=wolne then
               begin
                UkryjMysz;
                Wymarz(nrp);
                mapa.postacie[nrp].yp:=mapa.postacie[nrp].yp+1;
                mapa.postacie[nrp].xp:=mapa.postacie[nrp].xp-1;
                UmiescPostac(nrp);
                PokazMysz;
                Walidatuj(mapa.postacie[nrp].xp+1,mapa.postacie[nrp].yp-1);
                Walidatuj(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp);
                if zablokuj=true then if nrp=0 then scrollmap(strona);
               end;
if strona=KPrawoGora then if (mapa.postacie[nrp].xp+1<=80{mapa.rozx}) and (mapa.postacie[nrp].yp-1>=1) then
            if mapa.va[mapa.postacie[nrp].xp+1,mapa.postacie[nrp].yp-1]=wolne then
               begin
                UkryjMysz;
                Wymarz(nrp);
                mapa.postacie[nrp].yp:=mapa.postacie[nrp].yp-1;
                mapa.postacie[nrp].xp:=mapa.postacie[nrp].xp+1;
                UmiescPostac(nrp);
                PokazMysz;
                Walidatuj(mapa.postacie[nrp].xp-1,mapa.postacie[nrp].yp+1);
                Walidatuj(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp);
                if zablokuj=true then if nrp=0 then scrollmap(strona);
               end;
if strona=KLewoGora then if (mapa.postacie[nrp].xp-1>=1) and (mapa.postacie[nrp].yp-1>=1) then
          if mapa.va[mapa.postacie[nrp].xp-1,mapa.postacie[nrp].yp-1]=wolne then
               begin
                UkryjMysz;
                Wymarz(nrp);
                mapa.postacie[nrp].yp:=mapa.postacie[nrp].yp-1;
                mapa.postacie[nrp].xp:=mapa.postacie[nrp].xp-1;
                UmiescPostac(nrp);
                PokazMysz;
                Walidatuj(mapa.postacie[nrp].xp+1,mapa.postacie[nrp].yp+1);
                Walidatuj(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp);
                if zablokuj=true then if nrp=0 then scrollmap(strona);
               end;
if nrp=0 then
         begin
  if (mapa.postacie[0].xp=1) and (mapa.postacie[0].yp<>1) and (mapa.postacie[0].yp<>80{mapa.rozy}) then
           if mapa.wyjscia[klewo]<>'' then zmianamapy(Klewo) else
                            begin
                             opuscmape;
                             wymarzobraz;
                             MapaSwiata;
                            end;

  if (mapa.postacie[0].xp=80{mapa.rozx}) and (mapa.postacie[0].yp<>1) and (mapa.postacie[0].yp<>80{mapa.rozy}) then
           if mapa.wyjscia[kprawo]<>'' then zmianamapy(Kprawo) else
                            begin
                             opuscmape;
                             wymarzobraz;
                             MapaSwiata;
                            end;
  if (mapa.postacie[0].yp=1) and (mapa.postacie[0].xp<>1) and (mapa.postacie[0].xp<>80{mapa.rozx}) then
           if mapa.wyjscia[kgora]<>'' then zmianamapy(Kgora) else
                            begin
                             opuscmape;
                             wymarzobraz;
                             MapaSwiata;
                            end;
  if (mapa.postacie[0].yp=80{mapa.rozy}) and (mapa.postacie[0].xp<>1) and (mapa.postacie[0].xp<>80{mapa.rozy}) then
           if mapa.wyjscia[kdol]<>'' then zmianamapy(Kdol) else
                            begin
                             opuscmape;
                             wymarzobraz;
                             MapaSwiata;
                            end;
  if (mapa.postacie[0].xp=1) and (mapa.postacie[0].yp=1) then
           if mapa.wyjscia[klewogora]<>'' then zmianamapy(Klewogora) else
                            begin
                             opuscmape;
                             wymarzobraz;
                             MapaSwiata;
                            end;
  if (mapa.postacie[0].xp=1) and (mapa.postacie[0].yp=80{mapa.rozy}) then
           if mapa.wyjscia[klewodol]<>'' then zmianamapy(Klewodol) else
                            begin
                             opuscmape;
                             wymarzobraz;
                             MapaSwiata;
                            end;
  if (mapa.postacie[0].xp=80{mapa.rozx}) and (mapa.postacie[0].yp=1) then
           if mapa.wyjscia[kprawogora]<>'' then zmianamapy(Kprawogora) else
                            begin
                             opuscmape;
                             wymarzobraz;
                             MapaSwiata;
                            end;
  if (mapa.postacie[0].xp=80{mapa.rozx}) and (mapa.postacie[0].yp=80{mapa.rozy}) then
           if mapa.wyjscia[kprawodol]<>'' then zmianamapy(Kprawodol) else
                            begin
                             opuscmape;
                             wymarzobraz;
                             MapaSwiata;
                            end;
         end;

end;
{===================================================================}
{= PORUSZANIE POSTACIA O NUMERZE NRP W PODANA STRONE PODCZAS WALKI =}
{===================================================================}
procedure RuchPostaciFight(nrp,Strona:byte);
begin
if strona=Kprawo then if mapa.va[mapa.postacie[nrp].xp+1,mapa.postacie[nrp].yp]=0 then
                  if mapa.postacie[nrp].xp+1<80{mapa.rozx} then
                   begin
                    dec(mapa.postacie[nrp].ap);
                    UkryjMysz;
                    Wymarz(nrp);
                    mapa.postacie[nrp].xp:=mapa.postacie[nrp].xp+1;
                    UmiescPostac(nrp);
                    Pokazmysz;
                    Walidatuj(mapa.postacie[nrp].xp-1,mapa.postacie[nrp].yp);
                    Walidatuj(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp);
                   end
                   else if nrp>0 then dec(mapa.postacie[nrp].ap);
if strona=Klewo then if mapa.va[mapa.postacie[nrp].xp-1,mapa.postacie[nrp].yp]=0 then
                 if mapa.postacie[nrp].xp-1>1 then
               begin
                dec(mapa.postacie[nrp].ap);
                UkryjMysz;
                Wymarz(nrp);
                mapa.postacie[nrp].xp:=mapa.postacie[nrp].xp-1;
                UmiescPostac(nrp);
                PokazMysz;
                Walidatuj(mapa.postacie[nrp].xp+1,mapa.postacie[nrp].yp);
                Walidatuj(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp);
               end else if nrp>0 then dec(mapa.postacie[nrp].ap);
if strona=Kgora then if mapa.va[mapa.postacie[nrp].xp,mapa.postacie[nrp].yp-1]=0 then
                 if mapa.postacie[nrp].yp-1>1 then
               begin
                dec(mapa.postacie[nrp].ap);
                UkryjMysz;
                Wymarz(nrp);
                mapa.postacie[nrp].yp:=mapa.postacie[nrp].yp-1;
                UmiescPostac(nrp);
                PokazMysz;
                Walidatuj(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp+1);
                Walidatuj(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp);
               end else if nrp>0 then dec(mapa.postacie[nrp].ap);

if strona=Kdol then if mapa.va[mapa.postacie[nrp].xp,mapa.postacie[nrp].yp+1]=0 then
                if mapa.postacie[nrp].yp+1<80{mapa.rozy} then
               begin
                dec(mapa.postacie[nrp].ap);
                UkryjMysz;
                Wymarz(nrp);
                mapa.postacie[nrp].yp:=mapa.postacie[nrp].yp+1;
                UmiescPostac(nrp);
                Pokazmysz;
                Walidatuj(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp-1);
                Walidatuj(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp);
               end else if nrp>0 then dec(mapa.postacie[nrp].ap);
if strona=KPrawoDol then if mapa.va[mapa.postacie[nrp].xp+1,mapa.postacie[nrp].yp+1]=0 then
                if mapa.postacie[nrp].xp+1<80{mapa.rozx} then if mapa.postacie[nrp].yp+1<80{mapa.rozy} then
               begin
               dec(mapa.postacie[nrp].ap);
                UkryjMysz;
                Wymarz(nrp);
                mapa.postacie[nrp].yp:=mapa.postacie[nrp].yp+1;
                mapa.postacie[nrp].xp:=mapa.postacie[nrp].xp+1;
                UmiescPostac(nrp);
                PokazMysz;
                Walidatuj(mapa.postacie[nrp].xp-1,mapa.postacie[nrp].yp-1);
                Walidatuj(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp);
               end else if nrp>0 then dec(mapa.postacie[nrp].ap);
if strona=KLewoDol then if mapa.va[mapa.postacie[nrp].xp-1,mapa.postacie[nrp].yp+1]=0 then
                if mapa.postacie[nrp].xp-1>1 then if mapa.postacie[nrp].yp+1<80{mapa.rozy} then
               begin
                dec(mapa.postacie[nrp].ap);
                UkryjMysz;
                Wymarz(nrp);
                mapa.postacie[nrp].yp:=mapa.postacie[nrp].yp+1;
                mapa.postacie[nrp].xp:=mapa.postacie[nrp].xp-1;
                UmiescPostac(nrp);
                PokazMysz;
                Walidatuj(mapa.postacie[nrp].xp+1,mapa.postacie[nrp].yp-1);
                Walidatuj(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp);
               end else if nrp>0 then dec(mapa.postacie[nrp].ap);
if strona=KPrawoGora then if mapa.va[mapa.postacie[nrp].xp+1,mapa.postacie[nrp].yp-1]=0 then
                if mapa.postacie[nrp].xp+1<80{mapa.rozx} then if mapa.postacie[nrp].yp-1>1 then
               begin
                dec(mapa.postacie[nrp].ap);
                UkryjMysz;
                Wymarz(nrp);
                mapa.postacie[nrp].yp:=mapa.postacie[nrp].yp-1;
                mapa.postacie[nrp].xp:=mapa.postacie[nrp].xp+1;
                UmiescPostac(nrp);
                PokazMysz;
                Walidatuj(mapa.postacie[nrp].xp-1,mapa.postacie[nrp].yp+1);
                Walidatuj(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp);
               end else if nrp>0 then dec(mapa.postacie[nrp].ap);
if strona=KLewoGora then if mapa.va[mapa.postacie[nrp].xp-1,mapa.postacie[nrp].yp-1]=0 then
                if mapa.postacie[nrp].xp-1>1 then if mapa.postacie[nrp].yp-1>1 then
               begin
                dec(mapa.postacie[nrp].ap);
                UkryjMysz;
                Wymarz(nrp);
                mapa.postacie[nrp].yp:=mapa.postacie[nrp].yp-1;
                mapa.postacie[nrp].xp:=mapa.postacie[nrp].xp-1;
                UmiescPostac(nrp);
                PokazMysz;
                Walidatuj(mapa.postacie[nrp].xp+1,mapa.postacie[nrp].yp+1);
                Walidatuj(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp);
               end else if nrp>0 then dec(mapa.postacie[nrp].ap);

end;

{                                                       }
{                                                       }
{       GRAFICZNE ODWZOROWYWANIE RODOWISKA GRY         }
{                                                       }
{                                                       }

{==========================================================}
{= WYMAZANIE KWADRATU NA KTORYM STOI POSTAC O NUMERZE NRP =}
{==========================================================}
Procedure Wymarz(nrp:byte);
var i:byte;
begin
RysujKwadrat(mapa.postacie[nrp].xp,mapa.postacie[nrp].yp);
end;
{===================================================================}
{= WYMAZANIE KWADRATU NA KTORYM STOI OBIEKT SCENERII O NUMERZE NRS =}
{===================================================================}
Procedure Wymarzs(nrs:byte);
var i:byte;
begin
RysujKwadrat(mapa.scenerie[nrs].xs,mapa.scenerie[nrs].ys);
end;

{===============================================}
{= UMIESZCZANIE POSTACI O NUMERZE NRP NA MAPIE =}
{===============================================}
procedure umiescpostac(nrp:byte);
begin
if (mapa.postacie[nrp].xp<=mx+19) and (mapa.postacie[nrp].xp>=mx) and (mapa.postacie[nrp].yp>=my)
  and (mapa.postacie[nrp].yp<=my+12) then
  begin
   if mapa.postacie[nrp].status=normalny then RysOdpPostac(mappozx+(((mapa.postacie[nrp].xp-(mx-1))-1)*20),
                 mappozy+(((mapa.postacie[nrp].yp-(my-1))-1)*30),nrp);
   if mapa.postacie[nrp].status=martwy then MartwaPostac(mappozx+(((mapa.postacie[nrp].xp-(mx-1))-1)*20),
                 mappozy+(((mapa.postacie[nrp].yp-(my-1))-1)*30));
  end;
end;

{                                                        }
{                                                        }
{                        WALIDACJA                       }
{                                                        }
{                                                        }

{================================================================}
{= WALIDACJA POJEDYNCZEGO KWADRATU MAPY(CHODZI TYLKO O POSTACIE =}
{================================================================}
Procedure Walidatuj(xw,yw:byte);
var i:byte;
begin
mapa.va[xw,yw]:=wolne;
for i:=0 to 20 do
           begin
            if (mapa.postacie[i].xp=xw) and (mapa.postacie[i].yp=yw) and (mapa.postacie[i].status<>niema) then
                        mapa.va[xw,yw]:=postac;
           end;
for i:=1 to 50 do
           begin
            if (mapa.scenerie[i].xs=xw) and (mapa.scenerie[i].ys=yw) then
               if (mapa.scenerie[i].typ>=1) and (mapa.scenerie[i].typ<=8) then
                 begin
                  if mapa.scenerie[i].stan=otwarte then mapa.va[xw,yw]:=wolne;
                  if mapa.scenerie[i].stan<>otwarte then mapa.va[xw,yw]:=vsceneria;
                 end
                 else mapa.va[xw,yw]:=vsceneria;

           end;
end;
{=====================================}
{=       WALIDACJA CALEJ MAPY        =}
{=====================================}
Procedure WalidatujMape;
var xi,yi:byte;
begin
for yi:=1 to 80 do for xi:=1 to 80 do mapa.va[xi,yi]:=wolne;
for yi:=1 to 80 do for xi:=1 to 80 do
{WALIDACJA TILES}
          if ((mapa.tiles[xi,yi]>23) and (mapa.tiles[xi,yi]<=40)) or
             ((mapa.tiles[xi,yi]>=43) and (mapa.tiles[xi,yi]<=59)) or
             ((mapa.tiles[xi,yi]>=98) and (mapa.tiles[xi,yi]<=110)) or
             ((mapa.tiles[xi,yi]>161) and (mapa.tiles[xi,yi]<=166))
                                 then mapa.va[xi,yi]:=Polwolne;
{WALIDACJA SCIAN}
for yi:=1 to 80 do for xi:=1 to 80 do
                                    begin
                                     if (mapa.sciany[xi,yi]>0) and (mapa.sciany[xi,yi]<=150) then
                   mapa.va[xi,yi]:=vsciana else if mapa.sciany[xi,yi]>181 then mapa.va[xi,yi]:=vsciana else
                                if mapa.sciany[xi,yi]>0 then mapa.va[xi,yi]:=polwolne;
                                    end;

{WALIDACJA POSTACI}
for xi:=0 to 20 do if mapa.postacie[xi].status<>niema then mapa.va[mapa.postacie[xi].xp,mapa.postacie[xi].yp]:=postac;
{WALIDACJA SCENERII}
for xi:=1 to 50 do if mapa.scenerie[xi].xs>0 then
                          begin
                           if (mapa.scenerie[xi].typ>=1) and (mapa.scenerie[xi].typ<=8) then
                              begin
                               if mapa.scenerie[xi].stan=otwarte then mapa.va[mapa.scenerie[xi].xs,mapa.scenerie[xi].ys]:=wolne
                                                  else mapa.va[mapa.scenerie[xi].xs,mapa.scenerie[xi].ys]:=vsceneria;
                              end
                                       else mapa.va[mapa.scenerie[xi].xs,mapa.scenerie[xi].ys]:=vsceneria;
                          end;
{WALIDACJA SZAFEK I SPATIALI}
for xi:=1 to 40 do if mapa.szafki[xi].xs>0 then mapa.va[mapa.szafki[xi].xs,mapa.szafki[xi].ys]:=vszafka;
for xi:=1 to 10 do if mapa.spatiale[xi].xs>0 then mapa.va[mapa.spatiale[xi].xs,mapa.spatiale[xi].ys]:=spatial;
end;
{                                                          }
{                                                          }
{             PROCEDURY OPERACJI NA DANYCH POSTACI         }
{                                                          }
{                                                          }

{=====================================================}
{= WSTAWIENIE ODPOWIEDNICH DANYCH DO SLOTU EKWIPUNKU =}
{=====================================================}
Procedure UstawSlot(Iloscsl:real; Przedmiots,numerslotu:integer; postacs:byte);
begin
if numerslotu<25 then
                 begin
                  mapa.postacie[postacs].ekwipunek[numerslotu]:=przedmiots;
                  mapa.postacie[postacs].spec[numerslotu]:=iloscsl;
                 end;
if numerslotu=25 then
                 begin
                  mapa.postacie[postacs].bron:=przedmiots;
                  mapa.postacie[postacs].bronspec:=iloscsl;
                 end;
if numerslotu=26 then mapa.postacie[postacs].zbroja:=przedmiots;
end;
{=================================}
{= ZAMIANA WARTOSCI DWOCH SLOTOW =}
{=================================}
Procedure ZamienSloty(SlotZ,SlotDo,NrPostaci:byte);
var Zps1,Zps2:integer;
    Zis1,Zis2:real;
    Dop1,Dop2:real;
begin
if slotz<25 then
              begin
               Zps1:=mapa.postacie[nrpostaci].ekwipunek[slotz];
               Zis1:=mapa.postacie[nrpostaci].spec[slotz];
              end;
if slotz=25 then
              begin
               Zps1:=mapa.postacie[nrpostaci].bron;
               Zis1:=mapa.postacie[nrpostaci].bronspec;
              end;
if slotz=26 then
              begin
               Zps1:=mapa.postacie[nrpostaci].zbroja;
               Zis1:=0;
              end;
if slotdo<25 then
              begin
               Zps2:=mapa.postacie[nrpostaci].ekwipunek[slotdo];
               Zis2:=mapa.postacie[nrpostaci].spec[slotdo];
              end;
if slotdo=25 then
              begin
               Zps2:=mapa.postacie[nrpostaci].bron;
               Zis2:=mapa.postacie[nrpostaci].bronspec;
              end;
if slotdo=26 then
              begin
               Zps2:=mapa.postacie[nrpostaci].zbroja;
               Zis2:=0;
              end;
              {KOPIOWANIE}
if slotz<25 then
              begin
               mapa.postacie[nrpostaci].ekwipunek[slotz]:=Zps2;
               mapa.postacie[nrpostaci].spec[slotz]:=Zis2;
              end;
if slotz=25 then
              begin
               mapa.postacie[nrpostaci].bron:=Zps2;
               mapa.postacie[nrpostaci].bronspec:=Zis2;
              end;
if slotz=26 then
              begin
               mapa.postacie[nrpostaci].zbroja:=Zps2;
              end;

if slotdo<25 then
              begin
               mapa.postacie[nrpostaci].ekwipunek[slotdo]:=zps1;
               mapa.postacie[nrpostaci].spec[slotdo]:=zis1;
              end;
if slotdo=25 then
              begin
               mapa.postacie[nrpostaci].bron:=zps1;
               mapa.postacie[nrpostaci].bronspec:=zis1;
              end;
if slotdo=26 then
              begin
               mapa.postacie[nrpostaci].zbroja:=zps1;
              end;

end;
{==========================================}
{=   POLACZENIE ZAWARTOSCI DWOCH SLOTOW   =}
{==========================================}
Procedure PolaczZawartosc(SlotZ,SlotDo,NrPostaci:byte);
var roznica:real;
begin
roznica:=0;
setcolor(white);
outtextxy(100,100,'sdgsdgfsd');
delay(3000);
if idtyp(mapa.postacie[nrpostaci].ekwipunek[slotz])=amunicja then
                begin
                 roznica:=100-mapa.postacie[nrpostaci].spec[slotdo];
                 if roznica>0 then
                                begin
                                 if mapa.postacie[nrpostaci].spec[slotz]>roznica then
                     begin
                      mapa.postacie[nrpostaci].spec[slotz]:=mapa.postacie[nrpostaci].spec[slotz]-roznica;
                     end
                     else
                     begin
                      roznica:=mapa.postacie[nrpostaci].spec[slotz];
                      mapa.postacie[nrpostaci].spec[slotz]:=0;
                      mapa.postacie[nrpostaci].ekwipunek[slotz]:=0;
                     end;
                 mapa.postacie[nrpostaci].spec[slotdo]:=mapa.postacie[nrpostaci].spec[slotDO]+roznica;
                                end;
                end;
if idtyp(mapa.postacie[nrpostaci].ekwipunek[slotz])=waluta then
                begin
                 roznica:=mapa.postacie[nrpostaci].spec[slotz];
                 mapa.postacie[nrpostaci].ekwipunek[slotz]:=0;
                 mapa.postacie[nrpostaci].spec[slotz]:=0;
                 mapa.postacie[nrpostaci].spec[slotdo]:=mapa.postacie[nrpostaci].spec[slotdo]+roznica;
                end;
end;
{========================}
{= URZYWANIE PRZEDMIOTU =}
{========================}
Procedure UrzyjPRzedmiotu(nrpostaci,nrslotu:byte);
begin
crit:=nrpostaci;
UsedItem:=mapa.postacie[0].ekwipunek[nrslotu];
if nrpostaci>0 then
                 begin
                  dopisz('* Urzywasz przedmiotu:'+idname(mapa.postacie[0].ekwipunek[nrslotu])+' na '
                            +mapa.postacie[nrpostaci].imie+'.');
                 end else dopisz('* Urzywasz na sobie przedmiotu:'+idname(mapa.postacie[0].ekwipunek[nrslotu]));
RunItemScript(idscript(mapa.postacie[0].ekwipunek[nrslotu]),1);
if nrpostaci>0 then RunCritterScript(mapa.postacie[nrpostaci].skrypt,5);
mapa.postacie[0].ekwipunek[nrslotu]:=0;
mapa.postacie[0].spec[nrslotu]:=0;
polecenie:=koniec;
end;
{=========================================}
{= SPRAWDZANIE CZY PRZEDMIOTU MOZNA UZYC =}
{=========================================}
Function MoznaUrzyc(nrprz:integer):boolean;
begin
MoznaUrzyc:=false;
if (idtyp(nrprz)=specjalny) or (idtyp(nrprz)=Medykament) or (idtyp(nrprz)=urzywka) then
            moznaurzyc:=true;
end;
{=============================================}
{= KOPIOWANIE PRZEDMIOTU DO WSKAZANEGO SLOTU =}
{=============================================}
Procedure KopiujDo(SlotZ,SlotDo,NrPostaci:byte);

var Zps1,Zps3:integer;
    zps2,Zps4:real;
    zwp,zwb:byte;
    Okresl:boolean;
begin
okresl:=true;
if slotz=slotdo then okresl:=false;
if slotz=slotdo then if (slotz<25) and (nrpostaci=0) then if moznaurzyc(mapa.postacie[0].ekwipunek[slotz]) then
                          UrzyjPrzedmiotu(0,slotz);
{PRZECIWSKAZANIA}
if (slotdo=26) then
                 begin
                  if slotz<25 then if idtyp(mapa.postacie[nrpostaci].ekwipunek[slotz])<>Pancerz then Okresl:=false;
                  if slotz=25 then if idtyp(mapa.postacie[nrpostaci].bron)<>Pancerz then Okresl:=false;
                 end;
if slotz=25 then
              begin
               if slotdo<25 then if idtyp(mapa.postacie[nrpostaci].ekwipunek[slotdo])=Pancerz then Okresl:=false;
               if slotdo=26 then Okresl:=false;
              end;
if slotz=26 then
              begin
               if slotdo<25 then if not ((idtyp(mapa.postacie[nrpostaci].ekwipunek[slotdo])=Pancerz) or
                             (mapa.postacie[nrpostaci].ekwipunek[slotdo]=0)) then Okresl:=false;
              end;
if slotdo=25 then
                 begin
                  if slotz<25 then if idtyp(mapa.postacie[nrpostaci].ekwipunek[slotz])=Pancerz then Okresl:=false;
                  if slotz=26 then okresl:=false;
                 end;
{NO TO JEDZIEM!}
if okresl then
  begin
   if (slotz<25) and (slotdo<25) then
    begin
     if mapa.postacie[nrpostaci].ekwipunek[slotz]=mapa.postacie[nrpostaci].ekwipunek[slotdo] then
               PolaczZawartosc(Slotz,Slotdo,NrPostaci)
         else zamiensloty(slotz,slotdo,nrpostaci);
    end
     else ZamienSloty(SlotZ,SlotDo,NrPostaci);
  end;
wp:=slotdo; {to wyrazenie niczemu nie przeszkadza poniewaz przy wejsciu w}
            {obsluge ekwipunku, zmienna WP i tak jest zerowana}
end;
{========================}
{=  UZBRAJANIE POSTACI  =}
{========================}
Function UzbrojPostac(nrps:byte):boolean;
var i:byte;
begin
uzbrojpostac:=false;
for i:=1 to 24 do if mapa.postacie[nrps].bron=0 then if ((idtyp(mapa.postacie[nrps].ekwipunek[i])=bron)
                     or (idtyp(mapa.postacie[nrps].ekwipunek[i])=bronb))
                      and (mapa.postacie[nrps].spec[i]>0) then
                        begin
                         kopiujdo(i,25,nrps);
                         uzbrojpostac:=true;
                         dec(mapa.postacie[nrps].ap,4);
                         wymarz(nrps);
                         umiescpostac(nrps);
                        end;

end;
{==================================}
{=  POSZUKIWANIE BRONI U POSTACI  =}
{==================================}
Function WeaponSearch(nrps:byte):boolean;
var i:byte;
begin
weaponSearch:=false;
for i:=1 to 24 do if (idtyp(mapa.postacie[nrps].ekwipunek[i])=bron) or (idtyp(mapa.postacie[nrps].ekwipunek[i])=bronb) then
                 if mapa.postacie[nrps].spec[i]>0 then
                     WeaponSearch:=true;
end;

end.