unit Grafika;

interface
uses crt,graph,dane,textopr,mysz,elements,potworki;


type
    TDialog=record
         xd,yd:integer;   {Wspolrzedne okna dialogowego}
         Kolor:byte;      {kolor ramek okna dialogowego}
         WzorWypelnienia,KolorWypelnienia:byte;
         Tekst:string;    {Tekst w oknie dialogowym (ten ktory definiuje gracz)}
        end;
var
    Scrol:byte;   {Numer zadanie ktore jest wyswietlane jako pierwsze w ekranie dziennika}

    Wp:byte;      {Numer wskazanego przedmiotu}

    Dial:Tdialog;
{NOTKA:


}



         {=======================================================}
         {=                GRAFIKA ELEMENTOW MAPY               =}
         {=======================================================}

         {RYSOWANIE MAPY}
         Procedure RysujMape(xm,ym:integer; Sze,Wys:byte);
         Procedure RysujKwadrat(xm,ym:integer);
         {=======================================================}
         {=                   GRAFIKA POSTACI                   =}
         {=======================================================}
         Procedure RysujPostac(xp,yp:integer;Typ,bron,zbroja:byte);
         Procedure RysOdpPostac(xp,yp:integer;nrp:byte);
         Procedure MartwaPostac(xp,yp:integer);  {rysunek martwej postaci}

         {=======================================================}
         {=                    INTERFACE GRY                    =}
         {=======================================================}

         {PROCEDURY PANELI CZYNNOSCI (NP. Handel, Rozmowa itp.)}
         Procedure PanelScenerii(RodzajPanelu:byte); {Panel obslugi obiektow typu Sceneria}
         Procedure PanelRozmowy;                     {Panel obslugi obiektow typu Postac}
         Procedure PanelHandlu;                      {Panel obslugi zdazenia HANDLU}
         Procedure PanelEkwipunku;                   {Panel obslugi ekwipunku postaci}
         Procedure PanelKradziezy;                   {Panel obslugi procedury kradziezy}
         Procedure PanelIlosci(nrp:integer);         {Panel obslugi wybierania ilosci}
         Procedure PanelSzafek;                      {Panel obslugi przeszukiwania szafek}
         Procedure PanelPostaci;                     {Panel obslugi postaci}
         Procedure PanelDziennika;                   {Panel obslugi dziennika|}
         Procedure GlownyPanel;                      {Glowny panel }
         Procedure Nazwamapy;

         Procedure PanelUzyciaPrzedmiotow;
         Procedure PanelUmiejetnosci;
         Procedure PanelCzynnosci(nrp,typ:byte);




         {PROCEDURY WYSWIETLANIA DANYCH W POWYZSZYCH PANELACH}
         procedure PiszSpec(xt,yt:integer; tekst:string; trybpisania:byte);
         Procedure PiszTekst(xt,yt:integer; tekst:string);   {Zwyczajny tekst}
         Procedure PiszTekstE(tekst:string; Ekr,col:byte);   {Tekst o podanym kolorze w podanym ekranie}
         Procedure PiszTekstES(tekst:string; Atr,Ekr:byte);  {Tekst pisany w specjalny sposb w podanym ekranie}
         Procedure PiszTekstEE(tekst:string; Atr,Ekr,col:byte); {to co wyzej ale konfigurowalny jest kolor}
         Procedure PiszTekstED(xt,yt:integer; Tekst:string; Atr,Ekr,Col:byte); {W pelni konfigurowalny tekst}
         Procedure Centre(xt,yt:integer; tekst:string);      {Tekst wysrodkowany wzgledem wspolrzednej x}
         Procedure FloodTekst(nrp:byte; Slowk:string);       {Wyswietla FloodTekst}

         Procedure WyswietlPrzedmiotyHandlu(NRPH:byte);      {Wyswietla rysunki przedmiotow podczas handlu z}
                                                             {postacia o numerze NRPH}
         Procedure RysujPrzedmiotyUzycia;                    {Wyswietla przedmioty do uzycia}

         Procedure RysujPrzedmiotyEkwipunku;                 {Wyswietla rysunki przedmiotow podczas}
                                                             {zagladania do ekwipunku postaci bohatera}
         Procedure WyswietlDanePrzedmiotu(nrpp:integer);     {Wyswietla dane przedmiotu podczas zagladania}
                                                             {do ekwipunku postaci bohatera}
         Procedure DaneKradziezy(Nrp:integer);               {wyswietla dane podczas wykorzystywania}
                                                             {przez gracza, umiejetnosci KRADZIEZ}
         Procedure DaneSzafek(Nrp:integer);                  {wyswietla dane podczas zagladania}
                                                             {do szafek}
         Procedure DanePostaci;                              {wyswietla dane postaci, podczas uruchamiania}
                                                             {panelu obslugi postaci}
         Procedure DaneTrupa(Nrp:integer);
         Procedure WyswietlZapisy;                           {Wyswietla liste zapisow do wyboru(pobranych)}
         Procedure WyswietlZadania;                          {Wyswietla liste zadan zleconych}
         Procedure WyswietlDate;
         Procedure WyswietlGodzine;
         Procedure WyswietlOdpoczynek;

         Procedure WyswietlKonsole;                          {Wyswietla konsole}
         Procedure DaneGlownegoPanelu;                       {Wyswietla Dane glownego panelu}
         Procedure ShowMap;                                  {wyswietla mape}

         Procedure RamkaEkw(nr:byte);                        {Ramka dla wybranego przedmiotu w ekwipunku}
         Procedure DelRamkaEkw(nr:byte);                     {wymazanie ramki}
         Procedure WymarzRamkeL;{RAMKI HANDLU}
         Procedure RamkaHL;
         Procedure WymarzRamkeR;
         Procedure RamkaHR;
         Procedure WyswietlOferty;

         procedure RamkaKradziezy;
         Procedure DelRamkaKradziezy;


         Procedure PrzyciskiWalki;                           {Wyswietla przyciski walki}
         Procedure DaneHerosa;                               {Wyswietla tylko dane bohatera na glownym panelu}
         Procedure WyswietlWspolczynniki;                    {Wyswietla nazwy wspolczynnikow opisujacych postac}
         Procedure WyswietlUmiejetnosci;                     {wyswietla same umiejetnosci}
         {PROCEDURY ZADA NA OBIEKTACH}
         Procedure CzyscEkran(ekr:byte); {Czysci zawartosc podanego ekranu (EKR - numer ekranu)}
         Procedure RysujPrzyciski; {Rysuje wszystie przyciski}
         Procedure RysujEkrany; {Rysuje wszystkie ekrany}
         Procedure RysujOpcje;  {Rysuje wszystkie OPCJE}
         Procedure RysujListy;  {Rysuje wszystkie LISTY}

         {CZYSZCZENIE PANELI}
         Procedure WymarzTekstHandlu;     {WYMAZUJE TEKST PODCZAS W OKIENKU TEKSTOWYM HANDLU}
         Procedure WymarzOknaHandlu;      {wymazuje zawartkosc wszystkich okien z ekwipunkiem}
                                          {podczas handlu i okna z wartoscia postawionych na handel przedmiotow}
         Procedure CzyscEkranEkwipunku;   {Wymazuje zawartosc ekranu ekwipunku}
         procedure WymarzPanelRozmowy;    {Wymazuje ekrany panelu rozmowy}
         Procedure CzyscPanelIlosci;      {czysci okienko do wpisywania wartosci, w panelu ILOSCI}
         Procedure CzyscPanelSzafek;      {czysci panel szafek podczas przeszukiwania szafek}
         Procedure CzyscPanelKradziezy;   {Czysci zawartosc panelu kradziezy}
         Procedure CzyscPanelPostaci;     {Czysci zawartosc panelu postaci}
         Procedure CzyscPanelDziennika;   {czysci zawartosc panelu dziennkia}
         Procedure CzyscPanelUmiejetnsci; {czyszczenie panelu umiejetnosci}
         Procedure CzyscGlowny;           {czyszczenie glownego panelu}
         Procedure WymarzFlood;           {Wymazanie flood tekstu}
            {Funkcje zadan na obiektach}
            Function SprawdzKolor(Ekr:byte):byte;  {Sprawdza kolor tla ekranu o numerze EKR}
            Function SprawdzKroj(Ekr:byte):byte; {Sprawdza styl kroju tla ekranu o numerze EKR}

         {=====================================================}
         {=                         GUI                       =}
         {=====================================================}
         Procedure nit(xn1,yn1:integer); {Rysuje nit}
         Procedure Przycisk(xo1,yo1,xo2,yo2:integer; StanP,typp:byte; TekstP:string);{Rysuje przycisk}
         Procedure Okno(xo1,yo1,xo2,yo2:Integer; TypO:byte);{Rysuje okno}
         Procedure Ekranek(xo1,yo1,xo2,yo2:integer; Typek:byte);{Rysuje Ekran}
         Procedure Dialog(Xd,Yd:integer; Wzor,KolorW,Kolor:byte; tekst:string);
         Procedure WyswietlDialog;
         Procedure ProbaAtaku; {wcisniecie przycisku BRON}

         {=================================================}
         {=               GRAFIKA DO SKRYPTOW             =}
         {=================================================}


         {PROCEDURY POMOCNICZE}
         Procedure Inicjacja;
         Procedure StartGrafika;
         Procedure KoniecGrafika;
         Procedure UstawKolor(kolor:byte);
         procedure UstawTekst;
         procedure WyswietlWyjscia;

implementation

{===============================================================}
{=                                                             =}
{=                                                             =}
{=                    PROCEDURY POMOCNICZE                     =}
{=                                                             =}
{=                                                             =}
{===============================================================}

{===================================}
{=      WYSWIETLENIE NAZW WYJSC    =}
{===================================}
procedure WyswietlWyjscia;
begin
przycisk(20,20,220,110,0,1,'');
setcolor(black);
outtextxy(25,25,'LEWO:'+mapa.wyjscia[klewo]);
outtextxy(25,35,'PRAWO:'+mapa.wyjscia[kprawo]);
outtextxy(25,45,'GORA:'+mapa.wyjscia[kgora]);
outtextxy(25,55,'DOL:'+mapa.wyjscia[kdol]);
outtextxy(25,65,'LE-GO:'+mapa.wyjscia[klewogora]);
outtextxy(25,75,'PR-GO:'+mapa.wyjscia[kprawogora]);
outtextxy(25,85,'LE-DO:'+mapa.wyjscia[klewodol]);
outtextxy(25,95,'PR-DO:'+mapa.wyjscia[kprawodol]);

end;
{===================================}
{=   INICJACJA TRYBU GRAFICZNEGO   =}
{===================================}
procedure inicjacja;
var tryb,sterownik:integer;
begin
sterownik:=detect;
initgraph(sterownik,tryb,'');
end;
{===================================}
{=      START MODULU Z GRAFIKA     =}
{===================================}
Procedure StartGrafika;
begin
Inicjacja;
end;
{===================================}
{=  ZAKONCZENIE DZIALANIA MODULU   =}
{===================================}
Procedure KoniecGrafika;
begin
closegraph;
end;
{===================================}
{=        USTAWIENIE TEKSTU        =}
{===================================}
procedure UstawTekst;
begin
settextstyle(0,0,0);
end;
{=========================}
{=   USTAWIENIE KOLORU   =}
{=========================}
Procedure UstawKolor(kolor:byte);
begin
setcolor(kolor);
end;
{===============================================================}
{=                                                             =}
{=                                                             =}
{=                      GRAFIKA POSTACI                        =}
{=                                                             =}
{=                                                             =}
{===============================================================}



{=====================================================}
{=            RYSOWANIE POSTACI W KAMIZELCE          =}
{=====================================================}
Procedure PostacWKamizelce(xp,yp:integer;bron:byte);
begin
KolorZbroji1:=czarny;
kolorzbroji2:=szary;
if bron=0 then
                       begin
                        {NIEUZBROJONY}
                        Setcolor(kolorbutow);
                        line(xp+1,yp+29,xp+5,yp+29);
                        line(xp+2,yp+28,xp+6,yp+28);
                        line(xp+19,yp+29,xp+15,yp+29);
                        line(xp+18,yp+28,xp+14,yp+28);
                        setcolor(kolornog);
                        line(xp+4,yp+27,xp+7,yp+19);
                        line(xp+5,yp+27,xp+8,yp+19);
                        line(xp+6,yp+27,xp+9,yp+19);
                        line(xp+16,yp+27,xp+13,yp+19);
                        line(xp+15,yp+27,xp+12,yp+19);
                        line(xp+14,yp+27,xp+11,yp+19);
                        setfillstyle(1,kolorzbroji1);
                        bar(xp+8,yp+11,xp+12,yp+18);
                        setcolor(kolorzbroji2);
                        line(xp+9,yp+10,xp+9,yp+10);
                        line(xp+11,yp+10,xp+11,yp+10);
                        setcolor(kolortlowia);
                        line(xp+8,yp+10,xp+12,yp+10);
                        setcolor(kolorpaska);
                        line(xp+8,yp+17,xp+12,yp+17);
                        setcolor(kolorrak);
                        line(xp+8,yp+17,xp+7,yp+11);
                        line(xp+12,yp+17,xp+13,yp+11);
                          {rece}
                        line(xp+7,yp+10,xp+5,yp+16);
                        line(xp+6,yp+10,xp+4,yp+16);

                        line(xp+13,yp+10,xp+15,yp+16);
                        line(xp+14,yp+10,xp+16,yp+16);
                        setcolor(Zolty);
                        line(xp+4,yp+17,xp+5,yp+17);
                        line(xp+16,yp+17,xp+15,yp+17);
                          {glowa}
                        line(xp+9,yp+9,xp+11,yp+9);
                        line(xp+9,yp+8,xp+11,yp+8);
                        putpixel(xp+10,yp+10,zolty);
                        setcolor(brazowy);
                        line(xp+9,yp+8,xp+9,yp+7);
                        line(xp+11,yp+8,xp+11,yp+7);
                        line(xp+9,yp+7,xp+11,yp+7);
                       end;
                       if bron=BronDluga then
                       begin
                        {Z BRONIA DLUGA}
                        Setcolor(kolorbutow);
                        line(xp+1,yp+29,xp+5,yp+29);
                        line(xp+2,yp+28,xp+6,yp+28);
                        line(xp+19,yp+29,xp+15,yp+29);
                        line(xp+18,yp+28,xp+14,yp+28);
                        setcolor(kolornog);
                        line(xp+4,yp+27,xp+7,yp+19);
                        line(xp+5,yp+27,xp+8,yp+19);
                        line(xp+6,yp+27,xp+9,yp+19);
                        line(xp+16,yp+27,xp+13,yp+19);
                        line(xp+15,yp+27,xp+12,yp+19);
                        line(xp+14,yp+27,xp+11,yp+19);
                        setfillstyle(1,kolorzbroji1);
                        bar(xp+8,yp+11,xp+12,yp+18);
                        setcolor(kolorzbroji2);
                        line(xp+9,yp+10,xp+9,yp+10);
                        line(xp+11,yp+10,xp+11,yp+10);
                        setcolor(kolortlowia);
                        line(xp+8,yp+10,xp+12,yp+10);
                        setcolor(kolorpaska);
                        line(xp+8,yp+17,xp+12,yp+17);
                        setcolor(kolorrak);
                        line(xp+8,yp+17,xp+7,yp+11);
                        line(xp+12,yp+17,xp+13,yp+11);
                          {rece}
                        line(xp+7,yp+10,xp+4,yp+16);
                        line(xp+6,yp+10,xp+3,yp+16);

                        line(xp+13,yp+10,xp+15,yp+17);
                        line(xp+14,yp+10,xp+16,yp+17);

                        setcolor(Zolty);
                        line(xp+16,yp+18,xp+15,yp+18);
                          {Strzelba}
                        setcolor(brazowy);
                        line(xp+5,yp+15,xp+18,yp+17);
                        line(xp+6,yp+16,xp+18,yp+17);
                        line(xp+6,yp+15,xp+3,yp+18);
                        line(xp+3,yp+18,xp+7,yp+15);
                        setcolor(Zolty);
                        line(xp+3,yp+17,xp+4,yp+17);
                          {glowa}
                        line(xp+9,yp+9,xp+11,yp+9);
                        line(xp+9,yp+8,xp+11,yp+8);
                        putpixel(xp+10,yp+10,zolty);
                        setcolor(brazowy);
                        line(xp+9,yp+8,xp+9,yp+7);
                        line(xp+11,yp+8,xp+11,yp+7);
                        line(xp+9,yp+7,xp+11,yp+7);
                       end;
                       if bron=BronKrutka then
                       begin
                        {Z BRONI KROTKA}
                        Setcolor(kolorbutow);
                        line(xp+1,yp+29,xp+5,yp+29);
                        line(xp+2,yp+28,xp+6,yp+28);
                        line(xp+19,yp+29,xp+15,yp+29);
                        line(xp+18,yp+28,xp+14,yp+28);
                        setcolor(kolornog);
                        line(xp+4,yp+27,xp+7,yp+19);
                        line(xp+5,yp+27,xp+8,yp+19);
                        line(xp+6,yp+27,xp+9,yp+19);
                        line(xp+16,yp+27,xp+13,yp+19);
                        line(xp+15,yp+27,xp+12,yp+19);
                        line(xp+14,yp+27,xp+11,yp+19);
                        setfillstyle(1,kolorzbroji1);
                        bar(xp+8,yp+11,xp+12,yp+18);
                        setcolor(kolorzbroji2);
                        line(xp+9,yp+10,xp+9,yp+10);
                        line(xp+11,yp+10,xp+11,yp+10);
                        setcolor(kolortlowia);
                        line(xp+8,yp+10,xp+12,yp+10);
                        setcolor(kolorpaska);
                        line(xp+8,yp+17,xp+12,yp+17);
                        setcolor(kolorrak);
                        line(xp+8,yp+17,xp+7,yp+11);
                        line(xp+12,yp+17,xp+13,yp+11);
                          {rece}
                        line(xp+7,yp+10,xp+5,yp+16);
                        line(xp+6,yp+10,xp+4,yp+16);
                        line(xp+13,yp+10,xp+15,yp+16);
                        line(xp+14,yp+10,xp+16,yp+16);
                          {bron}
                        setcolor(czarny);
                        line(xp+5,yp+16,xp+3,yp+17);
                        line(xp+5,yp+17,xp+3,yp+18);
                        line(xp+3,yp+16,xp+3,yp+22);
                        line(xp+2,yp+16,xp+2,yp+21);
                        setcolor(Zolty);
                        line(xp+4,yp+17,xp+5,yp+17);
                        line(xp+16,yp+17,xp+15,yp+17);
                          {glowa}
                        line(xp+9,yp+9,xp+11,yp+9);
                        line(xp+9,yp+8,xp+11,yp+8);
                        putpixel(xp+10,yp+10,zolty);
                        setcolor(brazowy);
                        line(xp+9,yp+8,xp+9,yp+7);
                        line(xp+11,yp+8,xp+11,yp+7);
                        line(xp+9,yp+7,xp+11,yp+7);
                       end;
                       if bron=wlucznie then
                       begin
                        {Z WLOCZNIA}
                        Setcolor(kolorbutow);
                        line(xp+1,yp+29,xp+5,yp+29);
                        line(xp+2,yp+28,xp+6,yp+28);
                        line(xp+19,yp+29,xp+15,yp+29);
                        line(xp+18,yp+28,xp+14,yp+28);
                        setcolor(kolornog);
                        line(xp+4,yp+27,xp+7,yp+19);
                        line(xp+5,yp+27,xp+8,yp+19);
                        line(xp+6,yp+27,xp+9,yp+19);
                        line(xp+16,yp+27,xp+13,yp+19);
                        line(xp+15,yp+27,xp+12,yp+19);
                        line(xp+14,yp+27,xp+11,yp+19);
                        setfillstyle(1,kolorzbroji1);
                        bar(xp+8,yp+11,xp+12,yp+18);
                        setcolor(kolorzbroji2);
                        line(xp+9,yp+10,xp+9,yp+10);
                        line(xp+11,yp+10,xp+11,yp+10);
                        setcolor(kolortlowia);
                        line(xp+8,yp+10,xp+12,yp+10);
                        setcolor(kolorpaska);
                        line(xp+8,yp+17,xp+12,yp+17);
                        setcolor(kolorrak);
                        line(xp+8,yp+17,xp+7,yp+11);
                        line(xp+12,yp+17,xp+13,yp+11);
                          {rece}
                        line(xp+7,yp+10,xp+5,yp+16);
                        line(xp+6,yp+10,xp+4,yp+16);

                        line(xp+13,yp+10,xp+16,yp+16);
                        line(xp+14,yp+10,xp+17,yp+16);
                          {Wlocznia}
                        setcolor(czarny);
                        line(xp+17,yp+28,xp+17,yp+8);
                        setcolor(jasnyszary);
                        line(xp+16,yp+8,xp+18,yp+8);
                        line(xp+16,yp+8,xp+17,yp+7);
                        line(xp+17,yp+7,xp+18,yp+8);

                        setcolor(Zolty);
                        line(xp+4,yp+17,xp+5,yp+17);
                        line(xp+17,yp+17,xp+16,yp+17);
                          {glowa}
                        line(xp+9,yp+9,xp+11,yp+9);
                        line(xp+9,yp+8,xp+11,yp+8);
                        putpixel(xp+10,yp+10,zolty);
                        setcolor(brazowy);
                        line(xp+9,yp+8,xp+9,yp+7);
                        line(xp+11,yp+8,xp+11,yp+7);
                        line(xp+9,yp+7,xp+11,yp+7);
                       end;

end;

{=====================================================}
{=            RYSOWANIE POSTACI W KURTCE             =}
{=====================================================}
Procedure PostacWKurtce(xp,yp:integer;bron:byte);
begin
{Gosc W Kurtce, czarnej}
KolorZbroji1:=czarny;
if bron=0 then
                       begin
                        {NIEUZBROJONY}
                        Setcolor(kolorbutow);
                        line(xp+1,yp+29,xp+5,yp+29);
                        line(xp+2,yp+28,xp+6,yp+28);
                        line(xp+19,yp+29,xp+15,yp+29);
                        line(xp+18,yp+28,xp+14,yp+28);
                        setcolor(kolornog);
                        line(xp+4,yp+27,xp+7,yp+19);
                        line(xp+5,yp+27,xp+8,yp+19);
                        line(xp+6,yp+27,xp+9,yp+19);
                        line(xp+16,yp+27,xp+13,yp+19);
                        line(xp+15,yp+27,xp+12,yp+19);
                        line(xp+14,yp+27,xp+11,yp+19);
                        setfillstyle(1,kolorzbroji1);
                        bar(xp+8,yp+10,xp+12,yp+18);
                        setcolor(kolorpaska);
                        line(xp+8,yp+17,xp+12,yp+17);
                        setcolor(kolorzbroji1);
                        line(xp+8,yp+17,xp+7,yp+11);
                        line(xp+12,yp+17,xp+13,yp+11);
                          {rece}
                        line(xp+7,yp+10,xp+5,yp+16);
                        line(xp+6,yp+10,xp+4,yp+16);

                        line(xp+13,yp+10,xp+15,yp+16);
                        line(xp+14,yp+10,xp+16,yp+16);
                        setcolor(Zolty);
                        line(xp+4,yp+17,xp+5,yp+17);
                        line(xp+16,yp+17,xp+15,yp+17);
                          {glowa}
                        line(xp+9,yp+9,xp+11,yp+9);
                        line(xp+9,yp+8,xp+11,yp+8);
                        putpixel(xp+10,yp+10,zolty);
                        setcolor(brazowy);
                        line(xp+9,yp+8,xp+9,yp+7);
                        line(xp+11,yp+8,xp+11,yp+7);
                        line(xp+9,yp+7,xp+11,yp+7);
                       end;
                       if bron=BronDluga then
                       begin
                        {Z BRONIA DLUGA}
                        Setcolor(kolorbutow);
                        line(xp+1,yp+29,xp+5,yp+29);
                        line(xp+2,yp+28,xp+6,yp+28);
                        line(xp+19,yp+29,xp+15,yp+29);
                        line(xp+18,yp+28,xp+14,yp+28);
                        setcolor(kolornog);
                        line(xp+4,yp+27,xp+7,yp+19);
                        line(xp+5,yp+27,xp+8,yp+19);
                        line(xp+6,yp+27,xp+9,yp+19);
                        line(xp+16,yp+27,xp+13,yp+19);
                        line(xp+15,yp+27,xp+12,yp+19);
                        line(xp+14,yp+27,xp+11,yp+19);
                        setfillstyle(1,kolorzbroji1);
                        bar(xp+8,yp+10,xp+12,yp+18);
                        setcolor(kolorpaska);
                        line(xp+8,yp+17,xp+12,yp+17);
                        setcolor(kolorzbroji1);
                        line(xp+8,yp+17,xp+7,yp+11);
                        line(xp+12,yp+17,xp+13,yp+11);
                          {rece}
                        line(xp+7,yp+10,xp+4,yp+16);
                        line(xp+6,yp+10,xp+3,yp+16);

                        line(xp+13,yp+10,xp+15,yp+17);
                        line(xp+14,yp+10,xp+16,yp+17);

                        setcolor(Zolty);
                        line(xp+16,yp+18,xp+15,yp+18);
                          {Strzelba}
                        setcolor(brazowy);
                        line(xp+5,yp+15,xp+18,yp+17);
                        line(xp+6,yp+16,xp+18,yp+17);
                        line(xp+6,yp+15,xp+3,yp+18);
                        line(xp+3,yp+18,xp+7,yp+15);
                        setcolor(Zolty);
                        line(xp+3,yp+17,xp+4,yp+17);
                          {glowa}
                        line(xp+9,yp+9,xp+11,yp+9);
                        line(xp+9,yp+8,xp+11,yp+8);
                        putpixel(xp+10,yp+10,zolty);
                        setcolor(brazowy);
                        line(xp+9,yp+8,xp+9,yp+7);
                        line(xp+11,yp+8,xp+11,yp+7);
                        line(xp+9,yp+7,xp+11,yp+7);
                       end;
                       if bron=BronKrutka then
                       begin
                        {Z BRONI KROTKA}
                        Setcolor(kolorbutow);
                        line(xp+1,yp+29,xp+5,yp+29);
                        line(xp+2,yp+28,xp+6,yp+28);
                        line(xp+19,yp+29,xp+15,yp+29);
                        line(xp+18,yp+28,xp+14,yp+28);
                        setcolor(kolornog);
                        line(xp+4,yp+27,xp+7,yp+19);
                        line(xp+5,yp+27,xp+8,yp+19);
                        line(xp+6,yp+27,xp+9,yp+19);
                        line(xp+16,yp+27,xp+13,yp+19);
                        line(xp+15,yp+27,xp+12,yp+19);
                        line(xp+14,yp+27,xp+11,yp+19);
                        setfillstyle(1,kolorzbroji1);
                        bar(xp+8,yp+10,xp+12,yp+18);
                        setcolor(kolorpaska);
                        line(xp+8,yp+17,xp+12,yp+17);
                        setcolor(kolorzbroji1);
                        line(xp+8,yp+17,xp+7,yp+11);
                        line(xp+12,yp+17,xp+13,yp+11);
                          {rece}
                        line(xp+7,yp+10,xp+5,yp+16);
                        line(xp+6,yp+10,xp+4,yp+16);
                        line(xp+13,yp+10,xp+15,yp+16);
                        line(xp+14,yp+10,xp+16,yp+16);
                          {bron}
                        setcolor(czarny);
                        line(xp+5,yp+16,xp+3,yp+17);
                        line(xp+5,yp+17,xp+3,yp+18);
                        line(xp+3,yp+16,xp+3,yp+22);
                        line(xp+2,yp+16,xp+2,yp+21);
                        setcolor(Zolty);
                        line(xp+4,yp+17,xp+5,yp+17);
                        line(xp+16,yp+17,xp+15,yp+17);
                          {glowa}
                        line(xp+9,yp+9,xp+11,yp+9);
                        line(xp+9,yp+8,xp+11,yp+8);
                        putpixel(xp+10,yp+10,zolty);
                        setcolor(brazowy);
                        line(xp+9,yp+8,xp+9,yp+7);
                        line(xp+11,yp+8,xp+11,yp+7);
                        line(xp+9,yp+7,xp+11,yp+7);
                       end;
                       if bron=wlucznie then
                       begin
                        {Z WLOCZNIA}
                        Setcolor(kolorbutow);
                        line(xp+1,yp+29,xp+5,yp+29);
                        line(xp+2,yp+28,xp+6,yp+28);
                        line(xp+19,yp+29,xp+15,yp+29);
                        line(xp+18,yp+28,xp+14,yp+28);
                        setcolor(kolornog);
                        line(xp+4,yp+27,xp+7,yp+19);
                        line(xp+5,yp+27,xp+8,yp+19);
                        line(xp+6,yp+27,xp+9,yp+19);
                        line(xp+16,yp+27,xp+13,yp+19);
                        line(xp+15,yp+27,xp+12,yp+19);
                        line(xp+14,yp+27,xp+11,yp+19);
                        setfillstyle(1,kolorzbroji1);
                        bar(xp+8,yp+10,xp+12,yp+18);
                        setcolor(kolorpaska);
                        line(xp+8,yp+17,xp+12,yp+17);
                        setcolor(kolorzbroji1);
                        line(xp+8,yp+17,xp+7,yp+11);
                        line(xp+12,yp+17,xp+13,yp+11);
                          {rece}
                        line(xp+7,yp+10,xp+5,yp+16);
                        line(xp+6,yp+10,xp+4,yp+16);

                        line(xp+13,yp+10,xp+16,yp+16);
                        line(xp+14,yp+10,xp+17,yp+16);
                          {Wlocznia}
                        setcolor(czarny);
                        line(xp+17,yp+28,xp+17,yp+8);
                        setcolor(jasnyszary);
                        line(xp+16,yp+8,xp+18,yp+8);
                        line(xp+16,yp+8,xp+17,yp+7);
                        line(xp+17,yp+7,xp+18,yp+8);

                        setcolor(Zolty);
                        line(xp+4,yp+17,xp+5,yp+17);
                        line(xp+17,yp+17,xp+16,yp+17);
                          {glowa}
                        line(xp+9,yp+9,xp+11,yp+9);
                        line(xp+9,yp+8,xp+11,yp+8);
                        putpixel(xp+10,yp+10,zolty);
                        setcolor(brazowy);
                        line(xp+9,yp+8,xp+9,yp+7);
                        line(xp+11,yp+8,xp+11,yp+7);
                        line(xp+9,yp+7,xp+11,yp+7);
                       end;

end;
{=====================================================}
{=            RYSOWANIE POSTACI W DUZEJ ZBROJI       =}
{=====================================================}
Procedure PostacWDuzejZbroji(xp,yp:integer;bron:byte);
begin
KolorZbroji1:=czarny;
KolorZbroji2:=szary;
if bron=0 then
                       begin
                        {NIEUZBROJONY}
                        Setcolor(czarny);
                        line(xp+1,yp+29,xp+5,yp+29);
                        line(xp+2,yp+28,xp+6,yp+28);
                        line(xp+19,yp+29,xp+15,yp+29);
                        line(xp+18,yp+28,xp+14,yp+28);
                        setcolor(kolorzbroji2);
                        line(xp+4,yp+27,xp+7,yp+19);
                        line(xp+5,yp+27,xp+8,yp+19);
                        line(xp+6,yp+27,xp+9,yp+19);
                        line(xp+16,yp+27,xp+13,yp+19);
                        line(xp+15,yp+27,xp+12,yp+19);
                        line(xp+14,yp+27,xp+11,yp+19);
                        setfillstyle(1,kolorzbroji2);
                        bar(xp+8,yp+10,xp+12,yp+18);
                        setcolor(czarny);
                        line(xp+8,yp+17,xp+12,yp+17);
                        setcolor(kolorzbroji1);
                        line(xp+8,yp+17,xp+7,yp+11);
                        line(xp+12,yp+17,xp+13,yp+11);
                          {rece}
                        line(xp+7,yp+10,xp+5,yp+16);
                        line(xp+6,yp+10,xp+4,yp+16);

                        line(xp+13,yp+10,xp+15,yp+16);
                        line(xp+14,yp+10,xp+16,yp+16);
                        setcolor(Zolty);
                        line(xp+4,yp+17,xp+5,yp+17);
                        line(xp+16,yp+17,xp+15,yp+17);
                          {glowa}
                        line(xp+9,yp+9,xp+11,yp+9);
                        line(xp+9,yp+8,xp+11,yp+8);
                        putpixel(xp+10,yp+10,zolty);
                        setcolor(szary);
                        line(xp+9,yp+8,xp+9,yp+7);
                        line(xp+11,yp+8,xp+11,yp+7);
                        line(xp+9,yp+7,xp+11,yp+7);
                       end;
                       if bron=BronDluga then
                       begin
                        {Z BRONIA DLUGA}
                        Setcolor(czarny);
                        line(xp+1,yp+29,xp+5,yp+29);
                        line(xp+2,yp+28,xp+6,yp+28);
                        line(xp+19,yp+29,xp+15,yp+29);
                        line(xp+18,yp+28,xp+14,yp+28);
                        setcolor(kolorzbroji2);
                        line(xp+4,yp+27,xp+7,yp+19);
                        line(xp+5,yp+27,xp+8,yp+19);
                        line(xp+6,yp+27,xp+9,yp+19);
                        line(xp+16,yp+27,xp+13,yp+19);
                        line(xp+15,yp+27,xp+12,yp+19);
                        line(xp+14,yp+27,xp+11,yp+19);
                        setfillstyle(1,kolorzbroji2);
                        bar(xp+8,yp+10,xp+12,yp+18);
                        setcolor(czarny);
                        line(xp+8,yp+17,xp+12,yp+17);
                        setcolor(kolorzbroji1);
                        line(xp+8,yp+17,xp+7,yp+11);
                        line(xp+12,yp+17,xp+13,yp+11);
                          {rece}
                        line(xp+7,yp+10,xp+4,yp+16);
                        line(xp+6,yp+10,xp+3,yp+16);

                        line(xp+13,yp+10,xp+15,yp+17);
                        line(xp+14,yp+10,xp+16,yp+17);

                        setcolor(Zolty);
                        line(xp+16,yp+18,xp+15,yp+18);
                          {Strzelba}
                        setcolor(brazowy);
                        line(xp+5,yp+15,xp+18,yp+17);
                        line(xp+6,yp+16,xp+18,yp+17);
                        line(xp+6,yp+15,xp+3,yp+18);
                        line(xp+3,yp+18,xp+7,yp+15);
                        setcolor(Zolty);
                        line(xp+3,yp+17,xp+4,yp+17);
                          {glowa}
                        line(xp+9,yp+9,xp+11,yp+9);
                        line(xp+9,yp+8,xp+11,yp+8);
                        putpixel(xp+10,yp+10,zolty);
                        setcolor(szary);
                        line(xp+9,yp+8,xp+9,yp+7);
                        line(xp+11,yp+8,xp+11,yp+7);
                        line(xp+9,yp+7,xp+11,yp+7);
                       end;
                       if bron=BronKrutka then
                       begin
                        {Z BRONI KROTKA}
                        Setcolor(czarny);
                        line(xp+1,yp+29,xp+5,yp+29);
                        line(xp+2,yp+28,xp+6,yp+28);
                        line(xp+19,yp+29,xp+15,yp+29);
                        line(xp+18,yp+28,xp+14,yp+28);
                        setcolor(kolorzbroji2);
                        line(xp+4,yp+27,xp+7,yp+19);
                        line(xp+5,yp+27,xp+8,yp+19);
                        line(xp+6,yp+27,xp+9,yp+19);
                        line(xp+16,yp+27,xp+13,yp+19);
                        line(xp+15,yp+27,xp+12,yp+19);
                        line(xp+14,yp+27,xp+11,yp+19);
                        setfillstyle(1,kolorzbroji2);
                        bar(xp+8,yp+10,xp+12,yp+18);
                        setcolor(czarny);
                        line(xp+8,yp+17,xp+12,yp+17);
                        setcolor(kolorzbroji1);
                        line(xp+8,yp+17,xp+7,yp+11);
                        line(xp+12,yp+17,xp+13,yp+11);
                          {rece}
                        line(xp+7,yp+10,xp+5,yp+16);
                        line(xp+6,yp+10,xp+4,yp+16);
                        line(xp+13,yp+10,xp+15,yp+16);
                        line(xp+14,yp+10,xp+16,yp+16);
                          {bron}
                        setcolor(czarny);
                        line(xp+5,yp+16,xp+3,yp+17);
                        line(xp+5,yp+17,xp+3,yp+18);
                        line(xp+3,yp+16,xp+3,yp+22);
                        line(xp+2,yp+16,xp+2,yp+21);
                        setcolor(Zolty);
                        line(xp+4,yp+17,xp+5,yp+17);
                        line(xp+16,yp+17,xp+15,yp+17);
                          {glowa}
                        line(xp+9,yp+9,xp+11,yp+9);
                        line(xp+9,yp+8,xp+11,yp+8);
                        putpixel(xp+10,yp+10,zolty);
                        setcolor(szary);
                        line(xp+9,yp+8,xp+9,yp+7);
                        line(xp+11,yp+8,xp+11,yp+7);
                        line(xp+9,yp+7,xp+11,yp+7);
                       end;
                       if bron=wlucznie then
                       begin
                        {Z WLOCZNIA}
                        Setcolor(czarny);
                        line(xp+1,yp+29,xp+5,yp+29);
                        line(xp+2,yp+28,xp+6,yp+28);
                        line(xp+19,yp+29,xp+15,yp+29);
                        line(xp+18,yp+28,xp+14,yp+28);
                        setcolor(kolorzbroji2);
                        line(xp+4,yp+27,xp+7,yp+19);
                        line(xp+5,yp+27,xp+8,yp+19);
                        line(xp+6,yp+27,xp+9,yp+19);
                        line(xp+16,yp+27,xp+13,yp+19);
                        line(xp+15,yp+27,xp+12,yp+19);
                        line(xp+14,yp+27,xp+11,yp+19);
                        setfillstyle(1,kolorzbroji2);
                        bar(xp+8,yp+10,xp+12,yp+18);
                        setcolor(czarny);
                        line(xp+8,yp+17,xp+12,yp+17);
                        setcolor(kolorzbroji1);
                        line(xp+8,yp+17,xp+7,yp+11);
                        line(xp+12,yp+17,xp+13,yp+11);
                          {rece}
                        line(xp+7,yp+10,xp+5,yp+16);
                        line(xp+6,yp+10,xp+4,yp+16);

                        line(xp+13,yp+10,xp+16,yp+16);
                        line(xp+14,yp+10,xp+17,yp+16);
                          {Wlocznia}
                        setcolor(czarny);
                        line(xp+17,yp+28,xp+17,yp+8);
                        setcolor(jasnyszary);
                        line(xp+16,yp+8,xp+18,yp+8);
                        line(xp+16,yp+8,xp+17,yp+7);
                        line(xp+17,yp+7,xp+18,yp+8);

                        setcolor(Zolty);
                        line(xp+4,yp+17,xp+5,yp+17);
                        line(xp+17,yp+17,xp+16,yp+17);
                          {glowa}
                        line(xp+9,yp+9,xp+11,yp+9);
                        line(xp+9,yp+8,xp+11,yp+8);
                        putpixel(xp+10,yp+10,zolty);
                        setcolor(szary);
                        line(xp+9,yp+8,xp+9,yp+7);
                        line(xp+11,yp+8,xp+11,yp+7);
                        line(xp+9,yp+7,xp+11,yp+7);
                       end;

end;

{=====================================================}
{=            RYSOWANIE POSTACI W PANCERZU           =}
{=====================================================}
Procedure PostacWPancerzu(xp,yp:integer;bron:byte);
begin
KolorZbroji1:=czarny;
KolorZbroji2:=szary;
if bron=0 then
                       begin
                        {NIEUZBROJONY}
                        Setcolor(kolorbutow);
                        line(xp+1,yp+29,xp+5,yp+29);
                        line(xp+2,yp+28,xp+6,yp+28);
                        line(xp+19,yp+29,xp+15,yp+29);
                        line(xp+18,yp+28,xp+14,yp+28);
                        setcolor(kolornog);
                        line(xp+4,yp+27,xp+7,yp+19);
                        line(xp+5,yp+27,xp+8,yp+19);
                        line(xp+6,yp+27,xp+9,yp+19);
                        line(xp+16,yp+27,xp+13,yp+19);
                        line(xp+15,yp+27,xp+12,yp+19);
                        line(xp+14,yp+27,xp+11,yp+19);
                        setfillstyle(1,kolorzbroji1);
                        bar(xp+8,yp+10,xp+12,yp+18);
                        setcolor(kolorpaska);
                        line(xp+8,yp+17,xp+12,yp+17);
                        setcolor(kolorzbroji2);
                        line(xp+8,yp+17,xp+7,yp+11);
                        line(xp+12,yp+17,xp+13,yp+11);
                          {rece}
                        line(xp+7,yp+10,xp+5,yp+16);
                        line(xp+6,yp+10,xp+4,yp+16);

                        line(xp+13,yp+10,xp+15,yp+16);
                        line(xp+14,yp+10,xp+16,yp+16);
                        setcolor(Zolty);
                        line(xp+4,yp+17,xp+5,yp+17);
                        line(xp+16,yp+17,xp+15,yp+17);
                          {glowa}
                        line(xp+9,yp+9,xp+11,yp+9);
                        line(xp+9,yp+8,xp+11,yp+8);
                        putpixel(xp+10,yp+10,zolty);
                        setcolor(brazowy);
                        line(xp+9,yp+8,xp+9,yp+7);
                        line(xp+11,yp+8,xp+11,yp+7);
                        line(xp+9,yp+7,xp+11,yp+7);
                       end;
                       if bron=BronDluga then
                       begin
                        {Z BRONIA DLUGA}
                        Setcolor(kolorbutow);
                        line(xp+1,yp+29,xp+5,yp+29);
                        line(xp+2,yp+28,xp+6,yp+28);
                        line(xp+19,yp+29,xp+15,yp+29);
                        line(xp+18,yp+28,xp+14,yp+28);
                        setcolor(kolornog);
                        line(xp+4,yp+27,xp+7,yp+19);
                        line(xp+5,yp+27,xp+8,yp+19);
                        line(xp+6,yp+27,xp+9,yp+19);
                        line(xp+16,yp+27,xp+13,yp+19);
                        line(xp+15,yp+27,xp+12,yp+19);
                        line(xp+14,yp+27,xp+11,yp+19);
                        setfillstyle(1,kolorzbroji1);
                        bar(xp+8,yp+10,xp+12,yp+18);
                        setcolor(kolorpaska);
                        line(xp+8,yp+17,xp+12,yp+17);
                        setcolor(kolorzbroji2);
                        line(xp+8,yp+17,xp+7,yp+11);
                        line(xp+12,yp+17,xp+13,yp+11);
                          {rece}
                        line(xp+7,yp+10,xp+4,yp+16);
                        line(xp+6,yp+10,xp+3,yp+16);

                        line(xp+13,yp+10,xp+15,yp+17);
                        line(xp+14,yp+10,xp+16,yp+17);

                        setcolor(Zolty);
                        line(xp+16,yp+18,xp+15,yp+18);
                          {Strzelba}
                        setcolor(brazowy);
                        line(xp+5,yp+15,xp+18,yp+17);
                        line(xp+6,yp+16,xp+18,yp+17);
                        line(xp+6,yp+15,xp+3,yp+18);
                        line(xp+3,yp+18,xp+7,yp+15);
                        setcolor(Zolty);
                        line(xp+3,yp+17,xp+4,yp+17);
                          {glowa}
                        line(xp+9,yp+9,xp+11,yp+9);
                        line(xp+9,yp+8,xp+11,yp+8);
                        putpixel(xp+10,yp+10,zolty);
                        setcolor(brazowy);
                        line(xp+9,yp+8,xp+9,yp+7);
                        line(xp+11,yp+8,xp+11,yp+7);
                        line(xp+9,yp+7,xp+11,yp+7);
                       end;
                       if bron=BronKrutka then
                       begin
                        {Z BRONI KROTKA}
                        Setcolor(kolorbutow);
                        line(xp+1,yp+29,xp+5,yp+29);
                        line(xp+2,yp+28,xp+6,yp+28);
                        line(xp+19,yp+29,xp+15,yp+29);
                        line(xp+18,yp+28,xp+14,yp+28);
                        setcolor(kolornog);
                        line(xp+4,yp+27,xp+7,yp+19);
                        line(xp+5,yp+27,xp+8,yp+19);
                        line(xp+6,yp+27,xp+9,yp+19);
                        line(xp+16,yp+27,xp+13,yp+19);
                        line(xp+15,yp+27,xp+12,yp+19);
                        line(xp+14,yp+27,xp+11,yp+19);
                        setfillstyle(1,kolorzbroji1);
                        bar(xp+8,yp+10,xp+12,yp+18);
                        setcolor(kolorpaska);
                        line(xp+8,yp+17,xp+12,yp+17);
                        setcolor(kolorzbroji2);
                        line(xp+8,yp+17,xp+7,yp+11);
                        line(xp+12,yp+17,xp+13,yp+11);
                          {rece}
                        line(xp+7,yp+10,xp+5,yp+16);
                        line(xp+6,yp+10,xp+4,yp+16);
                        line(xp+13,yp+10,xp+15,yp+16);
                        line(xp+14,yp+10,xp+16,yp+16);
                          {bron}
                        setcolor(czarny);
                        line(xp+5,yp+16,xp+3,yp+17);
                        line(xp+5,yp+17,xp+3,yp+18);
                        line(xp+3,yp+16,xp+3,yp+22);
                        line(xp+2,yp+16,xp+2,yp+21);
                        setcolor(Zolty);
                        line(xp+4,yp+17,xp+5,yp+17);
                        line(xp+16,yp+17,xp+15,yp+17);
                          {glowa}
                        line(xp+9,yp+9,xp+11,yp+9);
                        line(xp+9,yp+8,xp+11,yp+8);
                        putpixel(xp+10,yp+10,zolty);
                        setcolor(brazowy);
                        line(xp+9,yp+8,xp+9,yp+7);
                        line(xp+11,yp+8,xp+11,yp+7);
                        line(xp+9,yp+7,xp+11,yp+7);
                       end;
                       if bron=wlucznie then
                       begin
                        {Z WLOCZNIA}
                        Setcolor(kolorbutow);
                        line(xp+1,yp+29,xp+5,yp+29);
                        line(xp+2,yp+28,xp+6,yp+28);
                        line(xp+19,yp+29,xp+15,yp+29);
                        line(xp+18,yp+28,xp+14,yp+28);
                        setcolor(kolornog);
                        line(xp+4,yp+27,xp+7,yp+19);
                        line(xp+5,yp+27,xp+8,yp+19);
                        line(xp+6,yp+27,xp+9,yp+19);
                        line(xp+16,yp+27,xp+13,yp+19);
                        line(xp+15,yp+27,xp+12,yp+19);
                        line(xp+14,yp+27,xp+11,yp+19);
                        setfillstyle(1,kolorzbroji1);
                        bar(xp+8,yp+10,xp+12,yp+18);
                        setcolor(kolorpaska);
                        line(xp+8,yp+17,xp+12,yp+17);
                        setcolor(kolorzbroji2);
                        line(xp+8,yp+17,xp+7,yp+11);
                        line(xp+12,yp+17,xp+13,yp+11);
                          {rece}
                        line(xp+7,yp+10,xp+5,yp+16);
                        line(xp+6,yp+10,xp+4,yp+16);

                        line(xp+13,yp+10,xp+16,yp+16);
                        line(xp+14,yp+10,xp+17,yp+16);
                          {Wlocznia}
                        setcolor(czarny);
                        line(xp+17,yp+28,xp+17,yp+8);
                        setcolor(jasnyszary);
                        line(xp+16,yp+8,xp+18,yp+8);
                        line(xp+16,yp+8,xp+17,yp+7);
                        line(xp+17,yp+7,xp+18,yp+8);

                        setcolor(Zolty);
                        line(xp+4,yp+17,xp+5,yp+17);
                        line(xp+17,yp+17,xp+16,yp+17);
                          {glowa}
                        line(xp+9,yp+9,xp+11,yp+9);
                        line(xp+9,yp+8,xp+11,yp+8);
                        putpixel(xp+10,yp+10,zolty);
                        setcolor(brazowy);
                        line(xp+9,yp+8,xp+9,yp+7);
                        line(xp+11,yp+8,xp+11,yp+7);
                        line(xp+9,yp+7,xp+11,yp+7);
                       end;

end;

{====================================================================}
{=    RYSOWANIE POSTACI NA PODSTAWIE PODANYCH DANYCH O KOLORACH     =}
{====================================================================}
Procedure PostacBezZbroji(xp,yp:integer; bron:byte);
begin
if bron=0 then
                       begin
                        {NIEUZBROJONY}
                        Setcolor(kolorbutow);
                        line(xp+1,yp+29,xp+5,yp+29);
                        line(xp+2,yp+28,xp+6,yp+28);
                        line(xp+19,yp+29,xp+15,yp+29);
                        line(xp+18,yp+28,xp+14,yp+28);
                        setcolor(kolornog);
                        line(xp+4,yp+27,xp+7,yp+19);
                        line(xp+5,yp+27,xp+8,yp+19);
                        line(xp+6,yp+27,xp+9,yp+19);
                        line(xp+16,yp+27,xp+13,yp+19);
                        line(xp+15,yp+27,xp+12,yp+19);
                        line(xp+14,yp+27,xp+11,yp+19);
                        setfillstyle(1,kolortlowia);
                        bar(xp+8,yp+10,xp+12,yp+18);
                        setcolor(kolorpaska);
                        line(xp+8,yp+17,xp+12,yp+17);
                        setcolor(kolortlowia);
                        line(xp+8,yp+17,xp+7,yp+11);
                        line(xp+12,yp+17,xp+13,yp+11);
                        setcolor(kolorrak);
                          {rece}
                        line(xp+7,yp+10,xp+5,yp+16);
                        line(xp+6,yp+10,xp+4,yp+16);

                        line(xp+13,yp+10,xp+15,yp+16);
                        line(xp+14,yp+10,xp+16,yp+16);

                        setcolor(Zolty);
                        line(xp+4,yp+17,xp+5,yp+17);
                        line(xp+16,yp+17,xp+15,yp+17);
                          {glowa}
                        line(xp+9,yp+9,xp+11,yp+9);
                        line(xp+9,yp+8,xp+11,yp+8);
                        putpixel(xp+10,yp+10,zolty);
                        setcolor(brazowy);
                        line(xp+9,yp+8,xp+9,yp+7);
                        line(xp+11,yp+8,xp+11,yp+7);
                        line(xp+9,yp+7,xp+11,yp+7);
                       end;
if bron=BronDluga then
                       begin
                        {Z BRONIA DLUGA}
                        Setcolor(kolorbutow);
                        line(xp+1,yp+29,xp+5,yp+29);
                        line(xp+2,yp+28,xp+6,yp+28);
                        line(xp+19,yp+29,xp+15,yp+29);
                        line(xp+18,yp+28,xp+14,yp+28);
                        setcolor(kolornog);
                        line(xp+4,yp+27,xp+7,yp+19);
                        line(xp+5,yp+27,xp+8,yp+19);
                        line(xp+6,yp+27,xp+9,yp+19);
                        line(xp+16,yp+27,xp+13,yp+19);
                        line(xp+15,yp+27,xp+12,yp+19);
                        line(xp+14,yp+27,xp+11,yp+19);
                        setfillstyle(1,kolortlowia);
                        bar(xp+8,yp+10,xp+12,yp+18);
                        setcolor(kolorpaska);
                        line(xp+8,yp+17,xp+12,yp+17);
                        setcolor(Kolortlowia);
                        line(xp+8,yp+17,xp+7,yp+11);
                        line(xp+12,yp+17,xp+13,yp+11);
                        setcolor(kolorrak);
                          {rece}
                        line(xp+7,yp+10,xp+4,yp+16);
                        line(xp+6,yp+10,xp+3,yp+16);

                        line(xp+13,yp+10,xp+15,yp+17);
                        line(xp+14,yp+10,xp+16,yp+17);

                        setcolor(Zolty);
                        line(xp+16,yp+18,xp+15,yp+18);
                          {Strzelba}
                        setcolor(brazowy);
                        line(xp+5,yp+15,xp+18,yp+17);
                        line(xp+6,yp+16,xp+18,yp+17);
                        line(xp+6,yp+15,xp+3,yp+18);
                        line(xp+3,yp+18,xp+7,yp+15);
                        setcolor(Zolty);
                        line(xp+3,yp+17,xp+4,yp+17);
                          {glowa}
                        line(xp+9,yp+9,xp+11,yp+9);
                        line(xp+9,yp+8,xp+11,yp+8);
                        putpixel(xp+10,yp+10,zolty);
                        setcolor(brazowy);
                        line(xp+9,yp+8,xp+9,yp+7);
                        line(xp+11,yp+8,xp+11,yp+7);
                        line(xp+9,yp+7,xp+11,yp+7);
                       end;
if bron=bronkrutka then
                       begin
                        {Z BRONI KROTKA}
                        Setcolor(kolorbutow);
                        line(xp+1,yp+29,xp+5,yp+29);
                        line(xp+2,yp+28,xp+6,yp+28);
                        line(xp+19,yp+29,xp+15,yp+29);
                        line(xp+18,yp+28,xp+14,yp+28);
                        setcolor(kolornog);
                        line(xp+4,yp+27,xp+7,yp+19);
                        line(xp+5,yp+27,xp+8,yp+19);
                        line(xp+6,yp+27,xp+9,yp+19);
                        line(xp+16,yp+27,xp+13,yp+19);
                        line(xp+15,yp+27,xp+12,yp+19);
                        line(xp+14,yp+27,xp+11,yp+19);
                        setfillstyle(1,kolortlowia);
                        bar(xp+8,yp+10,xp+12,yp+18);
                        setcolor(kolorpaska);
                        line(xp+8,yp+17,xp+12,yp+17);
                        setcolor(kolortlowia);
                        line(xp+8,yp+17,xp+7,yp+11);
                        line(xp+12,yp+17,xp+13,yp+11);
                        setcolor(kolorrak);
                          {rece}
                        line(xp+7,yp+10,xp+5,yp+16);
                        line(xp+6,yp+10,xp+4,yp+16);
                        line(xp+13,yp+10,xp+15,yp+16);
                        line(xp+14,yp+10,xp+16,yp+16);
                          {bron}
                        setcolor(czarny);
                        line(xp+5,yp+16,xp+3,yp+17);
                        line(xp+5,yp+17,xp+3,yp+18);
                        line(xp+3,yp+16,xp+3,yp+22);
                        line(xp+2,yp+16,xp+2,yp+21);
                        setcolor(Zolty);
                        line(xp+4,yp+17,xp+5,yp+17);
                        line(xp+16,yp+17,xp+15,yp+17);
                          {glowa}
                        line(xp+9,yp+9,xp+11,yp+9);
                        line(xp+9,yp+8,xp+11,yp+8);
                        putpixel(xp+10,yp+10,zolty);
                        setcolor(brazowy);
                        line(xp+9,yp+8,xp+9,yp+7);
                        line(xp+11,yp+8,xp+11,yp+7);
                        line(xp+9,yp+7,xp+11,yp+7);
                       end;
if bron=wlucznie then
                       begin
                        {Z WLOCZNIA}
                        Setcolor(kolorbutow);
                        line(xp+1,yp+29,xp+5,yp+29);
                        line(xp+2,yp+28,xp+6,yp+28);
                        line(xp+19,yp+29,xp+15,yp+29);
                        line(xp+18,yp+28,xp+14,yp+28);
                        setcolor(kolornog);
                        line(xp+4,yp+27,xp+7,yp+19);
                        line(xp+5,yp+27,xp+8,yp+19);
                        line(xp+6,yp+27,xp+9,yp+19);
                        line(xp+16,yp+27,xp+13,yp+19);
                        line(xp+15,yp+27,xp+12,yp+19);
                        line(xp+14,yp+27,xp+11,yp+19);
                        setfillstyle(1,kolortlowia);
                        bar(xp+8,yp+10,xp+12,yp+18);
                        setcolor(kolorpaska);
                        line(xp+8,yp+17,xp+12,yp+17);
                        setcolor(kolortlowia);
                        line(xp+8,yp+17,xp+7,yp+11);
                        line(xp+12,yp+17,xp+13,yp+11);
                        setcolor(kolorrak);
                          {rece}
                        line(xp+7,yp+10,xp+5,yp+16);
                        line(xp+6,yp+10,xp+4,yp+16);

                        line(xp+13,yp+10,xp+16,yp+16);
                        line(xp+14,yp+10,xp+17,yp+16);
                          {Wlocznia}
                        setcolor(czarny);
                        line(xp+17,yp+28,xp+17,yp+8);
                        setcolor(jasnyszary);
                        line(xp+16,yp+8,xp+18,yp+8);
                        line(xp+16,yp+8,xp+17,yp+7);
                        line(xp+17,yp+7,xp+18,yp+8);

                        setcolor(Zolty);
                        line(xp+4,yp+17,xp+5,yp+17);
                        line(xp+17,yp+17,xp+16,yp+17);
                          {glowa}
                        line(xp+9,yp+9,xp+11,yp+9);
                        line(xp+9,yp+8,xp+11,yp+8);
                        putpixel(xp+10,yp+10,zolty);
                        setcolor(brazowy);
                        line(xp+9,yp+8,xp+9,yp+7);
                        line(xp+11,yp+8,xp+11,yp+7);
                        line(xp+9,yp+7,xp+11,yp+7);
                       end;
end;

{=============================================}
{=             RYSOWANIE POSTACI             =}
{=============================================}
Procedure RysujPostac(xp,yp:integer;Typ,bron,zbroja:byte);
begin
{setfillstyle(1,yellow);
bar(xp,yp,xp+20,yp+30);}
if typ=1 then
          begin
           KolorNog:=niebieski;
           KolorRak:=niebieski;
           KolorTlowia:=niebieski;
           KolorPaska:=zolty;
           KolorButow:=brazowy;
           if zbroja=0 then PostacBezZbroji(xp,yp,bron);
           if zbroja=kurtka then PostacWKurtce(xp,yp,bron);
           if zbroja=Kamizelka then PostacWKamizelce(xp,yp,bron);
           if zbroja=ZBPancerz then PostacWPancerzu(xp,yp,bron);
           if zbroja=DuzaZbroja then PostacWDuzejZbroji(xp,yp,bron);
          end;
if typ=0 then
          begin
           KolorNog:=dziwnyniebieski;
           KolorRak:=ciemnydziwnyniebieski;
           KolorTlowia:=dziwnyniebieski;
           KolorPaska:=bialy;
           KolorButow:=czarny;
           if zbroja=0 then PostacBezZbroji(xp,yp,bron);
           if zbroja=kurtka then PostacWKurtce(xp,yp,bron);
           if zbroja=Kamizelka then PostacWKamizelce(xp,yp,bron);
           if zbroja=ZBPancerz then PostacWPancerzu(xp,yp,bron);
           if zbroja=DuzaZbroja then PostacWDuzejZbroji(xp,yp,bron);
          end;
if typ=2 then
          begin
           KolorNog:=niebieski;
           KolorRak:=czerwony;
           KolorTlowia:=czerwony;
           KolorPaska:=brazowy;
           KolorButow:=brazowy;
           if zbroja=0 then PostacBezZbroji(xp,yp,bron);
           if zbroja=kurtka then PostacWKurtce(xp,yp,bron);
           if zbroja=Kamizelka then PostacWKamizelce(xp,yp,bron);
           if zbroja=ZBPancerz then PostacWPancerzu(xp,yp,bron);
           if zbroja=DuzaZbroja then PostacWDuzejZbroji(xp,yp,bron);
          end;
if typ=3 then
          begin
           KolorNog:=jasnyszary;
           KolorRak:=jasnyniebieski;
           KolorTlowia:=jasnyniebieski;
           KolorPaska:=brazowy;
           KolorButow:=czarny;
           if zbroja=0 then PostacBezZbroji(xp,yp,bron);
           if zbroja=kurtka then PostacWKurtce(xp,yp,bron);
           if zbroja=Kamizelka then PostacWKamizelce(xp,yp,bron);
           if zbroja=ZBPancerz then PostacWPancerzu(xp,yp,bron);
           if zbroja=DuzaZbroja then PostacWDuzejZbroji(xp,yp,bron);
          end;
if typ=4 then
          begin
           KolorNog:=czerwony;
           KolorRak:=brazowy;
           KolorTlowia:=brazowy;
           KolorPaska:=czarny;
           KolorButow:=czarny;
           if zbroja=0 then PostacBezZbroji(xp,yp,bron);
           if zbroja=kurtka then PostacWKurtce(xp,yp,bron);
           if zbroja=Kamizelka then PostacWKamizelce(xp,yp,bron);
           if zbroja=ZBPancerz then PostacWPancerzu(xp,yp,bron);
           if zbroja=DuzaZbroja then PostacWDuzejZbroji(xp,yp,bron);
          end;
if typ=5 then
          begin
           KolorNog:=jasnyniebieski;
           KolorRak:=fioletowy;
           KolorTlowia:=fioletowy;
           KolorPaska:=brazowy;
           KolorButow:=czarny;
           if zbroja=0 then PostacBezZbroji(xp,yp,bron);
           if zbroja=kurtka then PostacWKurtce(xp,yp,bron);
           if zbroja=Kamizelka then PostacWKamizelce(xp,yp,bron);
           if zbroja=ZBPancerz then PostacWPancerzu(xp,yp,bron);
           if zbroja=DuzaZbroja then PostacWDuzejZbroji(xp,yp,bron);
          end;
if typ=6 then
          begin
           KolorNog:=szary;
           KolorRak:=szary;
           KolorTlowia:=jasnyszary;
           KolorPaska:=czarny;
           KolorButow:=czarny;
           if zbroja=0 then PostacBezZbroji(xp,yp,bron);
           if zbroja=kurtka then PostacWKurtce(xp,yp,bron);
           if zbroja=Kamizelka then PostacWKamizelce(xp,yp,bron);
           if zbroja=ZBPancerz then PostacWPancerzu(xp,yp,bron);
           if zbroja=DuzaZbroja then PostacWDuzejZbroji(xp,yp,bron);
          end;
if typ=7 then
          begin
           KolorNog:=brazowy;
           KolorRak:=jasnyzielony;
           KolorTlowia:=jasnyzielony;
           KolorPaska:=zolty;
           KolorButow:=czarny;
           if zbroja=0 then PostacBezZbroji(xp,yp,bron);
           if zbroja=kurtka then PostacWKurtce(xp,yp,bron);
           if zbroja=Kamizelka then PostacWKamizelce(xp,yp,bron);
           if zbroja=ZBPancerz then PostacWPancerzu(xp,yp,bron);
           if zbroja=DuzaZbroja then PostacWDuzejZbroji(xp,yp,bron);
          end;
if typ=8 then
          begin
           KolorNog:=niebieski;
           KolorRak:=bialy;
           KolorTlowia:=bialy;
           KolorPaska:=czarny;
           KolorButow:=czarny;
           if zbroja=0 then PostacBezZbroji(xp,yp,bron);
           if zbroja=kurtka then PostacWKurtce(xp,yp,bron);
           if zbroja=Kamizelka then PostacWKamizelce(xp,yp,bron);
           if zbroja=ZBPancerz then PostacWPancerzu(xp,yp,bron);
           if zbroja=DuzaZbroja then PostacWDuzejZbroji(xp,yp,bron);
          end;
if typ=9 then
          begin
           KolorNog:=czarny;
           KolorRak:=niebieski;
           KolorTlowia:=niebieski;
           KolorPaska:=czarny;
           KolorButow:=czarny;
           if zbroja=0 then PostacBezZbroji(xp,yp,bron);
           if zbroja=kurtka then PostacWKurtce(xp,yp,bron);
           if zbroja=Kamizelka then PostacWKamizelce(xp,yp,bron);
           if zbroja=ZBPancerz then PostacWPancerzu(xp,yp,bron);
           if zbroja=DuzaZbroja then PostacWDuzejZbroji(xp,yp,bron);
          end;
if typ=10 then
          begin
           KolorNog:=czerwony;
           KolorRak:=czerwony;
           KolorTlowia:=czerwony;
           KolorPaska:=zolty;
           KolorButow:=czarny;
           if zbroja=0 then PostacBezZbroji(xp,yp,bron);
           if zbroja=kurtka then PostacWKurtce(xp,yp,bron);
           if zbroja=Kamizelka then PostacWKamizelce(xp,yp,bron);
           if zbroja=ZBPancerz then PostacWPancerzu(xp,yp,bron);
           if zbroja=DuzaZbroja then PostacWDuzejZbroji(xp,yp,bron);
          end;
if typ=11 then
          begin
           KolorNog:=dziwnyniebieski;
           KolorRak:=brazowy;
           KolorTlowia:=jasnyczerwony;
           KolorPaska:=jasnyczerwony;
           KolorButow:=brazowy;
           if zbroja=0 then PostacBezZbroji(xp,yp,bron);
           if zbroja=kurtka then PostacWKurtce(xp,yp,bron);
           if zbroja=Kamizelka then PostacWKamizelce(xp,yp,bron);
           if zbroja=ZBPancerz then PostacWPancerzu(xp,yp,bron);
           if zbroja=DuzaZbroja then PostacWDuzejZbroji(xp,yp,bron);
          end;
if typ=12 then
          begin
           KolorNog:=ciemnydziwnyniebieski;
           KolorRak:=zielony;
           KolorTlowia:=zielony;
           KolorPaska:=ciemnydziwnyniebieski;
           KolorButow:=czarny;
           if zbroja=0 then PostacBezZbroji(xp,yp,bron);
           if zbroja=kurtka then PostacWKurtce(xp,yp,bron);
           if zbroja=Kamizelka then PostacWKamizelce(xp,yp,bron);
           if zbroja=ZBPancerz then PostacWPancerzu(xp,yp,bron);
           if zbroja=DuzaZbroja then PostacWDuzejZbroji(xp,yp,bron);
          end;
if typ=13 then
          begin
           KolorNog:=czarny;
           KolorRak:=fioletowy;
           KolorTlowia:=jasnyfioletowy;
           KolorPaska:=czarny;
           KolorButow:=brazowy;
           if zbroja=0 then PostacBezZbroji(xp,yp,bron);
           if zbroja=kurtka then PostacWKurtce(xp,yp,bron);
           if zbroja=Kamizelka then PostacWKamizelce(xp,yp,bron);
           if zbroja=ZBPancerz then PostacWPancerzu(xp,yp,bron);
           if zbroja=DuzaZbroja then PostacWDuzejZbroji(xp,yp,bron);
          end;
if typ=14 then
          begin
           KolorNog:=bialy;
           KolorRak:=jasnyszary;
           KolorTlowia:=bialy;
           KolorPaska:=czarny;
           KolorButow:=czarny;
           if zbroja=0 then PostacBezZbroji(xp,yp,bron);
           if zbroja=kurtka then PostacWKurtce(xp,yp,bron);
           if zbroja=Kamizelka then PostacWKamizelce(xp,yp,bron);
           if zbroja=ZBPancerz then PostacWPancerzu(xp,yp,bron);
           if zbroja=DuzaZbroja then PostacWDuzejZbroji(xp,yp,bron);
          end;
if typ>14 then Potwor(xp,yp,typ-14);
end;
{==========================================================}
{= RYSOWANIE ODPOWIEDNIEJ POSTACI NA PODSTAWIE JEJ DANYCH =}
{==========================================================}
Procedure RysOdpPostac(xp,yp:integer;nrp:byte);
begin
RysujPostac(xp,yp,mapa.postacie[nrp].rysunek,idframe(mapa.postacie[nrp].bron),idframe(mapa.postacie[nrp].zbroja));
end;

{===============================================================}
{=                                                             =}
{=                                                             =}
{=                 GRAFIKA ELEMENTOW MAPY                      =}
{=                                                             =}
{=                                                             =}
{===============================================================}

{================================================}
{=           RYSOWANIE MARTWEJ POSTACI          =}
{================================================}
Procedure MartwaPostac(xp,yp:integer);
begin
setfillstyle(1,white);
bar(xp+8,yp+20,xp+12,yp+2);
bar(xp+2,yp+6,xp+18,yp+10);
setcolor(black);
line(xp+8,yp+2,xp+12,yp+2);
line(xp+12,yp+2,xp+12,yp+6);
line(xp+12,yp+6,xp+18,yp+6);
line(xp+18,yp+6,xp+18,yp+10);
line(xp+18,yp+10,xp+12,yp+10);
line(xp+12,yp+10,xp+12,yp+20);
line(xp+12,yp+20,xp+8,yp+20);
line(xp+8,yp+20,xp+8,yp+10);
line(xp+8,yp+10,xp+2,yp+10);
line(xp+2,yp+10,xp+2,yp+6);
line(xp+2,yp+6,xp+8,yp+6);
line(xp+8,yp+6,xp+8,yp+2);
end;
{====}
procedure Siateczka(sxs,sys:integer);
var hj:byte;
begin
setcolor(white);
for hj:=1 to 5 do rectangle(sxs,sys,sxs+((hj-1)*4),sys+29);
end;
{====}
procedure Kratka(xx,yy:integer);
var hj:byte;
begin
setcolor(red);
for hj:=1 to 5 do rectangle(xx,yy,xx+((hj-1)*4),yy+29);
end;
{================================================}
{=   RYSOWANIE WYBRANEGO FRAGMENTU CALEJ MAPY   =}
{================================================}
Procedure RysujMape(xm,ym:integer; Sze,Wys:byte);
var ma,mb:integer;
    j:byte;
begin
for mb:=1 to wys+1 do
     begin
      for ma:=1 to sze+1  do
          begin
           Kafelka(xm+((ma-1)*20),ym+((mb-1)*30),mapa.tiles[(mx-1)+ma,(my-1)+mb]);
           if (mx-1)+ma=1 then if mapa.wyjscia[Klewo]='' then siateczka(xm+((ma-1)*20),ym+((mb-1)*30));
           if (mx-1)+ma=80 then if mapa.wyjscia[Kprawo]='' then siateczka(xm+((ma-1)*20),ym+((mb-1)*30));
           if (my-1)+mb=1 then if mapa.wyjscia[Kgora]='' then siateczka(xm+((ma-1)*20),ym+((mb-1)*30));
           if (my-1)+mb=80 then if mapa.wyjscia[Kdol]='' then siateczka(xm+((ma-1)*20),ym+((mb-1)*30));
{if TESTY then
               begin
                setcolor(black);
                Outtextxy(xm+((ma-1)*20),ym+((mb-1)*30),zamien(mapa.va[(mx-1)+ma,(my-1)+mb]));
               end;}
           wall(xm+((ma-1)*20),ym+((mb-1)*30),mapa.sciany[(mx-1)+ma,(my-1)+mb]);
          end;
     end;
for j:=0 to 20 do
   begin
    if mapa.postacie[j].status=Normalny then if (mapa.postacie[j].xp>=mx) and (mapa.postacie[j].xp<=mx+sze) and
(mapa.postacie[j].yp>=my) and (mapa.postacie[j].yp<=my+wys) then RysOdpPostac((xm-(20*(mx-1)))+
       ((mapa.postacie[j].xp-1)*20),(ym-(30*(my-1)))+((mapa.postacie[j].yp-1)*30),j);
    if mapa.postacie[j].status=martwy then if (mapa.postacie[j].xp>=mx) and (mapa.postacie[j].xp<=mx+sze) and
   (mapa.postacie[j].yp>=my) and (mapa.postacie[j].yp<=my+wys) then martwapostac((xm-(20*(mx-1)))+((mapa.postacie[j].xp-1)*20),
                                       (ym-(30*(my-1)))+((mapa.postacie[j].yp-1)*30));
   end;
for j:=1 to 40 do
     begin
      if mapa.szafki[j].xs>0 then if (mapa.szafki[j].xs>=mx) and (mapa.szafki[j].xs<=mx+sze) and
     (mapa.szafki[j].ys>=my) and (mapa.szafki[j].ys<=my+wys) then szafka((xm-(20*(mx-1)))+((mapa.szafki[j].xs-1)*20),
                                       (ym-(30*(my-1)))+((mapa.szafki[j].ys-1)*30),mapa.szafki[j].rysunek);
     end;
for j:=1 to 50 do
     begin
      if mapa.scenerie[j].xs>0 then if (mapa.scenerie[j].xs>=mx) and (mapa.scenerie[j].xs<=mx+sze) and
     (mapa.scenerie[j].ys>=my) and (mapa.scenerie[j].ys<=my+wys) then sceneria((xm-(20*(mx-1)))+((mapa.scenerie[j].xs-1)*20),
                           (ym-(30*(my-1)))+((mapa.scenerie[j].ys-1)*30),mapa.scenerie[j].rysunek,mapa.scenerie[j].stan);

     end;
for j:=1 to 10 do
     begin
      if mapa.spatiale[j].xs>0 then if (mapa.spatiale[j].xs>=mx) and (mapa.spatiale[j].xs<=mx+sze) and
     (mapa.spatiale[j].ys>=my) and (mapa.spatiale[j].ys<=my+wys) then kratka((xm-(20*(mx-1)))+((mapa.spatiale[j].xs-1)*20),
                           (ym-(30*(my-1)))+((mapa.spatiale[j].ys-1)*30));
     end;

{for mb:=1 to wys+1 do
     begin
      for ma:=1 to sze+1  do
          begin
           Outtextxy(xm+((ma-1)*20),ym+((mb-1)*30),zamien(mapa.va[(mx-1)+ma,(my-1)+mb]));
          end;
     end;
}
end;
{===============================================}
{=    RYSOWANIE POJEDYNCZEGO KWADRATU MAPY     =}
{===============================================}
Procedure RysujKwadrat(xm,ym:integer);
var i:byte;
begin
if (xm>=mx) and (ym>=my) and (xm<=mx+19) and (ym<=my+12) then
                begin
                 setfillstyle(1,red);
                 kafelka(mappozx+(((xm-(mx-1))-1)*20),mappozy+(((ym-(my-1))-1)*30),mapa.tiles[xm,ym]);
              for i:=1 to 50 do if (mapa.scenerie[i].xs=xm) and (mapa.scenerie[i].ys=ym) then
     Sceneria(mappozx+(((xm-(mx-1))-1)*20),mappozy+(((ym-(my-1))-1)*30),mapa.scenerie[i].rysunek,mapa.scenerie[i].stan);
                end;
end;
{===============================================================}
{=                                                             =}
{=                                                             =}
{=                     GRAFIKA EKWIPUNKU                       =}
{=                                                             =}
{=                                                             =}
{===============================================================}

{===============================================================}
{=                                                             =}
{=                                                             =}
{=                         GRAFIKA GUI                         =}
{=                                                             =}
{=                                                             =}
{===============================================================}

{===============================================================}
{= MALE OKIENKO DIALOGOWE DO ODBIORU CIAGU ZNAKOW Z KLAWIATURY =}
{===============================================================}
Procedure Dialog(Xd,Yd:integer; Wzor,KolorW,Kolor:byte; tekst:string);
begin
setfillstyle(wzor,kolorw);
bar(xd,yd,xd+200,yd+14);
setcolor(kolor);
rectangle(xd,yd,xd+200,yd+14);
Dial.wzorwypelnienia:=wzor;
Dial.KolorWypelnienia:=kolorw;
Dial.Kolor:=kolor;
Dial.xd:=xd;
Dial.yd:=yd;
Dial.tekst:=tekst;
end;
{================================================}
{=    WYSWIETLENIE DANYCH W OKNIE DIALOGOWYM    =}
{================================================}
Procedure WyswietlDialog;
begin
setfillstyle(dial.wzorwypelnienia,dial.kolorwypelnienia);
bar(dial.xd+1,dial.yd+1,dial.xd+199,dial.yd+199);
setcolor(dial.kolor);
outtextxy(dial.xd+2,dial.yd+2,dial.tekst);
end;
{=============================================}
{=               RYSOWANIE NITU              =}
{=============================================}
procedure nit(xn1,yn1:integer);
begin
setfillstyle(1,7);
setcolor(8);
circle(xn1,yn1,5);
floodfill(xn1,yn1,8);
end;
{=============================================}
{=                  PRZYCISKI                =}
{=============================================}
Procedure Przycisk(xo1,yo1,xo2,yo2:integer; StanP,typp:byte; TekstP:string);
begin
ukryjmysz;
if typp=0 then
       begin
        if stanp=0 then
                begin
                 setfillstyle(1,brown);
                 bar(xo1,yo1,xo2,yo2);
                 setcolor(white);
                 outtextxy(round(   (xo1+((xo2-xo1)/2))-(((length(tekstp)-1)*8)/2)),round ( (yo1+((yo2-yo1)/2)-5)),tekstp);
                 line(xo1,yo1-1,xo2,yo1-1);
                 line(xo1-1,yo1,xo1-1,yo2);
                 setcolor(black);
                 line(xo2+1,yo1,xo2+1,yo2);
                 line(xo1,yo2+1,xo2,yo2+1);
                end;
        if stanp=1 then
                begin
                 setfillstyle(1,brown);
                 bar(xo1,yo1,xo2,yo2);
                 setcolor(black);
                 line(xo1,yo1-1,xo2,yo1-1);
                 line(xo1-1,yo1,xo1-1,yo2);
                 setcolor(white);
                 outtextxy(round(   (xo1+((xo2-xo1)/2))-(((length(tekstp)-1)*8)/2)),round ( (yo1+((yo2-yo1)/2)-5)),tekstp);
                 line(xo2+1,yo1,xo2+1,yo2);
                 line(xo1,yo2+1,xo2,yo2+1);
                end;
        if stanp=2 then
                begin
                 setcolor(black);
                 line(xo1,yo1-1,xo2,yo1-1);
                 line(xo1-1,yo1,xo1-1,yo2);
                 setcolor(white);
                 line(xo2+1,yo1,xo2+1,yo2);
                 line(xo1,yo2+1,xo2,yo2+1);
                end;
        if stanp=3 then
                begin
                 setcolor(white);
                 line(xo1,yo1-1,xo2,yo1-1);
                 line(xo1-1,yo1,xo1-1,yo2);
                 setcolor(black);
                 line(xo2+1,yo1,xo2+1,yo2);
                 line(xo1,yo2+1,xo2,yo2+1);

                end;
       end;
if typp=1 then
       begin
        if stanp=0 then
                begin
                 setfillstyle(1,brown);
                 bar(xo1,yo1,xo2,yo2);
                 setcolor(yellow);
                 outtextxy(round(   (xo1+((xo2-xo1)/2))-(((length(tekstp)-1)*8)/2)),round ( (yo1+((yo2-yo1)/2)-5)),tekstp);
                 line(xo1,yo1-1,xo2,yo1-1);
                 line(xo1-1,yo1,xo1-1,yo2);
                 setcolor(black);
                 line(xo2+1,yo1,xo2+1,yo2);
                 line(xo1,yo2+1,xo2,yo2+1);
                end;
        if stanp=1 then
                begin
                 setfillstyle(1,brown);
                 bar(xo1,yo1,xo2,yo2);
                 setcolor(black);
                 line(xo1,yo1-1,xo2,yo1-1);
                 line(xo1-1,yo1,xo1-1,yo2);
                 setcolor(yellow);
                 outtextxy(round(   (xo1+((xo2-xo1)/2))-(((length(tekstp)-1)*8)/2)),round ( (yo1+((yo2-yo1)/2)-5)),tekstp);
                 line(xo2+1,yo1,xo2+1,yo2);
                 line(xo1,yo2+1,xo2,yo2+1);
                end;
        if stanp=2 then
                begin
                 setcolor(black);
                 line(xo1,yo1-1,xo2,yo1-1);
                 line(xo1-1,yo1,xo1-1,yo2);
                 setcolor(yellow);
                 line(xo2+1,yo1,xo2+1,yo2);
                 line(xo1,yo2+1,xo2,yo2+1);
                end;
        if stanp=3 then
                begin
                 setcolor(yellow);
                 line(xo1,yo1-1,xo2,yo1-1);
                 line(xo1-1,yo1,xo1-1,yo2);
                 setcolor(black);
                 line(xo2+1,yo1,xo2+1,yo2);
                 line(xo1,yo2+1,xo2,yo2+1);

                end;
      end;
if typp=2 then
       begin
        if stanp=0 then
                begin
                 setfillstyle(1,brown);
                 bar(xo1,yo1,xo2,yo2);
                 setcolor(yellow);
                 outtextxy(round(   (xo1+((xo2-xo1)/2))-(((length(tekstp)-1)*8)/2)),round ( (yo1+((yo2-yo1)/2)-5)),tekstp);
                 line(xo1,yo1-1,xo2,yo1-1);
                 line(xo1-1,yo1,xo1-1,yo2);
                 setcolor(black);
                 line(xo2+1,yo1,xo2+1,yo2);
                 line(xo1,yo2+1,xo2,yo2+1);
                end;
        if stanp=1 then
                begin
                 setfillstyle(1,brown);
                 bar(xo1,yo1,xo2,yo2);
                 setcolor(black);
                 line(xo1,yo1-1,xo2,yo1-1);
                 line(xo1-1,yo1,xo1-1,yo2);
                 setcolor(yellow);
                 outtextxy(round(   (xo1+((xo2-xo1)/2))-(((length(tekstp)-1)*8)/2)),round ( (yo1+((yo2-yo1)/2)-5)),tekstp);
                 line(xo2+1,yo1,xo2+1,yo2);
                 line(xo1,yo2+1,xo2,yo2+1);
                end;
        if stanp=2 then
                begin
                 setcolor(black);
                 line(xo1,yo1-1,xo2,yo1-1);
                 line(xo1-1,yo1,xo1-1,yo2);
                 setcolor(yellow);
                 line(xo2+1,yo1,xo2+1,yo2);
                 line(xo1,yo2+1,xo2,yo2+1);
                end;
        if stanp=3 then
                begin
                 setcolor(yellow);
                 line(xo1,yo1-1,xo2,yo1-1);
                 line(xo1-1,yo1,xo1-1,yo2);
                 setcolor(black);
                 line(xo2+1,yo1,xo2+1,yo2);
                 line(xo1,yo2+1,xo2,yo2+1);

                end;
      end;
if typp=3 then
       begin
        if stanp=0 then
                begin
                 setfillstyle(1,red);
                 bar(xo1,yo1,xo2,yo2);
                 setcolor(white);
                 outtextxy(round(   (xo1+((xo2-xo1)/2))-(((length(tekstp)-1)*8)/2)),round ( (yo1+((yo2-yo1)/2)-5)),tekstp);
                 line(xo1,yo1-1,xo2,yo1-1);
                 line(xo1-1,yo1,xo1-1,yo2);
                 setcolor(black);
                 line(xo2+1,yo1,xo2+1,yo2);
                 line(xo1,yo2+1,xo2,yo2+1);
                end;
        if stanp=1 then
                begin
                 setfillstyle(1,red);
                 bar(xo1,yo1,xo2,yo2);
                 setcolor(black);
                 line(xo1,yo1-1,xo2,yo1-1);
                 line(xo1-1,yo1,xo1-1,yo2);
                 setcolor(white);
                 outtextxy(round(   (xo1+((xo2-xo1)/2))-(((length(tekstp)-1)*8)/2)),round ( (yo1+((yo2-yo1)/2)-5)),tekstp);
                 line(xo2+1,yo1,xo2+1,yo2);
                 line(xo1,yo2+1,xo2,yo2+1);
                end;
        if stanp=2 then
                begin
                 setcolor(black);
                 line(xo1,yo1-1,xo2,yo1-1);
                 line(xo1-1,yo1,xo1-1,yo2);
                 setcolor(white);
                 line(xo2+1,yo1,xo2+1,yo2);
                 line(xo1,yo2+1,xo2,yo2+1);
                end;
        if stanp=3 then
                begin
                 setcolor(white);
                 line(xo1,yo1-1,xo2,yo1-1);
                 line(xo1-1,yo1,xo1-1,yo2);
                 setcolor(black);
                 line(xo2+1,yo1,xo2+1,yo2);
                 line(xo1,yo2+1,xo2,yo2+1);

                end;
      end;
pokazmysz;
end;

{=============================================}
{=                  OKNO                     =}
{=============================================}
procedure Okno(xo1,yo1,xo2,yo2:Integer; TypO:byte);
var kol,kol1:byte;
begin
if typo=0 then
            begin
             {Wymazanie}
             setfillstyle(1,black);
             bar(xo1,yo1,xo2,yo2);
             {Ramki}
             setcolor(yellow);
             rectangle(xo1,yo1,xo2,yo2);
             {Tlo}
             setfillstyle(7,brown);
             bar(xo1+3,yo1+2,xo2-3,yo2-2);
            end;
if typo=1 then
            begin
             {Wymazanie}
             setfillstyle(1,yellow);
             bar(xo1-6,yo1-5,xo2+6,yo2+1);
             {Ramki}
             setfillstyle(1,brown);
             bar(xo1-5,yo1-4,xo2+5,yo1);
             bar(xo1-5,yo1-4,xo1,yo2);
             bar(xo1,yo2,xo2,yo2-4);
             bar(xo2+5,yo2,xo2,yo1);
             {TLO}
             setfillstyle(1,black);
             bAR(xo1+2,yo1+2,xo2-2,yo2-6);
             {Dodatki}
             setfillstyle(1,yellow);
             bar(xo1,yo1,xo1-10,yo1-8);
             bar(xo2,yo1,xo2+10,yo1-8);
             bar(xo2,yo2-4,xo2+10,yo2+4);
             bar(xo1,yo2-4,xo1-10,yo2+4);
             setfillstyle(1,brown);
             bar(xo1-1,yo1-1,xo1-9,yo1-7);
             bar(xo2+1,yo1-1,xo2+9,yo1-7);
             bar(xo2+1,yo2-3,xo2+9,yo2+3);
             bar(xo1-1,yo2-3,xo1-9,yo2+3);
            end;
if TYPo=2 then
            begin
             kol:=yellow;
             setfillstyle(1,black);
             bar(xo1,yo1,xo2,yo2);
             setfillstyle(5,kol);
             setlinestyle(0,0,3);
             setcolor(brown);
             circle(xo1,yo1,9);
             circle(xo1,yo2,9);
             circle(xo2,yo2,9);
             circle(xo2,yo1,9);
             floodfill(xo1,yo1,brown);
             floodfill(xo2,yo1,brown);
             floodfill(xo1,yo2,brown);
             floodfill(xo2,yo2,brown);
             bar(xo1-5,yo1-5,xo2+5,yo1+7);
             bar(xo1-5,yo1-5,xo1+7,yo2+5);
             bar(xo1-5,yo2-7,xo2+5,yo2+5);
             bar(xo2-7,yo1-5,xo2+5,yo2+5);
             setcolor(brown);
             line(xo1+8,yo1-5,xo2-8,yo1-5);
             line(xo1-5,yo1+8,xo1-5,yo2-8);
             line(xo1+8,yo1+7,xo2-8,yo1+7);
             line(xo1+7,yo1+8,xo1+7,yo2-8);

             line(xo2-7,yo1+8,xo2-7,yo2-8);
             line(xo2+5,yo1+8,xo2+5,yo2-8);
             line(xo1+7,yo2-7,xo2-7,yo2-7);
             line(xo1+8,yo2+5,xo2-8,yo2+5);
             nit(xo1,yo1);
             nit(xo2,yo1);
             nit(xo1,yo2);
             nit(xo2,yo2);
            end;
if typo=3 then
            begin
             {Wymazanie}
             setfillstyle(1,black);
             bar(xo1,yo1,xo2,yo2);
             {Ramki}
             kol:=brown;
             kol1:=yellow;
             {TLO}
             setfillstyle(1,8);
             bar(xo1,yo1,xo2-5,yo2-5);
              {poziome}
             setfillstyle(5,kol);
             bar(xo1+10,yo1-6,xo2-10,yo1+1);
             setfillstyle(9,kol1);
             bar(xo1+10,yo1-8,xo2-10,yo1-6);
             bar(xo1+10,yo1+1,xo2-10,yo1+3);
             setfillstyle(5,kol);
             bar(xo1+10,yo2-6,xo2-10,yo2+1);
             setfillstyle(9,kol1);
             bar(xo1+10,yo2-8,xo2-10,yo2-6);
             bar(xo1+10,yo2+1,xo2-10,yo2+3);
              {pionowe}
             setfillstyle(4,kol);
             bar(xo1,yo1+6,xo1+7,yo2-10);
             setfillstyle(9,kol1);
             bar(xo1-2,yo1+6,xo1,yo2-10);
             bar(xo1+7,yo1+6,xo1+9,yo2-10);
             setfillstyle(4,kol);
             bar(xo2-4,yo1+6,xo2+3,yo2-10);
             setfillstyle(9,kol1);
             bar(xo2-6,yo1+6,xo2-4,yo2-10);
             bar(xo2+3,yo1+6,xo2+5,yo2-10);
             {Dodatki}
             setfillstyle(9,kol1);
             bar(xo1-7,yo1-12,xo1+13,yo1+10);
             bar(xo2-10,yo1-12,xo2+10,yo1+10);
             bar(xo1-7,yo2-14,xo1+13,yo2+8);
             bar(xo2-10,yo2-14,xo2+10,yo2+8);
             setfillstyle(6,kol);
             bar(xo1-4,yo1-9,xo1+10,yo1+7);
             bar(xo2-7,yo1-9,xo2+7,yo1+7);
             bar(xo1-4,yo2-11,xo1+10,yo2+5);
             bar(xo2-7,yo2-11,xo2+7,yo2+5);
            end;
if typo=4 then
            begin
             {Wymazanie}
             setfillstyle(1,black);
             bar(xo1,yo1,xo2,yo2);
             {Ramki}
             kol:=brown;
             kol1:=yellow;
             {TLO}
             setfillstyle(1,brown);
             bar(xo1,yo1,xo2-5,yo2-5);
              {poziome}
             setfillstyle(5,kol);
             bar(xo1+10,yo1-6,xo2-10,yo1+1);
             setfillstyle(9,kol1);
             bar(xo1+10,yo1-8,xo2-10,yo1-6);
             bar(xo1+10,yo1+1,xo2-10,yo1+3);
             setfillstyle(5,kol);
             bar(xo1+10,yo2-6,xo2-10,yo2+1);
             setfillstyle(9,kol1);
             bar(xo1+10,yo2-8,xo2-10,yo2-6);
             bar(xo1+10,yo2+1,xo2-10,yo2+3);
              {pionowe}
             setfillstyle(4,kol);
             bar(xo1,yo1+6,xo1+7,yo2-10);
             setfillstyle(9,kol1);
             bar(xo1-2,yo1+6,xo1,yo2-10);
             bar(xo1+7,yo1+6,xo1+9,yo2-10);
             setfillstyle(4,kol);
             bar(xo2-4,yo1+6,xo2+3,yo2-10);
             setfillstyle(9,kol1);
             bar(xo2-6,yo1+6,xo2-4,yo2-10);
             bar(xo2+3,yo1+6,xo2+5,yo2-10);
             {Dodatki}
             setfillstyle(9,kol1);
             bar(xo1-7,yo1-12,xo1+13,yo1+10);
             bar(xo2-10,yo1-12,xo2+10,yo1+10);
             bar(xo1-7,yo2-14,xo1+13,yo2+8);
             bar(xo2-10,yo2-14,xo2+10,yo2+8);
             setfillstyle(6,kol);
             bar(xo1-4,yo1-9,xo1+10,yo1+7);
             bar(xo2-7,yo1-9,xo2+7,yo1+7);
             bar(xo1-4,yo2-11,xo1+10,yo2+5);
             bar(xo2-7,yo2-11,xo2+7,yo2+5);
            end;
if typo=5 then
            begin
             {Wymazanie}
             setfillstyle(1,yellow);
             bar(xo1-6,yo1-5,xo2+6,yo2+1);
             {Ramki}
             setfillstyle(1,brown);
             bar(xo1-5,yo1-4,xo2+5,yo1);
             bar(xo1-5,yo1-4,xo1,yo2);
             bar(xo1,yo2,xo2,yo2-4);
             bar(xo2+5,yo2,xo2,yo1);
             {TLO}
             setfillstyle(1,brown);
             bAR(xo1+2,yo1+2,xo2-2,yo2-6);
             {Dodatki}
             setfillstyle(1,yellow);
             bar(xo1,yo1,xo1-10,yo1-8);
             bar(xo2,yo1,xo2+10,yo1-8);
             bar(xo2,yo2-4,xo2+10,yo2+4);
             bar(xo1,yo2-4,xo1-10,yo2+4);
             setfillstyle(1,brown);
             bar(xo1-1,yo1-1,xo1-9,yo1-7);
             bar(xo2+1,yo1-1,xo2+9,yo1-7);
             bar(xo2+1,yo2-3,xo2+9,yo2+3);
             bar(xo1-1,yo2-3,xo1-9,yo2+3);
            end;
if typo=6 then
            begin
             setfillstyle(1,brown);
             bar(xo1+1,yo1+1,xo2-1,yo2-1);
             setcolor(yellow);
             rectangle(xo1-1,yo1-1,xo2+1,yo2+1);
            end;
if typo=7 then
            begin
             setfillstyle(1,brown);
             bar(xo1+1,yo1+1,xo2-1,yo2-1);
             setcolor(yellow);
             rectangle(xo1-1,yo1-1,xo2+1,yo2+1);
            end;
if typo=8 then
            begin
             {Wymazanie}
             setfillstyle(1,yellow);
             bar(xo1-6,yo1-5,xo2+6,yo2+1);
             {Ramki}
             setfillstyle(1,brown);
             bar(xo1-5,yo1-4,xo2+5,yo1);
             bar(xo1-5,yo1-4,xo1,yo2);
             bar(xo1,yo2,xo2,yo2-4);
             bar(xo2+5,yo2,xo2,yo1);
             {TLO}
             setfillstyle(1,black);
             bAR(xo1+2,yo1+2,xo2-2,yo2-6);
             {Dodatki}
             setfillstyle(1,yellow);
             bar(xo1,yo1,xo1-10,yo1-8);
             bar(xo2,yo1,xo2+10,yo1-8);
             bar(xo2,yo2-4,xo2+10,yo2+4);
             bar(xo1,yo2-4,xo1-10,yo2+4);
             setfillstyle(1,brown);
             bar(xo1-1,yo1-1,xo1-9,yo1-7);
             bar(xo2+1,yo1-1,xo2+9,yo1-7);
             bar(xo2+1,yo2-3,xo2+9,yo2+3);
             bar(xo1-1,yo2-3,xo1-9,yo2+3);
           end;
if typo=9 then
            begin
             {Wymazanie}
             setfillstyle(1,black);
             bar(xo1,yo1,xo2,yo2);
             {Ramki}
             setcolor(yellow);
             rectangle(xo1,yo1,xo2,yo2);
            end;
if typo=10 then
            begin
             {Wymazanie}
             setfillstyle(1,black);
             bar(xo1,yo1,xo2,yo2);
             {Ramki}
             setcolor(yellow);
             rectangle(xo1,yo1,xo2,yo2);
             {Tlo}
{             setfillstyle(1,brown);
             bar(xo1+3,yo1+2,xo2-3,yo2-2);}
            end;

end;
{=============================================}
{=                  EKRANY                   =}
{=============================================}
Procedure Ekranek(xo1,yo1,xo2,yo2:integer; Typek:byte);
begin
if typek=0 then
            begin
             {Wymazanie}
             setfillstyle(1,black);
             bar(xo1,yo1,xo2,yo2);
             {Ramki}
             setcolor(7);
             rectangle(xo1,yo1,xo2,yo2);
             rectangle(xo1-1,yo1-1,xo2+1,yo2+1);
             rectangle(xo1-4,yo1-4,xo2+4,yo2+4);
             rectangle(xo1-5,yo1-5,xo2+5,yo2+5);
             {Tlo}
             setfillstyle(3,8);
             bar(xo1+1,yo1+1,xo2-1,yo2-1);
            end;
if typek=1 then
            begin
             {Wymazanie}
             setfillstyle(1,black);
             bar(xo1,yo1,xo2,yo2);
             {Ramki}
             setcolor(yellow);
             rectangle(xo1,yo1,xo2,yo2);
             rectangle(xo1-1,yo1-1,xo2+1,yo2+1);
             rectangle(xo1-4,yo1-4,xo2+4,yo2+4);
             rectangle(xo1-5,yo1-5,xo2+5,yo2+5);
             {Tlo}
             setfillstyle(11,brown);
             bar(xo1+1,yo1+1,xo2-1,yo2-1);
            end;
if typek=2 then
            begin
             {Wymazanie}
             setfillstyle(1,black);
             bar(xo1,yo1,xo2,yo2);
             {Ramki}
             setcolor(yellow);
             rectangle(xo1,yo1,xo2,yo2);
             rectangle(xo1-1,yo1-1,xo2+1,yo2+1);
             rectangle(xo1-4,yo1-4,xo2+4,yo2+4);
             rectangle(xo1-5,yo1-5,xo2+5,yo2+5);
             {Tlo}
             setfillstyle(10,brown);
             bar(xo1+1,yo1+1,xo2-1,yo2-1);
            end;
if typek=3 then
            begin
             okno(xo1-5,yo1-5,xo2,yo2,4);
            end;
if typek=4 then
            begin
             okno(xo1,yo1,xo2,yo2,0);
            end;
if typek=5 then
            begin
             okno(xo1+5,yo1+5,xo2-5,yo2-5,9);
            end;

end;
{=============================================}
{=  PROCEDURA RYSUJACA WSZYSTKIE PRZYCISKI   =}
{=============================================}
Procedure RysujPrzyciski;
var i:byte;
begin
for i:=1 to Liczbprzycisk do
         begin
          przycisk(Przyciski[i].xp1,Przyciski[i].yp1,
                   Przyciski[i].xp2,Przyciski[i].yp2,Przyciski[i].stan,Przyciski[i].typ,Przyciski[i].tekst);
         end;
end;
{=============================================}
{=    PROCEDURA RYSUJACA WSZYSTKIE EKRANY    =}
{=============================================}
Procedure RysujEkrany;
var i:byte;
begin
ukryjmysz;
for i:=1 to liczbekranow do
         begin
          inc(liczbekranow);
          ekranek(ekrany[i].xe1,ekrany[i].ye1,ekrany[i].xe2,ekrany[i].ye2,ekrany[i].typ);
         end;
pokazmysz;
end;
{=============================================}
{=   PROCEDURA CZYSZCZACA ZAWARTOSC EKRANU   =}
{=============================================}
Procedure CzyscEkran(ekr:byte);
begin
ukryjmysz;
if ekrany[ekr].typ=0 then
                   begin
                    setfillstyle(3,8);
                    bar(ekrany[ekr].xe1+1,ekrany[ekr].ye1+1,ekrany[ekr].xe2-1,ekrany[ekr].ye2-1);
                   end;
if ekrany[ekr].typ=1 then
                   begin
                    setfillstyle(11,green);
                    bar(ekrany[ekr].xe1+1,ekrany[ekr].ye1+1,ekrany[ekr].xe2-1,ekrany[ekr].ye2-1);
                   end;
if ekrany[ekr].typ=2 then
                   begin
                    setfillstyle(10,brown);
                    bar(ekrany[ekr].xe1+1,ekrany[ekr].ye1+1,ekrany[ekr].xe2-1,ekrany[ekr].ye2-1);
                   end;
if ekrany[ekr].typ=3 then
                   begin
                    setfillstyle(1,brown);
                    bar(ekrany[ekr].xe1+5,ekrany[ekr].ye1+5,ekrany[ekr].xe2-6,ekrany[ekr].ye2-15);
                   end;
if ekrany[ekr].typ=4 then
                   begin
                    setfillstyle(7,brown);
                    bar(ekrany[ekr].xe1+2,ekrany[ekr].ye1+2,ekrany[ekr].xe2-5,ekrany[ekr].ye2-5);
                   end;
if ekrany[ekr].typ=5 then
                   begin
                    setfillstyle(1,black);
                    bar(ekrany[ekr].xe1+6,ekrany[ekr].ye1+6,ekrany[ekr].xe2-6,ekrany[ekr].ye2-6);
                   end;

Ekrany[ekr].lo:=0;
pokazmysz;
end;
{============================================}
{=  SPRAWDZANIE KROJU PODANEGO TYPU EKRANU  =}
{============================================}
Function SprawdzKroj(Ekr:byte):byte;
begin
SprawdzKroj:=1;
if Ekrany[ekr].typ=0 then SprawdzKroj:=3;{}
if Ekrany[ekr].typ=1 then SprawdzKroj:=11; {}
if Ekrany[ekr].typ=2 then SprawdzKroj:=10;{}
if Ekrany[ekr].typ=3 then SprawdzKroj:=1;
if Ekrany[ekr].typ=4 then SprawdzKroj:=7;
end;
{============================================}
{= SPRAWDZANIE KOLORU PODANEGO TYPU EKRANU  =}
{============================================}
Function SprawdzKolor(Ekr:byte):byte;
begin
SprawdzKolor:=0;
if Ekrany[ekr].typ=0 then SprawdzKolor:=8;{}
if Ekrany[ekr].typ=1 then SprawdzKolor:=green;{}
if Ekrany[ekr].typ=2 then SprawdzKolor:=brown;
if Ekrany[ekr].typ=3 then SprawdzKolor:=brown;
if Ekrany[ekr].typ=4 then SprawdzKolor:=8;
end;
{===============================================================}
{=                                                             =}
{=                                                             =}
{=                    PROCEDURY PANELI                         =}
{=                                                             =}
{=                                                             =}
{===============================================================}

{                                                  }
{                                                  }
{             PROCEDURY PANELU HANDLU              }
{                                                  }
{                                                  }

{=============================================}
{=                PANEL HANDLU               =}
{=============================================}
Procedure PanelHandlu;
begin
ukryjmysz;
zerujekrany;
zerujprzyciski;
okno(2,2,638,478,0);

okno(9,29,151,451,6);
okno(164,29,306,451,6);
okno(319,29,463,451,6);
okno(474,29,618,451,6);

okno(10,9,150,25,6);
okno(165,9,305,25,6);

okno(320,9,462,25,6);
okno(475,9,617,25,6);

okno(100,455,540,473,6);
tworzprzycisk(15,456,95,470,0,1,'Oferta ');
tworzprzycisk(550,456,630,470,0,1,'Koniec ');
rysujprzyciski;
pokazmysz;
end;
{=====================================}
{=    WYMAZANIE RAMKI LEWEGO OKNA    =}
{=====================================}
Procedure WymarzRamkeL;
begin
if RHL<13 then if rhl>0 then
            begin
             setcolor(brown);
             rectangle(10,30+((rhl-1)*35),80,30+(rhl*35));
            end;
if (RHL>12) and (rhl<25) then
            begin
             setcolor(brown);
             rectangle(80,30+((rhl-13)*35),150,30+((rhl-12)*35));
            end;
if (RHL>24) and (rhl<37) then
            begin
             setcolor(brown);
             rectangle(165,30+((rhl-25)*35),245,30+((rhl-24)*35));
            end;
if (RHL>36) then
            begin
             setcolor(brown);
             rectangle(245,30+((rhl-37)*35),305,30+((rhl-36)*35));
            end;

end;
{==================================}
{=    RAMKA HANDLU LEWEGO OKNA    =}
{==================================}
Procedure RamkaHL;
begin
if RHL<13 then if rhl>0 then
            begin
             setcolor(red);
             rectangle(10,30+((rhl-1)*35),80,30+(rhl*35));
            end;
if (RHL>12) and (rhl<25) then
            begin
             setcolor(red);
             rectangle(80,30+((rhl-13)*35),150,30+((rhl-12)*35));
            end;
if (RHL>24) and (rhl<37) then
            begin
             setcolor(red);
             rectangle(165,30+((rhl-25)*35),245,30+((rhl-24)*35));
            end;
if (RHL>36) then
            begin
             setcolor(red);
             rectangle(245,30+((rhl-37)*35),305,30+((rhl-36)*35));
            end;

end;
{======================================}
{=    WYMAZANIE RAMKI PRAWEGO OKNA    =}
{======================================}
Procedure WymarzRamker;
begin
if RHR<13 then if rhr>0 then
            begin
             setcolor(brown);
             rectangle(475,30+((rhr-1)*35),545,30+(rhr*35));
            end;
if (RHR>12) and (rhR<25) then
            begin
             setcolor(brown);
             rectangle(545,30+((rhr-13)*35),615,30+((rhr-12)*35));
            end;
if (RHr>24) and (rhr<37) then
            begin
             setcolor(brown);
             rectangle(320,30+((rhR-25)*35),390,30+((rhr-24)*35));
            end;
if (RHr>36) then
            begin
             setcolor(brown);
             rectangle(390,30+((rhr-37)*35),460,30+((rhr-36)*35));
            end;
end;
{===================================}
{=    RAMKA HANDLU PRAWEGO OKNA    =}
{===================================}
Procedure RamkaHR;
begin
if RHR<13 then if rhr>0 then
            begin
             setcolor(red);
             rectangle(475,30+((rhr-1)*35),545,30+(rhr*35));
            end;
if (RHR>12) and (rhR<25) then
            begin
             setcolor(red);
             rectangle(545,30+((rhr-13)*35),615,30+((rhr-12)*35));
            end;
if (RHr>24) and (rhr<37) then
            begin
             setcolor(red);
             rectangle(320,30+((rhR-25)*35),390,30+((rhr-24)*35));
            end;
if (RHr>36) then
            begin
             setcolor(red);
             rectangle(390,30+((rhr-37)*35),460,30+((rhr-36)*35));
            end;

end;
{=============================================}
{=  WYMAZANIE OKNA Z TEKSTEM PODCZAS HANDLU  =}
{=============================================}
Procedure WymarzTekstHandlu;
begin
ukryjmysz;
setfillstyle(1,brown);
bar(101,456,539,472);
pokazmysz;
end;
{================================================}
{=   WYSWIETLANIE WARTOSCI OFERT HANDLUJACYCH   =}
{================================================}
Procedure WyswietlOferty;
begin
okno(165,9,305,25,6);
okno(320,9,462,25,6);
setcolor(white);
centre(245,12,zamien(round(oferta[1]))+'$');
centre(390,12,zamien(round(oferta[2]))+'$');
end;
{==================================================}
{=  WYMAZANIE OKIEN Z EKWIPUNKIEM PODCZAS HANDLU  =}
{==================================================}
Procedure WymarzOknaHandlu;
begin
ukryjmysz;
okno(9,29,151,451,6);
okno(164,29,306,451,6);
okno(319,29,463,451,6);
okno(474,29,618,451,6);
okno(165,9,305,25,6);
okno(320,9,462,25,6);
pokazmysz;
end;

{=============================================}
{=    PROCEDURA WYSWIETLAJACA PRZEDMIOTY     =}
{=============================================}
Procedure WyswietlPrzedmiotyHandlu(NRPH:byte); {podawany jest tylko   }
                                               {numer postaci z ktora}
                                               {handluje bohater}
var i:byte;
begin
ukryjmysz;
for i:=1 to 24 do
    begin
     if Mapa.postacie[0].ekwipunek[i]<>0 then
                   begin
                    if i<13 then RysujPrzedmiot(10,30+((i-1)*35),IdGFX(Mapa.postacie[0].ekwipunek[i]));
                    if i>12 then RysujPrzedmiot(80,30+((i-13)*35),IdGFX(Mapa.postacie[0].ekwipunek[i]));
                    setcolor(black);
                    if i<13 then if mapa.postacie[0].spec[i]>1 then outtextxy(15,32+((i-1)*35),
                                                         zamien(round(mapa.postacie[0].spec[i])));
                    if i>12 then if mapa.postacie[0].spec[i]>1 then outtextxy(85,32+((i-13)*35),
                                                         zamien(round(mapa.postacie[0].spec[i])));

                   end;
     if DoHandlu[1,i]<>0 then
                   begin
                    if i<13 then RysujPrzedmiot(165,30+((i-1)*35),IdGFX(dohandlu[1,i]));
                    if i>12 then RysujPrzedmiot(235,30+((i-13)*35),IdGFX(dohandlu[1,i]));
                    setcolor(black);
                    if i<13 then if dohandluspec[1,i]>1 then outtextxy(170,32+((i-1)*35),
                                                         zamien(round(dohandluspec[1,i])));
                    if i>12 then if dohandluspec[1,i]>1 then outtextxy(240,32+((i-13)*35),
                                                         zamien(round(dohandluspec[1,i])));

                   end;
     if DoHandlu[2,i]<>0 then
                   begin
                    if i<13 then RysujPrzedmiot(320,30+((i-1)*35),IdGFX(dohandlu[2,i]));
                    if i>12 then RysujPrzedmiot(390,30+((i-13)*35),IdGFX(dohandlu[2,i]));
                    setcolor(black);
                    if i<13 then if dohandluspec[2,i]>1 then outtextxy(325,32+((i-1)*35),
                                                         zamien(round(dohandluspec[2,i])));
                    if i>12 then if dohandluspec[2,i]>1 then outtextxy(395,32+((i-13)*35),
                                                         zamien(round(dohandluspec[2,i])));

                   end;
     if Mapa.postacie[nrph].ekwipunek[i]<>0 then
                   begin
                    if i<13 then RysujPrzedmiot(475,30+((i-1)*35),IdGFX(Mapa.postacie[nrph].ekwipunek[i]));
                    if i>12 then RysujPrzedmiot(545,30+((i-13)*35),IdGFX(Mapa.postacie[nrph].ekwipunek[i]));
                    setcolor(black);
                    if i<13 then if mapa.postacie[nrph].spec[i]>1 then outtextxy(475,32+((i-1)*35),
                                                         zamien(round(mapa.postacie[nrph].spec[i])));
                    if i>12 then if mapa.postacie[nrph].spec[i]>1 then outtextxy(550,32+((i-13)*35),
                                                         zamien(round(mapa.postacie[nrph].spec[i])));

                   end;

    end;
setcolor(white);
centre(245,12,zamien(round(oferta[1]))+'$');
centre(390,12,zamien(round(oferta[2]))+'$');
centre(80,12,mapa.postacie[0].imie+' ');
centre(545,12,mapa.postacie[nrph].imie+' ');

pokazmysz;
end;

{                                                     }
{                                                     }
{              PROCEDURY PANELU ROZMOWY               }
{                                                     }
{                                                     }

{====================================================}
{= RYSOWANIE PANELU URUCHAMIANIA ROZMOWY Z POSTACIA =}
{====================================================}
Procedure PanelRozmowy;
begin
ukryjmysz;
cleardevice;
ZerujPrzyciski;
ZerujEkrany;
ZerujOpcje;
ZerujListe;
TworzEkran(20,20,630,280,3);
TworzEkran(120,310,520,470,3);
Okno(15,305,95,470,3);
Okno(540,305,630,470,3);
{Przycisk(555,325,618,345,0,2,'Handel');}
TypWyboru:=List;
EkranWpisu:=2;
EkranOdczytu:=1;
RysujEkrany;
pokazmysz;
end;
{=============================================}
{=         WYMAZANIE PANELU ROZMOWY          =}
{=============================================}
procedure WymarzPanelRozmowy;
begin
ukryjmysz;
zerujprzyciski;
zerujliste;
zerujopcje;
zerujzapisy;
Czyscekran(ekranwpisu);
CzyscEkran(ekranodczytu);
pokazmysz;
end;
{                                                     }
{                                                     }
{              PROCEDURY PANELU EKWIPUNKU             }
{                                                     }
{                                                     }

{===========================================}
{= RAMKA PRZY WYBORZE PRZEDMIOTU EKWIPUNKU =}
{===========================================}
Procedure RamkaEkw(nr:byte);
var xra,yra:integer;
begin
if nr<>0 then
begin
xra:=0;
yra:=0;
if (nr>0) and (nr<13) then
                        begin
                         xra:=110;
                         yra:=30+((nr-1)*35)
                        end;
if (nr>12) and (nr<25) then
                        begin
                         xra:=180;
                         yra:=30+((nr-13)*35)
                        end;
if nr=25 then
           begin
            xra:=300;
            yra:=300;
           end;
if nr=26 then
           begin
            xra:=300;
            yra:=370;
           end;
if xra<>0 then
            begin
             setcolor(red);
             rectangle(xra,yra,xra+70,yra+35)
            end;
end;
end;
{=====================================================}
{= WYMAZANIE RAMKI PRZY WYBORZE PRZEDMIOTU EKWIPUNKU =}
{=====================================================}
Procedure DelRamkaEkw(nr:byte);
var xra,yra:integer;
begin
if nr<>0 then
begin
xra:=0;
yra:=0;
if (nr>0) and (nr<13) then
                        begin
                         xra:=110;
                         yra:=30+((nr-1)*35)
                        end;
if (nr>12) and (nr<25) then
                        begin
                         xra:=180;
                         yra:=30+((nr-13)*35)
                        end;
if nr=25 then
           begin
            xra:=300;
            yra:=300;
           end;
if nr=26 then
           begin
            xra:=300;
            yra:=370;
           end;
if xra<>0 then
            begin
             setcolor(brown);
             rectangle(xra,yra,xra+70,yra+35)
            end;
end;
end;
{===================================}
{=   PANEL PRZEDMIOTOW DO UZYCIA   =}
{===================================}
Procedure PanelUzyciaPrzedmiotow;
begin
ukryjmysz;
okno(100,20,259,460,0);
okno(109,29,251,451,6);
pokazmysz;
end;
{========================================================}
{= RYSOWANIE PRZEDMIOTOW W PANELU PRZEDMIOTOW DO UZYCIA =}
{========================================================}
Procedure RysujPrzedmiotyUzycia;
var i:byte;
    Pomnr:integer;
begin
ukryjmysz;
for i:=1 to 24 do
      begin
       setfillstyle(1,green);
       if i<13 then bar(110,30+((i-1)*35),180,30+((i-1)*35)+35);
       if i>12 then bar(180,30+((i-13)*35),250,30+((i-13)*35)+35);
      end;
for i:=1 to 24 do
      begin

       if mapa.postacie[0].ekwipunek[i]>0 then
                                 begin
                                  Pomnr:=mapa.postacie[0].ekwipunek[i];
                                  if i<13 then RysujPrzedmiot(110,30+((i-1)*35),idgfx(pomnr));
                                  if i>12 then RysujPrzedmiot(180,30+((i-13)*35),idgfx(pomnr));
                                  if mapa.postacie[0].spec[i]>1 then
                                        begin
                                         setcolor(black);
                                         if idtyp(pomnr)=Amunicja then setcolor(red);
                                         if idtyp(pomnr)=Bron  then setcolor(white);
                                         if i<13 then Outtextxy(115,34+((i-1)*35),zamien(round(Mapa.postacie[0].spec[i])) );
                                         if i>12 then Outtextxy(185,34+((i-13)*35),zamien(round(Mapa.postacie[0].spec[i])) );
                                        end;
                                 end;
      end;
pokazmysz;
end;

{============================================}
{=       RYSOWANIE PANELU EKWIPUNKU         =}
{============================================}
Procedure PanelEkwipunku;
begin
ukryjmysz;
ZerujPrzyciski;
ZerujEkrany;
ZerujOpcje;
ZerujListe;
okno(100,20,540,460,0);
okno(109,29,251,451,6);
okno(300,280,370,295,7);
setcolor(yellow);
centre(335,284,'Bron:');
okno(300,350,370,365,7);
centre(335,354,'Zbroja:');
okno(299,299,371,336,6);
okno(299,369,371,406,6);
okno(400,299,420,330,6);
TworzEkran(260,34,525,230,1);
Ekranodczytu:=1;
TworzPrzycisk(300,420,370,435,0,1,'Koniec ');
TworzPrzycisk(430,310,530,325,0,1,'Zaladuj Bron ');
RysujPrzyciski;
RysujEkrany;
pokazmysz;
end;
{============================================}
{= RYSOWANIE PRZEDMIOTOW W PANELU EKWIPUNKU =}
{============================================}
Procedure RysujPrzedmiotyEkwipunku;
var i:byte;
    Pomnr:integer;
begin
ukryjmysz;
for i:=1 to 24 do
      begin
       setfillstyle(1,brown);
       if i<13 then bar(110,30+((i-1)*35),180,30+((i-1)*35)+35);
       if i>12 then bar(180,30+((i-13)*35),250,30+((i-13)*35)+35);
      end;
setfillstyle(1,brown);
bar(300,300,370,335);
setfillstyle(1,brown);
bar(300,370,370,405);
for i:=1 to 24 do
      begin

       if mapa.postacie[0].ekwipunek[i]>0 then
                                 begin
                                  Pomnr:=mapa.postacie[0].ekwipunek[i];
                                  if i<13 then RysujPrzedmiot(110,30+((i-1)*35),idgfx(pomnr));
                                  if i>12 then RysujPrzedmiot(180,30+((i-13)*35),idgfx(pomnr));
                                  if mapa.postacie[0].spec[i]>1 then
                                        begin
                                         setcolor(black);
                                         if idtyp(pomnr)=Amunicja then setcolor(red);
                                         if idtyp(pomnr)=Bron  then setcolor(white);
                                         if i<13 then Outtextxy(115,34+((i-1)*35),zamien(round(Mapa.postacie[0].spec[i])) );
                                         if i>12 then Outtextxy(185,34+((i-13)*35),zamien(round(Mapa.postacie[0].spec[i])) );
                                        end;
                                 end;
{                                 else
                                 begin
                                  setfillstyle(1,green);
                                  if i<13 then bar(110,30+((i-1)*35),180,30+((i-1)*35)+35);
                                  if i>12 then bar(180,30+((i-13)*35),250,30+((i-13)*35)+35);
                                 end;}
      end;
if mapa.postacie[0].bron>0 then
                              begin
                               Pomnr:=mapa.postacie[0].bron;
                               RysujPrzedmiot(300,300,idgfx(pomnr));
                               setcolor(red);
                               if mapa.postacie[0].bronspec>1 then Outtextxy(305,305,zamien(round(Mapa.postacie[0].bronspec)));
                              end;
{                              else
                              begin
                               setfillstyle(1,green);
                               bar(300,300,370,335);
                              end;}
if mapa.postacie[0].zbroja>0 then
                              begin
                               Pomnr:=mapa.postacie[0].zbroja;
                               RysujPrzedmiot(300,370,idgfx(pomnr));
                              end;
{                              else
                              begin
                               setfillstyle(1,green);
                               bar(300,370,370,405);
                              end;}
okno(400,299,420,330,6);
RysOdpPostac(400,299,0);
pokazmysz;
end;
{=================================================}
{= WYSWIETLANIE DANYCH O PRZEDMIOCIE W EKWIPUNKU =}
{=================================================}
Procedure WyswietlDanePrzedmiotu(nrpp:integer);
begin
ukryjmysz;
Pisztekste(idname(nrpp),ekranodczytu,white);
Pisztekste('-------------------------------',ekranodczytu,yellow);
Pisztekste('TYP         :'+TypPrzedmiotu[idtyp(nrpp)],ekranodczytu,yellow);
Pisztekste('CENA        :'+zamien(idprice(nrpp)),ekranodczytu,yellow);
If idtyp(nrpp)=bron then
                                             begin
                                              Pisztekste('SILA RAZENIA:'+zamien(idDam(nrpp)),ekranodczytu,yellow);
                                              Pisztekste('AMUNICJA    :'+idname(idammo(nrpp)),ekranodczytu,yellow);
                                              PiszTekste('ILOSC AMUNI.:'+zamien(idammoload(nrpp)),ekranodczytu,yellow);
                                             end;
if idtyp(nrpp)=bronb then
                       begin
                        PiszTekste('SILA RAZENIA:'+zamien(iddam(nrpp)),ekranodczytu,yellow);
                       end;
if idtyp(nrpp)=pancerz then PiszTekste('OCHRONA     :'+zamien(idres(nrpp)),ekranodczytu,yellow);
Pisztekste('-------------------------------',ekranodczytu,yellow);
Pisztekste('',ekranodczytu,yellow);
PiszTekste(' '+idOpis(nrpp),ekranodczytu,yellow);
Pisztekste('',ekranodczytu,yellow);
Pisztekste('-------------------------------',ekranodczytu,yellow);
pokazmysz;
end;
{=================================================}
{=         CZYSZCZENIE EKRANU EKWIPUNKU          =}
{=================================================}
Procedure CzyscEkranEkwipunku;
begin
ukryjmysz;
CzyscEkran(ekranodczytu);
okno(109,29,251,451,6);
okno(299,299,371,336,6);
okno(299,369,371,406,6);
pokazmysz;
end;
{                                                     }
{                                                     }
{              PROCEDURY PANELU SCENERII              }
{                                                     }
{                                                     }

{==================================================}
{= RYSOWANIE PANELU URUCHAMIANIA OBIEKTU SCENERII =}
{==================================================}
Procedure PanelScenerii(RodzajPanelu:byte);
begin
ukryjmysz;
AktPanel:=rodzajpanelu;
if rodzajpanelu=1 then
           begin
            {Panel duzy do wpisywania}
            cleardevice;
            ZerujEkrany;
            ZerujPrzyciski;
            ZerujOpcje;
            ZerujListe;
            cleardevice;
            TworzEkran(10,10,630,445,0);
            RysujEkrany;
            EkranWpisu:=1;
            EkranOdczytu:=1;
           end;
if rodzajpanelu=2 then
           begin
            {Panel z ekranem do wyswietlania animacji}
            ZerujEkrany;
            ZerujPrzyciski;
            ZerujOpcje;
            ZerujListe;
            okno(70,60,570,400,10);
            TworzEkran(80,70,350,280,0);
            TworzEkran(365,70,560,390,2);
            TworzEkran(80,295,350,390,2);
            RysujEkrany;
            EkranWpisu:=3;
            EkranOdczytu:=2;
           end;
if rodzajpanelu=3 then
           begin
            {Standardowy panel do obslugi komputera}
            ClearDevice;
            ZerujEkrany;
            ZerujPrzyciski;
            ZerujOpcje;
            ZerujListe;
            TworzEkran(10,10,630,340,4);
            okno(10,355,100,465,0);
            TworzEkran(115,355,515,465,4);
            okno(530,355,630,465,0);
            rysujekrany;
            ekranwpisu:=2;
            Ekranodczytu:=1;
           end;
if rodzajpanelu=4 then
           begin
            {Panel do obslugi Windy}
            ZerujEkrany;
            ZerujPrzyciski;
            ZerujOpcje;
            ZerujListe;
            TworzEkran(200,100,400,300,0);
            TworzEkran(200,315,400,360,0);
            RysujEkrany;
            EkranWpisu:=1;
            EkranOdczytu:=2;
           end;
if rodzajpanelu=5 then
           begin
            {Panel do obslugi telefonu}
            ZerujEkrany;
            ZerujPrzyciski;
            ZerujOpcje;
            ZerujListe;
            TworzEkran(100,100,300,280,0);
            TworzEkran(315,100,500,280,0);
            TworzEkran(100,295,500,410,0);
            RysujEkrany;
            EkranWpisu:=1;
            EkranOdczytu:=2;
           end;
pokazmysz;
end;
{                                                  }
{                                                  }
{           PROCEDURY PANELU DZIENNIKA             }
{                                                  }
{                                                  }

{=======================================}
{=      RYSOWANIE PANELU DZIENNIKA     =}
{=======================================}
Procedure PanelDziennika;
begin
ukryjmysz;
zerujprzyciski;
zerujekrany;
cleardevice;
okno(10,10,630,470,8);
TworzEkran(15,15,500,460,4);
okno(505,190,625,315,0);
okno(505,15,625,45,0);
TworzPrzycisk(511,200,620,225,0,1,'Zadania');
TworzPrzycisk(511,240,620,265,0,1,'Pliki');
TworzPrzycisk(511,280,620,305,0,1,'Odpoczynek');
okno(510,55,560,100,0);
tworzprzycisk(515,60,555,75,0,1,'/\ ');
tworzprzycisk(515,80,555,95,0,1,'\/ ');
tworzprzycisk(511,430,620,445,0,1,'Koniec ');
rysujekrany;
rysujprzyciski;
ekranodczytu:=1;
Ekranwpisu:=1;
pokazmysz;
end;
{=====================================}
{=    WYSWIETLANIE DATY I CZASU      =}
{=====================================}
Procedure WyswietlDate;
begin
ukryjmysz;
setfillstyle(7,8);
bar(506,16,624,44);
setcolor(lightgreen);
centre(566,20,zamien(dd)+'.'+zamien(mm)+'.'+zamien(rr));
setcolor(white);
if mn>9 then centre(566,30,zamien(gg)+':'+zamien(mn))
        else centre(566,30,zamien(gg)+':0'+zamien(mn));
pokazmysz;
end;
{===============================}
{=  WYSWIETLANIE SAMEGO CZASU  =}
{===============================}
Procedure WyswietlGodzine;
begin
setfillstyle(7,8);
bar(506,30,624,44);
setcolor(white);
if mn>9 then centre(566,30,zamien(gg)+':'+zamien(mn))
        else centre(566,30,zamien(gg)+':0'+zamien(mn));
end;
{=====================================}
{=     WYSWIETLANIE LISTY ZAPISOW    =}
{=====================================}
Procedure WyswietlZapisy;
var i:byte;
begin
ukryjmysz;
wyswietldate;
for i:=1 to ilosczapisow do
    begin
     if zapis[i].status=zapisany then PiszTekstEd(10,i*10,Zapis[i].nazwa,0,ekranwpisu,white);
    end;
pokazmysz;
end;
{======================================}
{=  WYSWIETLANIE DLUGOSCI ODPOCZYNKU  =}
{======================================}
Procedure WyswietlOdpoczynek;
begin
ukryjmysz;
czyscekran(ekranwpisu);
setcolor(white);
outtextxy(40,60,'Odpoczynek jednogodzinny.');
outtextxy(40,90,'Odpoczynek Dwugodzinny.');
outtextxy(40,120,'Odpoczynek czterogodzinny.');
outtextxy(40,150,'Odpoczynij do rana (8:00).');
outtextxy(40,180,'Odpoczynij do poludnia (12:00).');
outtextxy(40,210,'Odpoczynij do wieczora (18:00).');
outtextxy(40,240,'Odpoczynij do polnocy (0:00).');
outtextxy(40,270,'Odpoczynij do pelnego wyleczenia.');
pokazmysz;
end;
{=====================================}
{=     WYSWIETLANIE LISTY ZADA      =}
{=====================================}
Procedure WyswietlZadania;
var i:byte;
begin
ukryjmysz;
wyswietldate;
i:=0;
repeat
inc(i);
if (scrol-1)+i<=ilosczadan then
                begin
         if zadania[(scrol-1)+i].status=wykonane then pisztekstee('- '+nazwazadania((scrol-1)+i),11,1,yellow);
         if zadania[(scrol-1)+i].status=niewykonane then pisztekste('- '+nazwazadania((scrol-1)+i),1,lightgreen);
         pisztekste(' ',1,1);
         pisztekste(' ',1,1);
                end;
until (ekrany[1].lo+3>=43) or ((scrol-1)+i>ilosczadan);
pokazmysz;
end;
{=====================================}
{=   CZYSZCZENIE PANELU DZIENNIKA    =}
{=====================================}
Procedure CzyscPanelDziennika;
begin
ukryjmysz;
czyscekran(1);
okno(505,15,625,45,0);
pokazmysz;
end;

{                                                  }
{                                                  }
{            PROCEDURY GWNEGO PANELU             }
{                                                  }
{                                                  }

{=======================================}
{=         RYSOWANIE KONSOLI           =}
{=======================================}
Procedure WyswietlKonsole;
var i:byte;
begin
ukryjmysz;
setfillstyle(7,brown);
bar(12,412,408,470);
setcolor(white);
for i:=1 to 6 do
               begin
                if lewo(konsola[i],1)='*' then
                                            begin
                                             setcolor(lightgreen);
                                             outtextxy(14,413+((i-1)*10),'*');
                                             setcolor(white);
                                             outtextxy(14,413+((i-1)*10),'  '+pomin(konsola[i],2));
                                            end else
                                            begin
                                             setcolor(white);
                                             outtextxy(14,413+((i-1)*10),konsola[i]);
                                            end;
               end;
pokazmysz;
end;
{=======================================}
{=      RYSOWANIE GWNEGO PANELU      =}
{=======================================}
Procedure GlownyPanel;
begin
ukryjmysz;
zerujprzyciski;
zerujekrany;
zerujopcje;
zerujzapisy;
zerujliste;
setfillstyle(1,brown);
bar(0,0,640,10);
bar(0,0,10,480);
bar(630,0,640,480);
bar(410,0,420,480);
bar(0,473,640,480);
bar(0,402,410,410);
bar(410,170,640,180);
okno(10,410,410,473,10);
setcolor(black);
rectangle(10,10,412,402);
setcolor(yellow);
rectangle(9,9,413,403);
setcolor(yellow);
rectangle(420,180,630,470);
okno(420,10,630,170,10);
okno(420,180,630,473,10);

TworzPrzycisk(450,450,600,465,0,1,'Wyjscie');
TworzPrzycisk(450,430,600,445,0,1,'Charakterystyka');
TworzPrzycisk(450,410,600,425,0,1,'Ekwipunek');
TworzPrzycisk(450,390,600,405,0,1,'Dziennik');

setcolor(yellow);
outtextxy(440,40,'SI :');
outtextxy(440,55,'PE :');
outtextxy(440,70,'ZR :');
outtextxy(440,85,'INT:');
outtextxy(440,100,'CH :');
outtextxy(440,115,'WY :');
outtextxy(440,130,'SZ :');

outtextxy(530,40,'PA :');
outtextxy(530,55,'PW :');
outtextxy(506,85,'Poziom:');
outtextxy(490,195,'Bron:');
outtextxy(500,230,'Zbroja:');
setcolor(white);
rectangle(425,191,625,216);
setcolor(red);
rectangle(424,190,626,217);
setcolor(yellow);
rectangle(425,226,625,251);
rectangle(424,225,626,252);
RysujPrzyciski;
pokazmysz;
end;
{=========================================}
{= WCISNIECIE NA BRON, CZYLI PROBA ATAKU =}
{=========================================}
Procedure ProbaAtaku;
begin
setcolor(red);
rectangle(425,191,625,216);
delay(100);
setcolor(white);
rectangle(425,191,625,216);
end;
{=======================================}
{=         WYSWIETLANIE MAPY           =}
{=======================================}
procedure ShowMap;
begin
ukryjmysz;
RysujMape(11,11,19,12);
pokazmysz;
end;
{==============================================}
{= WYSWIETLENIE TYLKO DANYCH POSTACI BOHATERA =}
{==============================================}
Procedure DaneHerosa;
begin
setfillstyle(1,black);
bar(475,40,490,140);
bar(565,40,628,100);
setcolor(white);
centre(525,20,mapa.postacie[0].imie);
RysOdpPostac(540,115,mapa.postacie[0].rysunek);
setcolor(yellow);
outtextxy(475,40,zamien(mapa.postacie[0].cechy[sila]));
outtextxy(475,55,zamien(mapa.postacie[0].cechy[percepcja]));
outtextxy(475,70,zamien(mapa.postacie[0].cechy[zrecznosc]));
outtextxy(475,85,zamien(mapa.postacie[0].cechy[inteligencja]));
outtextxy(475,100,zamien(mapa.postacie[0].cechy[charyzma]));
outtextxy(475,115,zamien(mapa.postacie[0].cechy[wytrzymalosc]));
outtextxy(475,130,zamien(mapa.postacie[0].cechy[szczescie]));

outtextxy(565,40,zamien(mapa.postacie[0].ap));
outtextxy(565,55,zamien(mapa.postacie[0].hp)+'/'+zamien(mapa.postacie[0].maxhp));
outtextxy(565,85,zamien(poziom));
setfillstyle(1,black);
bar(461,195,488,203);
setcolor(11);
if mapa.postacie[0].bron>0 then centre(475,195,zamien(round(mapa.postacie[0].bronspec)));
end;

{======================================}
{= PROCEDURA WYSWIETLAJACA NAZWE MAPY =}
{======================================}
Procedure Nazwamapy;
begin
if testy=true then
       begin
        setfillstyle(1,green);
        bar(100,0,200,8);
        setcolor(black);
        outtextxy(100,0,mapa.nazwa);
       end;
end;

{=========================================}
{= WYSWIETLANIE DANYCH NA GLOWNYM PANELU =}
{=========================================}
Procedure DaneGlownegoPanelu;
begin
ukryjmysz;
WyswietlKonsole;
centre(525,20,mapa.postacie[0].imie);
RysOdpPostac(540,115,mapa.postacie[0].rysunek);
setcolor(yellow);
outtextxy(475,40,zamien(mapa.postacie[0].cechy[sila]));
outtextxy(475,55,zamien(mapa.postacie[0].cechy[percepcja]));
outtextxy(475,70,zamien(mapa.postacie[0].cechy[zrecznosc]));
outtextxy(475,85,zamien(mapa.postacie[0].cechy[inteligencja]));
outtextxy(475,100,zamien(mapa.postacie[0].cechy[charyzma]));
outtextxy(475,115,zamien(mapa.postacie[0].cechy[wytrzymalosc]));
outtextxy(475,130,zamien(mapa.postacie[0].cechy[szczescie]));

outtextxy(565,40,zamien(mapa.postacie[0].ap));
outtextxy(565,55,zamien(mapa.postacie[0].hp)+'/'+zamien(mapa.postacie[0].maxhp));
outtextxy(565,85,zamien(poziom));
if mapa.postacie[0].bron>0 then
                            begin
                             setcolor(red);
                             if idfire(mapa.postacie[0].bron)>1 then
                                                                 begin
                                                                  outtextxy(530,195,'(Seria)');
                                                                  setcolor(11);
                                                                  centre(475,195,zamien(round(mapa.postacie[0].bronspec)));
                                                                 end;
                             if idfire(mapa.postacie[0].bron)=1 then
                                                                 begin
                                                                  outtextxy(530,195,'(Pojedynczy)');
                                                                  setcolor(11);
                                                                  centre(475,195,zamien(round(mapa.postacie[0].bronspec)));
                                                                 end;
                             setcolor(yellow);
                        if idapc(mapa.postacie[0].bron)>0 then outtextxy(430,195,zamien(idapc(mapa.postacie[0].bron))+' PA');
                            end
                            else
                            begin
                             setcolor(red);
                             outtextxy(530,195,'(Udezenie)');
                             setcolor(yellow);
                             outtextxy(430,195,'3 PA');
                            end;
setcolor(lightred);
if mapa.postacie[0].bron>0 then centre(525,205,idname(mapa.postacie[0].bron))
                           else centre(525,205,'Piesci');
if mapa.postacie[0].zbroja>0 then centre(525,240,idname(mapa.postacie[0].zbroja))
                             else centre(525,240,'Kombinezon');

setcolor(white);
if mapa.postacie[0].choroby[Napromieniowanie]>0 then centre(525,260,'Napromieniowanie');
if mapa.postacie[0].choroby[Trucizna]>0 then centre(525,270,'Trucizna');
if mapa.postacie[0].choroby[Uzaleznienie]>0 then centre(525,280,'Uzalezniony');
setcolor(yellow);
if PomLev then centre(525,295,'Poziom');
if trybgry=trybwalki then
           begin
            przycisk(470,320,590,335,0,3,'Koniec Tury');
            przycisk(470,340,590,355,0,3,'Koniec Walki');
            przycisk(470,360,590,375,0,3,'Przeladuj');
           end;
Nazwamapy;
pokazmysz;
end;
{============================================}
{=       CZYSZCZENIE GLOWNEGO PANELU        =}
{============================================}
Procedure CzyscGlowny;
begin
ukryjmysz;
okno(10,410,410,473,10);
okno(420,10,630,170,10);
okno(420,180,630,473,10);
pokazmysz;
end;
{==================================================}
{=  WYSWIETLANIE PRZYCISKOW NIEZBEDNYCH DO WALKI  =}
{==================================================}
Procedure PrzyciskiWalki;
begin
przycisk(470,320,590,335,0,3,'Koniec Tury');
przycisk(470,340,590,355,0,3,'Koniec Walki');
end;

{                                                  }
{                                                  }
{             PROCEDURY PANELU POSTACI             }
{                                                  }
{                                                  }

{=======================================}
{=      RYSOWANIE PANELU POSTACI       =}
{=======================================}
Procedure PanelPostaci;
begin
ukryjmysz;
zerujekrany;
zerujprzyciski;
okno(115,60,560,340,8);
okno(120,65,250,85,0);{MIEJSCE NA IMIE}
okno(120,90,250,240,0); {Miejsce na cechy}
setcolor(lightgreen);
outtextxy(125,100,nazwycech[1]);
outtextxy(125,120,nazwycech[2]);
outtextxy(125,140,nazwycech[3]);
outtextxy(125,160,nazwycech[4]);
outtextxy(125,180,nazwycech[5]);
outtextxy(125,200,nazwycech[6]);
outtextxy(125,220,nazwycech[7]);
okno(360,65,555,190,0); {Miejsce na umiejetnosci}
setcolor(lightgreen);
outtextxy(365,70,nazwyumie[1]);
outtextxy(365,80,nazwyumie[2]);
outtextxy(365,90,nazwyumie[3]);
outtextxy(365,100,nazwyumie[4]);
outtextxy(365,110,nazwyumie[5]);
outtextxy(365,120,nazwyumie[6]);
outtextxy(365,130,nazwyumie[7]);
outtextxy(365,140,nazwyumie[8]);
outtextxy(375,155,'Punkty do rozd.:');
okno(255,65,355,190,0);{Miejsce na dodatkowe dane}
setcolor(lightgreen);
outtextxy(260,70,' AP :');
outtextxy(260,85,' HP :');
outtextxy(260,100,'Obr. w wal.');
outtextxy(260,110,'wrecz:');
outtextxy(260,125,'Pancerz:');
outtextxy(260,140,'Pkt.lecz.:');
okno(120,245,250,330,0);    {Miejsce na doswiadczenie}
setcolor(lightgreen);
outtextxy(125,250,'Doswiadczenie:');
line(125,264,235,264);
outtextxy(125,270,'PD:');
outtextxy(125,285,'Poziom:');
outtextxy(125,300,'Nastep. Poziom:');
okno(255,195,400,330,0);  {Miejsce na karme}
setcolor(lightgreen);
outtextxy(260,200,'Karma:');
line(260,224,395,224);
tworzekran(400,190,560,335,5);
tworzprzycisk(425,170,448,185,0,1,'+ ');
tworzprzycisk(452,170,476,185,0,1,'- ');
tworzprzycisk(480,170,540,185,0,1,'Koniec ');
tworzprzycisk(365,170,420,185,0,1,'Ulecz');
ekranodczytu:=1;
rysujekrany;
rysujprzyciski;
pokazmysz;
end;
{==================================================================}
{= WYSWIETLANIE NAZW WSZYSTKICH WSPOLCZYNNIKOW OPISUJACYCH POSTAC =}
{==================================================================}
Procedure WyswietlWspolczynniki;
var kp:byte;
begin
ukryjmysz;
kp:=11;
setcolor(lightgreen);
if wb=1 then setcolor(kp);
outtextxy(125,100,nazwycech[1]);
setcolor(lightgreen);
if wb=2 then setcolor(kp);
outtextxy(125,120,nazwycech[2]);
setcolor(lightgreen);
if wb=3 then setcolor(kp);
outtextxy(125,140,nazwycech[3]);
setcolor(lightgreen);
if wb=4 then setcolor(kp);
outtextxy(125,160,nazwycech[4]);
setcolor(lightgreen);
if wb=5 then setcolor(kp);
outtextxy(125,180,nazwycech[5]);
setcolor(lightgreen);
if wb=6 then setcolor(kp);
outtextxy(125,200,nazwycech[6]);
setcolor(lightgreen);
if wb=7 then setcolor(kp);
outtextxy(125,220,nazwycech[7]);
setcolor(lightgreen);
if wb=8 then setcolor(kp);
outtextxy(365,70,nazwyumie[1]);
setcolor(lightgreen);
if wb=9 then setcolor(kp);
outtextxy(365,80,nazwyumie[2]);
setcolor(lightgreen);
if wb=10 then setcolor(kp);
outtextxy(365,90,nazwyumie[3]);
setcolor(lightgreen);
if wb=11 then setcolor(kp);
outtextxy(365,100,nazwyumie[4]);
setcolor(lightgreen);
if wb=12 then setcolor(kp);
outtextxy(365,110,nazwyumie[5]);
setcolor(lightgreen);
if wb=13 then setcolor(kp);
outtextxy(365,120,nazwyumie[6]);
setcolor(lightgreen);
if wb=14 then setcolor(kp);
outtextxy(365,130,nazwyumie[7]);
setcolor(lightgreen);
if wb=15 then setcolor(kp);
outtextxy(365,140,nazwyumie[8]);
setcolor(lightgreen);
outtextxy(375,155,'Punkty do rozd.:');
setcolor(lightgreen);
if wb=16 then setcolor(kp);
outtextxy(260,70,' AP :');
setcolor(lightgreen);
if wb=17 then setcolor(kp);
outtextxy(260,85,' HP :');
setcolor(lightgreen);
if wb=18 then setcolor(kp);
outtextxy(260,100,'Obr. w wal.');
outtextxy(260,110,'wrecz:');
setcolor(lightgreen);
if wb=19 then setcolor(kp);
outtextxy(260,125,'Pancerz:');
setcolor(lightgreen);
if wb=20 then setcolor(kp);
outtextxy(260,140,'Pkt.lecz.:');
setcolor(lightgreen);
if wb=21 then setcolor(kp);
outtextxy(125,250,'Doswiadczenie:');
line(125,264,235,264);
outtextxy(125,270,'PD:');
outtextxy(125,285,'Poziom:');
outtextxy(125,300,'Nastep. Poziom:');
setcolor(lightgreen);
if wb=22 then setcolor(kp);
outtextxy(260,200,'Karma:');
setcolor(lightgreen);
if reputation[1]>0 then if wb=23 then
                  begin
                   setcolor(kp);
                   outtextxy(260,230,reputacja[1]);
                   setcolor(lightgreen);
                  end
                  else outtextxy(260,230,reputacja[1]);

if reputation[2]>0 then if wb=24 then
                  begin
                   setcolor(kp);
                   outtextxy(260,240,reputacja[2]);
                   setcolor(lightgreen);
                  end else outtextxy(260,240,reputacja[2]);
if reputation[3]>0 then if wb=25 then
                  begin
                   setcolor(kp);
                   outtextxy(260,250,reputacja[3]);
                   setcolor(lightgreen);
                  end else outtextxy(260,250,reputacja[3]);
if reputation[4]>0 then if wb=26 then
                  begin
                   setcolor(kp);
                   outtextxy(260,260,reputacja[4]);
                   setcolor(lightgreen);
                  end else outtextxy(260,260,reputacja[4]);
if reputation[5]>0 then if wb=27 then
                  begin
                   setcolor(kp);
                   outtextxy(260,270,reputacja[5]);
                   setcolor(lightgreen);
                  end else outtextxy(260,270,reputacja[5]);
if reputation[6]>0 then if wb=28 then
                  begin
                   setcolor(kp);
                   outtextxy(260,280,reputacja[6]);
                   setcolor(lightgreen);
                  end else outtextxy(260,280,reputacja[6]);
if reputation[7]>0 then if wb=29 then
                  begin
                   setcolor(kp);
                   outtextxy(260,290,reputacja[7]);
                   setcolor(lightgreen);
                  end else outtextxy(260,290,reputacja[7]);
if reputation[8]>0 then if wb=30 then
                  begin
                   setcolor(kp);
                   outtextxy(260,300,reputacja[8]);
                   setcolor(lightgreen);
                  end else outtextxy(260,300,reputacja[8]);
if reputation[9]>0 then if wb=31 then
                  begin
                   setcolor(kp);
                   outtextxy(260,310,reputacja[9]);
                   setcolor(lightgreen);
                  end else outtextxy(260,310,reputacja[9]);
if reputation[10]>0 then if wb=32 then
                  begin
                   setcolor(kp);
                   outtextxy(260,320,reputacja[10]);
                   setcolor(lightgreen);
                  end else outtextxy(260,320,reputacja[10]);
czyscekran(1);
Pisztekste(czytajtext(tekstygry+'charc.msg',wb),1,bialy);
pokazmysz;
end;
{=======================================}
{=  WYSWIETLENIE SAMYCH UMIEJENTNOSCI  =}
{=======================================}
Procedure WyswietlUmiejetnosci;
begin
ukryjmysz;
setfillstyle(7,8);
bar(510,70,535,165);
setcolor(yellow);
outtextxy(510,70,zamien(calkowityskill(0,1)));
outtextxy(510,80,zamien(calkowiTYSKIll(0,2)));
outtextxy(510,90,zamien(calkowityskill(0,3)));
outtextxy(510,100,zamien(calkowityskill(0,4)));
outtextxy(510,110,zamien(calkowityskill(0,5)));
outtextxy(510,120,zamien(calkowityskill(0,6)));
outtextxy(510,130,zamien(calkowityskill(0,7)));
outtextxy(510,140,zamien(calkowityskill(0,8)));
outtextxy(510,155,zamien(pnkt));
pokazmysz;
end;
{=======================================}
{= WYSWIETLANIE DANYCH PANELU POSTACI  =}
{=======================================}
Procedure DanePostaci;
var i:byte;
begin
ukryjmysz;
setcolor(yellow);
centre(185,70,mapa.postacie[0].imie);
outtextxy(230,100,zamien(mapa.postacie[0].cechy[1]));
outtextxy(230,120,zamien(mapa.postacie[0].cechy[2]));
outtextxy(230,140,zamien(mapa.postacie[0].cechy[3]));
outtextxy(230,160,zamien(mapa.postacie[0].cechy[4]));
outtextxy(230,180,zamien(mapa.postacie[0].cechy[5]));
outtextxy(230,200,zamien(mapa.postacie[0].cechy[6]));
outtextxy(230,220,zamien(mapa.postacie[0].cechy[7]));

outtextxy(510,70,zamien(calkowityskill(0,1)));
outtextxy(510,80,zamien(calkowiTYSKIll(0,2)));
outtextxy(510,90,zamien(calkowityskill(0,3)));
outtextxy(510,100,zamien(calkowityskill(0,4)));
outtextxy(510,110,zamien(calkowityskill(0,5)));
outtextxy(510,120,zamien(calkowityskill(0,6)));
outtextxy(510,130,zamien(calkowityskill(0,7)));
outtextxy(510,140,zamien(calkowityskill(0,8)));

outtextxy(510,155,zamien(pnkt));
centre(325,70,zamien(mapa.postacie[0].maxap+addap));
centre(325,85,zamien(mapa.postacie[0].hp)+'/'+zamien(mapa.postacie[0].maxhp));
centre(325,110,zamien(round((mapa.postacie[0].cechy[sila]*1.5)/2)));
outtextxy(330,125,zamien(round((mapa.postacie[0].cechy[wytrzymalosc]*1.1)*0.5)+idres(mapa.postacie[0].zbroja)));
outtextxy(340,140,zamien(round((mapa.postacie[0].cechy[wytrzymalosc]*0.5))));

if mapa.postacie[0].choroby[uzaleznienie]>0 then outtextxy(260,155,'Uzalezn.');
if mapa.postacie[0].choroby[napromieniowanie]>0 then outtextxy(260,165,'Napromien.');
if mapa.postacie[0].choroby[trucizna]>0 then outtextxy(260,175,'Trucizna');
outtextxy(155,270,zamien(exp));
outtextxy(185,285,zamien(poziom));
centre(185,315,zamien(zliczEXP));
outtextxy(310,200,zamien(karma));
outtextxy(260,215,stopienkarmy);
for i:=1 to 10 do if reputation[i]=1 then outtextxy(260,220+(i*10),reputacja[i]);
pokazmysz;
end;
{=======================================}
{=     CZYSZCZENIE PANELU POSTACI      =}
{=======================================}
Procedure CzyscPanelPostaci;
begin
ukryjmysz;
okno(120,90,250,240,0); {Miejsce na cechy}
setcolor(lightgreen);
outtextxy(125,100,nazwycech[1]);
outtextxy(125,120,nazwycech[2]);
outtextxy(125,140,nazwycech[3]);
outtextxy(125,160,nazwycech[4]);
outtextxy(125,180,nazwycech[5]);
outtextxy(125,200,nazwycech[6]);
outtextxy(125,220,nazwycech[7]);
okno(360,65,535,190,0); {Miejsce na umiejetnosci}
setcolor(lightgreen);
outtextxy(365,70,nazwyumie[1]);
outtextxy(365,80,nazwyumie[2]);
outtextxy(365,90,nazwyumie[3]);
outtextxy(365,100,nazwyumie[4]);
outtextxy(365,110,nazwyumie[5]);
outtextxy(365,120,nazwyumie[6]);
outtextxy(365,130,nazwyumie[7]);
outtextxy(365,140,nazwyumie[8]);
outtextxy(365,155,'Punkty do rozd.:');
okno(255,65,355,190,0);{Miejsce na dodatkowe dane}
setcolor(lightgreen);
outtextxy(260,70,' AP :');
outtextxy(260,85,' HP :');
outtextxy(260,100,'Obr. w wal.');
outtextxy(260,110,'wrecz:');
outtextxy(260,125,'Pancerz:');
outtextxy(260,140,'Pkt.lecz.:');
okno(120,245,250,330,0);    {Miejsce na doswiadczenie}
setcolor(lightgreen);
outtextxy(125,250,'Doswiadczenie:');
line(125,264,235,264);
outtextxy(125,270,'PD:');
outtextxy(125,285,'Poziom:');
outtextxy(125,300,'Nastep. Poziom:');
okno(255,195,400,330,0);  {Miejsce na karme}
setcolor(lightgreen);
outtextxy(260,200,'Karma:');
line(260,224,395,224);
pokazmysz;
end;
{                                                      }
{                                                      }
{ PROCEDURY PANELU WYBIERANIA ILOSCI DANEGO PRZEDMIOTU }
{              (np. ilosc kradzionych monet)           }
{                                                      }

{======================================}
{=      RYSOWANIE PANELU ILOSCI       =}
{======================================}
Procedure PanelIlosci(nrp:integer);
begin
ukryjmysz;
okno(200,170,398,230,1);
okno(209,179,281,214,6);
outtextxy(290,180,'Ilosc:');
okno(290,192,390,212,0);
RysujPrzedmiot(210,180,idgfx(nrp));
pokazmysz;
end;
{======================================}
{=     CZYSZCZENIE PANELU ILOSCI      =}
{======================================}
Procedure CzyscPanelIlosci;
begin
ukryjmysz;
okno(290,192,390,212,0);
pokazmysz;
end;
{                                                     }
{                                                     }
{              PROCEDURY PANELU KRADZIEZY             }
{                                                     }
{                                                     }

{===============================}
{=   WYMARZ RAMKE KRADZIEZY    =}
{===============================}
Procedure DelRamkaKradziezy;
begin
ukryjmysz;
if (ws<13) and (ws>0) then
     begin
      setcolor(brown);
      rectangle(160,30+((ws-1)*35),230,30+(ws*35));
     end;
if (ws>12) and (ws<25) then
     begin
      setcolor(brown);
      rectangle(230,30+((ws-13)*35),300,30+((ws-12)*35));
     end;
if (ws>24) and (ws<37) then
     begin
      setcolor(brown);
      rectangle(340,30+((ws-25)*35),410,30+((ws-24)*35));
     end;
if (ws>36) and (ws<49) then
     begin
      setcolor(brown);
      rectangle(410,30+((ws-37)*35),480,30+((ws-36)*35));
     end;
pokazmysz;
end;

{=====================================}
{= RYSOWANIE RAMKI PODCZAS KRADZIEZY =}
{=====================================}
procedure RamkaKradziezy;
begin
ukryjmysz;
if (ws<13) and (ws>0) then
     begin
      setcolor(red);
      rectangle(160,30+((ws-1)*35),230,30+(ws*35));
     end;
if (ws>12) and (ws<25) then
     begin
      setcolor(red);
      rectangle(230,30+((ws-13)*35),300,30+((ws-12)*35));
     end;
if (ws>24) and (ws<37) then
     begin
      setcolor(red);
      rectangle(340,30+((ws-25)*35),410,30+((ws-24)*35));
     end;
if (ws>36) and (ws<49) then
     begin
      setcolor(red);
      rectangle(410,30+((ws-37)*35),480,30+((ws-36)*35));
     end;
pokazmysz;
end;
{======================================}
{=    RYSOWANIE PANELU KRADZIERZY     =}
{======================================}
Procedure PanelKradziezy;
begin
ukryjmysz;
zerujprzyciski;
Okno(60,20,580,460,0);
okno(159,29,301,451,6);
okno(339,29,481,451,6);

okno(79,29,101,61,7);
okno(539,29,561,61,7);
tworzprzycisk(490,430,570,445,0,1,'Anuluj');
rysujprzyciski;
pokazmysz;
end;
{==============================================}
{= WYSWIETLANIE PRZEDMIOTOW OKRADANEJ POSTACI =}
{==============================================}
Procedure DaneKradziezy(Nrp:integer);
var i:byte;
    pomnr:integer;
begin
ukryjmysz;
okno(159,29,301,451,6);
okno(339,29,481,451,6);
RysOdpPostac(80,30,0);
RysOdpPostac(540,30,nrp);
for i:=1 to 24 do
        begin
         if mapa.postacie[0].ekwipunek[i]>0 then
                      begin
                       pomnr:=mapa.postacie[0].ekwipunek[i];
                       if i<13 then RysujPrzedmiot(160,30+((i-1)*35),idgfx(pomnr));
                       if i>12 then RysujPrzedmiot(230,30+((i-13)*35),idgfx(pomnr));
                       if mapa.postacie[0].spec[i]>1 then
                                        begin
                                         setcolor(black);
                                         if idtyp(pomnr)=Amunicja then setcolor(red);
                                         if idtyp(pomnr)=Bron  then setcolor(white);
                                         if i<13 then Outtextxy(165,34+((i-1)*35),zamien(round(Mapa.postacie[0].spec[i])) );
                                         if i>12 then Outtextxy(235,34+((i-13)*35),zamien(round(Mapa.postacie[0].spec[i])) );
                                        end;

                      end;
         if mapa.postacie[nrp].ekwipunek[i]>0 then
                      begin
                       pomnr:=mapa.postacie[nrp].ekwipunek[i];
                       if i<13 then RysujPrzedmiot(340,30+((i-1)*35),idgfx(pomnr));
                       if i>12 then RysujPrzedmiot(410,30+((i-13)*35),idgfx(pomnr));
                       if mapa.postacie[nrp].spec[i]>1 then
                                        begin
                                         setcolor(black);
                                         if idtyp(pomnr)=Amunicja then setcolor(red);
                                         if idtyp(pomnr)=Bron  then setcolor(white);
                                         if i<13 then Outtextxy(345,34+((i-1)*35),zamien(round(Mapa.postacie[nrp].spec[i])) );
                                         if i>12 then Outtextxy(415,34+((i-13)*35),zamien(round(Mapa.postacie[nrp].spec[i])) );
                                        end;

                      end;

        end;
pokazmysz;
end;
{============================================}
{=  CZYSZCZENIE ZAWARTOSCI PANELU KRADZIEZY =}
{============================================}
Procedure CzyscPanelKradziezy;
begin
ukryjmysz;
okno(159,29,301,451,6);
okno(339,29,481,451,6);

okno(79,29,101,61,7);
okno(539,29,561,61,7);
pokazmysz;
end;

{                                                     }
{                                                     }
{        PROCEDURY PANELU PRZESZUKIWANIA SZAFEK       }
{                                                     }
{                                                     }

{==========================================}
{= RYSOWANIE PANELU PRZESZUKIWANIA SZAFEK =}
{==========================================}
Procedure PanelSzafek;
begin
ukryjmysz;
zerujprzyciski;
Okno(60,20,580,460,0);
okno(159,29,301,451,6);
okno(339,29,481,451,6);

okno(79,29,101,61,7);
okno(539,29,562,61,7);
tworzprzycisk(490,430,570,445,0,1,'Koniec');
rysujprzyciski;
pokazmysz;
end;
{==========================================}
{=  CZYSZCZENIE ZAWARTOSCI PANELU SZAFEK  =}
{==========================================}
Procedure CzyscPanelSzafek;
begin
ukryjmysz;
okno(159,29,301,451,6);
okno(339,29,481,451,6);

okno(79,29,101,61,7);
okno(539,29,562,61,7);
pokazmysz;
end;
{==============================================}
{= WYSWIETLANIE PRZEDMIOTOW OKRADANEJ POSTACI =}
{==============================================}
Procedure DaneSzafek(Nrp:integer);

var i:byte;
    pomnr:integer;
begin
ukryjmysz;
RysOdpPostac(80,30,0);
Szafka(540,30,mapa.szafki[nrp].rysunek);
for i:=1 to 24 do
        begin
         if mapa.postacie[0].ekwipunek[i]>0 then
                      begin
                       pomnr:=mapa.postacie[0].ekwipunek[i];
                       if i<13 then RysujPrzedmiot(160,30+((i-1)*35),idgfx(pomnr));
                       if i>12 then RysujPrzedmiot(230,30+((i-13)*35),idgfx(pomnr));
                       if mapa.postacie[0].spec[i]>1 then
                                        begin
                                         setcolor(black);
                                         if idtyp(pomnr)=Amunicja then setcolor(red);
                                         if idtyp(pomnr)=Bron  then setcolor(white);
                                         if i<13 then Outtextxy(165,34+((i-1)*35),zamien(round(Mapa.postacie[0].spec[i])) );
                                         if i>12 then Outtextxy(235,34+((i-13)*35),zamien(round(Mapa.postacie[0].spec[i])) );
                                        end;

                      end;
         if mapa.szafki[nrp].sprzety[i]>0 then
                      begin
                       pomnr:=mapa.szafki[nrp].sprzety[i];
                       if i<13 then RysujPrzedmiot(340,30+((i-1)*35),idgfx(pomnr));
                       if i>12 then RysujPrzedmiot(410,30+((i-13)*35),idgfx(pomnr));
                       if mapa.szafki[nrp].spec[i]>1 then
                                        begin
                                         setcolor(black);
                                         if idtyp(pomnr)=Amunicja then setcolor(red);
                                         if idtyp(pomnr)=Bron  then setcolor(white);
                                         if i<13 then Outtextxy(345,34+((i-1)*35),zamien(round(Mapa.szafki[nrp].spec[i])) );
                                         if i>12 then Outtextxy(415,34+((i-13)*35),zamien(round(Mapa.szafki[nrp].spec[i])) );
                                        end;

                      end;

        end;
pokazmysz;
end;
{=========================================================}
{= WYSWIETLANIE PRZEDMIOTOW PODCZAS PRZESZUKIWANIA CIALA =}
{=========================================================}
Procedure DaneTrupa(Nrp:integer);

var i:byte;
    pomnr:integer;
begin
ukryjmysz;
RysOdpPostac(80,30,0);
MartwaPostac(540,30);
for i:=1 to 24 do
        begin
         if mapa.postacie[0].ekwipunek[i]>0 then
                      begin
                       pomnr:=mapa.postacie[0].ekwipunek[i];
                       if i<13 then RysujPrzedmiot(160,30+((i-1)*35),idgfx(pomnr));
                       if i>12 then RysujPrzedmiot(230,30+((i-13)*35),idgfx(pomnr));
                       if mapa.postacie[0].spec[i]>1 then
                                        begin
                                         setcolor(black);
                                         if idtyp(pomnr)=Amunicja then setcolor(red);
                                         if idtyp(pomnr)=Bron  then setcolor(white);
                                         if i<13 then Outtextxy(165,34+((i-1)*35),zamien(round(Mapa.postacie[0].spec[i])) );
                                         if i>12 then Outtextxy(235,34+((i-13)*35),zamien(round(Mapa.postacie[0].spec[i])) );
                                        end;

                      end;
         if mapa.postacie[nrp].ekwipunek[i]>0 then
                      begin
                       pomnr:=mapa.postacie[nrp].ekwipunek[i];
                       if i<13 then RysujPrzedmiot(340,30+((i-1)*35),idgfx(pomnr));
                       if i>12 then RysujPrzedmiot(410,30+((i-13)*35),idgfx(pomnr));
                       if mapa.postacie[nrp].spec[i]>1 then
                                        begin
                                         setcolor(black);
                                         if idtyp(pomnr)=Amunicja then setcolor(red);
                                         if idtyp(pomnr)=Bron  then setcolor(white);
                                         if i<13 then Outtextxy(345,34+((i-1)*35),zamien(round(Mapa.postacie[nrp].spec[i])) );
                                         if i>12 then Outtextxy(415,34+((i-13)*35),zamien(round(Mapa.postacie[nrp].spec[i])) );
                                        end;

                      end;

        end;
pokazmysz;
end;

{                                                     }
{                                                     }
{         PANELE DODATKOWE I ICH PROCEDURY            }
{                                                     }
{                                                     }

{===================================================}
{=      PANEL WYBORU UMIEJETNOSCI DO URZYCIA       =}
{===================================================}
Procedure PanelUmiejetnosci;
begin
ukryjmysz;
ZerujPrzyciski;
setfillstyle(1,black);
bar(425,305,620,465);
tworzprzycisk(450,310,600,320,0,1,nazwyumie[nauka]);
tworzprzycisk(450,321,600,331,0,1,nazwyumie[otwieraniezamkow]);
tworzprzycisk(450,332,600,342,0,1,nazwyumie[leczenie]);
tworzprzycisk(450,343,600,353,0,1,nazwyumie[kradzierz]);
RysujPRzyciski;
pokazmysz;
end;
{====================================================}
{=    CZYSZCZENIE PANELU UMIEJETNOSCI DO URZYCIA    =}
{====================================================}
Procedure CzyscPanelUmiejetnsci;
begin
ukryjmysz;
setfillstyle(1,black);
bar(425,305,620,465);
pokazmysz;
end;
{============================================}
{=   PANEL WYBIERANIA CZYNNOSCI DO UZYCIA   =}
{============================================}
Procedure PanelCzynnosci(nrp,typ:byte);
var xpom,ypom:integer;
begin
ukryjmysz;
ZerujPrzyciski;
setfillstyle(1,black);
bar(425,305,620,465);
if typ=postac then
               begin
                tworzprzycisk(20+xpoz(nrp),ypoz(nrp),xpoz(nrp)+70,ypoz(nrp)+10,0,1,'Mow');
                tworzprzycisk(20+xpoz(nrp),ypoz(nrp)+14,xpoz(nrp)+70,ypoz(nrp)+24,0,1,'Patrz');
                tworzprzycisk(20+xpoz(nrp),ypoz(nrp)+28,xpoz(nrp)+70,ypoz(nrp)+38,0,1,'Ekw');
                tworzprzycisk(20+xpoz(nrp),ypoz(nrp)+42,xpoz(nrp)+70,ypoz(nrp)+52,0,1,'Skill');
               end;
if typ=vsceneria then
               begin
                tworzprzycisk(20+xpozs(nrp),ypozs(nrp),xpozs(nrp)+70,ypozs(nrp)+10,0,1,'Urzyj');
                tworzprzycisk(20+xpozs(nrp),ypozs(nrp)+14,xpozs(nrp)+70,ypozs(nrp)+24,0,1,'Patrz');
                tworzprzycisk(20+xpozs(nrp),ypozs(nrp)+28,xpozs(nrp)+70,ypozs(nrp)+38,0,1,'Ekw');
                tworzprzycisk(20+xpozs(nrp),ypozs(nrp)+42,xpozs(nrp)+70,ypozs(nrp)+52,0,1,'Skill');
               end;
RysujPrzyciski;
pokazmysz;
end;
{===============================================================}
{=                                                             =}
{=                                                             =}
{=      PROCEDURY WYSWIETLAJACE DANE W POWYZSZYCH PANELACH     =}
{=                                                             =}
{=                                                             =}
{===============================================================}

{                                                  }
{                                                  }
{                 WYSWIETLANIE TEKSTU              }
{                                                  }
{                                                  }

{========================================}
{=       WYSWIETLANIE FLOODTEKSTU       =}
{========================================}
Procedure FloodTekst(nrp:byte; Slowk:string);
begin
ukryjmysz;
setcolor(black);
centre(320,0,mapa.postacie[nrp].imie+':'+slowk);
pokazmysz;
licznikFlood:=1;
end;
{============================}
{=  WYMAZANIE FLOOD TEKSTU  =}
{============================}
Procedure WymarzFlood;
begin
ukryjmysz;
setfillstyle(1,brown);
bar(0,0,640,9);
pokazmysz;
end;
{======================================}
{= WYWIETLENIE TEKSTU WYSRODKOWANEGO =}
{======================================}
Procedure Centre(xt,yt:integer; tekst:string);
begin
outtextxy(xt-round((length(tekst)*8)/2),yt,tekst);
end;
{==================================}
{= WYWIETLENIE ZWYCZAJNEGO TEKSTU=}
{==================================}
Procedure PiszTekst(xt,yt:integer; tekst:string);
begin
outtextxy(xt,yt,tekst);
end;
{==================================}
{=       SPECJALNE PISANIE        =}
{==================================}
procedure PiszSpec(xt,yt:integer; tekst:string; trybpisania:byte);
var p4:integer;
begin
if trybpisania=0 then begin
p4:=0;
repeat
p4:=p4+1;
setcolor(white);
outtextxy(xt+((p4-1)*8),yt,tekst[p4]);
delay(15);
setcolor(green);
outtextxy(xt+((p4-1)*8),yt,tekst[p4]);
until p4=length(tekst);
end;
if trybpisania=1 then begin
p4:=0;
repeat
p4:=p4+1;
setcolor(white);
outtextxy(xt+((p4-1)*8),yt,tekst[p4]);
delay(25);
setcolor(green);
outtextxy(xt+((p4-1)*8),yt,tekst[p4]);
until p4=length(tekst);
end;
if trybpisania=2 then begin
p4:=0;
repeat
p4:=p4+1;
setcolor(white);
outtextxy(xt+((p4-1)*8),yt,tekst[p4]);
delay(50);
setcolor(green);
outtextxy(xt+((p4-1)*8),yt,tekst[p4]);
until p4=length(tekst);
end;
end;
{=============================================}
{=    PROCEDURA PISZACA TEKST NA EKRANIE     =}
{=============================================}
Procedure PiszTekstE(tekst:string; Ekr,col:byte);
var maxTex:byte;
begin
if ekr=0 then Ekr:=EkranOdczytu;
maxtex:=round ( (((Ekrany[ekr].xe2-10)-(ekrany[ekr].xe1+10))/8));
if length(tekst)>maxtex then
                          begin
                           setcolor(col);
                           outtextxy(ekrany[ekr].xe1+10,ekrany[ekr].ye1+10+(ekrany[ekr].lo*10),lewo(tekst,maxtex));
                           ekrany[ekr].lo:=ekrany[ekr].lo+1;
                           PisztekstE(pomin(tekst,maxtex),ekr,col);
                          end
                          else
                          begin
                           setcolor(col);
                           outtextxy(ekrany[ekr].xe1+10,ekrany[ekr].ye1+10+(ekrany[ekr].lo*10),tekst);
                           ekrany[ekr].lo:=ekrany[ekr].lo+1;
                          end;

end;
{=====================================================}
{= PROCEDURA PISZACA TEKST W SPEC. SPOSB NA EKRANIE =}
{=====================================================}
Procedure PiszTekstES(tekst:string; Atr,Ekr:byte);
var maxtex:byte;
begin
if ekr=0 then Ekr:=EkranOdczytu;
maxtex:=round ( (((Ekrany[ekr].xe2-10)-(ekrany[ekr].xe1+10))/8));
if length(tekst)>maxtex then
                          begin
                    if atr<10 then piszspec(ekrany[ekr].xe1+10,ekrany[ekr].ye1+10+(ekrany[ekr].lo*10),lewo(tekst,maxtex),atr)
                                   else
                                      begin
                                       setcolor(white);
                                       outtextxy(ekrany[ekr].xe1+10,ekrany[ekr].ye1+10+(ekrany[ekr].lo*10),lewo(tekst,maxtex));
                                       line(ekrany[ekr].xe1+10,ekrany[ekr].ye1+14+(ekrany[ekr].lo*10),ekrany[ekr].xe1+10+
                                            (length(lewo(tekst,maxtex))*8),EKRANY[ekr].ye1+14+(ekrany[ekr].lo*10));
                                      END;
                           ekrany[ekr].lo:=ekrany[ekr].lo+1;
                           PisztekstEs(pomin(tekst,maxtex),atr,ekr);
                          end
                          else
                          begin
                    if atr<10 then piszspec(ekrany[ekr].xe1+10,ekrany[ekr].ye1+10+(ekrany[ekr].lo*10),tekst,atr)
                                   else
                                      begin
                                       setcolor(white);
                                       outtextxy(ekrany[ekr].xe1+10,ekrany[ekr].ye1+10+(ekrany[ekr].lo*10),tekst);
                                       line(ekrany[ekr].xe1+10,ekrany[ekr].ye1+14+(ekrany[ekr].lo*10),ekrany[ekr].xe1+10+
                                            (length(tekst)*8),EKRANY[ekr].ye1+14+(ekrany[ekr].lo*10));
                                      END;


                           ekrany[ekr].lo:=ekrany[ekr].lo+1;
                          end;
end;

{=========================================================================}
{= PROCEDURA PISZACA TEKST W SPEC. SPOSB NA EKRANIE I W PODANYM KOLORZE =}
{=========================================================================}
Procedure PiszTekstEE(tekst:string; Atr,Ekr,col:byte);
var maxtex:byte;
begin
if ekr=0 then Ekr:=EkranOdczytu;
maxtex:=round ( (((Ekrany[ekr].xe2-10)-(ekrany[ekr].xe1+10))/8));
if length(tekst)>maxtex then
                          begin
                    if atr<10 then piszspec(ekrany[ekr].xe1+10,ekrany[ekr].ye1+10+(ekrany[ekr].lo*10),lewo(tekst,maxtex),atr)
                                   else
                                      begin
                                       setcolor(col);
                                       outtextxy(ekrany[ekr].xe1+10,ekrany[ekr].ye1+10+(ekrany[ekr].lo*10),lewo(tekst,maxtex));
                                       line(ekrany[ekr].xe1+10,ekrany[ekr].ye1+14+(ekrany[ekr].lo*10),ekrany[ekr].xe1+10+
                                            (length(lewo(tekst,maxtex))*8),EKRANY[ekr].ye1+14+(ekrany[ekr].lo*10));
                                      END;
                           ekrany[ekr].lo:=ekrany[ekr].lo+1;
                           PisztekstEe(pomin(tekst,maxtex),atr,ekr,col);
                          end
                          else
                          begin
                    if atr<10 then piszspec(ekrany[ekr].xe1+10,ekrany[ekr].ye1+10+(ekrany[ekr].lo*10),tekst,atr)
                                   else
                                      begin
                                       setcolor(col);
                                       outtextxy(ekrany[ekr].xe1+10,ekrany[ekr].ye1+10+(ekrany[ekr].lo*10),tekst);
                                       line(ekrany[ekr].xe1+10,ekrany[ekr].ye1+14+(ekrany[ekr].lo*10),ekrany[ekr].xe1+10+
                                            (length(tekst)*8),EKRANY[ekr].ye1+14+(ekrany[ekr].lo*10));
                                      END;


                           ekrany[ekr].lo:=ekrany[ekr].lo+1;
                          end;
end;

{============================================================================}
{= PROCEDURA PISZACA W PELNI KONFIGURUJACA SPOSB PISANIA TEKSTU NA EKRANIE =}
{============================================================================}
Procedure PiszTekstED(xt,yt:integer; Tekst:string; Atr,Ekr,Col:byte);
var maxtex:byte;
begin
if ekr=0 then Ekr:=EkranOdczytu;
maxtex:=round ( (((Ekrany[ekr].xe2-10)-((ekrany[ekr].xe1+10)+xt))/8));
if length(tekst)>maxtex then
                          begin
                           setcolor(col);
                   if Atr<>0 then piszspec(ekrany[ekr].xe1+xt,ekrany[ekr].ye1+yt,lewo(tekst,maxtex),atr);
                   if atr=0 then outtextxy(ekrany[ekr].xe1+xt,ekrany[ekr].ye1+yt,lewo(tekst,maxtex));
                           yt:=yt+10;
                           PisztekstED(xt,yt,pomin(tekst,maxtex),atr,ekr,col);
                          end
                          else
                          begin
                           setcolor(col);
                   if Atr<>0 then piszspec(ekrany[ekr].xe1+xt,ekrany[ekr].ye1+yt,tekst,atr);
                   if atr=0 then outtextxy(ekrany[ekr].xe1+xt,ekrany[ekr].ye1+yt,tekst);
                           ekrany[ekr].lo:=round(yt/10);
                          end;

end;

{                                                  }
{                                                  }
{         WYSWIETLANIE DANYCH W PANELACH           }
{                                                  }
{                                                  }

{===========================================}
{=    WYSWIETLANIE OBIEKTW TYPU OPCJA     =}
{===========================================}
Procedure RysujOpcje;
var i:byte;
begin
ukryjmysz;
if aktopcja=0 then aktopcja:=1;
for i:=1 to liczbopcji do
      begin
       if aktopcja<>i then setfillstyle(SprawdzKroj(EkranWpisu),SprawdzKolor(ekranWpisu))
                          else setfillstyle(1,kolortla);
       if aktopcja<>i then setcolor(kolortekstu) else setcolor(kolornumerow);
       bar(ekrany[ekranwpisu].xe1+10+Opcje[i].xop,ekrany[ekranwpisu].ye1+10+Opcje[i].yop-1,
       ekrany[ekranwpisu].xe1+10+Opcje[i].xop+((length(opcje[i].tekst)+2)*8),ekrany[ekranwpisu].ye1+10+opcje[i].yop+10-2);
       outtextxy(ekrany[ekranwpisu].xe1+10+opcje[i].xop+8,ekrany[ekranwpisu].ye1+10+opcje[i].yop,opcje[i].tekst);
      end;
pokazmysz;
end;
{===========================================}
{=    WYSWIETLANIE OBIEKTW TYPU LISTA     =}
{===========================================}
Procedure RysujListy;
var nri:byte;
begin
ukryjmysz;
for nri:=1 to liczblist do
       begin
        PiszTekstEd(Lista[nri].xl,lista[nri].yl,'*',0,ekranwpisu,kolornumerow);
        PiszTekstEd(Lista[nri].xl+16,lista[nri].yl,lista[nri].tekst,0,ekranwpisu,kolortekstu);
       end;
pokazmysz;
end;

end.