/*
 RIX2BMP -- 32-bit console Win app.
 Converts ColorRIX Image Files (*.RIX) to Windows Bitmap Files (*.BMP)

 This programme is able to convert 640*480*8 RIXes only
 (those which has been used as splash screens in Fallout 2).
 But it could handle all the ColorRIX formats... with minor modifications ;)

 Tools used: kinda brains & Visual C++ 5.0
 Written by Serge (w_master@softhome.net) in 1999. 
 This is a freeware. All lefts reserved ;))))

 Written for all funs of Fallout 2 - best postnuclear RPG ever made...
*/

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

int main(int argc, char **argv)
{
	DWORD i,rix_size,signature=0x33584952;	//"RIX3"
	int b=4;
	BYTE *ptr_rix;
	BYTE *ptr2;
	HANDLE h_rix, h_bmp;
	BITMAPCOREHEADER b_core_header;
	BITMAPFILEHEADER b_file_header;
	RGBTRIPLE entries[256];

    if (argc<2)
	{
		printf("\nRIX2BMP Converter\n");
		printf("Copyleft 1999 by Serge (w_master@softhome.net). All lefts reserved :)\n");
		printf("Converts ColorRIX 640x480x8 *.RIX to Windows *.BMP bitmaps\n");
		printf("Usage: %s infile.rix outfile.bmp [bfactor]\n",argv[0]);
		printf(",where bfactor=brightness factor (default=4)\n");
		printf("Example: %s splash6.rix mademan.bmp\n",argv[0]);
	return -1;
    }

//Open RIX file
	h_rix=CreateFile(argv[1],
		GENERIC_READ,
		FILE_SHARE_READ,
		NULL,
		OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL,
		NULL);

    if (h_rix==INVALID_HANDLE_VALUE)
	{
		printf("Cannot read %s\n",argv[1]);
	return -1;
    }

//open(create) BMP file
	h_bmp=CreateFile(argv[2],
		GENERIC_WRITE,
		0,
		NULL,
		CREATE_ALWAYS,
		FILE_ATTRIBUTE_NORMAL,
		NULL);
	
	if (h_bmp==INVALID_HANDLE_VALUE)
	{
		printf("Cannot create %s\n",argv[2]);
		CloseHandle(h_rix);
	return -1;
	}

// Check for RIX3 signature
	if(ReadFile(h_rix,&rix_size,4,&i,NULL)==0)
	{
		printf("Cannot read RIX3 signature!");
		goto end_files;
	}

	if (rix_size!=signature)
	{
		printf("Not a ColorRIX 640*256*8 Image File format");
		goto end_files;
	}

// move RIX file pointer so that it points to actual data
	i=SetFilePointer (h_rix,10,NULL,FILE_BEGIN) ;
	if (i==0xFFFFFFFF)
	{
		printf("Cannot seek to palette data...");
		goto end_files;
     }

//Allocate memory for RIX file
	rix_size=GetFileSize(h_rix,NULL)-10;	//skip header 
	ptr_rix=new BYTE [rix_size];
	if(ptr_rix==0)
	{
		printf("Cannot allocate heap, free %lu bytes of memory then try again...",rix_size);
		goto end_files;
	}

//Read RIX file into heap pointed by ptr_rix
	if(!ReadFile(h_rix, ptr_rix, rix_size,
		&i,NULL))
	{
		printf("Cannot read RIX into buffer!");
		goto end_all;
	}
	ptr2=ptr_rix;

// Now obtain a brightness factor from cli
	if(argv[3])
		b=atoi(argv[3]);

// Now, ptr2 points to RIX palette (offset 0xA).
// So transform it to rgba.
	for(i=0;i<256;i++)
	{
		entries[i].rgbtRed=(*ptr2++)*b;
		entries[i].rgbtGreen=(*ptr2++)*b;
		entries[i].rgbtBlue=(*ptr2++)*b;
	}

// Converted palette stored now in entries[].
// ptr2 points to RIX raw data
// Now prepare BMP header
	b_file_header.bfType='MB';
	b_file_header.bfSize=308278;	//size of BMP file (for 640*480*8+headers)
	b_file_header.bfReserved1=0;
	b_file_header.bfReserved2=0;
	b_file_header.bfOffBits=sizeof(b_file_header)+sizeof(b_core_header)+sizeof(entries);	//offset to the raw data

	b_core_header.bcSize=sizeof(b_core_header);	//structure size;
	b_core_header.bcWidth=640;
	b_core_header.bcHeight=480;
	b_core_header.bcPlanes=1;
	b_core_header.bcBitCount=8;

//Write all data to BMP
//write BMPFILEHEADER
	if(!WriteFile(h_bmp,&b_file_header,sizeof(b_file_header),&i,NULL))
	{
		printf("Cannot write BMPFILEHEADER to %s\n",argv[2]);
		goto end_all;
	}

//write BMPCOREHEADER
	if(!WriteFile(h_bmp,&b_core_header,sizeof(b_core_header),&i,NULL))
	{
		printf("Cannot write BMPCOREHEADER to %s\n",argv[2]);
		goto end_all;
	}

//write palette
	if(!WriteFile(h_bmp,&entries,sizeof(entries),&i,NULL))
	{
		printf("Cannot write palette data to %s\n",argv[2]);
		goto end_all;
	}

//turn raw data head over heels then write line by line
//(not my best but i'm lazy ;)
	i=(b_core_header.bcHeight-1);
	ptr2+=i*b_core_header.bcWidth;
	for(i;i!=-1;i--)
	{
		if(!WriteFile(h_bmp,ptr2,b_core_header.bcWidth,&signature,NULL))
		{
			printf("Cannot write raw data to %s\n",argv[2]);
			goto end_all;
		}
	ptr2-=b_core_header.bcWidth;
	}

	printf("\nAll Done!!!\n");

//Close files and release memory	
end_all:
	delete[] ptr_rix;
end_files:
	CloseHandle(h_bmp);
	CloseHandle(h_rix);

return 0;
}